/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.common.util;

import com.siebel.common.util.CSSSystem;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageLoader {
    private String m_fileName;
    private final String m_imagePath = "com/siebel/ssa/ui/laf/icons/";
    protected static ImageLoader m_imageLoader;

    public ImageLoader(String string) {
        this.m_fileName = string;
    }

    public static Image getJARImage(String string) {
        if (m_imageLoader == null) {
            m_imageLoader = new ImageLoader(CSSSystem.getRootJarPath());
        }
        return m_imageLoader.getImage(string);
    }

    public Image getImage(String string) {
        byte[] byArray = this.getData("com/siebel/ssa/ui/laf/icons/" + string);
        Image image = null;
        if (byArray != null) {
            image = Toolkit.getDefaultToolkit().createImage(byArray);
        }
        return image;
    }

    public byte[] getData(String string) {
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        try {
            ZipFile zipFile = new ZipFile(this.m_fileName);
            FileInputStream fileInputStream = new FileInputStream(this.m_fileName);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                int n3 = (int)zipEntry.getSize();
                if (n3 == -1) {
                    n3 = (int)zipFile.getEntry(zipEntry.getName()).getSize();
                }
                n = 0;
                n2 = 0;
                byte[] byArray2 = new byte[n3];
                while (n3 - n > 0 && (n2 = zipInputStream.read(byArray2, n, n3 - n)) != -1) {
                    n += n2;
                }
                if (!zipEntry.getName().equals(string)) continue;
                byArray = byArray2;
            }
        }
        catch (NullPointerException nullPointerException) {
            byArray = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            byArray = null;
        }
        catch (IOException iOException) {
            byArray = null;
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage is:\n  ImageLoader <jar file> <image file>\n");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        ImageLoader imageLoader = new ImageLoader(string);
        Image image = imageLoader.getImage(string2);
        Frame frame = new Frame(string + " / " + string2);
        if (image == null) {
            System.exit(0);
        }
        frame.setSize(image.getWidth(frame), image.getHeight(frame));
        JLabel jLabel = new JLabel(new ImageIcon(image));
        frame.add(jLabel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((dimension.width - image.getWidth(frame)) / 2, (dimension.height - image.getHeight(frame)) / 2);
        frame.setVisible(true);
    }
}

