/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.data;

import com.siebel.common.common.CSSException;

public class SiebelException
extends Exception {
    private CSSException cssException;
    private int fieldMajorNumber = 4096;
    private int fieldMinorNumber = 0;
    private String fieldMessage = new String("Unknown");
    private String fieldDetailMessage = new String("Unknown");
    private static String MINOR_START_TAG = "<Minor No.>";
    private static String MINOR_END_TAG = "</Minor No.>";
    private static String MAJOR_START_TAG = "<Major No.>";
    private static String MAJOR_END_TAG = "</Major No.>";
    private static String MSG_START_TAG = "<Message>";
    private static String MSG_END_TAG = "</Message>";
    private static String DMSG_START_TAG = "<DetailedMessage>";
    private static String DMSG_END_TAG = "</DetailedMessage>";

    public SiebelException() {
        this.fieldMajorNumber = 4096;
        this.fieldMinorNumber = 0;
    }

    public SiebelException(CSSException cSSException) {
        this.cssException = cSSException;
        this.fieldMajorNumber = cSSException.getMajorCode();
        this.fieldMinorNumber = this.cssException.getErrorCode();
        this.fieldMessage = this.cssException.getErrorMessage();
    }

    public SiebelException(int n, int n2) {
        this.fieldMajorNumber = n;
        this.fieldMinorNumber = n2;
    }

    public SiebelException(int n, int n2, String string) {
        this.fieldMajorNumber = n;
        this.fieldMinorNumber = n2;
        if (string != null) {
            this.fieldMessage = string;
        }
    }

    public SiebelException(int n, int n2, String string, String string2) {
        this.fieldMajorNumber = n;
        this.fieldMinorNumber = n2;
        if (string != null) {
            this.fieldMessage = string;
        }
        if (string2 != null) {
            this.fieldDetailMessage = string2;
        }
    }

    public int getErrorCode() {
        if (this.cssException != null) {
            return this.cssException.getErrorCode();
        }
        return this.fieldMinorNumber;
    }

    public String getDetailedMessage() {
        if (this.cssException != null) {
            return this.cssException.toString();
        }
        return this.fieldDetailMessage;
    }

    public String getErrorMessage() {
        return this.fieldMessage;
    }

    public int getMajorNumber() {
        int n = this.fieldMajorNumber;
        return n;
    }

    @Override
    public String getMessage() {
        return this.fieldMessage;
    }

    public int getMinorNumber() {
        int n = this.fieldMinorNumber;
        return n;
    }

    public void setDetailMessage(String string) {
        if (string != null) {
            this.fieldDetailMessage = string;
        }
    }

    public void setMajorNumber(int n) {
        this.fieldMajorNumber = n;
    }

    public void setMessage(String string) {
        if (string != null) {
            this.fieldMessage = string;
        }
    }

    public void setMinorNumber(int n) {
        this.fieldMinorNumber = n;
    }

    @Override
    public String toString() {
        if (this.cssException != null) {
            if (this.cssException.getErrorCount() > 1) {
                return "<Exception>\n" + MAJOR_START_TAG + this.fieldMajorNumber + MAJOR_END_TAG + MINOR_START_TAG + this.fieldMinorNumber + MINOR_END_TAG + MSG_START_TAG + this.fieldMessage + MSG_END_TAG + DMSG_START_TAG + this.fieldDetailMessage + DMSG_START_TAG + "\n" + this.cssException + "</Exception>";
            }
            return "<Exception>\n" + MAJOR_START_TAG + this.fieldMajorNumber + MAJOR_END_TAG + MINOR_START_TAG + this.fieldMinorNumber + MINOR_END_TAG + MSG_START_TAG + this.fieldMessage + MSG_END_TAG + DMSG_START_TAG + this.fieldDetailMessage + DMSG_START_TAG + "\n" + "</Exception>";
        }
        return "<Exception>\n" + MAJOR_START_TAG + this.fieldMajorNumber + MAJOR_END_TAG + MINOR_START_TAG + this.fieldMinorNumber + MINOR_END_TAG + MSG_START_TAG + this.fieldMessage + MSG_END_TAG + DMSG_START_TAG + this.fieldDetailMessage + DMSG_START_TAG + "\n" + "</Exception>";
    }
}

