/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelService;
import com.siebel.extra.MangleString;
import java.util.ResourceBundle;

public class SiebelServiceAdapterBase {
    protected static final boolean DEBUG = false;
    protected static final int LOGIN_ATTEMPTS = 3;
    protected static final String DEFAULT_BEAN_CLASS = "com.siebel.data.SiebelDataBean";
    protected static final String DEFAULT_PROPERTY_FILE_NAME = "siebel";
    protected static final String CONNECT_STRING_PROPERTY = "siebel.connection.string";
    protected static final String USERNAME_PROPERTY = "siebel.user.name";
    protected static final String PASSWORD_PROPERTY = "siebel.user.password";
    protected static final String LANGUAGE_PROPERTY = "siebel.user.language";
    protected static final String IS_ENCRYPTED_PROPERTY = "siebel.user.encrypted";
    protected static final String BEAN_CLASS_PROPERTY = "siebel.jdb.classname";
    protected String fResourceBundleName = null;
    protected String fUsername = null;
    protected String fPassword = null;
    protected String fLanguage = null;
    protected String fSiebelServiceName = null;
    protected String fConnectString = null;
    protected String fBeanClassName = "com.siebel.data.SiebelDataBean";
    protected boolean fIsConnected = false;
    protected boolean fResponsible = true;
    protected ResourceBundle fResources = null;
    protected SiebelDataBean fSiebelDataBean = null;
    protected SiebelService fSiebelService = null;

    public SiebelServiceAdapterBase() {
        this.fResourceBundleName = DEFAULT_PROPERTY_FILE_NAME;
    }

    public SiebelServiceAdapterBase(SiebelDataBean siebelDataBean) {
        this.fResponsible = false;
        this.fSiebelDataBean = siebelDataBean;
        this.fResourceBundleName = DEFAULT_PROPERTY_FILE_NAME;
        this.fIsConnected = true;
    }

    public SiebelServiceAdapterBase(String string) {
        this.fResourceBundleName = string;
    }

    public SiebelServiceAdapterBase(String string, String string2, String string3) {
        this.fResourceBundleName = DEFAULT_PROPERTY_FILE_NAME;
        if (string != null) {
            this.fUsername = string;
        }
        if (string2 != null) {
            this.fPassword = string2;
        }
        if (string3 != null) {
            this.fConnectString = string3;
        }
    }

    public SiebelServiceAdapterBase(String string, String string2, String string3, String string4) {
        this.fResourceBundleName = DEFAULT_PROPERTY_FILE_NAME;
        if (string != null) {
            this.fUsername = string;
        }
        if (string2 != null) {
            this.fPassword = string2;
        }
        if (string4 != null) {
            this.fLanguage = string4;
        }
        if (string3 != null) {
            this.fConnectString = string3;
        }
    }

    public void initialize() throws SiebelException {
        String string = null;
        boolean bl = false;
        MangleString mangleString = new MangleString();
        if (this.fResponsible) {
            try {
                this.fResources = ResourceBundle.getBundle(this.fResourceBundleName);
                if (this.fConnectString == null) {
                    this.fConnectString = this.fResources.getString(CONNECT_STRING_PROPERTY);
                }
                string = this.fResources.getString(IS_ENCRYPTED_PROPERTY);
                bl = new Boolean(string);
                if (this.fUsername == null) {
                    string = this.fResources.getString(USERNAME_PROPERTY);
                    String string2 = this.fUsername = bl ? mangleString.decrypt(string) : string;
                }
                if (this.fPassword == null) {
                    string = this.fResources.getString(PASSWORD_PROPERTY);
                    this.fPassword = bl ? mangleString.decrypt(string) : string;
                }
                try {
                    if (this.fLanguage == null) {
                        string = this.fResources.getString(LANGUAGE_PROPERTY);
                        this.fLanguage = bl ? mangleString.decrypt(string) : string;
                    }
                }
                catch (Exception exception) {
                    this.fLanguage = null;
                }
                try {
                    string = this.fResources.getString(BEAN_CLASS_PROPERTY);
                    String string3 = string = bl ? mangleString.decrypt(string) : string;
                    if (string != null) {
                        this.fBeanClassName = string;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                throw new SiebelException();
            }
        }
        if (this.fSiebelDataBean == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_BEAN_CLASS);
                Class<?> clazz2 = Class.forName(this.fBeanClassName);
                if (clazz.isAssignableFrom(clazz2)) {
                    Object obj = clazz2.newInstance();
                    this.fSiebelDataBean = (SiebelDataBean)obj;
                } else {
                    System.err.println("Class \"" + this.fBeanClassName + "\" is not a valid SiebelDataBean class.\n" + "Using com.siebel.data.SiebelDataBean instead.");
                    this.fSiebelDataBean = new SiebelDataBean();
                }
            }
            catch (Exception exception) {
                this.fSiebelDataBean = new SiebelDataBean();
            }
        }
        if (this.fResponsible) {
            this.login();
        }
        this.getService();
    }

    protected void login() throws SiebelException {
        if (!this.fIsConnected) {
            if (this.fSiebelDataBean != null) {
                try {
                    if (this.fLanguage == null) {
                        this.fSiebelDataBean.login(this.fConnectString, this.fUsername, this.fPassword);
                    } else {
                        this.fSiebelDataBean.login(this.fConnectString, this.fUsername, this.fPassword, this.fLanguage);
                    }
                    this.fIsConnected = true;
                }
                catch (SiebelException siebelException) {
                    SiebelException siebelException2 = new SiebelException(0x10000002, 3, "Can't connect to Siebel");
                    siebelException2.setDetailMessage(siebelException.getErrorMessage());
                    throw siebelException2;
                }
                catch (NullPointerException nullPointerException) {
                    SiebelException siebelException = new SiebelException(0x10000002, 3, "Can't connect to Siebel");
                    siebelException.setDetailMessage("Null pointer Error: " + nullPointerException.getMessage());
                    throw siebelException;
                }
            } else {
                SiebelException siebelException = new SiebelException(0x10000002, 3, "Can't connect to Siebel");
                siebelException.setDetailMessage("Can't login, fSiebelDataBean is null");
                throw siebelException;
            }
        }
    }

    public void logout() throws SiebelException {
        this.fSiebelService = null;
        try {
            if (this.fResponsible) {
                this.fSiebelDataBean.logoff();
                this.fIsConnected = false;
            }
        }
        catch (SiebelException siebelException) {
            this.fIsConnected = false;
        }
    }

    protected void getService() throws SiebelException {
        try {
            this.getService(this.fSiebelServiceName);
        }
        catch (SiebelException siebelException) {
            SiebelException siebelException2 = new SiebelException(0x10000002, 4, "Can't initialize Siebel Service");
            siebelException2.setDetailMessage("Can't get the service [" + this.fSiebelServiceName + "]: " + siebelException.getMessage());
            throw siebelException2;
        }
    }

    public SiebelDataBean getSiebelDataBean() {
        return this.fSiebelDataBean;
    }

    public SiebelService getSiebelService() {
        return this.fSiebelService;
    }

    protected void finalize() throws Throwable {
        if (this.fResponsible) {
            try {
                this.fSiebelService = null;
                this.logout();
                this.fSiebelDataBean = null;
            }
            catch (SiebelException siebelException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    protected void getService(String string) throws SiebelException {
        if (!this.fIsConnected) {
            this.login();
        }
        try {
            this.fSiebelService = this.fSiebelDataBean.getService(string);
        }
        catch (SiebelException siebelException) {
            SiebelException siebelException2 = new SiebelException(0x10000002, 4, "Can't initialize Siebel Service");
            siebelException2.setDetailMessage("Can't get the service [" + this.fSiebelServiceName + "]: " + siebelException.getMessage());
            throw siebelException2;
        }
    }

    public String getSiebelServiceName() {
        return this.fSiebelServiceName;
    }

    public void initialize(String string) throws SiebelException {
        this.fSiebelServiceName = string;
        this.initialize();
    }

    protected void lazyLoad() throws SiebelException {
        if (!this.fIsConnected) {
            this.initialize();
        }
    }

    protected void setSiebelServiceName(String string) {
        this.fSiebelServiceName = string;
    }
}

