/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.common.crypt.SiebelCipher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Random;
import java.util.Vector;

public class EncodeJndiProperties
extends Thread {
    private static Vector<String> m_jndiFileContents;
    private static Vector<String> m_jndiFileContentsForRestore;
    private static String m_jndiFileName;
    private static String m_siebelCipherSeed;
    private static String m_srvrmgrpath;
    private static String m_subsystem_name;
    private static String m_gtwyServerName;
    private static String m_gtwyServerPort;
    private static String m_enterprise;
    private static String m_gtwyServerUsername;
    private static String m_gtwyServerPassword;
    private static boolean m_checkError;
    private InputStream m_is = null;
    private String m_type = null;

    public EncodeJndiProperties(InputStream inputStream, String string) {
        this.m_is = inputStream;
        this.m_type = string;
        m_checkError = false;
    }

    private static void restoreJndiProperties() {
        try {
            System.out.print("\n\tRestoring original contents of jndi.properties file...");
            FileWriter fileWriter = new FileWriter(m_jndiFileName);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i < m_jndiFileContentsForRestore.size(); ++i) {
                bufferedWriter.write(m_jndiFileContentsForRestore.get(i) + "\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error occured while restoring jndi properties file : " + exception.getMessage());
            System.exit(1);
        }
        System.out.println("Done!");
    }

    @Override
    public void run() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.m_is);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (this.m_type.equalsIgnoreCase("error")) {
                    m_checkError = true;
                }
                System.out.println(this.m_type + "\t> " + string);
            }
        }
        catch (Exception exception) {
            System.out.println("Error occured while capturing process output : " + exception.getMessage());
            System.out.println("" + exception.getStackTrace());
        }
    }

    public static void printUsage() {
        String string = "";
        string = string + "\n\nUsage \"java EncodeJndiProperties <jndi file name> <encryption seed> <srvrmgr path> <Gateway Server Name> <Gateway Server Port> <Siebel Enterprise> <Username> <Password> <Named Subsystem>\"";
        string = string + "\n\n";
        string = string + "\t <JNDI file name> - Full path of the jndi file which is to encoded.\n";
        string = string + "\t <Encryption seed> - Encryption seed for encoding the jndi.properties credentials.\n";
        string = string + "\t <SRVRMGR path> - Full path for srvrmgr executable.\n";
        string = string + "\t <Gateway Server Name> - Gateway server name.\n";
        string = string + "\t <Gateway Server Port> - Gateway server port.\n";
        string = string + "\t <Siebel Enterprise> - Gateway server port.\n";
        string = string + "\t <Gateway Server Username> - Username to connect to gateway server .\n";
        string = string + "\t <Gateway Server Password> - Password to connect to gateway server .\n";
        string = string + "\t <Named Subsystem name> - Named subsystem name to set the seed for decryption.\n";
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string;
        String string2;
        Object object3;
        Object object4;
        Object object5;
        if (stringArray.length < 9) {
            EncodeJndiProperties.printUsage();
            System.exit(1);
        }
        m_jndiFileName = stringArray[0];
        File file = new File(m_jndiFileName);
        if (m_jndiFileName.toLowerCase().indexOf("jndi.properties") < 0 || !file.exists()) {
            System.out.println("Specified JNDI file doesnot exists. Check the filename and path.");
            System.exit(1);
        }
        m_siebelCipherSeed = stringArray[1];
        m_srvrmgrpath = stringArray[2];
        file = new File(m_srvrmgrpath);
        if (m_srvrmgrpath.toLowerCase().indexOf("srvrmgr") < 0 || !file.exists()) {
            System.out.println("Invalid srvrmgr path specified. Check the filename and path.");
            System.exit(1);
        }
        m_gtwyServerName = stringArray[3];
        m_gtwyServerPort = stringArray[4];
        try {
            Integer.parseInt(m_gtwyServerPort);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid gateway server port value. Enter a valid number.");
            System.exit(1);
        }
        m_enterprise = stringArray[5];
        m_gtwyServerUsername = stringArray[6];
        m_gtwyServerPassword = stringArray[7];
        m_subsystem_name = stringArray[8];
        m_jndiFileContents = new Vector();
        m_jndiFileContentsForRestore = new Vector();
        try {
            System.out.println("\n\t1. Reading JNDI Properties file : " + m_jndiFileName);
            object5 = new FileInputStream(m_jndiFileName);
            object4 = new DataInputStream((InputStream)object5);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object4));
            while ((object3 = bufferedReader.readLine()) != null) {
                m_jndiFileContentsForRestore.add((String)object3);
                if (((String)object3).trim().toLowerCase().indexOf("java.naming.security.credentials") >= 0) {
                    int n = ((String)object3).indexOf("=");
                    string2 = ((String)object3).substring(0, n);
                    string = ((String)object3).substring(n + 1);
                    object2 = new SiebelCipher(m_siebelCipherSeed);
                    string = ((SiebelCipher)object2).encrypt(string.trim());
                    object = string2 + "=" + string;
                    m_jndiFileContents.add((String)object);
                    continue;
                }
                m_jndiFileContents.add((String)object3);
            }
            ((FilterInputStream)object4).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error occured while reading jndi properties file : " + exception.getMessage());
            System.exit(1);
        }
        try {
            System.out.print("\n\t2. Writing encoded JNDI properties file...");
            object5 = new FileWriter(m_jndiFileName);
            object4 = new BufferedWriter((Writer)object5);
            for (int i = 0; i < m_jndiFileContents.size(); ++i) {
                ((Writer)object4).write(m_jndiFileContents.get(i) + "\n");
            }
            ((BufferedWriter)object4).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error occured while writting jndi properties file : " + exception.getMessage());
            System.exit(1);
        }
        System.out.println("Done!");
        System.out.println("\n\t3. Preparing srvrmgr commands for storing seed value.");
        object5 = new Random();
        object4 = "";
        File file2 = null;
        try {
            file2 = File.createTempFile("srvrcmds_" + ((Random)object5).nextInt(99999), ".cmd");
            file2.deleteOnExit();
            object4 = file2.getAbsolutePath();
            object3 = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)object3);
            string2 = "";
            string2 = "change param JNDIEncryptionSeed=" + m_siebelCipherSeed + " for named subsystem " + m_subsystem_name + "\n";
            bufferedWriter.write(string2);
            System.out.print("\t- Command 1 : " + string2);
            string2 = "change param JNDIEncryptionCheck=TRUE for named subsystem " + m_subsystem_name + "\n";
            bufferedWriter.write(string2);
            System.out.print("\t- Command 2 : " + string2);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Error in creating temporary file for storing srvrmgr commands.");
            System.out.println("Check permissions to create file and rerun the utility.");
            EncodeJndiProperties.restoreJndiProperties();
            System.exit(1);
        }
        System.out.println("\n\t4. Connecting to Server Manager to set encryption seed for decryption.");
        object3 = "";
        object3 = (String)object3 + " /s " + m_gtwyServerName + " /g " + m_gtwyServerName + ":" + m_gtwyServerPort + " ";
        object3 = (String)object3 + "/e " + m_enterprise + " ";
        object3 = (String)object3 + "/u " + m_gtwyServerUsername + " /p " + m_gtwyServerPassword + " ";
        object3 = (String)object3 + "/i " + (String)object4;
        boolean bl = false;
        int n = 0;
        try {
            string = m_srvrmgrpath + (String)object3;
            System.out.println("\t- Executing system command : \n\t  " + string);
            System.out.println("\n************************************ SRVRMGR - START **************************************\n");
            object2 = Runtime.getRuntime();
            object = ((Runtime)object2).exec(string);
            EncodeJndiProperties encodeJndiProperties = new EncodeJndiProperties(((Process)object).getErrorStream(), "Error");
            EncodeJndiProperties encodeJndiProperties2 = new EncodeJndiProperties(((Process)object).getInputStream(), "Output");
            encodeJndiProperties.start();
            encodeJndiProperties2.start();
            encodeJndiProperties.join();
            encodeJndiProperties2.join();
            n = ((Process)object).waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("\n************************************ SRVRMGR - END *****************************************\n");
        if (m_checkError) {
            System.out.println("\tERROR OCCURED WHILE EXECUTING SRVRMGR COMMAND. Please verify the command details above.");
            EncodeJndiProperties.restoreJndiProperties();
        }
    }

    static {
        m_jndiFileName = null;
        m_siebelCipherSeed = null;
        m_srvrmgrpath = null;
        m_subsystem_name = null;
        m_gtwyServerName = null;
        m_gtwyServerPort = null;
        m_enterprise = null;
        m_gtwyServerUsername = null;
        m_gtwyServerPassword = null;
        m_checkError = false;
    }
}

