/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.data.SiebelPropertySet;
import com.siebel.eai.SiebelBusinessService;
import com.siebel.eai.SiebelBusinessServiceException;
import com.siebel.eai.jms.JMSDebugger;
import com.siebel.eai.jms.JMSSecureDurableSubscribe;
import com.siebel.eai.jms.JMSSecurePublish;
import com.siebel.eai.jms.JMSSecureReceive;
import com.siebel.eai.jms.JMSSecureSend;
import com.siebel.eai.jms.SiebelJMSException;
import com.siebel.eai.jms.SiebelJMSLogger;
import com.siebel.eai.jms.SiebelJMSProperties;
import com.siebel.eai.jms.SiebelJNDIContext;
import com.siebel.eai.jms.SiebelJNDISecurityContext;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class JMSBusinessService
extends SiebelBusinessService
implements ExceptionListener {
    private long time;
    private boolean sessionIntentionallyLeftOpen;
    private Connection connection;
    private Session session;
    private SiebelJNDIContext jndiContext;
    private Hashtable jndiDecryptionEnv = null;
    private boolean connectionCached = true;
    private boolean jndiContextCached = false;
    private String cachedFactoryName;
    private String cachedConnectionUsername;
    private String cachedConnectionPassword;
    private Queue replyToQueue;
    private Hashtable environment = null;
    private static final String CONTEXT_FACTORY = "CONTEXTFACTORY";
    private static final String PROVIDER_URL = "PROVIDER_URL";
    private static final String SECURITY_PRINCIPAL = "SECURITY_PRINCIPAL";
    private static final String SECURITY_CREDENTIALS = "SECURITY_CREDENTIALS";
    private static final String CONNECTION_EXCEPTION_RETRIES = "ConnectionExceptionRetries";
    private static int maxMessagesPerCon = 1;
    private int msgsPerConnection = 0;
    private int msgLogLevel = 5;
    private boolean isReceiver = false;
    private boolean isDistributed = false;
    private static final long MAX_RECEIVE_TIMEOUT = 30000L;
    private static final int MAX_LIMIT_MESSAGES_PER_CONNECTION = 100;
    private String loggerFileName = null;
    private int maxRetries = 15;

    public JMSBusinessService() {
        this.loggerFileName = System.getProperty("jms.log");
        new JMSBusinessService(System.getProperty("jms.log"));
    }

    public JMSBusinessService(String string, int n) {
        this.loggerFileName = string;
        SiebelJMSLogger.setLogFile(this.loggerFileName);
        SiebelJMSLogger.setLogLevel(n);
        this.setMaxCon();
    }

    public JMSBusinessService(String string) {
        this.loggerFileName = string;
        SiebelJMSLogger.setLogFile(this.loggerFileName);
        this.setMaxCon();
    }

    private void setMaxCon() {
        try {
            String string = System.getProperty("jms.max.msg.per.con");
            if (string != null) {
                int n = Integer.parseInt(string);
                if (n <= 0 || n > 100) {
                    throw new SiebelJMSException("INVALID_ARGUMENT", "value of 'jms.max.msg.per.con' should range from 1 to 100");
                }
                maxMessagesPerCon = n;
                SiebelJMSLogger.log(4, null, "Messages per connection : " + maxMessagesPerCon);
            } else {
                SiebelJMSLogger.log(2, null, "JVM option 'jms.max.msg.per.con' is not specified. Using default value : " + maxMessagesPerCon);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SiebelJMSLogger.log(1, null, "JVM option for 'jms.max.msg.per.con' is an invalid integer. Using default value : " + maxMessagesPerCon);
        }
        catch (SiebelJMSException siebelJMSException) {
            SiebelJMSLogger.log(1, null, "Using default value for Maximum messages per connections : " + siebelJMSException.getErrorMessage());
        }
    }

    @Override
    public void doInvokeMethod(String string, SiebelPropertySet siebelPropertySet, SiebelPropertySet siebelPropertySet2) throws SiebelBusinessServiceException {
        block33: {
            long l = System.currentTimeMillis();
            SiebelJMSLogger.setLogFile(this.loggerFileName);
            SiebelJMSLogger.log(5, null, "Invoking method " + string);
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(JMSBusinessService.class.getClassLoader());
            }
            try {
                try {
                    this.environment = new Hashtable();
                    String string2 = siebelPropertySet.getProperty(CONTEXT_FACTORY);
                    if (string2 != null) {
                        siebelPropertySet.removeProperty(CONTEXT_FACTORY);
                        this.environment.put("java.naming.factory.initial", string2);
                    }
                    if ((string2 = siebelPropertySet.getProperty(PROVIDER_URL)) != null) {
                        siebelPropertySet.removeProperty(PROVIDER_URL);
                        this.environment.put("java.naming.provider.url", string2);
                    }
                    if ((string2 = siebelPropertySet.getProperty(SECURITY_PRINCIPAL)) != null) {
                        siebelPropertySet.removeProperty(SECURITY_PRINCIPAL);
                        this.environment.put("java.naming.security.principal", string2);
                    }
                    if ((string2 = siebelPropertySet.getProperty(SECURITY_CREDENTIALS)) != null) {
                        siebelPropertySet.removeProperty(SECURITY_CREDENTIALS);
                        this.environment.put("java.naming.security.credentials", string2);
                    }
                    if (this.environment.size() == 0) {
                        this.environment = null;
                    }
                    this.jndiDecryptionEnv = new Hashtable();
                    SiebelJMSProperties siebelJMSProperties = new SiebelJMSProperties(siebelPropertySet);
                    String string3 = "true";
                    String string4 = siebelJMSProperties.jndiEncryptionSeed() != null ? siebelJMSProperties.jndiEncryptionSeed() : "noseed";
                    this.jndiDecryptionEnv.put("JNDIEncryptionSeed", string4);
                    if (siebelJMSProperties.jndiEncryptionCheck() != null && siebelJMSProperties.jndiEncryptionCheck().equalsIgnoreCase("false")) {
                        string3 = "false";
                    }
                    this.jndiDecryptionEnv.put("JNDIEncryptionCheck", string3);
                    string2 = siebelPropertySet.getProperty(CONNECTION_EXCEPTION_RETRIES);
                    if (string2 != null) {
                        try {
                            siebelPropertySet.removeProperty(CONNECTION_EXCEPTION_RETRIES);
                            this.maxRetries = Integer.parseInt(string2);
                            if (this.maxRetries > 15) {
                                SiebelJMSLogger.log(5, null, "Retry limit set to maximum of 15 tries.");
                                this.maxRetries = 15;
                            }
                            if (this.maxRetries < 2) {
                                SiebelJMSLogger.log(5, null, "Retry limit set to minimum of 2 tries.");
                                this.maxRetries = 2;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            SiebelJMSLogger.log(5, null, "Defaulting the retry limit to minimum of 2 retries.");
                            this.maxRetries = 2;
                        }
                    }
                    int n = 1;
                    while (true) {
                        try {
                            ++n;
                            this.doInvokeMethodWithExceptions(string, siebelPropertySet, siebelPropertySet2);
                        }
                        catch (SiebelJMSException siebelJMSException) {
                            if (this.isConnectionError(siebelJMSException.getErrorSubtype()) && n <= this.maxRetries) {
                                SiebelJMSLogger.log(1, null, "Exception during " + string + ":" + SiebelJMSLogger.newline + siebelJMSException.getStackTraceString());
                                SiebelJMSLogger.log(3, null, "Waiting for 2 seconds before retrying.");
                                Thread.sleep(2000L);
                                SiebelJMSLogger.log(3, null, "Retry " + (n - 1) + ": Attempting " + string + " again with new Connection");
                                try {
                                    this.closeConnection();
                                }
                                catch (SiebelJMSException siebelJMSException2) {}
                                continue;
                            }
                            try {
                                this.closeConnection();
                            }
                            catch (SiebelJMSException siebelJMSException3) {
                                // empty catch block
                            }
                            this.closeJNDI();
                            throw siebelJMSException;
                            if (n <= this.maxRetries) continue;
                        }
                        break;
                    }
                }
                catch (SiebelJMSException siebelJMSException) {
                    if (this.isConnectionError(siebelJMSException.getErrorSubtype())) {
                        SiebelJMSLogger.log(1, null, "Exception during " + string + ":" + SiebelJMSLogger.newline + siebelJMSException.getStackTraceString());
                        SiebelJMSLogger.log(3, null, "Waiting for 2 seconds before retrying.");
                        Thread.sleep(2000L);
                        SiebelJMSLogger.log(3, null, "Last retry: Attempting " + string + " again with new Connection");
                        try {
                            this.closeConnection();
                        }
                        catch (SiebelJMSException siebelJMSException4) {
                            // empty catch block
                        }
                        this.doInvokeMethodWithExceptions(string, siebelPropertySet, siebelPropertySet2);
                        break block33;
                    }
                    try {
                        this.closeConnection();
                    }
                    catch (SiebelJMSException siebelJMSException5) {
                        // empty catch block
                    }
                    this.closeJNDI();
                    throw siebelJMSException;
                }
            }
            catch (SiebelJMSException siebelJMSException) {
                String string5 = siebelJMSException.getStackTraceString();
                siebelPropertySet2.setProperty("StackTrace", string5);
                SiebelJMSLogger.log(1, "Error invoking " + string, siebelJMSException);
                SiebelJMSLogger.log(1, null, "Threw SiebelBusinessServiceException with " + SiebelJMSLogger.newline + "ErrorCode = " + siebelJMSException.getErrorCode() + SiebelJMSLogger.newline + "ErrorMessage = " + siebelJMSException.getErrorMessage() + SiebelJMSLogger.newline + "StackTrace = " + string5);
                throw new SiebelBusinessServiceException(siebelJMSException.getErrorCode(), siebelJMSException.getErrorMessage());
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                throwable.printStackTrace(printWriter);
                siebelPropertySet2.setProperty("StackTrace", new String(stringWriter.getBuffer()));
                throw new SiebelBusinessServiceException("JMS_EXCEPTION", "An unexpected error occurred (see StackTrace): " + throwable.getMessage());
            }
            finally {
                this.time += System.currentTimeMillis() - l;
                SiebelJMSLogger.log(4, null, "Cumulative time = " + this.time);
            }
        }
    }

    public void finalize() throws SiebelJMSException {
        SiebelJMSLogger.log(5, null, "finalize is called");
        this.closeConnection();
    }

    public boolean isConnectionError(String string) {
        SiebelJMSLogger.log(4, null, "Checking if exception is a connection exception");
        if (string.equals("CREATING_SESSION") || string.equals("LOOKING_UP_CONNECTION_FACTORY") || string.equals("LOOKING_UP_QUEUE") || string.equals("LOOKING_UP_TOPIC") || string.equals("CREATING_CONNECTION") || string.equals("CREATING_PUBLISHER") || string.equals("CREATING_RECEIVER") || string.equals("CREATING_SENDER") || string.equals("CREATING_SESSION") || string.equals("OBTAINING_CONNECTION") || string.equals("OBTAINING_QUEUE_SESSION") || string.equals("OBTAINING_TOPIC_SESSION") || string.equals("STARTING_CONNECTION")) {
            SiebelJMSLogger.log(4, null, string + " : is a Connection related exception");
            return true;
        }
        SiebelJMSLogger.log(4, null, string + " : is not a Connection related exception");
        return false;
    }

    @Override
    public void destroy() {
        SiebelJMSLogger.log(5, null, "destroy is called");
        try {
            this.closeConnection();
        }
        catch (SiebelJMSException siebelJMSException) {
            String string = siebelJMSException.getStackTraceString();
            SiebelJMSLogger.log(1, null, "Closing connection threw exception with " + SiebelJMSLogger.newline + "ErrorCode = " + siebelJMSException.getErrorCode() + SiebelJMSLogger.newline + "ErrorMessage = " + siebelJMSException.getErrorMessage() + SiebelJMSLogger.newline + "StackTrace = " + string);
        }
    }

    public static byte[] getBytes(BytesMessage bytesMessage) throws JMSException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = bytesMessage.readBytes(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeMethodWithExceptions(String string, SiebelPropertySet siebelPropertySet, SiebelPropertySet siebelPropertySet2) throws SiebelJMSException {
        SiebelJMSProperties siebelJMSProperties;
        block36: {
            siebelJMSProperties = new SiebelJMSProperties(siebelPropertySet);
            siebelJMSProperties.log();
            this.isReceiver = siebelJMSProperties.isReceiver();
            this.isDistributed = siebelJMSProperties.hasDistributedDestinations();
            SiebelJMSLogger.log(4, null, "is a Receiver : " + this.isReceiver);
            SiebelJMSLogger.log(4, null, "distributed destinations : " + this.isDistributed);
            int n = 1;
            boolean bl = true;
            try {
                if (string.equalsIgnoreCase("Send")) {
                    this.createConnection(siebelJMSProperties, "Queue");
                    this.createQueueSession(bl, n);
                    String string2 = (String)SiebelJNDISecurityContext.runAs(siebelJMSProperties.sendUsername(), siebelJMSProperties.sendPassword(), new JMSSecureSend(this, siebelJMSProperties));
                    siebelPropertySet2.setProperty("JMSMessageID", string2);
                    siebelPropertySet2.setValue("<Message sent>");
                    break block36;
                }
                if (string.equalsIgnoreCase("Receive")) {
                    Object object;
                    long l = siebelJMSProperties.receiveTimeout();
                    if (this.isDistributed && this.isReceiver) {
                        this.verifyReceiveTimeout(siebelJMSProperties.receiveTimeout());
                    }
                    this.createConnection(siebelJMSProperties, "Queue");
                    this.createQueueSession(bl, n);
                    Message message = (Message)SiebelJNDISecurityContext.runAs(siebelJMSProperties.receiveUsername(), siebelJMSProperties.receivePassword(), new JMSSecureReceive(this, siebelJMSProperties, null));
                    this.setOutput(siebelPropertySet2, message);
                    if (message != null) {
                        SiebelJMSLogger.log(4, null, "Received message");
                        try {
                            object = message.getJMSReplyTo();
                            if (object instanceof Queue) {
                                this.replyToQueue = (Queue)object;
                            }
                        }
                        catch (JMSException jMSException) {}
                    } else {
                        SiebelJMSLogger.log(4, null, "No message is received");
                    }
                    object = siebelPropertySet2.getProperty("TimedOut");
                    if (this.isDistributed && this.isReceiver) {
                        this.setMessagesPerConnection((String)object);
                    }
                    break block36;
                }
                if (string.equalsIgnoreCase("SendReceive")) {
                    Object object;
                    if (this.isDistributed && this.isReceiver) {
                        this.verifyReceiveTimeout(siebelJMSProperties.receiveTimeout());
                    }
                    this.createConnection(siebelJMSProperties, "Queue");
                    this.createQueueSession(bl, n);
                    String string3 = siebelJMSProperties.receiveQueue();
                    if (string3 == null || string3.equals("")) {
                        throw new SiebelJMSException("MISSING_PARAMETER", "ReceiveQueue");
                    }
                    siebelJMSProperties.replyTo(string3);
                    Object object2 = siebelJMSProperties.correlationID();
                    if (object2 == null && siebelJMSProperties.isJMSConnector()) {
                        object = new Random();
                        object2 = Integer.toString(((Random)object).nextInt(Integer.MAX_VALUE));
                        siebelJMSProperties.getPropertySet().setProperty("JMSCorrelationID", (String)object2);
                    }
                    object = (String)SiebelJNDISecurityContext.runAs(siebelJMSProperties.sendUsername(), siebelJMSProperties.sendPassword(), new JMSSecureSend(this, siebelJMSProperties));
                    this.commitSession();
                    if (object2 == null) {
                        object2 = object;
                    }
                    Message message = (Message)SiebelJNDISecurityContext.runAs(siebelJMSProperties.receiveUsername(), siebelJMSProperties.receivePassword(), new JMSSecureReceive(this, siebelJMSProperties, (String)object2));
                    this.setOutput(siebelPropertySet2, message);
                    String string4 = siebelPropertySet2.getProperty("TimedOut");
                    if (this.isDistributed && this.isReceiver) {
                        this.setMessagesPerConnection(string4);
                    }
                    break block36;
                }
                if (string.equalsIgnoreCase("Publish")) {
                    this.createConnection(siebelJMSProperties, "Topic");
                    this.createTopicSession(bl, n);
                    String string5 = (String)SiebelJNDISecurityContext.runAs(siebelJMSProperties.topicUsername(), siebelJMSProperties.topicPassword(), new JMSSecurePublish(this, siebelJMSProperties));
                    siebelPropertySet2.setProperty("JMSMessageID", string5);
                    siebelPropertySet2.setValue("<Message published>");
                    break block36;
                }
                if (string.equalsIgnoreCase("Subscribe")) {
                    String string6 = siebelJMSProperties.subscriberIdentifier();
                    if (string6 == null || string6.equals("")) {
                        throw new SiebelJMSException("MISSING_PARAMETER", "SubscriberIdentifier");
                    }
                    JMSBusinessService jMSBusinessService = this;
                    synchronized (jMSBusinessService) {
                        this.closeConnection();
                    }
                    this.createConnection(siebelJMSProperties, "Topic");
                    this.setConnectionClientID(string6);
                    this.createTopicSession(bl, n);
                    jMSBusinessService = (Message)SiebelJNDISecurityContext.runAs(siebelJMSProperties.topicUsername(), siebelJMSProperties.topicPassword(), new JMSSecureDurableSubscribe(this, siebelJMSProperties));
                    this.setOutput(siebelPropertySet2, (Message)jMSBusinessService);
                    break block36;
                }
                if (string.equalsIgnoreCase("Commit")) {
                    this.commitSession();
                    siebelPropertySet2.setValue("<Session committed>");
                    this.close();
                    break block36;
                }
                if (string.equalsIgnoreCase("Rollback")) {
                    this.rollbackSession();
                    siebelPropertySet2.setValue("<Session rolled back>");
                    this.close();
                    break block36;
                }
                if (string.equalsIgnoreCase("CloseConnection")) {
                    if (this.getConnection() != null) {
                        this.closeConnection();
                    }
                    siebelPropertySet2.setValue("<Connection closed>");
                    break block36;
                }
                if (string.startsWith("check") || string.startsWith("Check")) {
                    JMSDebugger.check(string, siebelPropertySet, siebelPropertySet2);
                    break block36;
                }
                throw new SiebelJMSException("INVALID_METHOD", string);
            }
            catch (SiebelJMSException siebelJMSException) {
                try {
                    this.rollbackSession();
                    this.close();
                    this.closeJNDI();
                    SiebelJMSLogger.log(1, null, string + " failed.");
                }
                catch (SiebelJMSException siebelJMSException2) {
                    throw siebelJMSException;
                }
                throw siebelJMSException;
            }
            catch (Throwable throwable) {
                try {
                    this.rollbackSession();
                    this.close();
                    this.closeJNDI();
                    SiebelJMSLogger.log(1, null, string + " failed.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                throwable.printStackTrace(printWriter);
                throw new SiebelJMSException("JMS_EXCEPTION", "An unexpected error occurred (see StackTrace): " + throwable.getMessage());
            }
        }
        if (this.getSession() != null) {
            if (siebelJMSProperties.commitTransaction()) {
                this.commitSession();
                this.close();
            } else {
                this.sessionIntentionallyLeftOpen = true;
                SiebelJMSLogger.log(4, null, "JMS session intentionally left open.");
            }
        }
        SiebelJMSLogger.log(5, null, string + " successfully executed.");
    }

    private void verifyReceiveTimeout(long l) throws SiebelJMSException {
        if (l == 0L) {
            throw new SiebelJMSException("INVALID_ARGUMENT", "ReceiveTimeout can not be Zero for a Receiver with Distributed Destinations");
        }
        if (l >= 30000L) {
            SiebelJMSLogger.log(2, null, "ReceiveTimeout of " + l + " is large for a Receiver. This may impact over-all performance");
        }
    }

    private void setMessagesPerConnection(String string) {
        ++this.msgsPerConnection;
        if (string.equalsIgnoreCase("true")) {
            this.msgsPerConnection = maxMessagesPerCon;
        }
    }

    private void setConnectionClientID(String string) throws SiebelJMSException {
        if (string == null || string.equals("")) {
            throw new SiebelJMSException("MISSING_PARAMETER", "SubscriberIdentifier");
        }
        try {
            this.getConnection().setClientID(string);
        }
        catch (InvalidClientIDException invalidClientIDException) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.getConnection().setClientID(string);
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("SETTING_CONNECTION_CLIENT_ID", (Exception)((Object)jMSException));
            }
        }
        catch (JMSException jMSException) {
            try {
                this.closeConnection();
            }
            catch (SiebelJMSException siebelJMSException) {
                // empty catch block
            }
            throw new SiebelJMSException("SETTING_CONNECTION_CLIENT_ID", (Exception)((Object)jMSException));
        }
    }

    private void createTopicSession(boolean bl, int n) throws SiebelJMSException {
        if (this.getSession() != null && !this.sessionIntentionallyLeftOpen) {
            this.closeSession();
        }
        if (this.getSession() == null) {
            try {
                TopicConnection topicConnection = null;
                try {
                    topicConnection = (TopicConnection)this.getConnection();
                }
                catch (ClassCastException classCastException) {
                    throw new SiebelJMSException("WRONG_CONNECTION_TYPE");
                }
                this.session = topicConnection.createTopicSession(bl, n);
                if (this.session == null) {
                    throw new SiebelJMSException("OBTAINING_TOPIC_SESSION");
                }
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("CREATING_SESSION", (Exception)((Object)jMSException));
            }
        }
    }

    Message subscribe(SiebelJMSProperties siebelJMSProperties) throws SiebelJMSException {
        if (siebelJMSProperties.topic() == null || siebelJMSProperties.topic().equals("")) {
            throw new SiebelJMSException("MISSING_PARAMETER", "Topic");
        }
        boolean bl = true;
        if (siebelJMSProperties.disableJNDIObjectCaching() != null && siebelJMSProperties.disableJNDIObjectCaching().equalsIgnoreCase("true")) {
            bl = false;
        }
        if (siebelJMSProperties.enableJNDIObjectCaching() != null && siebelJMSProperties.enableJNDIObjectCaching().equalsIgnoreCase("true")) {
            bl = true;
        }
        Topic topic = this.getJNDIContext().getTopic(siebelJMSProperties.topic(), bl);
        TopicSubscriber topicSubscriber = null;
        try {
            topicSubscriber = this.getTopicSession().createDurableSubscriber(topic, siebelJMSProperties.subscriberIdentifier());
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CREATING_DURABLE_SUBSCRIBER", (Exception)((Object)jMSException));
        }
        this.startConnection();
        Message message = null;
        try {
            message = topicSubscriber.receive(siebelJMSProperties.receiveTimeout());
            String string = siebelJMSProperties.subscriberIdentifier();
            if (message == null) {
                SiebelJMSLogger.log(4, siebelJMSProperties.topic(), string + " timed out after " + siebelJMSProperties.receiveTimeout() + " ms");
            } else {
                SiebelJMSLogger.log(4, siebelJMSProperties.topic(), string + " Message subscribed: " + SiebelJMSLogger.newline + message);
            }
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("RECEIVING_MESSAGE", (Exception)((Object)jMSException));
        }
        try {
            topicSubscriber.close();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CLOSING_SUBSCRIBER", (Exception)((Object)jMSException));
        }
        return message;
    }

    String publish(SiebelJMSProperties siebelJMSProperties) throws SiebelJMSException {
        if (siebelJMSProperties.topic() == null || siebelJMSProperties.topic().equals("")) {
            throw new SiebelJMSException("MISSING_PARAMETER", "Topic");
        }
        boolean bl = true;
        if (siebelJMSProperties.disableJNDIObjectCaching() != null && siebelJMSProperties.disableJNDIObjectCaching().equalsIgnoreCase("true")) {
            bl = false;
        }
        if (siebelJMSProperties.enableJNDIObjectCaching() != null && siebelJMSProperties.enableJNDIObjectCaching().equalsIgnoreCase("true")) {
            bl = true;
        }
        Topic topic = this.getJNDIContext().getTopic(siebelJMSProperties.topic(), bl);
        TopicPublisher topicPublisher = null;
        try {
            topicPublisher = this.getTopicSession().createPublisher(topic);
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CREATING_PUBLISHER", (Exception)((Object)jMSException));
        }
        Message message = this.createMessage(siebelJMSProperties);
        try {
            topicPublisher.publish(message, siebelJMSProperties.deliveryMode(), siebelJMSProperties.priority(), siebelJMSProperties.expiration());
            SiebelJMSLogger.log(4, siebelJMSProperties.topic(), "Published a " + message.getClass());
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("PUBLISHING_MESSAGE", (Exception)((Object)jMSException));
        }
        try {
            topicPublisher.close();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CLOSING_PUBLISHER", (Exception)((Object)jMSException));
        }
        String string = null;
        try {
            string = message.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("READING_MESSAGE_ID", (Exception)((Object)jMSException));
        }
        return string;
    }

    private void rollbackSession() throws SiebelJMSException {
        if (this.getSession() != null) {
            try {
                this.getSession().rollback();
                this.sessionIntentionallyLeftOpen = false;
                SiebelJMSLogger.log(4, null, "JMS session rolled back.");
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("ROLLING_BACK_SESSION", (Exception)((Object)jMSException));
            }
        }
    }

    private void setOutput(SiebelPropertySet siebelPropertySet, Message message) throws SiebelJMSException {
        Object object;
        Object object2;
        if (message == null) {
            siebelPropertySet.setProperty("TimedOut", "true");
            return;
        }
        siebelPropertySet.setProperty("TimedOut", "false");
        SiebelJMSLogger.log(4, null, "Received an instance of the " + message.getClass());
        if (message instanceof ObjectMessage) {
            this.processObjectMessage(siebelPropertySet, message);
        } else if (message instanceof TextMessage) {
            try {
                siebelPropertySet.setValue(((TextMessage)message).getText());
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("READING_TEXT_MESSAGE", (Exception)((Object)jMSException));
            }
        } else if (message instanceof BytesMessage) {
            try {
                object2 = (BytesMessage)message;
                object2.reset();
                object = JMSBusinessService.getBytes((BytesMessage)object2);
                siebelPropertySet.setByteValue((byte[])object);
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("READING_BYTES_MESSAGE", (Exception)((Object)jMSException));
            }
        } else {
            throw new SiebelJMSException("UNSUPPORTED_MESSAGE_TYPE", message.getClass().toString());
        }
        try {
            siebelPropertySet.setProperty("JMSMessageID", message.getJMSMessageID());
            siebelPropertySet.setProperty("JMSTimestamp", new Long(message.getJMSTimestamp()).toString());
            siebelPropertySet.setProperty("JMSRedelivered", new Boolean(message.getJMSRedelivered()).toString());
            if (message.getJMSType() != null) {
                siebelPropertySet.setProperty("JMSType", message.getJMSType());
            } else {
                siebelPropertySet.setProperty("JMSType", "");
            }
            if (message.getJMSCorrelationID() != null) {
                siebelPropertySet.setProperty("JMSCorrelationID", message.getJMSCorrelationID());
            } else {
                siebelPropertySet.setProperty("JMSCorrelationID", "");
            }
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("READING_HEADERS", (Exception)((Object)jMSException));
        }
        try {
            object2 = message.getPropertyNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (((String)object).startsWith("JMS")) continue;
                Object object3 = message.getObjectProperty((String)object);
                if (object3 != null) {
                    siebelPropertySet.setProperty("SIEBEL_JMS:" + (String)object, object3.toString());
                    continue;
                }
                siebelPropertySet.setProperty("SIEBEL_JMS:" + (String)object, "");
                SiebelJMSLogger.log(4, null, "Custom property " + (String)object + " has NULL value");
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void processObjectMessage(SiebelPropertySet siebelPropertySet, Message message) throws SiebelJMSException {
        try {
            SiebelJMSLogger.log(4, null, "Setting ObjectMessage");
            ObjectMessage objectMessage = (ObjectMessage)message;
            if (objectMessage != null) {
                SiebelPropertySet siebelPropertySet2 = (SiebelPropertySet)objectMessage.getObject();
                if (siebelPropertySet2 != null) {
                    SiebelJMSLogger.log(4, null, "Retrieved ObjectMessage");
                    siebelPropertySet.setType(siebelPropertySet2.getType());
                    siebelPropertySet.setValue(siebelPropertySet2.getValue());
                    Enumeration enumeration = siebelPropertySet2.getPropertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        siebelPropertySet.setProperty(string, siebelPropertySet2.getProperty(string));
                    }
                    if (siebelPropertySet2.getChildCount() > 0) {
                        for (int i = 0; i < siebelPropertySet2.getChildCount(); ++i) {
                            siebelPropertySet.addChild(siebelPropertySet2.getChild(i));
                        }
                    }
                } else {
                    SiebelJMSLogger.log(2, null, "SiebelPropertySet could not be retrieved");
                }
            } else {
                SiebelJMSLogger.log(2, null, "ObjectMessage could not be retrieved");
            }
        }
        catch (JMSException jMSException) {
            SiebelJMSLogger.log(1, null, "Exception : " + jMSException.getMessage());
            throw new SiebelJMSException("READING_OBJECT_MESSAGE", (Exception)((Object)jMSException));
        }
    }

    private void close() throws SiebelJMSException {
        this.closeSession();
        this.setSession(null);
        this.replyToQueue = null;
        if (!this.connectionCached || this.abortConnection()) {
            this.closeConnection();
        }
    }

    private void closeJNDI() throws SiebelJMSException {
        if (!this.jndiContextCached && this.getJNDIContext() != null) {
            this.getJNDIContext().close();
            this.jndiContext = null;
        }
    }

    private boolean abortConnection() {
        if (maxMessagesPerCon > 0 && this.isDistributed && this.isReceiver && this.msgsPerConnection >= maxMessagesPerCon) {
            this.msgsPerConnection = 0;
            return true;
        }
        return false;
    }

    private void closeSession() throws SiebelJMSException {
        if (this.getSession() == null) {
            return;
        }
        try {
            this.getSession().close();
            this.setSession(null);
            SiebelJMSLogger.log(4, null, "JMS session closed.");
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CLOSING_SESSION", (Exception)((Object)jMSException));
        }
    }

    private void closeConnection() throws SiebelJMSException {
        if (this.getConnection() != null) {
            try {
                this.getConnection().stop();
                this.getConnection().close();
                this.connection = null;
                SiebelJMSLogger.log(4, null, "Connection is closed");
            }
            catch (IllegalStateException illegalStateException) {
                SiebelJMSLogger.log(1, null, "fail to close connection due to exception:" + illegalStateException.getMessage() + "\nignore the exception and throw away the connection.");
                this.connection = null;
            }
            catch (JMSException jMSException) {
                this.connection = null;
                throw new SiebelJMSException("CLOSING_CONNECTION", (Exception)((Object)jMSException));
            }
        }
    }

    private void commitSession() throws SiebelJMSException {
        try {
            this.getSession().commit();
            this.sessionIntentionallyLeftOpen = false;
            SiebelJMSLogger.log(4, null, "JMS session committed.");
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("COMMITTING_SESSION", (Exception)((Object)jMSException));
        }
    }

    private void createQueueSession(boolean bl, int n) throws SiebelJMSException {
        if (this.getSession() != null && !this.sessionIntentionallyLeftOpen) {
            this.closeSession();
        }
        if (this.getSession() == null) {
            try {
                QueueConnection queueConnection = null;
                try {
                    queueConnection = (QueueConnection)this.getConnection();
                }
                catch (ClassCastException classCastException) {
                    throw new SiebelJMSException("WRONG_CONNECTION_TYPE");
                }
                this.session = queueConnection.createQueueSession(bl, n);
                if (this.session == null) {
                    throw new SiebelJMSException("OBTAINING_QUEUE_SESSION");
                }
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("CREATING_SESSION", (Exception)((Object)jMSException));
            }
        }
    }

    Message receive(SiebelJMSProperties siebelJMSProperties, String string) throws SiebelJMSException {
        if (siebelJMSProperties.receiveQueue() == null || siebelJMSProperties.receiveQueue().equals("")) {
            throw new SiebelJMSException("MISSING_PARAMETER", "ReceiveQueue");
        }
        boolean bl = true;
        if (siebelJMSProperties.disableJNDIObjectCaching() != null && siebelJMSProperties.disableJNDIObjectCaching().equalsIgnoreCase("true")) {
            bl = false;
        }
        if (siebelJMSProperties.enableJNDIObjectCaching() != null && siebelJMSProperties.enableJNDIObjectCaching().equalsIgnoreCase("true")) {
            bl = true;
        }
        Queue queue = this.getJNDIContext().getQueue(siebelJMSProperties.receiveQueue(), bl);
        QueueReceiver queueReceiver = null;
        try {
            queueReceiver = string != null ? this.getQueueSession().createReceiver(queue, "JMSCorrelationID = '" + string + "'") : this.getQueueSession().createReceiver(queue);
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CREATING_RECEIVER", (Exception)((Object)jMSException));
        }
        this.startConnection();
        Message message = null;
        try {
            message = queueReceiver.receive(siebelJMSProperties.receiveTimeout());
            if (message == null) {
                SiebelJMSLogger.log(4, siebelJMSProperties.receiveQueue(), "Timed out after " + siebelJMSProperties.receiveTimeout() + " ms");
            } else {
                SiebelJMSLogger.log(4, siebelJMSProperties.receiveQueue(), "Message received");
            }
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("RECEIVING_MESSAGE", (Exception)((Object)jMSException));
        }
        try {
            queueReceiver.close();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CLOSING_RECEIVER", (Exception)((Object)jMSException));
        }
        return message;
    }

    private void startConnection() throws SiebelJMSException {
        try {
            this.getConnection().start();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("STARTING_CONNECTION", (Exception)((Object)jMSException));
        }
    }

    public void onException(JMSException jMSException) {
        SiebelJMSLogger.log(1, "onException called: ", (Exception)((Object)jMSException));
        try {
            this.closeConnection();
        }
        catch (SiebelJMSException siebelJMSException) {
            this.connection = null;
        }
        catch (NullPointerException nullPointerException) {
            SiebelJMSLogger.log(1, "NullPointerException during closeConnection() in response to onException: ", (Exception)((Object)jMSException));
        }
    }

    String send(SiebelJMSProperties siebelJMSProperties) throws SiebelJMSException {
        String string;
        Queue queue = this.replyToQueue;
        if (queue == null) {
            string = siebelJMSProperties.sendQueue();
            if (string == null || string.equals("")) {
                throw new SiebelJMSException("MISSING_PARAMETER", "SendQueue");
            }
            boolean bl = true;
            if (siebelJMSProperties.disableJNDIObjectCaching() != null && siebelJMSProperties.disableJNDIObjectCaching().equalsIgnoreCase("true")) {
                bl = false;
            }
            if (siebelJMSProperties.enableJNDIObjectCaching() != null && siebelJMSProperties.enableJNDIObjectCaching().equalsIgnoreCase("true")) {
                bl = true;
            }
            queue = this.getJNDIContext().getQueue(string, bl);
        }
        string = null;
        try {
            string = this.getQueueSession().createSender(queue);
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CREATING_SENDER", (Exception)((Object)jMSException));
        }
        Message message = this.createMessage(siebelJMSProperties);
        try {
            string.send(message, siebelJMSProperties.deliveryMode(), siebelJMSProperties.priority(), siebelJMSProperties.expiration());
            SiebelJMSLogger.log(4, siebelJMSProperties.sendQueue(), "Sent a " + message.getClass());
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("SENDING_MESSAGE", (Exception)((Object)jMSException));
        }
        try {
            string.close();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CLOSING_SENDER", (Exception)((Object)jMSException));
        }
        String string2 = null;
        try {
            string2 = message.getJMSMessageID();
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("READING_MESSAGE_ID", (Exception)((Object)jMSException));
        }
        return string2;
    }

    private Message createMessage(SiebelJMSProperties siebelJMSProperties) throws SiebelJMSException {
        ObjectMessage objectMessage = null;
        if (siebelJMSProperties.jmsType().equalsIgnoreCase("ObjectMessage")) {
            try {
                objectMessage = this.getSession().createObjectMessage((Serializable)siebelJMSProperties.getPropertySet());
                SiebelJMSLogger.log(4, null, "Created ObjectMessage");
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("CREATING_OBJECT_MESSAGE", (Exception)((Object)jMSException));
            }
        }
        if (siebelJMSProperties.isStringValue()) {
            try {
                objectMessage = this.getSession().createTextMessage(siebelJMSProperties.getValue());
                SiebelJMSLogger.log(4, null, "Creating TextMessage ");
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("CREATING_TEXT_MESSAGE", (Exception)((Object)jMSException));
            }
        }
        try {
            byte[] byArray;
            objectMessage = this.getSession().createBytesMessage();
            if (siebelJMSProperties.isFileRef()) {
                SiebelJMSLogger.log(4, null, "ReadingFile..");
                byArray = this.readFile(siebelJMSProperties);
            } else {
                byArray = siebelJMSProperties.getByteValue();
            }
            if (byArray != null) {
                ((BytesMessage)objectMessage).writeBytes(byArray);
            }
            SiebelJMSLogger.log(4, null, "Creating BytesMessage");
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("CREATING_BYTES_MESSAGE", (Exception)((Object)jMSException));
        }
        try {
            objectMessage.setJMSType(siebelJMSProperties.jmsType());
            if (siebelJMSProperties.correlationID() != null) {
                objectMessage.setJMSCorrelationID(siebelJMSProperties.correlationID());
            }
            if (siebelJMSProperties.replyTo() != null) {
                boolean bl = true;
                if (siebelJMSProperties.disableJNDIObjectCaching() != null && siebelJMSProperties.disableJNDIObjectCaching().equalsIgnoreCase("true")) {
                    bl = false;
                }
                if (siebelJMSProperties.enableJNDIObjectCaching() != null && siebelJMSProperties.enableJNDIObjectCaching().equalsIgnoreCase("true")) {
                    bl = true;
                }
                Queue queue = this.getJNDIContext().getQueue(siebelJMSProperties.replyTo(), bl);
                objectMessage.setJMSReplyTo((Destination)queue);
            }
        }
        catch (JMSException jMSException) {
            throw new SiebelJMSException("SETTING_MESSAGE_HEADER", (Exception)((Object)jMSException));
        }
        HashMap hashMap = siebelJMSProperties.getMessageProperties();
        if (hashMap.size() > 0) {
            for (String string : hashMap.keySet()) {
                String string2 = (String)hashMap.get(string);
                try {
                    objectMessage.setStringProperty(string, string2);
                }
                catch (JMSException jMSException) {
                    throw new SiebelJMSException("SETTING_MESSAGE_PROPERTIES", (Exception)((Object)jMSException));
                }
            }
        }
        return objectMessage;
    }

    private void createConnection(SiebelJMSProperties siebelJMSProperties, String string) throws SiebelJMSException {
        String string2 = siebelJMSProperties.connectionFactory();
        String string3 = siebelJMSProperties.connectionUsername();
        String string4 = siebelJMSProperties.connectionPassword();
        if (string2 == null) {
            throw new SiebelJMSException("MISSING_PARAMETER", "ConnectionFactory");
        }
        if (this.getConnection() == null || !string2.equals(this.cachedFactoryName) || string3 == null && this.cachedConnectionUsername != null || string3 != null && !string3.equals(this.cachedConnectionUsername) || string4 == null && this.cachedConnectionPassword != null || string4 != null && !string4.equals(this.cachedConnectionPassword)) {
            if (this.getConnection() != null) {
                this.closeConnection();
                SiebelJMSLogger.log(4, null, "Replacing connection from ConnectionFactory " + this.cachedFactoryName + " with one from " + string2 + " or with differnt credential");
            } else {
                SiebelJMSLogger.log(4, null, "No cached connection found");
            }
            boolean bl = true;
            if (siebelJMSProperties.disableJNDIObjectCaching() != null && siebelJMSProperties.disableJNDIObjectCaching().equalsIgnoreCase("true")) {
                bl = false;
            }
            if (siebelJMSProperties.enableJNDIObjectCaching() != null && siebelJMSProperties.enableJNDIObjectCaching().equalsIgnoreCase("true")) {
                bl = true;
            }
            ConnectionFactory connectionFactory = this.getJNDIContext().getFactory(string2, bl);
            try {
                if ("Queue".equals(string)) {
                    this.connection = siebelJMSProperties.connectionUsername() == null || siebelJMSProperties.connectionUsername().equals("") ? ((QueueConnectionFactory)connectionFactory).createQueueConnection() : ((QueueConnectionFactory)connectionFactory).createQueueConnection(siebelJMSProperties.connectionUsername(), siebelJMSProperties.connectionPassword());
                } else if ("Topic".equals(string)) {
                    this.connection = siebelJMSProperties.connectionUsername() == null || siebelJMSProperties.connectionUsername().equals("") ? ((TopicConnectionFactory)connectionFactory).createTopicConnection() : ((TopicConnectionFactory)connectionFactory).createTopicConnection(siebelJMSProperties.connectionUsername(), siebelJMSProperties.connectionPassword());
                }
            }
            catch (JMSException jMSException) {
                throw new SiebelJMSException("CREATING_CONNECTION", (Exception)((Object)jMSException));
            }
            if (this.getConnection() == null) {
                throw new SiebelJMSException("OBTAINING_CONNECTION");
            }
            this.cachedFactoryName = string2;
            this.cachedConnectionUsername = string3;
            this.cachedConnectionPassword = string4;
            if (siebelJMSProperties.connectionUsername() == null || siebelJMSProperties.connectionUsername().equals("")) {
                SiebelJMSLogger.log(4, null, "New connection created");
            } else {
                SiebelJMSLogger.log(4, null, "New secure connection created");
            }
        }
    }

    private byte[] readFile(SiebelJMSProperties siebelJMSProperties) throws SiebelJMSException {
        String string = siebelJMSProperties.getFileRef();
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[(int)file.length()];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            dataInputStream.close();
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SiebelJMSException("READ_FILE_ERROR", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new SiebelJMSException("READ_FILE_ERROR", iOException);
        }
    }

    private SiebelJNDIContext getJNDIContext() throws SiebelJMSException {
        if (this.jndiContext == null) {
            this.jndiContext = new SiebelJNDIContext(this.environment, this.jndiDecryptionEnv);
        }
        return this.jndiContext;
    }

    public Session getSession() {
        return this.session;
    }

    public QueueSession getQueueSession() throws SiebelJMSException {
        try {
            return (QueueSession)this.session;
        }
        catch (ClassCastException classCastException) {
            throw new SiebelJMSException("WRONG_SESSION_TYPE");
        }
    }

    public TopicSession getTopicSession() throws SiebelJMSException {
        try {
            return (TopicSession)this.session;
        }
        catch (ClassCastException classCastException) {
            throw new SiebelJMSException("WRONG_SESSION_TYPE");
        }
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

