/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.data.SiebelPropertySet;
import com.siebel.eai.SiebelBusinessServiceException;
import com.siebel.eai.jms.JMSBusinessService;
import com.siebel.eai.jms.JMSCheckSubscribe;
import com.siebel.eai.jms.JMSCreateDurableSubscriber;
import com.siebel.eai.jms.JMSPublish;
import com.siebel.eai.jms.JMSReceiveNoWait;
import com.siebel.eai.jms.JMSSend;
import com.siebel.eai.jms.SiebelJMSException;
import com.siebel.eai.jms.SiebelJMSLogger;
import com.siebel.eai.jms.SiebelJNDISecurityContext;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JMSDebugger {
    private static final String newline = System.getProperty("line.separator");
    private Topic topic;
    private Queue queue;
    private ConnectionFactory connectionFactory;
    private InitialContext jndi;
    private SiebelPropertySet input;
    private String output = "";

    public static void main(String[] stringArray) throws SiebelBusinessServiceException {
        JMSBusinessService jMSBusinessService = new JMSBusinessService("f:\\debug_scratch\\jms\\jmsdebugger.log", 1);
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        SiebelPropertySet siebelPropertySet2 = new SiebelPropertySet();
        siebelPropertySet.setProperty("ConnectionFactory", stringArray[0]);
        if (stringArray[1].equalsIgnoreCase("queue")) {
            siebelPropertySet.setProperty("SendQueue", stringArray[2]);
        } else {
            siebelPropertySet.setProperty("Topic", stringArray[2]);
        }
        if (stringArray.length > 3) {
            siebelPropertySet.setProperty("ConnectionUsername", stringArray[3]);
            siebelPropertySet.setProperty("ConnectionPassword", stringArray[4]);
        }
        jMSBusinessService.doInvokeMethod("CheckAll", siebelPropertySet, siebelPropertySet2);
        System.out.println("Output property set: ");
        System.out.println(siebelPropertySet2.toString());
    }

    public static void check(String string, SiebelPropertySet siebelPropertySet, SiebelPropertySet siebelPropertySet2) throws SiebelJMSException {
        JMSDebugger jMSDebugger;
        block8: {
            jMSDebugger = new JMSDebugger();
            try {
                jMSDebugger.input(siebelPropertySet);
                if (string.equalsIgnoreCase("checkClasspath")) {
                    jMSDebugger.checkClasspath();
                    break block8;
                }
                if (string.equalsIgnoreCase("checkJNDIContext")) {
                    jMSDebugger.checkJNDIContext();
                    break block8;
                }
                if (string.equalsIgnoreCase("checkJNDIObjects")) {
                    jMSDebugger.checkJNDIObjects();
                    break block8;
                }
                if (string.equalsIgnoreCase("checkJMSServer")) {
                    jMSDebugger.checkJMSServer();
                    break block8;
                }
                if (string.equalsIgnoreCase("checkAll")) {
                    jMSDebugger.checkAll();
                    break block8;
                }
                throw new SiebelJMSException("INVALID_METHOD", string);
            }
            catch (SiebelJMSException siebelJMSException) {
                throw siebelJMSException;
            }
            catch (Throwable throwable) {
                jMSDebugger.println("An unexpected error occurred: " + throwable.toString());
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                throwable.printStackTrace(printWriter);
                jMSDebugger.println(new String(stringWriter.getBuffer()));
            }
        }
        jMSDebugger.println("SUCCESSFUL TEST");
        SiebelJMSLogger.log(4, null, newline + jMSDebugger.output);
        siebelPropertySet2.setValue(jMSDebugger.output);
    }

    private void publishSubscribe() throws SiebelJMSException {
        SimpleDateFormat simpleDateFormat;
        String string = this.input.getProperty("Topic");
        String string2 = this.input.getProperty("ConnectionUsername");
        String string3 = this.input.getProperty("ConnectionPassword");
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        TopicSubscriber topicSubscriber = null;
        String string4 = "DurSubTest01";
        try {
            this.println("Creating a durable subscriber \"DurSubTest01\" on " + string + "...");
            topicConnection = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
            topicConnection.setClientID(string4);
            topicSession = topicConnection.createTopicSession(false, 1);
            topicSubscriber = (TopicSubscriber)SiebelJNDISecurityContext.runAs(string2, string3, new JMSCreateDurableSubscriber(topicSession, this.topic, string4));
            topicConnection.start();
        }
        catch (Exception exception) {
            this.println("ERROR:  Exception creating durable subscriber:  " + exception.toString());
            try {
                if (topicConnection != null) {
                    topicConnection.close();
                }
                if (topicSession != null) {
                    topicSession.close();
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw new SiebelJMSException("CREATING_DURABLE_SUBSCRIBER", "ERROR:  JMSException creating durable subscriber:  " + exception.toString());
        }
        try {
            simpleDateFormat = new SimpleDateFormat("E MMM d h:mm a");
            this.println("Publishing a message to " + string + "...");
            TopicConnection topicConnection2 = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(string2, string3);
            TopicSession topicSession2 = topicConnection2.createTopicSession(false, 1);
            TextMessage textMessage = topicSession2.createTextMessage();
            textMessage.setText("A TextMessage published by Diagnose " + simpleDateFormat.format(new Date()));
            SiebelJNDISecurityContext.runAs(string2, string3, new JMSPublish(topicSession2, this.topic, (Message)textMessage));
            topicConnection2.start();
            topicSession2.close();
            topicConnection2.close();
        }
        catch (Exception exception) {
            this.println("ERROR:  Exception publishing message:  " + exception.toString());
            throw new SiebelJMSException("PUBLISHING_MESSAGE", "ERROR:  JMSException publishing message:  " + exception.toString());
        }
        try {
            this.println("Subscriber checking for message on " + string + "...");
            simpleDateFormat = (Message)SiebelJNDISecurityContext.runAs(string2, string3, new JMSCheckSubscribe(topicSubscriber));
            if (simpleDateFormat == null) {
                this.println("ERROR:  No message received");
                throw new SiebelJMSException("PUBLISHING_MESSAGE", "ERROR:  No message received");
            }
            this.println("Received message");
            this.println("Removing durable subscriber...");
            topicSubscriber.close();
            topicSession.unsubscribe("DurSubTest01");
            topicSession.close();
            topicConnection.close();
        }
        catch (Exception exception) {
            try {
                topicConnection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.println("ERROR:  Exception checking subscription: " + exception.toString());
            throw new SiebelJMSException("PUBLISHING_MESSAGE", "ERROR:  JMSException checking subscription: " + exception.toString());
        }
    }

    private void sendReceive() throws SiebelJMSException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E MMM d h:mm a");
        String string = this.input.getProperty("SendQueue");
        String string2 = this.input.getProperty("SendUsername");
        String string3 = this.input.getProperty("SendPassword");
        try {
            this.println("Create connection");
            QueueConnection queueConnection = string2 == null || string2.equals("") ? ((QueueConnectionFactory)this.connectionFactory).createQueueConnection() : ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(string2, string3);
            QueueSession queueSession = queueConnection.createQueueSession(false, 1);
            this.println("Sending a message to " + string + "...");
            TextMessage textMessage = queueSession.createTextMessage();
            textMessage.setText("A TextMessage sent by Diagnose " + simpleDateFormat.format(new Date()));
            SiebelJNDISecurityContext.runAs(string2, string3, new JMSSend(queueSession, this.queue, (Message)textMessage));
            this.println("Receiving a message from " + string + "...");
            queueConnection.start();
            Message message = (Message)SiebelJNDISecurityContext.runAs(string2, string3, new JMSReceiveNoWait(queueSession, this.queue));
            if (message == null) {
                this.println("ERROR:  No message received.");
                throw new SiebelJMSException("SENDING_MESSAGE", "ERROR:  No message received.");
            }
            this.println("Received message:" + message);
            queueSession.close();
            queueConnection.close();
        }
        catch (Exception exception) {
            this.println("ERROR:  Exception during send/receive: " + exception.toString());
            throw new SiebelJMSException("SENDING_MESSAGE", "ERROR:  JMSException during send/receive: " + exception.toString());
        }
    }

    private void checkAll() throws SiebelJMSException {
        this.println("1. Checking classpath ...");
        this.checkClasspath();
        this.println(newline + "2. Checking JNDI context...");
        if (!this.checkJNDIContext()) {
            return;
        }
        this.println(newline + "3. Checking JNDI administered objects...");
        if (!this.checkJNDIObjects()) {
            return;
        }
        this.println(newline + "4. Checking JMS server ...");
        this.checkJMSServer();
    }

    private void checkJMSServer() throws SiebelJMSException {
        if (this.connectionFactory == null && !this.checkJNDIObjects()) {
            return;
        }
        if (this.queue != null) {
            this.println("Found queue; testing point-to-point (send and receive)...");
            this.sendReceive();
        } else if (this.topic != null) {
            this.println("Found topic; testing publish and subscribe...");
            this.publishSubscribe();
        }
    }

    private boolean checkJNDIObjects() throws SiebelJMSException {
        String string;
        if (this.jndi == null) {
            this.checkJNDIContext();
        }
        if ((string = this.input.getProperty("ConnectionFactory")) == null) {
            this.println("ERROR:  Property ConnectionFactory not specified.");
            throw new SiebelJMSException("MISSING_PARAMETER", "ERROR:  Property ConnectionFactory not specified.");
        }
        this.connectionFactory = (ConnectionFactory)this.lookup(string, ConnectionFactory.class);
        if (this.connectionFactory == null) {
            throw new SiebelJMSException("LOOKING_UP_CONNECTION_FACTORY", "JNDI Look up for " + string + " Failed");
        }
        String string2 = this.input.getProperty("SendQueue");
        String string3 = null;
        if (string2 != null) {
            this.queue = (Queue)this.lookup(string2, Queue.class);
        } else {
            string3 = this.input.getProperty("Topic");
            if (string3 != null) {
                this.topic = (Topic)this.lookup(string3, Topic.class);
            } else {
                this.println("WARNING:  Neither property SendQueue nor Topic specified.");
                return false;
            }
        }
        if (this.queue == null && this.topic == null) {
            this.println("WARNING:  Could not find queue or topic.");
            if (string2 != null) {
                throw new SiebelJMSException("LOOKING_UP_QUEUE", "JNDI Look up for " + string2 + " Failed");
            }
            if (string3 != null) {
                throw new SiebelJMSException("LOOKING_UP_TOPIC", "JNDI Look up for " + string3 + " Failed");
            }
            return false;
        }
        return true;
    }

    private Object lookup(String string, Class clazz) {
        Object object = null;
        try {
            object = this.jndi.lookup(string);
        }
        catch (NamingException namingException) {
            this.println("ERROR:  JNDI cannot find an object named " + string);
            return null;
        }
        if (clazz.isInstance(object)) {
            this.println("Successfully retrieved " + string + ", a " + clazz.getName());
            return object;
        }
        String string2 = null;
        try {
            string2 = ((Reference)object).getClassName();
        }
        catch (ClassCastException classCastException) {
            this.println("ERROR:  JNDI found an object named " + string + newline + "        but it is neither a " + clazz + " nor a javax.naming.Reference");
            return null;
        }
        try {
            Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.println("ERROR:  Object retrieved from JNDI under the name of " + string + newline + "        refers to an instance of the class " + string2 + newline + "        but that class is not found in classpath.");
            return null;
        }
        this.println("ERROR:  Retrieved an object of type " + string2 + " instead of type " + clazz.getName());
        return null;
    }

    private boolean checkJNDIContext() throws SiebelJMSException {
        Object object;
        Object object2;
        NamingEnumeration<NameClassPair> namingEnumeration;
        try {
            namingEnumeration = this.input.getProperty("ConnectionUsername");
            object2 = this.input.getProperty("ConnectionPassword");
            object = new Hashtable<String, String>();
            ((Hashtable)object).put("java.naming.security.principal", namingEnumeration);
            ((Hashtable)object).put("java.naming.security.credentials", object2);
            this.println("enabling SSL ");
            ((Hashtable)object).put("java.naming.security.protocol", "ssl");
            this.jndi = new InitialContext((Hashtable<?, ?>)object);
            this.println("Created JNDI InitialContext with ");
        }
        catch (NamingException namingException) {
            this.println("ERROR:  Cannot create JNDI InitialContext: " + namingException.toString());
            throw new SiebelJMSException("CREATING_JNDI_CONTEXT", "Cannot create JNDI InitialContext: " + namingException.toString());
        }
        try {
            namingEnumeration = this.jndi.getEnvironment();
            object2 = ((Hashtable)((Object)namingEnumeration)).keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.println("  " + (String)object + " = " + ((Hashtable)((Object)namingEnumeration)).get(object).toString());
            }
        }
        catch (NamingException namingException) {
            this.println("ERROR retrieving environment from JNDI InitialContext: " + namingException.getMessage());
        }
        try {
            this.println("The InitialContext has the following entries:");
            namingEnumeration = this.jndi.list("");
            while (namingEnumeration.hasMoreElements()) {
                object2 = namingEnumeration.next();
                this.println("  " + ((NameClassPair)object2).getName() + " (" + ((NameClassPair)object2).getClassName() + ")");
            }
        }
        catch (NamingException namingException) {
            this.println("ERROR retrieving listing from JNDI InitialContext: " + namingException.getMessage());
            return true;
        }
        return true;
    }

    private void checkClasspath() throws SiebelJMSException {
        this.println("");
        String string = System.getProperty("java.class.path");
        this.println("java.class.path = " + string);
        this.println("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
                try {
                    object = new JarFile(string2);
                    this.println("Found jar file " + ((ZipFile)object).getName() + " with " + ((ZipFile)object).size() + " entries.");
                    if (((JarFile)object).getEntry("jndi.properties") == null) continue;
                    this.println("NOTE:  A jndi.properties file is present in " + ((ZipFile)object).getName());
                    bl = true;
                    continue;
                }
                catch (IOException iOException) {
                    this.println("ERROR:  Cannot find jar file " + string2 + newline + "  ");
                    throw new SiebelJMSException("WRONG_CLASSPATH", "ERROR:  Cannot find jar file " + string2 + newline + "Please check CLASSPATH");
                }
            }
            object = new File(string2);
            if (((File)object).exists()) {
                if (((File)object).isDirectory()) {
                    this.println("Found directory " + ((File)object).getAbsolutePath());
                    File[] fileArray = ((File)object).listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.equals("jndi.properties");
                        }
                    });
                    if (fileArray.length <= 0) continue;
                    this.println("NOTE:  A jndi.properties file is present in " + ((File)object).getAbsolutePath());
                    bl = true;
                    continue;
                }
                this.println("Found file " + ((File)object).getAbsolutePath());
                continue;
            }
            this.println("Cannot find file/dir " + ((File)object).getAbsolutePath());
            throw new SiebelJMSException("WRONG_CLASSPATH", "Cannot find file/dir " + ((File)object).getAbsolutePath() + newline + "Please check CLASSPATH");
        }
        if (!bl) {
            this.println("WARNING:  No jndi.properties file was found in the CLASSPATH");
        }
    }

    private void println(String string) {
        this.output = this.output + string + newline;
    }

    private void input(SiebelPropertySet siebelPropertySet) {
        this.input = siebelPropertySet;
        this.println("Input property set: " + siebelPropertySet.toString());
    }
}

