/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import java.io.PrintWriter;
import java.io.StringWriter;

public class SiebelJMSException
extends Exception {
    Exception wrappedException;
    String errorMessage = "";
    String errorSubtype;
    public static final String WRONG_CONNECTION_TYPE = "WRONG_CONNECTION_TYPE";
    public static final String WRONG_SESSION_TYPE = "WRONG_SESSION_TYPE";
    public static final String WRONG_CLASSPATH = "WRONG_CLASSPATH";
    public static final String INVALID_METHOD = "INVALID_METHOD";
    public static final String INVALID_ARGUMENT = "INVALID_ARGUMENT";
    public static final String MISSING_PARAMETER = "MISSING_PARAMETER";
    public static final String UNSUPPORTED_MESSAGE_TYPE = "UNSUPPORTED_MESSAGE_TYPE";
    public static final String CLOSING_JNDI_CONNECTION = "CLOSING_JNDI_CONNECTION";
    public static final String CREATING_JNDI_CONTEXT = "CREATING_JNDI_CONTEXT";
    public static final String LOOKING_UP_CONNECTION_FACTORY = "LOOKING_UP_CONNECTION_FACTORY";
    public static final String LOOKING_UP_QUEUE = "LOOKING_UP_QUEUE";
    public static final String LOOKING_UP_TOPIC = "LOOKING_UP_TOPIC";
    public static final String CLOSING_CONNECTION = "CLOSING_CONNECTION";
    public static final String CLOSING_PUBLISHER = "CLOSING_PUBLISHER";
    public static final String CLOSING_RECEIVER = "CLOSING_RECEIVER";
    public static final String CLOSING_SENDER = "CLOSING_SENDER";
    public static final String CLOSING_SESSION = "CLOSING_SESSION";
    public static final String CLOSING_SUBSCRIBER = "CLOSING_SUBSCRIBER";
    public static final String COMMITTING_SESSION = "COMMITTING_SESSION";
    public static final String ROLLING_BACK_SESSION = "ROLLING_BACK_SESSION";
    public static final String CREATING_BYTES_MESSAGE = "CREATING_BYTES_MESSAGE";
    public static final String CREATING_DURABLE_SUBSCRIBER = "CREATING_DURABLE_SUBSCRIBER";
    public static final String CREATING_TEXT_MESSAGE = "CREATING_TEXT_MESSAGE";
    public static final String CREATING_OBJECT_MESSAGE = "CREATING_OBJECT_MESSAGE";
    public static final String CREATING_CONNECTION = "CREATING_CONNECTION";
    public static final String CREATING_PUBLISHER = "CREATING_PUBLISHER";
    public static final String CREATING_RECEIVER = "CREATING_RECEIVER";
    public static final String CREATING_SENDER = "CREATING_SENDER";
    public static final String CREATING_SESSION = "CREATING_SESSION";
    public static final String OBTAINING_CONNECTION = "OBTAINING_CONNECTION";
    public static final String OBTAINING_QUEUE_SESSION = "OBTAINING_QUEUE_SESSION";
    public static final String OBTAINING_TOPIC_SESSION = "OBTAINING_TOPIC_SESSION";
    public static final String PUBLISHING_MESSAGE = "PUBLISHING_MESSAGE";
    public static final String READING_BYTES_MESSAGE = "READING_BYTES_MESSAGE";
    public static final String READING_TEXT_MESSAGE = "READING_TEXT_MESSAGE";
    public static final String READING_OBJECT_MESSAGE = "READING_OBJECT_MESSAGE";
    public static final String READING_MESSAGE_ID = "READING_MESSAGE_ID";
    public static final String READING_HEADERS = "READING_HEADERS";
    public static final String RECEIVING_MESSAGE = "RECEIVING_MESSAGE";
    public static final String SENDING_MESSAGE = "SENDING_MESSAGE";
    public static final String SETTING_CONNECTION_CLIENT_ID = "SETTING_CONNECTION_CLIENT_ID";
    public static final String SETTING_MESSAGE_HEADER = "SETTING_MESSAGE_HEADER";
    public static final String SETTING_MESSAGE_PROPERTIES = "SETTING_MESSAGE_PROPERTIES";
    public static final String STARTING_CONNECTION = "STARTING_CONNECTION";
    public static final String RUN_SECURE_ACTION = "RUNNING_SECURE_ACTION";
    public static final String LOGIN_USER = "LOGIN_USER";
    public static final String LOGOUT_USER = "LOGOUT_USER";
    public static final String READ_FILE_ERROR = "READ_FILE_ERROR";

    public SiebelJMSException(String string) {
        this.errorSubtype = string;
    }

    public SiebelJMSException(String string, String string2) {
        this.errorSubtype = string;
        this.errorMessage = string2;
    }

    public String getErrorCode() {
        if (this.getErrorSubtype().indexOf("WRONG") > -1) {
            return "INTERNAL_ERROR";
        }
        if (this.getErrorSubtype().indexOf("MISSING") > -1) {
            return this.getErrorSubtype();
        }
        if (this.getErrorSubtype().indexOf(INVALID_METHOD) > -1) {
            return this.getErrorSubtype();
        }
        if (this.getErrorSubtype().indexOf(INVALID_ARGUMENT) > -1) {
            return this.getErrorSubtype();
        }
        if (this.getErrorSubtype().indexOf("UNSUPPORTED") > -1) {
            return this.getErrorSubtype();
        }
        if (this.getErrorSubtype().indexOf("JNDI") > -1 || this.getErrorSubtype().indexOf("LOOKING_UP") > -1) {
            return "JNDI_ERROR";
        }
        return "JMS_EXCEPTION";
    }

    @Override
    public String toString() {
        String string = "SiebelJMSException errorSubtype=" + this.getErrorSubtype();
        if (this.getWrappedException() != null) {
            string = string + " (wrapped exception = " + this.getWrappedException().toString() + ")";
        }
        return string;
    }

    public SiebelJMSException(String string, Exception exception) {
        this.errorSubtype = string;
        this.wrappedException = exception;
        this.errorMessage = "Exception: " + exception.toString() + "; Message: " + exception.getMessage();
    }

    public Exception getWrappedException() {
        return this.wrappedException;
    }

    public String getStackTraceString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.getWrappedException() != null) {
            this.getWrappedException().printStackTrace(printWriter);
        } else {
            this.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public String getErrorSubtype() {
        return this.errorSubtype;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }
}

