/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.common.common.CSSUtilities;
import com.siebel.eai.jms.JMSTraceLevel;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SiebelJMSLogger {
    public static String newline = System.getProperty("line.separator");
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("h:mm:ss.SSS a E MMM d");
    private static ThreadLocal logger = new ThreadLocal();
    private static ThreadLocal logging = new ThreadLocal();
    private static int logLevelVar = 5;
    private static Lock m_lock = new ReentrantLock();

    public static void setLogFile(String string) {
        if ((string = CSSUtilities.ValidateAndFormatLogFileName(string)) == null) {
            logging.set(false);
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                PrintStream printStream = new PrintStream(fileOutputStream, true);
                logging.set(true);
                logger.set(printStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("SiebelJMSLogger cannot find file " + string + "; logging is disabled.");
                logging.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int n, String string, String string2) {
        if (n > logLevelVar) {
            return;
        }
        if (logging != null && logging.get() != null && ((Boolean)logging.get()).booleanValue()) {
            String string3 = "[SIEBEL " + JMSTraceLevel.getLogLevelName(n) + "]\t";
            string3 = string3 + Thread.currentThread().toString();
            string3 = string3 + "\t[";
            string3 = string3 + SiebelJMSLogger.getDate();
            string3 = string3 + "] ";
            if (string != null) {
                string3 = string3 + string + " -- ";
            }
            string3 = string3 + string2;
            PrintStream printStream = (PrintStream)logger.get();
            if (printStream != null) {
                m_lock.lock();
                try {
                    printStream.println(string3);
                }
                finally {
                    m_lock.unlock();
                }
            }
        }
    }

    private static String getDate() {
        return dateFormat.format(new Date()) + ": ";
    }

    public static void logln(int n, String string, String string2) {
        SiebelJMSLogger.log(n, string, string2 + newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int n, String string, Exception exception) {
        if (n > logLevelVar) {
            return;
        }
        if (logging != null && logging.get() != null && ((Boolean)logging.get()).booleanValue()) {
            PrintStream printStream;
            String string2 = "[SIEBEL " + JMSTraceLevel.getLogLevelName(n) + "]\t";
            string2 = string2 + Thread.currentThread().toString();
            string2 = string2 + "\t[";
            string2 = string2 + SiebelJMSLogger.getDate();
            string2 = string2 + "] ";
            if (string != null) {
                string2 = string2 + string + " -- " + newline;
            }
            if ((printStream = (PrintStream)logger.get()) != null) {
                m_lock.lock();
                try {
                    printStream.println(string2);
                    exception.printStackTrace(printStream);
                    printStream.println("");
                }
                finally {
                    m_lock.unlock();
                }
            }
        }
    }

    public static int getLogLevel() {
        return logLevelVar;
    }

    public static void setLogLevel(int n) {
        logLevelVar = 1;
        if (logging == null || logging.get() == null || !((Boolean)logging.get()).booleanValue()) {
            System.err.println("Log file not set for JMS logging, hence the default log level = 'ERROR' has been set.");
            return;
        }
        if (SiebelJMSLogger.getLogLevel() == n) {
            return;
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("JMSLogLevel");
        }
        logLevelVar = n;
        SiebelJMSLogger.log(3, null, "JMS Log level set to " + n);
    }

    public void setLogLevel(String string) {
        String string2 = string.trim();
        for (int i = 0; i < JMSTraceLevel.LOG_LEVEL.length; ++i) {
            String string3 = JMSTraceLevel.LOG_LEVEL[i].trim();
            if (string3.compareToIgnoreCase(string2) != 0) continue;
            SiebelJMSLogger.setLogLevel(i);
            return;
        }
        throw new IllegalArgumentException("JMSLogLevel");
    }
}

