/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.data.SiebelPropertySet;
import com.siebel.eai.jms.SiebelJMSException;
import com.siebel.eai.jms.SiebelJMSLogger;
import java.util.Enumeration;
import java.util.HashMap;

public class SiebelJMSProperties {
    private SiebelPropertySet propSet;
    public static final String CONNECTION_FACTORY = "ConnectionFactory";
    public static final String CONNECTION_USERNAME = "ConnectionUsername";
    public static final String CONNECTION_PASSWORD = "ConnectionPassword";
    public static final String SEND_QUEUE = "SendQueue";
    public static final String RECEIVE_QUEUE = "ReceiveQueue";
    public static final String RECEIVE_TIMEOUT = "ReceiveTimeout";
    public static final String TOPIC = "Topic";
    public static final String COMMIT_TRANSACTION = "CommitTransaction";
    public static final String SUBSCRIBER_IDENTIFIER = "SubscriberIdentifier";
    public static final String PRIORITY = "JMSPriority";
    public static final String DELIVERY_MODE = "JMSDeliveryMode";
    public static final String EXPIRATION = "JMSExpiration";
    public static final String REPLY_TO = "JMSReplyTo";
    public static final String CORRELATION_ID = "JMSCorrelationID";
    public static final String JMS_TYPE = "JMSType";
    public static final String SEND_USERNAME = "SendUsername";
    public static final String SEND_PASSWORD = "SendPassword";
    public static final String RECEIVE_USERNAME = "ReceiveUsername";
    public static final String RECEIVE_PASSWORD = "ReceivePassword";
    public static final String TOPIC_USERNAME = "TopicUsername";
    public static final String TOPIC_PASSWORD = "TopicPassword";
    public static final String DISABLE_JNDI_OBJECT_CACHE = "DisableJNDIObjectCache";
    public static final String ENABLE_JNDI_OBJECT_CACHE = "EnableJNDIObjectCache";
    public static final String JMS_CONNECTOR = "JMSConnector";
    public static final String JMS_JNDI_ENCRYPTION_CHECK = "JNDIEncryptionCheck";
    public static final String JMS_JNDI_ENCRYPTION_SEED = "JNDIEncryptionSeed";
    public static final String RECEIVER = "Receiver";

    public SiebelJMSProperties(SiebelPropertySet siebelPropertySet) {
        this.propSet = siebelPropertySet;
    }

    public String sendQueue() {
        return this.propSet.getProperty(SEND_QUEUE);
    }

    public String subscriberIdentifier() {
        return this.propSet.getProperty(SUBSCRIBER_IDENTIFIER);
    }

    public String topic() {
        return this.propSet.getProperty(TOPIC);
    }

    public boolean isJMSConnector() {
        String string = this.propSet.getProperty(JMS_CONNECTOR);
        if (string == null || string.equals("")) {
            return false;
        }
        return string.equalsIgnoreCase("true");
    }

    public HashMap getMessageProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = this.propSet.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = "";
            try {
                string = (String)enumeration.nextElement();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (!string.startsWith("SIEBEL_JMS:")) continue;
            hashMap.put(string.substring(11), this.propSet.getProperty(string));
        }
        return hashMap;
    }

    public String receiveQueue() {
        return this.propSet.getProperty(RECEIVE_QUEUE);
    }

    public boolean commitTransaction() {
        String string = this.propSet.getProperty(COMMIT_TRANSACTION);
        if (string == null || string.equals("")) {
            return true;
        }
        return string.equalsIgnoreCase("true");
    }

    public boolean hasDistributedDestinations() {
        String string = null;
        boolean bl = false;
        String string2 = "distDest:";
        string = this.sendQueue();
        if (string != null && this.startsWithIgnoreCase(string, string2)) {
            this.propSet.setProperty(SEND_QUEUE, string.substring(9));
            bl = true;
        }
        if ((string = this.receiveQueue()) != null && this.startsWithIgnoreCase(string, string2)) {
            this.propSet.setProperty(RECEIVE_QUEUE, string.substring(9));
            bl = true;
        }
        return bl;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        if (string != null && string2 != null && string.length() >= string2.length()) {
            return string.substring(0, string2.length()).equalsIgnoreCase(string2);
        }
        return false;
    }

    public boolean isStringValue() {
        return this.propSet.isStringValue();
    }

    public String getValue() {
        return this.propSet.getValue();
    }

    public SiebelPropertySet getPropertySet() {
        return this.propSet;
    }

    public boolean isFileRef() {
        return this.propSet.isFileRef();
    }

    public String getFileRef() {
        return this.propSet.getFileRef();
    }

    public byte[] getByteValue() {
        return this.propSet.getByteValue();
    }

    public String jmsType() {
        String string = this.propSet.getProperty(JMS_TYPE);
        if (string == null || string.equals("")) {
            return "SiebelJMSMessage";
        }
        return string;
    }

    public int deliveryMode() throws SiebelJMSException {
        String string = this.propSet.getProperty(DELIVERY_MODE);
        if (string == null || string.equals("")) {
            return 2;
        }
        if (string.equalsIgnoreCase("PERSISTENT")) {
            return 2;
        }
        if (string.equalsIgnoreCase("NON_PERSISTENT")) {
            return 1;
        }
        throw new SiebelJMSException("INVALID_ARGUMENT", "JMSDeliveryMode must be either PERSISTENT or NON_PERSISTENT");
    }

    public int priority() throws SiebelJMSException {
        int n;
        String string = this.propSet.getProperty(PRIORITY);
        if (string == null || string.equals("")) {
            return 4;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SiebelJMSException("INVALID_ARGUMENT", "JMSPriority must be an integer.");
        }
        return n;
    }

    public String correlationID() {
        String string = this.propSet.getProperty(CORRELATION_ID);
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    public String replyTo() {
        String string = this.propSet.getProperty(REPLY_TO);
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    public void replyTo(String string) {
        if (string != null && !string.equals("")) {
            this.propSet.setProperty(REPLY_TO, string);
        }
    }

    public long expiration() throws SiebelJMSException {
        int n;
        String string = this.propSet.getProperty(EXPIRATION);
        if (string == null || string.equals("")) {
            return 0L;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SiebelJMSException("INVALID_ARGUMENT", "JMSExpiration must be an integer.");
        }
        return n;
    }

    public long receiveTimeout() throws SiebelJMSException {
        int n;
        String string = this.propSet.getProperty(RECEIVE_TIMEOUT);
        if (string == null || string.equals("")) {
            return 3000L;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SiebelJMSException("INVALID_ARGUMENT", "ReceiveTimeout must be an integer.");
        }
        return n;
    }

    public String connectionFactory() {
        String string = this.propSet.getProperty(CONNECTION_FACTORY);
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    public String connectionUsername() {
        return this.propSet.getProperty(CONNECTION_USERNAME);
    }

    public String connectionPassword() {
        return this.propSet.getProperty(CONNECTION_PASSWORD);
    }

    public String sendUsername() {
        return this.propSet.getProperty(SEND_USERNAME);
    }

    public String sendPassword() {
        return this.propSet.getProperty(SEND_PASSWORD);
    }

    public String receiveUsername() {
        return this.propSet.getProperty(RECEIVE_USERNAME);
    }

    public String receivePassword() {
        return this.propSet.getProperty(RECEIVE_PASSWORD);
    }

    public String topicUsername() {
        return this.propSet.getProperty(TOPIC_USERNAME);
    }

    public String topicPassword() {
        return this.propSet.getProperty(TOPIC_PASSWORD);
    }

    public String disableJNDIObjectCaching() {
        return this.propSet.getProperty(DISABLE_JNDI_OBJECT_CACHE);
    }

    public String enableJNDIObjectCaching() {
        return this.propSet.getProperty(ENABLE_JNDI_OBJECT_CACHE);
    }

    public String jndiEncryptionCheck() {
        return this.propSet.getProperty(JMS_JNDI_ENCRYPTION_CHECK);
    }

    public String jndiEncryptionSeed() {
        return this.propSet.getProperty(JMS_JNDI_ENCRYPTION_SEED);
    }

    public boolean isReceiver() {
        String string = this.propSet.getProperty(RECEIVER);
        if (string != null && !string.equals("")) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public void log() {
        SiebelJMSLogger.log(4, null, ">ConnectionFactory=" + this.connectionFactory());
        if (this.connectionUsername() != null) {
            SiebelJMSLogger.log(4, null, ">ConnectionUsername=" + this.connectionUsername());
        }
        if (this.connectionPassword() != null) {
            SiebelJMSLogger.log(4, null, ">ConnectionPassword=*");
        }
        if (this.sendQueue() != null) {
            SiebelJMSLogger.log(4, null, ">SendQueue=" + this.sendQueue());
        }
        if (this.sendUsername() != null) {
            SiebelJMSLogger.log(4, null, ">SendUsername=" + this.sendUsername());
        }
        if (this.sendPassword() != null) {
            SiebelJMSLogger.log(4, null, ">SendPassword=*");
        }
        if (this.receiveQueue() != null) {
            SiebelJMSLogger.log(4, null, ">ReceiveQueue=" + this.receiveQueue());
        }
        if (this.receiveUsername() != null) {
            SiebelJMSLogger.log(4, null, ">ReceiveUsername=" + this.receiveUsername());
        }
        if (this.receivePassword() != null) {
            SiebelJMSLogger.log(4, null, ">ReceivePassword=*");
        }
        if (this.topic() != null) {
            SiebelJMSLogger.log(4, null, ">Topic=" + this.topic());
        }
        if (this.topicUsername() != null) {
            SiebelJMSLogger.log(4, null, ">TopicUsername=" + this.topicUsername());
        }
        if (this.topicPassword() != null) {
            SiebelJMSLogger.log(4, null, ">TopicPassword=*");
        }
    }
}

