/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.common.crypt.SiebelCipher;
import com.siebel.eai.jms.SiebelJMSException;
import com.siebel.eai.jms.SiebelJMSLogger;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SiebelJNDIContext {
    private long cumulativeTime;
    private Hashtable cachedObjects = new Hashtable();
    private InitialContext context;
    public static final int MAX_CACHE_SIZE = 100;
    private static Hashtable exceptionNames = new Hashtable();

    public SiebelJNDIContext() throws SiebelJMSException {
        try {
            this.getContext(null, null);
        }
        catch (NamingException namingException) {
            throw new SiebelJMSException("CREATING_JNDI_CONTEXT", namingException);
        }
    }

    public SiebelJNDIContext(Hashtable hashtable) throws SiebelJMSException {
        try {
            this.getContext(hashtable, null);
        }
        catch (NamingException namingException) {
            throw new SiebelJMSException("CREATING_JNDI_CONTEXT", namingException);
        }
    }

    public SiebelJNDIContext(Hashtable hashtable, Hashtable hashtable2) throws SiebelJMSException {
        try {
            this.getContext(hashtable, hashtable2);
        }
        catch (NamingException namingException) {
            throw new SiebelJMSException("CREATING_JNDI_CONTEXT", namingException);
        }
    }

    public InitialContext getContext(Hashtable hashtable, Hashtable hashtable2) throws NamingException, SiebelJMSException {
        block13: {
            if (this.context == null) {
                try {
                    String string;
                    Object object;
                    boolean bl = false;
                    String string2 = null;
                    if (hashtable2 != null) {
                        SiebelJMSLogger.log(4, null, "Reading properties for jndi.properties credential decryption.");
                        object = (String)hashtable2.get("JNDIEncryptionCheck");
                        bl = object != null && ((String)object).equalsIgnoreCase("true");
                        string = (String)hashtable2.get("JNDIEncryptionSeed");
                        string2 = string != null && !string.equals("") ? string : null;
                    }
                    if (hashtable == null) {
                        SiebelJMSLogger.log(2, null, "Environment for creating JNDI context is null.");
                        object = null;
                        if (bl && string2 != null) {
                            object = this.getNewEnvFromJndiPropertiesFile(string2);
                        }
                        if (object != null && ((Hashtable)object).size() > 0) {
                            SiebelJMSLogger.log(4, null, "Manually creating JNDI context with new environment with parameters from jndi.properties file.");
                            this.context = new InitialContext((Hashtable<?, ?>)object);
                        } else {
                            SiebelJMSLogger.log(4, null, "Creating JNDI context with default environment.");
                            this.context = new InitialContext();
                        }
                        break block13;
                    }
                    if (bl && string2 != null) {
                        try {
                            object = new SiebelCipher(string2);
                            string = (String)hashtable.get("java.naming.security.credentials");
                            String string3 = ((SiebelCipher)object).decrypt(string);
                            hashtable.put("java.naming.security.credentials", string3);
                        }
                        catch (Exception exception) {
                            SiebelJMSLogger.log(1, null, "Invalid seed specified in the JMSSubsystem. Not able to decrypt the credentials specified in the jndi.properties file. Specify a valid seed for decrypting the credentials. If credentials are not encrypted at all, then set the JNDIEncryptCheck to false in the respective JMSSubsystem. If JNDIEncryptCheck parameter is not found in the existing JMSSubsystem then recreate the respective JMSSubsystem or contact Siebel administrator.");
                            throw new SiebelJMSException("CREATING_JNDI_CONTEXT", "An error occurred while decrypting credentials in jndi.properties file found in the JVM classpath.");
                        }
                    }
                    SiebelJMSLogger.log(4, null, "Creating JNDI context with the supplied environment.");
                    object = (String)hashtable.get("java.naming.provider.url");
                    SiebelJMSLogger.log(4, null, "URL : " + (String)object);
                    this.context = new InitialContext(hashtable);
                }
                catch (Error error) {
                    throw new SiebelJMSException("CREATING_JNDI_CONTEXT", error.toString());
                }
            }
        }
        return this.context;
    }

    public ConnectionFactory getFactory(String string, boolean bl) throws SiebelJMSException {
        return (ConnectionFactory)this.getObject(string, ConnectionFactory.class, bl);
    }

    public Queue getQueue(String string, boolean bl) throws SiebelJMSException {
        return (Queue)this.getObject(string, Queue.class, bl);
    }

    private Object getObject(String string, Class clazz, boolean bl) throws SiebelJMSException {
        Object object;
        long l = System.currentTimeMillis();
        try {
            object = this.getObject(string, bl);
        }
        catch (NamingException namingException) {
            throw new SiebelJMSException(SiebelJNDIContext.exceptionName(clazz), namingException);
        }
        long l2 = System.currentTimeMillis();
        this.cumulativeTime += l2 - l;
        SiebelJMSLogger.log(4, null, "Cumulative JNDI time: " + this.cumulativeTime);
        if (object == null) {
            throw new SiebelJMSException(SiebelJNDIContext.exceptionName(clazz));
        }
        if (!clazz.isInstance(object)) {
            throw new SiebelJMSException(SiebelJNDIContext.exceptionName(clazz), "JNDI returned a " + object.getClass().getName() + " for " + string);
        }
        return object;
    }

    private static String exceptionName(Class clazz) {
        return (String)exceptionNames.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, boolean bl) throws NamingException, SiebelJMSException {
        Object object;
        Hashtable hashtable;
        SiebelJMSLogger.log(4, null, "jndi object caching : " + bl);
        SiebelJMSLogger.log(4, null, "jndi alias : " + string);
        if (bl) {
            hashtable = this.cachedObjects;
            synchronized (hashtable) {
                object = this.cachedObjects.get(string);
            }
            if (object != null) {
                SiebelJMSLogger.log(4, null, "Using cached JNDI object stored under " + string);
                return object;
            }
        }
        SiebelJMSLogger.log(4, null, "JNDI Object " + string + " not present in cache");
        object = this.getContext(null, null).lookup(string);
        SiebelJMSLogger.log(4, null, "Looked up " + string + " with JNDI service");
        if (bl && object != null) {
            hashtable = this.cachedObjects;
            synchronized (hashtable) {
                this.cachedObjects.put(string, object);
            }
            SiebelJMSLogger.log(4, null, "Added JNDI Object " + string + " to cache");
        }
        if (this.cachedObjects.size() > 100) {
            hashtable = this.cachedObjects;
            synchronized (hashtable) {
                Enumeration enumeration;
                if (this.cachedObjects.size() > 100 && (enumeration = this.cachedObjects.keys()).hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    this.cachedObjects.remove(k);
                    SiebelJMSLogger.log(4, null, "Removed " + k.toString() + " from cache");
                }
            }
        }
        return object;
    }

    public Topic getTopic(String string, boolean bl) throws SiebelJMSException {
        return (Topic)this.getObject(string, Topic.class, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SiebelJMSException {
        if (this.context != null) {
            try {
                this.context.close();
                SiebelJMSLogger.log(4, null, "Closed JNDI Context");
                Hashtable hashtable = this.cachedObjects;
                synchronized (hashtable) {
                    if (this.cachedObjects != null && this.cachedObjects.size() > 0) {
                        this.cachedObjects.clear();
                    }
                }
                SiebelJMSLogger.log(4, null, "Clearing cached jndi objects.");
            }
            catch (NamingException namingException) {
                throw new SiebelJMSException("CLOSING_JNDI_CONNECTION", namingException);
            }
        }
    }

    private Hashtable getNewEnvFromJndiPropertiesFile(String string) throws SiebelJMSException {
        Object object;
        Object object2;
        Object object3;
        String string2 = System.getProperty("java.class.path");
        SiebelJMSLogger.log(4, null, "Looking for jndi.properties file in classpath - " + string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, System.getProperty("path.separator"));
        String string3 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken();
                if (((String)object3).endsWith(".jar") && ((String)object3).endsWith(".zip") || !((File)(object2 = new File((String)object3))).exists() || !((File)object2).isDirectory() || ((File[])(object = ((File)object2).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.equals("jndi.properties");
                    }
                }))).length <= 0) continue;
                string3 = object[0].getAbsolutePath();
                break;
            }
        }
        catch (Exception exception) {
            SiebelJMSLogger.log(1, null, "Error:findJndiProeprty Method");
        }
        if (string3 == null || string3.equals("")) {
            SiebelJMSLogger.log(2, null, "Warning: jndi.properties could not be found in classpath : " + string2);
            return null;
        }
        object3 = new Hashtable();
        try {
            String string4;
            SiebelJMSLogger.log(4, null, "Reading jndi file - " + string3);
            object2 = new FileInputStream(string3);
            object = new DataInputStream((InputStream)object2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.trim().isEmpty()) continue;
                int n = string4.indexOf("=");
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                if (string5.trim().toLowerCase().indexOf("java.naming.security.credentials") >= 0) {
                    SiebelCipher siebelCipher = new SiebelCipher(string);
                    string6 = siebelCipher.decrypt(string6.trim());
                }
                ((Hashtable)object3).put(string5, string6);
            }
            ((FilterInputStream)object).close();
        }
        catch (Exception exception) {
            SiebelJMSLogger.log(1, null, "Invalid seed specified in the JMSSubsystem. Not able to decrypt the credentials specified in the jndi.properties file. Specify a valid seed for decrypting the credentials. If credentials are not encrypted at all, then set the JNDIEncryptCheck to false in the respective JMSSubsystem. If JNDIEncryptCheck parameter is not found in the existing JMSSubsystem then recreate the respective JMSSubsystem or contact Siebel administrator.");
            throw new SiebelJMSException("CREATING_JNDI_CONTEXT", "An error occurred while decrypting credentials in jndi.properties file found in the JVM classpath.");
        }
        return object3;
    }

    static {
        exceptionNames.put(Queue.class, "LOOKING_UP_QUEUE");
        exceptionNames.put(Topic.class, "LOOKING_UP_TOPIC");
        exceptionNames.put(ConnectionFactory.class, "LOOKING_UP_CONNECTION_FACTORY");
    }
}

