/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.jms;

import com.siebel.eai.jms.SiebelJMSException;
import com.siebel.eai.jms.SiebelJMSLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SiebelJNDISecurityContext {
    public static boolean ssl_enable;
    public static String WEBLOGIC_SSL_URL;

    public static Object runAs(String string, String string2, PrivilegedExceptionAction privilegedExceptionAction) throws SiebelJMSException {
        SiebelJMSLogger.log(4, null, "SiebelJNDISecurityContext.runAs starts...");
        try {
            Object object;
            if (string == null || string.equals("")) {
                SiebelJMSLogger.log(2, null, "Invoke SiebelJNDISecurityContext.runAs with null or empty username");
                if (privilegedExceptionAction != null) {
                    SiebelJMSLogger.log(2, null, "Run action");
                    return privilegedExceptionAction.run();
                }
                SiebelJMSLogger.log(2, null, "Action is null");
                return null;
            }
            SiebelJMSLogger.log(4, null, "Authenticating " + string + "/***");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.security.principal", string);
            if (string2 != null) {
                hashtable.put("java.naming.security.credentials", string2);
            }
            if (!ssl_enable) {
                object = SiebelJNDISecurityContext.findJndiPropertyFileName();
                ssl_enable = SiebelJNDISecurityContext.checkWebLogicSSLEnable((String)object);
            }
            if (ssl_enable) {
                hashtable.put("java.naming.security.protocol", "ssl");
                SiebelJMSLogger.log(4, null, "SSL enabled connection");
            }
            object = null;
            object = new InitialContext(hashtable);
            SiebelJMSLogger.log(4, null, string + " is authenticated");
            Object var5_8 = null;
            if (privilegedExceptionAction != null) {
                var5_8 = privilegedExceptionAction.run();
            }
            if (object != null) {
                ((InitialContext)object).close();
            }
            SiebelJMSLogger.log(4, null, "SiebelJNDISecurityContext.runAs returns normally...");
            return var5_8;
        }
        catch (AuthenticationException authenticationException) {
            SiebelJMSLogger.log(1, null, "ERROR: JNDI Authentication failed, please check your configurations");
            SiebelJMSLogger.log(1, null, "ERROR: For Tibco EMS/IBM MQ, make sure SendUsername/ReceiveUsername/TopicUseranme is NOT set");
            SiebelJMSLogger.log(1, null, "ERROR: For BEA Weblogic, make sure Username/Password for Send/Receive/Topic are set appropriately");
            SiebelJMSLogger.log(1, null, "ERROR: Abort executing action");
            throw new SiebelJMSException("LOGIN_USER", authenticationException);
        }
        catch (NamingException namingException) {
            throw new SiebelJMSException("LOGIN_USER", namingException);
        }
        catch (Exception exception) {
            if (exception instanceof SiebelJMSException) {
                throw (SiebelJMSException)exception;
            }
            throw new SiebelJMSException("RUNNING_SECURE_ACTION", exception);
        }
    }

    private static String findJndiPropertyFileName() {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        String string2 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                File[] fileArray;
                File file;
                String string3 = stringTokenizer.nextToken();
                if (string3.endsWith(".jar") && string3.endsWith(".zip") || !(file = new File(string3)).exists() || !file.isDirectory() || (fileArray = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.equals("jndi.properties");
                    }
                })).length <= 0) continue;
                string2 = fileArray[0].getAbsolutePath();
                break;
            }
        }
        catch (Exception exception) {
            SiebelJMSLogger.log(1, null, "Error:findJndiProeprty Method");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkWebLogicSSLEnable(String string) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string2 = properties.getProperty("java.naming.provider.url").trim();
            if (string2.equalsIgnoreCase(WEBLOGIC_SSL_URL)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            SiebelJMSLogger.log(1, null, "Error:JNdi File");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                SiebelJMSLogger.log(1, null, "Error" + exception);
            }
        }
        return bl;
    }

    static {
        WEBLOGIC_SSL_URL = "t3s://localhost:7002";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        InitialContext initialContext = null;
        hashtable.put("java.naming.security.principal", "");
        hashtable.put("java.naming.security.credentials", "");
        hashtable.put("java.naming.security.protocol", "");
        ssl_enable = false;
        try {
            SiebelJMSLogger.log(4, null, "Initializing JNDI authentication...");
            initialContext = new InitialContext(hashtable);
            initialContext.close();
            SiebelJMSLogger.log(4, null, "JNDI authentication initialized");
        }
        catch (Exception exception) {
            SiebelJMSLogger.log(1, null, "WARNING: Fail to initialize JNDI authentication");
            SiebelJMSLogger.log(1, null, "WARNING: Please check if jndi.properties file path is in classpath");
            SiebelJMSLogger.log(1, null, "WARNING: Please check java.naming.security.principal parameter in jndi.properties file");
            SiebelJMSLogger.log(1, null, "WARNING: Please check java.naming.security.credentials parameter in jndi.properties file");
        }
    }
}

