/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.outbound.server;

import com.siebel.eai.SiebelBusinessServiceException;
import com.siebel.eai.outbound.dispatcher.DispatcherSessionRemote;
import com.siebel.eai.outbound.server.EAIContext;
import com.siebel.eai.outbound.server.EAIWebLogicContext;
import com.siebel.integration.util.SiebelTrace;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class EAIOutboundServiceLocator {
    private static Context initialContext;
    private static Map<String, DispatcherSessionRemote> cacheContext;
    private Hashtable<String, String> htInitContext = new Hashtable();

    public EAIOutboundServiceLocator() {
        cacheContext = Collections.synchronizedMap(new HashMap());
    }

    public Map<String, DispatcherSessionRemote> getcacheContext() {
        return cacheContext;
    }

    public Context getinitialContext() throws SiebelBusinessServiceException {
        try {
            if (this.htInitContext.get("EAIOutboundSrvrType").equalsIgnoreCase("weblogic")) {
                EAIWebLogicContext eAIWebLogicContext = new EAIWebLogicContext();
                initialContext = ((EAIContext)eAIWebLogicContext).GetContext(this.htInitContext);
            } else {
                initialContext = new InitialContext(this.htInitContext);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", " This exception is thrown when a component of the name cannot be resolved because it is not bound : " + nameNotFoundException.getCause().getMessage());
            throw new SiebelBusinessServiceException(nameNotFoundException.getCause(), "EAIOutboundJavaBusinessService", " This exception is thrown when a component of the name cannot be resolved because it is not bound. Refer Siebel logs and EAIOutbound logs for detailed explanation and cause of this error.");
        }
        catch (NamingException namingException) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", " Name could not be resolved : " + namingException.getCause().getMessage());
            throw new SiebelBusinessServiceException(namingException.getCause(), "EAIOutboundJavaBusinessService", " Name could not be resolved. Refer Siebel logs and EAIOutbound logs for detailed explanation and cause of this error.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", " Exception occured while initializing Context " + exception.getCause().getMessage());
            throw new SiebelBusinessServiceException(exception.getCause(), "EAIOutboundJavaBusinessService", " Exception occured while initializing Context. Refer Siebel logs and EAIOutbound logs for detailed explanation and cause of this error.");
        }
        return initialContext;
    }

    public Hashtable<String, String> gethtInitContext() {
        return this.htInitContext;
    }

    public void sethtInitContext(Hashtable<String, String> hashtable) {
        this.htInitContext = hashtable;
    }
}

