/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.outbound.util;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.util.Base64;
import com.siebel.eai.outbound.util.FaultSiebelPropertySet;
import com.siebel.eai.outbound.util.SiebelSupportData;
import com.siebel.eai.outbound.util.StructForCast;
import com.siebel.integration.util.SiebelTrace;
import com.sun.org.apache.xerces.internal.dom.ElementNSImpl;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SiebelConvertDataType {
    private HashMap<Class, SiebelSupportData> hm_javaclass = new HashMap();
    private static FaultSiebelPropertySet objFltSPSet = new FaultSiebelPropertySet();
    private ArrayList<String> alDTFormats = new ArrayList();

    public SiebelConvertDataType() {
        SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", " Initializing class which converts Data to and From String ");
        this.hm_javaclass.put(Boolean.class, SiebelSupportData.BOOLEAN);
        this.hm_javaclass.put(BigDecimal.class, SiebelSupportData.BIGDECIMAL);
        this.hm_javaclass.put(Integer.class, SiebelSupportData.INTEGER);
        this.hm_javaclass.put(GregorianCalendar.class, SiebelSupportData.GREGORIANCALENDAR);
        this.hm_javaclass.put(XMLGregorianCalendar.class, SiebelSupportData.XMLGREGORIANCALENDAR);
        this.hm_javaclass.put(Duration.class, SiebelSupportData.DURATION);
        this.hm_javaclass.put(Double.class, SiebelSupportData.DOUBLE);
        this.hm_javaclass.put(Short.class, SiebelSupportData.SHORT);
        this.hm_javaclass.put(Long.class, SiebelSupportData.LONG);
        this.hm_javaclass.put(Float.class, SiebelSupportData.FLOAT);
        this.hm_javaclass.put(Byte.class, SiebelSupportData.BYTE);
        this.hm_javaclass.put(Character.class, SiebelSupportData.CHARACTER);
        this.hm_javaclass.put(byte[].class, SiebelSupportData.BYTEARRAY);
        this.hm_javaclass.put(Object.class, SiebelSupportData.OBJECT);
        this.hm_javaclass.put(QName.class, SiebelSupportData.QNAME);
        this.hm_javaclass.put(Element.class, SiebelSupportData.ELEMENT);
        this.hm_javaclass.put(String.class, SiebelSupportData.STRING);
        this.hm_javaclass.put(Enum.class, SiebelSupportData.ENUM);
        this.alDTFormats.add("MM/dd/yyyy hh:mm:ss");
        this.alDTFormats.add("MM/dd/yyyy");
        this.alDTFormats.add("HH:mm:ss");
        SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", " Initialized class which converts Data to and From String ");
    }

    public StructForCast ConvertDataType(StructForCast structForCast) throws IllegalArgumentException, ParseException, DatatypeConfigurationException, ParserConfigurationException, SAXException, IOException, TransformerException {
        SiebelSupportData siebelSupportData = null;
        Object object = null;
        if (structForCast.isCastToObj.booleanValue()) {
            SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", " Converting data type from : String to : " + structForCast.clsFromStrToObj.getSimpleName());
            Class clazz = structForCast.clsFromStrToObj;
            if (!this.hm_javaclass.containsKey(clazz)) {
                throw new IllegalArgumentException(clazz.toString() + " : " + CSSMsgMgr.get(8718306));
            }
            siebelSupportData = this.hm_javaclass.get(clazz);
            object = structForCast.strInputValue;
            SiebelTrace.getInstance().trace(null, 5, "GeneratedWrapper", " Converting String value \"" + structForCast.strInputValue + "\" to : " + structForCast.clsFromStrToObj.getSimpleName());
            return this.CastToObj(siebelSupportData, structForCast.strInputValue, structForCast);
        }
        SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", " Converting data type from : " + structForCast.clsToStrFromObj.getSimpleName() + " to : String");
        Class clazz = structForCast.clsToStrFromObj;
        if (!this.hm_javaclass.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz.toString() + " : " + CSSMsgMgr.get(8718306));
        }
        siebelSupportData = this.hm_javaclass.get(clazz);
        object = structForCast.objInputValue;
        return this.CastToString(siebelSupportData, structForCast.objInputValue, structForCast);
    }

    public StructForCast CastToString(SiebelSupportData siebelSupportData, Object object, StructForCast structForCast) throws IllegalArgumentException, ParseException, DatatypeConfigurationException, ParserConfigurationException, SAXException, IOException, TransformerException {
        switch (siebelSupportData) {
            case BOOLEAN: {
                structForCast.strOutputValue = DatatypeConverter.printBoolean((boolean)((Boolean)object));
                break;
            }
            case BIGDECIMAL: {
                structForCast.strOutputValue = DatatypeConverter.printDecimal((BigDecimal)((BigDecimal)object));
                break;
            }
            case BIGINTEGER: {
                structForCast.strOutputValue = DatatypeConverter.printInteger((BigInteger)((BigInteger)object));
                break;
            }
            case INTEGER: {
                structForCast.strOutputValue = DatatypeConverter.printInt((int)((Integer)object));
                break;
            }
            case QNAME: {
                structForCast.strOutputValue = ((QName)object).toString();
                break;
            }
            case GREGORIANCALENDAR: {
                structForCast.strOutputValue = ((GregorianCalendar)object).getTime().toString();
                break;
            }
            case XMLGREGORIANCALENDAR: {
                structForCast.strOutputValue = ((XMLGregorianCalendar)object).toString();
                break;
            }
            case DURATION: {
                structForCast.strOutputValue = ((Duration)object).toString();
                break;
            }
            case DOUBLE: {
                structForCast.strOutputValue = DatatypeConverter.printDouble((double)((Double)object));
                break;
            }
            case SHORT: {
                structForCast.strOutputValue = DatatypeConverter.printShort((short)((Short)object));
                break;
            }
            case LONG: {
                structForCast.strOutputValue = DatatypeConverter.printLong((long)((Long)object));
                break;
            }
            case FLOAT: {
                structForCast.strOutputValue = DatatypeConverter.printFloat((float)((Float)object).floatValue());
                break;
            }
            case BYTE: {
                structForCast.strOutputValue = DatatypeConverter.printByte((byte)((Byte)object));
                break;
            }
            case CHARACTER: {
                structForCast.strOutputValue = ((Character)object).toString();
                break;
            }
            case BYTEARRAY: {
                structForCast.strOutputValue = Base64.encode((byte[])object);
                break;
            }
            case OBJECT: {
                if (this.hm_javaclass.containsKey(structForCast.objInputValue.getClass()) && !structForCast.objInputValue.getClass().equals(Object.class)) {
                    SiebelConvertDataType siebelConvertDataType = new SiebelConvertDataType();
                    structForCast.clsToStrFromObj = structForCast.objInputValue.getClass();
                    structForCast = siebelConvertDataType.ConvertDataType(structForCast);
                    break;
                }
                if (object.getClass().equals(ElementNSImpl.class)) {
                    if (((ElementNSImpl)object).getFirstChild() != null) {
                        structForCast.strOutputValue = ((ElementNSImpl)object).getFirstChild().getTextContent();
                        break;
                    }
                    throw new IllegalArgumentException(structForCast.clsToStrFromObj.toString() + " : " + CSSMsgMgr.get(8718306));
                }
                structForCast.strOutputValue = object.toString();
                break;
            }
            case STRING: {
                structForCast.strOutputValue = (String)object;
                break;
            }
            case ENUM: {
                try {
                    structForCast.strOutputValue = ((Enum)object).toString();
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(CSSMsgMgr.get(8718312) + " : " + structForCast.clsEnumType.toString() + " = " + object.toString());
                }
            }
            case ELEMENT: {
                StringWriter stringWriter = new StringWriter();
                try {
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource((Element)object), new StreamResult(stringWriter));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerException(CSSMsgMgr.get(8718312) + " : Element-To-String  : Transformer Exception", transformerException.fillInStackTrace());
                }
                structForCast.strOutputValue = stringWriter.toString();
                structForCast.strXMLHierarchy = "sfe_XMLHierarchy_";
                break;
            }
            default: {
                throw new IllegalArgumentException(structForCast.clsToStrFromObj.toString() + " : " + CSSMsgMgr.get(8718306));
            }
        }
        SiebelTrace.getInstance().trace(null, 5, "GeneratedWrapper", " Converted data from " + structForCast.clsToStrFromObj.getSimpleName() + " value to String value \"" + structForCast.strOutputValue + "\"");
        SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", " Converted data type from : " + structForCast.clsToStrFromObj.getSimpleName() + " to : String");
        return structForCast;
    }

    public StructForCast CastToObj(SiebelSupportData siebelSupportData, Object object, StructForCast structForCast) throws IllegalArgumentException, ParseException, DatatypeConfigurationException, ParserConfigurationException, SAXException, IOException, TransformerException {
        Throwable throwable = null;
        switch (siebelSupportData) {
            case BOOLEAN: {
                structForCast.objOutputValue = DatatypeConverter.parseBoolean((String)((String)object));
                break;
            }
            case BIGDECIMAL: {
                structForCast.objOutputValue = DatatypeConverter.parseDecimal((String)((String)object));
                break;
            }
            case BIGINTEGER: {
                structForCast.objOutputValue = DatatypeConverter.parseInteger((String)((String)object));
                break;
            }
            case INTEGER: {
                structForCast.objOutputValue = DatatypeConverter.parseInt((String)((String)object));
                break;
            }
            case QNAME: {
                structForCast.objOutputValue = QName.valueOf((String)object);
                break;
            }
            case GREGORIANCALENDAR: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                try {
                    gregorianCalendar.setTime(simpleDateFormat.parse((String)object));
                }
                catch (ParseException parseException) {
                    throwable = parseException.fillInStackTrace();
                    throw new ParseException(CSSMsgMgr.get(8718309) + " : " + objFltSPSet.getStackTrace(throwable), parseException.getErrorOffset());
                }
                structForCast.objOutputValue = gregorianCalendar;
                break;
            }
            case XMLGREGORIANCALENDAR: {
                XMLGregorianCalendar xMLGregorianCalendar = null;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                boolean bl = false;
                for (int i = 0; i < this.alDTFormats.size(); ++i) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.alDTFormats.get(i));
                    try {
                        bl = true;
                        gregorianCalendar.setTime(simpleDateFormat.parse((String)object));
                    }
                    catch (ParseException parseException) {
                        if (i == this.alDTFormats.size() - 1) {
                            throwable = parseException.fillInStackTrace();
                            throw new ParseException("ParseException : " + CSSMsgMgr.get(8718310) + " : " + objFltSPSet.getStackTrace(throwable), parseException.getErrorOffset());
                        }
                        bl = false;
                    }
                    if (bl) break;
                }
                try {
                    xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    throwable = datatypeConfigurationException.fillInStackTrace();
                    throw new DatatypeConfigurationException("DatatypeConfigurationException : " + CSSMsgMgr.get(8718310) + " : ", throwable);
                }
                structForCast.objOutputValue = xMLGregorianCalendar;
                break;
            }
            case DURATION: {
                structForCast.objOutputValue = DatatypeFactory.newInstance().newDuration((String)object);
                break;
            }
            case DOUBLE: {
                structForCast.objOutputValue = DatatypeConverter.parseDouble((String)((String)object));
                break;
            }
            case SHORT: {
                structForCast.objOutputValue = DatatypeConverter.parseShort((String)((String)object));
                break;
            }
            case LONG: {
                structForCast.objOutputValue = DatatypeConverter.parseLong((String)((String)object));
                break;
            }
            case FLOAT: {
                structForCast.objOutputValue = Float.valueOf(DatatypeConverter.parseFloat((String)((String)object)));
                break;
            }
            case BYTE: {
                structForCast.objOutputValue = DatatypeConverter.parseByte((String)((String)object));
                break;
            }
            case CHARACTER: {
                structForCast.objOutputValue = new Character(((String)object).charAt(0));
                break;
            }
            case BYTEARRAY: {
                structForCast.objOutputValue = Base64.decode((String)object);
                break;
            }
            case OBJECT: {
                structForCast.objOutputValue = object;
                break;
            }
            case STRING: {
                structForCast.objOutputValue = object;
                break;
            }
            case ENUM: {
                try {
                    structForCast.objOutputValue = Enum.valueOf(structForCast.clsEnumType, (String)object);
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(CSSMsgMgr.get(8718312) + " : " + structForCast.clsEnumType.toString() + " = " + object.toString());
                }
            }
            case ELEMENT: {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource(new StringReader((String)object)));
                    Element element = document.getDocumentElement();
                    structForCast.objOutputValue = element;
                    break;
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throwable = parserConfigurationException.fillInStackTrace();
                    throw new ParserConfigurationException("ParserConfigurationException : " + parserConfigurationException.getStackTrace().toString());
                }
                catch (SAXException sAXException) {
                    throwable = sAXException.fillInStackTrace();
                    throw new SAXException("SAXException : " + sAXException.getStackTrace().toString());
                }
                catch (IOException iOException) {
                    throwable = iOException.fillInStackTrace();
                    throw new DatatypeConfigurationException("IOException : " + iOException.getStackTrace().toString(), throwable);
                }
            }
            default: {
                throw new IllegalArgumentException(structForCast.clsFromStrToObj.toString() + " : " + CSSMsgMgr.get(8718306));
            }
        }
        SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", " Converted data type from : String to : " + structForCast.clsFromStrToObj.getSimpleName());
        return structForCast;
    }
}

