/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.eai.outbound.util;

import com.siebel.data.SiebelPropertySet;
import com.siebel.integration.util.SiebelTrace;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SyncSoapHeadersHandler
implements SOAPHandler<SOAPMessageContext> {
    SiebelPropertySet spsHeader = null;
    SiebelPropertySet spsRespHeader = null;
    QName qnameService = null;
    String strNameSpace = null;

    public SyncSoapHeadersHandler(SiebelPropertySet siebelPropertySet, QName qName) {
        if (siebelPropertySet != null) {
            this.spsHeader = siebelPropertySet.copy();
        }
        this.qnameService = qName;
        this.strNameSpace = this.qnameService.getNamespaceURI() != null ? this.qnameService.getNamespaceURI() : "";
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        return this.ProcessHeader(sOAPMessageContext);
    }

    public boolean ProcessHeader(SOAPMessageContext sOAPMessageContext) {
        boolean bl;
        SOAPHeader sOAPHeader;
        SOAPMessage sOAPMessage;
        block10: {
            sOAPMessage = null;
            SOAPEnvelope sOAPEnvelope = null;
            sOAPHeader = null;
            bl = (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
            if (this.spsHeader == null && bl) {
                return true;
            }
            try {
                sOAPMessage = sOAPMessageContext.getMessage();
                sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
                sOAPHeader = sOAPEnvelope.getHeader();
                if (sOAPHeader != null) break block10;
                if (bl) {
                    sOAPHeader = sOAPEnvelope.addHeader();
                    break block10;
                }
                return true;
            }
            catch (SOAPException sOAPException) {
                SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
            }
        }
        if (!bl) {
            this.spsRespHeader = this.AddResponseHeader(sOAPHeader);
            return true;
        }
        if (!this.spsHeader.getType().equalsIgnoreCase("SoapHeaderElement")) {
            SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", "Input property set does not contain any  header part");
            this.spsHeader = null;
            return true;
        }
        int n = this.spsHeader.getChildCount();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = this.spsHeader.getChild(i).getType() != null ? this.spsHeader.getChild(i).getType() : "";
            if (string.equalsIgnoreCase("CustomHeaderContext") || string.equalsIgnoreCase("OtherThirdPartyHeader")) {
                this.AddRequestHeader(this.spsHeader.getChild(i), sOAPHeader);
            }
            if (!string.equalsIgnoreCase("SecurityHeaderContext")) continue;
            this.AddSecurityHeader(sOAPHeader, this.spsHeader.getChild(i));
        }
        this.spsHeader = null;
        try {
            sOAPMessage.saveChanges();
        }
        catch (SOAPException sOAPException) {
            SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
        }
        return true;
    }

    public SiebelPropertySet getResponseHeader() {
        return this.spsRespHeader;
    }

    public void AddSecurityHeader(SOAPHeader sOAPHeader, SiebelPropertySet siebelPropertySet) {
        try {
            if (siebelPropertySet.propertyExists("username") && siebelPropertySet.propertyExists("password")) {
                String string = "http://schemas.xmlsoap.org/ws/2002/07/secext";
                QName qName = new QName(string, "Security", "wsse");
                SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(qName);
                SOAPElement sOAPElement = sOAPHeaderElement.addChildElement(new QName(string, "wsse:UsernameToken"));
                sOAPElement.addChildElement(new QName(string, "wsse:Username")).addTextNode(siebelPropertySet.getProperty("username"));
                sOAPElement.addChildElement(new QName(string, "wsse:Password")).addTextNode(siebelPropertySet.getProperty("password"));
            }
        }
        catch (SOAPException sOAPException) {
            SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
        }
    }

    public void AddRequestHeader(SiebelPropertySet siebelPropertySet, SOAPHeader sOAPHeader) {
        QName qName;
        String string;
        int n;
        int n2 = siebelPropertySet.getPropertyCount();
        int n3 = siebelPropertySet.getChildCount();
        for (n = 0; n < n2; ++n) {
            String string2 = string = n == 0 ? siebelPropertySet.getFirstProperty() : siebelPropertySet.getNextProperty();
            if (string == null) continue;
            try {
                qName = new QName(this.strNameSpace, string);
                SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(qName);
                sOAPHeaderElement.addTextNode(siebelPropertySet.getProperty(string));
                continue;
            }
            catch (SOAPException sOAPException) {
                SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
            }
        }
        for (n = 0; n < n3; ++n) {
            String string3 = string = siebelPropertySet.getChild(n).getType() != null ? siebelPropertySet.getChild(n).getType() : "CustomHeader_" + n;
            if (siebelPropertySet.getChild(n).getType() == null) {
                SiebelTrace.getInstance().trace(null, 2, "GeneratedWrapper", "Property set type not set at Level " + n + " under " + siebelPropertySet.getType() + ".  Type set as " + string);
            } else {
                SiebelTrace.getInstance().trace(null, 3, "GeneratedWrapper", "Adding header for Property set at Level " + n + " under " + siebelPropertySet.getType() + ".  Type set as " + string);
            }
            try {
                qName = sOAPHeader.addHeaderElement(new QName(this.strNameSpace, string));
                this.AssignElementToHeader((SOAPElement)qName, siebelPropertySet.getChild(n));
                continue;
            }
            catch (SOAPException sOAPException) {
                SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
            }
        }
    }

    public SiebelPropertySet AddResponseHeader(SOAPHeader sOAPHeader) {
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        siebelPropertySet.setType("SoapHeaderElement");
        if (sOAPHeader != null) {
            Iterator iterator = sOAPHeader.extractAllHeaderElements();
            while (iterator.hasNext()) {
                NodeList nodeList = null;
                int n = 0;
                Node node = (Node)iterator.next();
                if (node.hasChildNodes()) {
                    nodeList = node.getFirstChild().getChildNodes();
                    n = nodeList.getLength();
                }
                if (n > 0) {
                    siebelPropertySet.addChild(this.GetHeaderChildNodes(node));
                    continue;
                }
                siebelPropertySet.setProperty(node.getLocalName(), node.getTextContent());
            }
        }
        sOAPHeader.detachNode();
        return siebelPropertySet;
    }

    public SiebelPropertySet GetHeaderChildNodes(Node node) {
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        siebelPropertySet.setType(node.getLocalName());
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = node2.getFirstChild().getChildNodes();
            if (nodeList2.getLength() > 0) {
                siebelPropertySet.addChild(this.GetHeaderChildNodes(nodeList.item(i)));
                continue;
            }
            siebelPropertySet.setProperty(node2.getLocalName(), node2.getTextContent());
        }
        return siebelPropertySet;
    }

    public void AssignElementToHeader(SOAPElement sOAPElement, SiebelPropertySet siebelPropertySet) {
        String string;
        int n;
        int n2 = siebelPropertySet.getPropertyCount();
        int n3 = siebelPropertySet.getChildCount();
        for (n = 0; n < n2; ++n) {
            String string2 = string = n == 0 ? siebelPropertySet.getFirstProperty() : siebelPropertySet.getNextProperty();
            if (string == null) continue;
            try {
                sOAPElement.addChildElement(string).addTextNode(siebelPropertySet.getProperty(string));
                continue;
            }
            catch (SOAPException sOAPException) {
                SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
            }
        }
        for (n = 0; n < n3; ++n) {
            try {
                string = sOAPElement.addChildElement(new QName(this.strNameSpace, siebelPropertySet.getChild(n).getType()));
                this.AssignElementToHeader((SOAPElement)string, siebelPropertySet.getChild(n));
                continue;
            }
            catch (SOAPException sOAPException) {
                SiebelTrace.getInstance().trace(null, 0, "GeneratedWrapper", "Exception occured during assignment of header : " + sOAPException.getMessage());
            }
        }
    }

    public boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        return this.ProcessHeader(sOAPMessageContext);
    }

    public void close(MessageContext messageContext) {
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

