/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.adapter;

import com.siebel.integration.adapter.SiebelJCAAdapterBase;
import com.siebel.integration.util.SiebelTrace;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

public class JCACommon {
    public static final String USER_NAME = "Username";
    public static final String PASS_WORD = "Password";
    public static final String SESSION_TYPE = "SessionType";
    public static final String SESSION_TOKEN = "SessionToken";
    public static final String EMPTY_STRING = "empty";
    public static final String USERNAME_TOKEN = "UsernameToken";
    public static final String PASSWORD_TEXT = "PasswordText";
    public static final String SIEBEL_NS = "http://siebel.com/webservices";
    public static final String STANDARD_NS = "HTTPdocs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String SECURITY_TAG = "Security";
    public static final String KEY_SESSIONTOKEN = "SessToken";
    public static final String SIEBEL_HEADER = "siebel-header";
    private String m_UserName = null;
    private String m_Password = null;
    private String m_SessionType = null;
    private String m_SessionToken = null;

    public void readStandardSoapHeader(Header header) {
        HashMap<String, String> hashMap = null;
        XMLStreamReader xMLStreamReader = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            xMLStreamReader = header.readHeader();
            while (xMLStreamReader.hasNext()) {
                if (xMLStreamReader.getEventType() == 1 && ((string = xMLStreamReader.getLocalName()).equals(USER_NAME) || string.equals(PASS_WORD) || string.equals(SESSION_TYPE) || string.equals(SESSION_TOKEN))) {
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    hashMap.put(string, EMPTY_STRING);
                }
                if (xMLStreamReader.getEventType() == 4) {
                    int n = xMLStreamReader.getTextStart();
                    int n2 = xMLStreamReader.getTextLength();
                    String string2 = new String(xMLStreamReader.getTextCharacters(), n, n2);
                    if (string2.trim().isEmpty() && string.equals(USER_NAME)) {
                        bl = true;
                    } else if (string2.trim().isEmpty() && string.equals(PASS_WORD)) {
                        bl2 = true;
                    }
                    String string3 = string2.trim();
                    if (!string3.equals("") && !string3.equals(Character.valueOf('\n'))) {
                        if (hashMap.get(USER_NAME) != null && ((String)hashMap.get(USER_NAME)).equals(EMPTY_STRING) && !bl) {
                            hashMap.put(USER_NAME, string3);
                            this.setSessionUserName((String)hashMap.get(USER_NAME));
                        } else if (hashMap.get(PASS_WORD) != null && ((String)hashMap.get(PASS_WORD)).equals(EMPTY_STRING) && !bl2) {
                            hashMap.put(PASS_WORD, string3);
                            this.setSessionPassword((String)hashMap.get(PASS_WORD));
                        } else if (hashMap.get(SESSION_TYPE) != null && ((String)hashMap.get(SESSION_TYPE)).equals(EMPTY_STRING)) {
                            hashMap.put(SESSION_TYPE, string3);
                            this.setSessionType((String)hashMap.get(SESSION_TYPE));
                        } else if (hashMap.get(SESSION_TOKEN) != null && ((String)hashMap.get(SESSION_TOKEN)).equals(EMPTY_STRING)) {
                            hashMap.put(SESSION_TOKEN, string3);
                            this.setSessionToken((String)hashMap.get(SESSION_TOKEN));
                        }
                    }
                }
                xMLStreamReader.next();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            SiebelTrace.getInstance().trace(null, 1, "readStandardSoapHeader", "Exception : " + xMLStreamException.getMessage());
        }
    }

    public void readSiebelSoapHeaders(HeaderList headerList) {
        this.ResetSessionParameters();
        for (int i = 0; i < headerList.size(); ++i) {
            String string = headerList.get(i).getLocalPart();
            this.readSiebelSoapHeader(headerList, string);
        }
    }

    public void readSiebelSoapHeader(HeaderList headerList, String string) {
        HashMap<String, String> hashMap = null;
        XMLStreamReader xMLStreamReader = null;
        Header header = headerList.get(SIEBEL_NS, string, true);
        String string2 = null;
        try {
            xMLStreamReader = header.readHeader();
            while (xMLStreamReader.hasNext()) {
                if (xMLStreamReader.getEventType() == 1 && (string2 = xMLStreamReader.getLocalName()).equals(string)) {
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    hashMap.put(string2, EMPTY_STRING);
                }
                if (xMLStreamReader.getEventType() == 4) {
                    int n = xMLStreamReader.getTextStart();
                    int n2 = xMLStreamReader.getTextLength();
                    String string3 = new String(xMLStreamReader.getTextCharacters(), n, n2);
                    if (((String)hashMap.get(string)).equals(EMPTY_STRING)) {
                        hashMap.put(string, string3);
                        if (string2.equals(USERNAME_TOKEN)) {
                            this.setSessionUserName((String)hashMap.get(USERNAME_TOKEN));
                        } else if (string2.equals(PASSWORD_TEXT)) {
                            this.setSessionPassword((String)hashMap.get(PASSWORD_TEXT));
                        } else if (string2.equals(SESSION_TYPE)) {
                            this.setSessionType((String)hashMap.get(SESSION_TYPE));
                        } else if (string2.equals(SESSION_TOKEN)) {
                            this.setSessionToken((String)hashMap.get(SESSION_TOKEN));
                        }
                    }
                }
                xMLStreamReader.next();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            SiebelTrace.getInstance().trace(null, 1, "readSiebelSoapHeader", "Exception : " + xMLStreamException.getMessage());
        }
    }

    public void readSoapHeader(SiebelJCAAdapterBase siebelJCAAdapterBase, JCACommon jCACommon, WebServiceContext webServiceContext) {
        HeaderList headerList = (HeaderList)webServiceContext.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        Header header = headerList.get(STANDARD_NS, SECURITY_TAG, true);
        if (header != null) {
            jCACommon.ResetSessionParameters();
            for (int i = 0; i < headerList.size(); ++i) {
                jCACommon.readStandardSoapHeader(header);
            }
        } else {
            jCACommon.readSiebelSoapHeaders(headerList);
        }
        if (jCACommon.getSessionUserName().equals("")) {
            siebelJCAAdapterBase.setSessionUserName(null);
        } else {
            siebelJCAAdapterBase.setSessionUserName(jCACommon.getSessionUserName());
        }
        if (jCACommon.getSessionPassword().equals("")) {
            siebelJCAAdapterBase.setSessionPassword(null);
        } else {
            siebelJCAAdapterBase.setSessionPassword(jCACommon.getSessionPassword());
        }
        if (jCACommon.getSessionType().equals("")) {
            siebelJCAAdapterBase.setSessionType(null);
        } else {
            siebelJCAAdapterBase.setSessionType(jCACommon.getSessionType());
        }
        if (jCACommon.getSessionToken().equals("")) {
            siebelJCAAdapterBase.setSessionToken(null);
        } else {
            siebelJCAAdapterBase.setSessionToken(jCACommon.getSessionToken());
        }
    }

    public void SetSessionContext(SiebelJCAAdapterBase siebelJCAAdapterBase, WebServiceContext webServiceContext) {
        MessageContext messageContext = webServiceContext.getMessageContext();
        messageContext.put((Object)KEY_SESSIONTOKEN, (Object)siebelJCAAdapterBase.getSessionToken());
    }

    public void ResetSessionParameters() {
        this.setSessionUserName("");
        this.setSessionPassword("");
        this.setSessionType("");
        this.setSessionToken("");
    }

    public void setSessionUserName(String string) {
        this.m_UserName = string;
    }

    public String getSessionUserName() {
        return this.m_UserName;
    }

    public void setSessionPassword(String string) {
        this.m_Password = string;
    }

    public String getSessionPassword() {
        return this.m_Password;
    }

    public void setSessionType(String string) {
        if (string == null || string.equalsIgnoreCase("None") || string.equals("")) {
            this.m_SessionType = "None";
        } else if (!(string.equalsIgnoreCase("None") || string.equalsIgnoreCase("Stateless") || string.equalsIgnoreCase("Stateful") || string.equalsIgnoreCase("ServerDetermined"))) {
            this.m_SessionType = "None";
            SiebelTrace.getInstance().trace(null, 3, "JCACommon.setSessionType", "Invalid Session Type \"" + string + "\". Defaulting it to \"None\".");
        } else {
            this.m_SessionType = string;
        }
    }

    public String getSessionType() {
        return this.m_SessionType;
    }

    public void setSessionToken(String string) {
        this.m_SessionToken = string;
    }

    public String getSessionToken() {
        return this.m_SessionToken;
    }
}

