/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.adapter;

import com.siebel.common.util.FileManager;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.eai.jms.JMSBusinessService;
import com.siebel.integration.adapter.SiebelJCAAdapterReceiverWork;
import com.siebel.integration.adapter.SiebelJCAAdapterSenderWork;
import com.siebel.integration.jca.cci.SiebelConnectionFactory;
import com.siebel.integration.jca.client.SiebelPropertySetRecord;
import com.siebel.integration.jca.spi.SiebelActivationSpec;
import com.siebel.integration.jca.spi.endpoint.SiebelEndpointConsumer;
import com.siebel.integration.sessmgr.SiebelJCASessionManager;
import com.siebel.integration.sessmgr.SiebelJCASessionManagerWork;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.integration.util.SiebelUserProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.xa.XAResource;

public class SiebelJCAAdapterBase
implements ResourceAdapter {
    protected ConnectionFactory m_connectionFactory = null;
    private SiebelJCASessionManager m_sessMgr = null;
    protected SiebelUserProperties m_properties = null;
    protected String m_siebelServiceName = null;
    private static HashMap m_cachedFactories = new HashMap();
    private static long m_lastCachedTime = 0L;
    private String m_sessUserName = null;
    private String m_sessPassword = null;
    private String m_sessToken = null;
    private String m_sessionType = null;
    private String m_currency = null;
    private String m_locale = null;
    private String m_timezone = null;
    private String m_language = null;
    private String m_xsdUri = null;
    public static String m_resourceReferenceName = null;
    public static long m_cacheDuration = 900000L;
    public static final long ATTACHMENT_MEMORY_MIN_THRESHOLD = 0x100000L;
    public static final long ATTACHMENT_MEMORY_MAX_THRESHOLD = 0x1400000L;
    private static final int CHUNK_SIZE = 1617;
    private boolean m_bHasAttachment = false;
    private boolean m_RESTRequest = false;
    private static String m_weblogicHome = System.getProperty("weblogic.home");
    private static String persistentFileName = System.getProperty("weblogic.home") + System.getProperty("file.separator") + "sessiontokens.txt";
    private static final String JCA_SESSION_LOCALE = "JCALocale";
    private static final String JCA_SESSION_CURRENCY = "JCACurrency";
    private static final String JCA_SESSION_TIMEZONE = "JCATimeZone";
    private static final String JCA_SESSION_LANGUAGE = "JCALanguage";
    private static final String HAS_ATTACHMENT = "HasAttachment";
    private transient BootstrapContext m_bootCtx = null;
    private Work m_receiverWork = null;
    private Work m_sessMgrWork = null;
    private String m_queueConFactory = null;
    private String m_receiveQueue = null;
    private String m_sendQueue = null;
    private String m_jcaReceiverLogFile = null;
    private String m_jcaSenderLogFile = null;

    public SiebelJCAAdapterBase() {
    }

    public SiebelJCAAdapterBase(SiebelConnectionFactory siebelConnectionFactory) {
        if (this.m_connectionFactory == null) {
            this.m_connectionFactory = siebelConnectionFactory;
        }
    }

    public SiebelJCAAdapterBase(String string) {
        this.m_properties = new SiebelUserProperties(string);
    }

    public SiebelJCAAdapterBase(String string, String string2, String string3) {
        this.m_properties = new SiebelUserProperties(string, string2, string3);
    }

    public SiebelJCAAdapterBase(String string, String string2, String string3, String string4) {
        this.m_properties = new SiebelUserProperties(string, string2, string3, string4);
    }

    public String getConnectString() {
        return this.getProperties().getConnectString();
    }

    public boolean getEncrypted() {
        return this.getProperties().getEncrypted();
    }

    public String getLanguage() {
        return this.getProperties().getLanguage();
    }

    public String getPassword() {
        return this.getProperties().getPassword();
    }

    public String getSiebelServiceName() {
        return this.m_siebelServiceName;
    }

    public String getUserName() {
        return this.getProperties().getUserName();
    }

    public static int getChunkSize() {
        return 1617;
    }

    public void initialize() {
    }

    public SiebelPropertySet invoke(String string, SiebelPropertySet siebelPropertySet) throws SiebelException {
        SiebelPropertySetRecord siebelPropertySetRecord = null;
        try {
            this.m_sessMgr = new SiebelJCASessionManager(this.m_connectionFactory, this.m_properties, this.m_siebelServiceName);
            this.m_sessMgr.setSessionType(this.m_sessionType);
            this.m_sessMgr.setSessionUserName(this.m_sessUserName);
            this.m_sessMgr.setSessionPassword(this.m_sessPassword);
            this.m_sessMgr.setSessionToken(this.m_sessToken);
            this.m_sessMgr.setRESTRequest(this.isRESTRequest());
            this.m_sessMgr.setXsdUri(this.m_xsdUri);
            this.m_sessMgr.initSessionManager();
            if (this.m_bHasAttachment) {
                siebelPropertySet.setProperty(HAS_ATTACHMENT, "true");
            }
            if (this.m_language != null) {
                siebelPropertySet.setProperty(JCA_SESSION_LANGUAGE, this.m_language);
            }
            if (this.m_currency != null) {
                siebelPropertySet.setProperty(JCA_SESSION_CURRENCY, this.m_currency);
            }
            if (this.m_locale != null) {
                siebelPropertySet.setProperty(JCA_SESSION_LOCALE, this.m_locale);
            }
            if (this.m_timezone != null) {
                siebelPropertySet.setProperty(JCA_SESSION_TIMEZONE, this.m_timezone);
            }
            siebelPropertySetRecord = (SiebelPropertySetRecord)this.m_sessMgr.handleRequest(string, siebelPropertySet);
        }
        catch (Exception exception) {
            SiebelException siebelException = new SiebelException(0x10000002, 4, "Method invocation failed. See log file for more details.");
            siebelException.setDetailMessage(exception.toString());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterBase.invoke()", string2);
            throw siebelException;
        }
        finally {
            this.setSessionToken(this.m_sessMgr.getSessionToken());
        }
        return siebelPropertySetRecord;
    }

    public void setConnectionFactory(SiebelConnectionFactory siebelConnectionFactory) {
        this.m_connectionFactory = siebelConnectionFactory;
    }

    public void setConnectString(String string) {
        this.getProperties().setConnectString(string);
    }

    private SiebelUserProperties getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new SiebelUserProperties();
        }
        return this.m_properties;
    }

    public void setEncrypt(boolean bl) {
        this.getProperties().setEncrypt(bl);
    }

    public void setLanguage(String string) {
        this.getProperties().setLanguage(string);
    }

    public void setPassword(String string) {
        this.getProperties().setPassword(string);
    }

    public void setSiebelServiceName(String string) {
        this.m_siebelServiceName = string;
    }

    public void setUserProperties(String string) {
        this.m_properties = new SiebelUserProperties(string);
    }

    public void setUserName(String string) {
        this.getProperties().setUserName(string);
    }

    public void setQueueConnectionFactory(String string) {
        this.m_queueConFactory = string;
        SiebelJCAAdapterReceiverWork.setConFactory(this.m_queueConFactory);
        SiebelJCAAdapterSenderWork.setConFactory(this.m_queueConFactory);
    }

    public void setReceiveQueue(String string) {
        this.m_receiveQueue = string;
        SiebelJCAAdapterReceiverWork.setReceiveQueue(this.m_receiveQueue);
    }

    public void setSendQueue(String string) {
        this.m_sendQueue = string;
        SiebelJCAAdapterSenderWork.setSendQueue(this.m_sendQueue);
    }

    public void setJCAReceiverLog(String string) {
        this.m_jcaReceiverLogFile = string;
        SiebelJCAAdapterReceiverWork.setLogFile(this.m_jcaReceiverLogFile);
    }

    public void setJCASenderLog(String string) {
        this.m_jcaSenderLogFile = string;
        SiebelJCAAdapterSenderWork.setLogFile(this.m_jcaSenderLogFile);
    }

    public void setSessionLanguage(String string) {
        this.m_language = string;
    }

    public String getSessionLangauge() {
        return this.m_language;
    }

    public void setSessionCurrency(String string) {
        this.m_currency = string;
    }

    public String getSessionCurrency() {
        return this.m_currency;
    }

    public void setSessionLocale(String string) {
        this.m_locale = string;
    }

    public String getSessionLocale() {
        return this.m_locale;
    }

    public void setTimeZone(String string) {
        this.m_timezone = string;
    }

    public String getTimeZone() {
        return this.m_timezone;
    }

    public void setSessionUserName(String string) {
        this.m_sessUserName = string;
    }

    public void setSessionPassword(String string) {
        this.m_sessPassword = string;
    }

    public void setSessionToken(String string) {
        this.m_sessToken = string;
    }

    public void setSessionType(String string) {
        this.m_sessionType = string;
    }

    public String getResourceReferenceName() {
        return m_resourceReferenceName;
    }

    public String getSessionToken() {
        return this.m_sessToken;
    }

    public void hasAttachment(boolean bl) {
        this.m_bHasAttachment = bl;
    }

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        WorkManager workManager = null;
        try {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.start", "Starting Siebel Resource Adapter...");
            this.m_bootCtx = bootstrapContext;
            workManager = this.m_bootCtx.getWorkManager();
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.start", "Scheduling sweep thread...");
            this.m_sessMgrWork = new SiebelJCASessionManagerWork();
            ((SiebelJCASessionManagerWork)this.m_sessMgrWork).setDoWork(true);
            workManager.scheduleWork(this.m_sessMgrWork);
            if (this.isOutboundResourceAdapter()) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.start", "Scheduling Receiver thread...");
                this.m_receiverWork = new SiebelJCAAdapterReceiverWork(workManager);
                workManager.scheduleWork(this.m_receiverWork);
            }
        }
        catch (WorkRejectedException workRejectedException) {
            SiebelTrace.getInstance().trace(null, 0, "SiebelJCAAdapterBase.start", "Unable to schedule the Work : " + workRejectedException.getMessage());
            throw new ResourceAdapterInternalException(workRejectedException.getMessage());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 0, "SiebelJCAAdapterBase.start", "Unable to start the Resource Adapter : " + exception.getMessage());
            throw new ResourceAdapterInternalException(exception.getMessage());
        }
    }

    public void stop() {
        try {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.stop", "Stopping Siebel Resource Adapter...");
            this.m_sessMgr = new SiebelJCASessionManager();
            if (this.m_sessMgr != null) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.stop", "Closing all open connections (if any)...");
                this.m_sessMgr.closeAllConnections();
            }
            if (this.isOutboundResourceAdapter()) {
                ((SiebelJCAAdapterReceiverWork)this.m_receiverWork).stopPolling();
            }
            FileManager.recursiveDelete(FileManager.getSiebelTmpAttDir());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterBase.stop", "Error occurred while stopping Resource Adapter : " + exception.getMessage());
        }
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        block4: {
            try {
                if (!this.isOutboundResourceAdapter()) break block4;
                SiebelEndpointConsumer siebelEndpointConsumer = new SiebelEndpointConsumer(messageEndpointFactory, (SiebelActivationSpec)activationSpec);
                ((SiebelJCAAdapterReceiverWork)this.m_receiverWork).addEndpointConsumer(messageEndpointFactory, siebelEndpointConsumer);
                SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
                SiebelPropertySet siebelPropertySet2 = new SiebelPropertySet();
                JMSBusinessService jMSBusinessService = new JMSBusinessService();
                siebelPropertySet.setProperty("ConnectionFactory", this.m_queueConFactory);
                siebelPropertySet.setProperty("SendQueue", this.m_receiveQueue);
                siebelPropertySet.setProperty("JMSType", "ObjectMessage");
                siebelPropertySet.setProperty("JMSConnector", "true");
                try {
                    jMSBusinessService.doInvokeMethod("Send", siebelPropertySet, siebelPropertySet2);
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterReceiverWork.consumeMessages ", "Sent empty message to Queue " + this.m_receiveQueue + " to complete re-initialization of endpoint");
                }
                catch (Exception exception) {
                    SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterReceiverWork.consumeMessages ", "Error occurred while trying to send empty message to Queue " + this.m_receiveQueue + " to complete re-initialization of endpoint");
                    throw new ResourceException(exception.getMessage());
                }
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterBase.endpointActivation", "Error occurred while activating Endpoint : " + exception.getMessage());
                throw new ResourceException(exception.getMessage());
            }
        }
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        if (this.isOutboundResourceAdapter()) {
            ((SiebelJCAAdapterReceiverWork)this.m_receiverWork).removeEndpointConsumer(messageEndpointFactory);
        }
    }

    private boolean isOutboundResourceAdapter() {
        InitialContext initialContext = null;
        if (this.m_queueConFactory == null || this.m_receiveQueue == null || this.m_sendQueue == null) {
            return false;
        }
        try {
            initialContext = new InitialContext();
            initialContext.lookup(this.m_queueConFactory);
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.isOutboundResourceAdapter", "Looked up connection factory : " + this.m_queueConFactory);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterBase.isOutboundResourceAdapter", "Error occurred while looking up connection factory " + this.m_queueConFactory + ": " + exception.getMessage());
            return false;
        }
        try {
            initialContext.lookup(this.m_receiveQueue);
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.isOutboundResourceAdapter", "Looked up receive queue : " + this.m_receiveQueue);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterBase.isOutboundResourceAdapter", "Error occurred while looking up receive queue " + this.m_receiveQueue + ": " + exception.getMessage());
            return false;
        }
        try {
            initialContext.lookup(this.m_sendQueue);
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.isOutboundResourceAdapter", "Looked up send queue : " + this.m_sendQueue);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterBase.isOutboundResourceAdapter", "Error occurred while looking up send queue " + this.m_sendQueue + " : " + exception.getMessage());
            return false;
        }
        return true;
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecArray) throws ResourceException {
        throw new NotSupportedException();
    }

    private ConnectionFactory getConnectionFactory(String string) throws NamingException {
        this.m_connectionFactory = (ConnectionFactory)m_cachedFactories.get(string);
        if (this.m_connectionFactory == null) {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.getConnectionFactory()", "Looking up JNDI Object");
            InitialContext initialContext = new InitialContext();
            Object object = initialContext.lookup(string);
            this.m_connectionFactory = (ConnectionFactory)object;
            m_cachedFactories.put(string, this.m_connectionFactory);
        }
        return this.m_connectionFactory;
    }

    public synchronized ConnectionFactory lookUp(String string) throws NamingException {
        long l;
        boolean bl = false;
        if (m_cacheDuration > 0L && (l = System.currentTimeMillis()) - m_lastCachedTime > m_cacheDuration) {
            m_cachedFactories.clear();
            this.m_connectionFactory = null;
            m_lastCachedTime = l;
            bl = true;
        }
        this.m_connectionFactory = this.getConnectionFactory(string);
        if (!bl) {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterBase.getConnectionFactory()", "Using cached JNDI Object");
            if (m_lastCachedTime == 0L) {
                m_lastCachedTime = System.currentTimeMillis();
            }
        }
        return this.m_connectionFactory;
    }

    public void setCloseOnAppErr(String string) {
        this.getProperties().SetCloseOnAppErr(string);
    }

    public void setRESTRequest(boolean bl) {
        this.m_RESTRequest = bl;
    }

    public boolean isRESTRequest() {
        return this.m_RESTRequest;
    }

    public void setXsdUri(String string) {
        this.m_xsdUri = string;
    }

    public String getXsdUri() {
        return this.m_xsdUri;
    }
}

