/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.adapter;

import com.siebel.data.SiebelPropertySet;
import com.siebel.eai.jms.JMSBusinessService;
import com.siebel.integration.adapter.SiebelJCAAdapterSenderWork;
import com.siebel.integration.jca.client.SiebelPropertySetRecord;
import com.siebel.integration.jca.spi.endpoint.SiebelEndpointConsumer;
import com.siebel.integration.util.SiebelTrace;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import weblogic.connector.extensions.LongRunning;

@LongRunning
public class SiebelJCAAdapterReceiverWork
implements Work,
Serializable {
    private boolean m_active = true;
    protected transient WorkManager m_workManager;
    private transient Hashtable m_endpointConsumers = null;
    private static String m_receiveQueue = null;
    private static String m_conFactory = null;
    private static String m_logFile = null;

    public static void setReceiveQueue(String string) {
        m_receiveQueue = string;
    }

    public static void setConFactory(String string) {
        m_conFactory = string;
    }

    public static void setLogFile(String string) {
        m_logFile = string;
    }

    public SiebelJCAAdapterReceiverWork(WorkManager workManager) {
        this.m_workManager = workManager;
        this.m_endpointConsumers = new Hashtable();
    }

    public void release() {
        this.m_active = false;
    }

    public void run() {
        SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterReceiverWork.run", "Consuming messages");
        while (this.m_active) {
            try {
                this.consumeMessages();
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 0, "SiebelJCAAdapterReceiverWork.run", exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeMessages() {
        Enumeration enumeration = this.m_endpointConsumers.elements();
        while (true) {
            SiebelEndpointConsumer siebelEndpointConsumer;
            Serializable serializable = this.m_endpointConsumers;
            synchronized (serializable) {
                if (!this.m_active || !enumeration.hasMoreElements()) {
                    break;
                }
                siebelEndpointConsumer = (SiebelEndpointConsumer)enumeration.nextElement();
            }
            try {
                serializable = new SiebelPropertySet();
                JMSBusinessService jMSBusinessService = new JMSBusinessService(m_logFile, SiebelTrace.getInstance().getLogLevel());
                SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
                ((SiebelPropertySet)serializable).setProperty("ConnectionFactory", m_conFactory);
                ((SiebelPropertySet)serializable).setProperty("ReceiveQueue", m_receiveQueue);
                ((SiebelPropertySet)serializable).setProperty("JMSType", "ObjectMessage");
                ((SiebelPropertySet)serializable).setProperty("JMSConnector", "true");
                ((SiebelPropertySet)serializable).setProperty("ReceiveTimeout", "0");
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterReceiverWork.consumeMessages ", "Receiving message from : m_receiveQueue");
                jMSBusinessService.doInvokeMethod("Receive", (SiebelPropertySet)serializable, siebelPropertySet);
                SiebelTrace.getInstance().trace(null, 5, "SiebelJCAAdapterReceiverWork.consumeMessages ", "Received message : " + siebelPropertySet.toString());
                SiebelPropertySetRecord siebelPropertySetRecord = new SiebelPropertySetRecord(siebelPropertySet);
                siebelEndpointConsumer.setSiebelMessage(siebelPropertySetRecord);
                this.scheduleJCAAdapterSender(siebelEndpointConsumer);
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterReceiverWork.consumeMessages ", exception.getMessage());
            }
        }
    }

    private void scheduleJCAAdapterSender(SiebelEndpointConsumer siebelEndpointConsumer) throws Exception {
        try {
            SiebelJCAAdapterSenderWork siebelJCAAdapterSenderWork = new SiebelJCAAdapterSenderWork(siebelEndpointConsumer);
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCAAdapterReceiverWork.scheduleJCAAdapterSender ", "scheduling sender work");
            this.m_workManager.scheduleWork((Work)siebelJCAAdapterSenderWork);
        }
        catch (WorkRejectedException workRejectedException) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterReceiverWork.scheduleJCAAdapterSender ", "Unable to schedule work : " + workRejectedException.getMessage());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterReceiverWork.scheduleJCAAdapterSender ", exception.getMessage());
        }
    }

    public void stopPolling() {
        this.removeAllEndpointConsumers();
        this.m_active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndpointConsumer(MessageEndpointFactory messageEndpointFactory, SiebelEndpointConsumer siebelEndpointConsumer) {
        Hashtable hashtable = this.m_endpointConsumers;
        synchronized (hashtable) {
            this.m_endpointConsumers.put(messageEndpointFactory, siebelEndpointConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpointConsumer(MessageEndpointFactory messageEndpointFactory) {
        Hashtable hashtable = this.m_endpointConsumers;
        synchronized (hashtable) {
            this.m_endpointConsumers.remove(messageEndpointFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllEndpointConsumers() {
        Hashtable hashtable = this.m_endpointConsumers;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_endpointConsumers.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    try {
                        this.m_endpointConsumers.remove(enumeration.nextElement());
                    }
                    catch (Exception exception) {
                        SiebelTrace.getInstance().trace(null, 1, "SiebelJCAAdapterReceiverWork.removeAllEndpointConsumers ", "Unable to remove endpoint consumer : " + exception.getMessage());
                    }
                }
            }
        }
        this.m_endpointConsumers = null;
    }
}

