/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.adapter;

import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.integration.util.SiebelUserProperties;

public class SiebelJDBAdapterBase {
    private static final String BEAN_CLASS_PROPERTY = "siebel.jdb.classname";
    private static final String SDB_CLASS = "com.siebel.data.SiebelDataBean";
    protected String m_beanClassName = null;
    protected boolean m_isConnected = false;
    protected boolean m_isResponsible = true;
    protected String m_siebelServiceName = null;
    protected SiebelService m_siebelService = null;
    protected SiebelDataBean m_siebelDataBean = null;
    protected SiebelUserProperties m_properties = null;

    public SiebelJDBAdapterBase() {
        this.m_properties = new SiebelUserProperties("siebel.properties");
    }

    public SiebelJDBAdapterBase(SiebelDataBean siebelDataBean) {
        this.m_properties = new SiebelUserProperties("siebel.properties");
        this.m_isConnected = true;
        this.m_isResponsible = false;
        this.m_siebelDataBean = siebelDataBean;
    }

    public SiebelJDBAdapterBase(String string) {
        this.m_properties = new SiebelUserProperties(string);
    }

    public SiebelJDBAdapterBase(String string, String string2, String string3) {
        this.m_properties = new SiebelUserProperties(string, string2, string3);
    }

    public SiebelJDBAdapterBase(String string, String string2, String string3, String string4) {
        this.m_properties = new SiebelUserProperties(string, string2, string3, string4);
    }

    public void initialize() throws SiebelException {
        this.m_beanClassName = this.m_properties.getProperty(BEAN_CLASS_PROPERTY, SDB_CLASS, false);
        if (this.m_siebelDataBean == null) {
            this.trace(5, "Trying class " + this.m_beanClassName);
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(SDB_CLASS);
                Class<?> clazz2 = Thread.currentThread().getContextClassLoader().loadClass(this.m_beanClassName);
                if (clazz.isAssignableFrom(clazz2)) {
                    this.m_siebelDataBean = (SiebelDataBean)clazz2.newInstance();
                } else {
                    System.err.println("Class \"" + this.m_beanClassName + "\" is not a valid SiebelDataBean class.\n" + "Using " + SDB_CLASS + " instead.");
                    this.m_siebelDataBean = new SiebelDataBean();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.trace(1, "Could not find class " + classNotFoundException);
                this.m_siebelDataBean = new SiebelDataBean();
            }
            catch (InstantiationException instantiationException) {
                this.trace(1, "Could not instantiate class " + instantiationException);
                this.m_siebelDataBean = new SiebelDataBean();
            }
            catch (IllegalAccessException illegalAccessException) {
                this.trace(1, illegalAccessException.toString());
                this.m_siebelDataBean = new SiebelDataBean();
            }
        }
        if (this.m_isResponsible) {
            this.login();
        }
        this.getService();
    }

    public SiebelPropertySet invoke(String string, SiebelPropertySet siebelPropertySet) throws SiebelException {
        SiebelPropertySet siebelPropertySet2 = new SiebelPropertySet();
        if (!this.m_isConnected) {
            this.initialize();
        }
        this.getSiebelService().invokeMethod(string, siebelPropertySet, siebelPropertySet2);
        return siebelPropertySet2;
    }

    protected void login() throws SiebelException {
        if (!this.m_isConnected) {
            if (this.m_siebelDataBean != null) {
                try {
                    if (this.m_properties.getLanguage() == null) {
                        this.m_siebelDataBean.login(this.m_properties.getConnectString(), this.m_properties.getUserName(), this.m_properties.getPassword());
                    } else {
                        this.m_siebelDataBean.login(this.m_properties.getConnectString(), this.m_properties.getUserName(), this.m_properties.getPassword(), this.m_properties.getLanguage());
                    }
                    this.m_isConnected = true;
                    this.trace(5, "Login successful");
                }
                catch (NullPointerException nullPointerException) {
                    this.trace(1, "Error Message:" + nullPointerException.getMessage());
                    SiebelException siebelException = new SiebelException(0x10000002, 3, "Can't connect to Siebel");
                    siebelException.setDetailMessage("NullPointerException during login(): " + nullPointerException.getMessage());
                    throw siebelException;
                }
            } else {
                this.trace(5, "Cannot login; SiebelDataBean is null");
                SiebelException siebelException = new SiebelException(0x10000002, 3, "Can't connect to Siebel");
                siebelException.setDetailMessage("Can't login, m_siebelDataBean is null");
                throw siebelException;
            }
        }
    }

    public void logout() throws SiebelException {
        this.m_siebelService = null;
        try {
            if (this.m_isResponsible) {
                this.m_siebelDataBean.logoff();
                this.m_isConnected = false;
                this.trace(5, "Logged Out.");
            }
        }
        catch (SiebelException siebelException) {
            this.trace(1, "Logoff failed: " + siebelException.getMessage());
            this.m_isConnected = false;
        }
    }

    protected void getService() throws SiebelException {
        try {
            this.getService(this.m_siebelServiceName);
        }
        catch (SiebelException siebelException) {
            this.trace(1, "Can't get the service [" + this.m_siebelServiceName + "]: " + siebelException.getMessage());
            SiebelException siebelException2 = new SiebelException(0x10000002, 4, "Can't initialize Siebel Service");
            siebelException2.setDetailMessage(this.m_siebelServiceName + ": " + siebelException.getMessage());
            throw siebelException2;
        }
    }

    public SiebelService getSiebelService() {
        return this.m_siebelService;
    }

    protected void finalize() throws Throwable {
        this.trace(5, "Finalizing...");
        if (this.m_isResponsible) {
            try {
                this.m_siebelService = null;
                this.logout();
                this.trace(5, "Logged out of Siebel");
                this.m_siebelDataBean = null;
            }
            catch (SiebelException siebelException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    protected void getService(String string) throws SiebelException {
        if (!this.m_isConnected) {
            this.login();
        }
        try {
            this.m_siebelService = this.m_siebelDataBean.getService(string);
        }
        catch (SiebelException siebelException) {
            this.trace(1, "Can't get the service [" + string + "]: " + siebelException.getMessage());
            SiebelException siebelException2 = new SiebelException(0x10000002, 4, "Can't initialize Siebel Service");
            siebelException2.setDetailMessage(this.m_siebelServiceName + ": " + siebelException.getMessage());
            throw siebelException2;
        }
    }

    public String getSiebelServiceName() {
        return this.m_siebelServiceName;
    }

    public SiebelDataBean getSiebelDataBean() {
        return this.m_siebelDataBean;
    }

    public void initialize(String string) throws SiebelException {
        this.m_siebelServiceName = string;
        this.initialize();
    }

    public String getConnectString() {
        return this.m_properties.getConnectString();
    }

    public boolean getEncrypted() {
        return this.m_properties.getEncrypted();
    }

    public String getLanguage() {
        return this.m_properties.getLanguage();
    }

    public String getPassword() {
        return this.m_properties.getPassword();
    }

    public String getUserName() {
        return this.m_properties.getUserName();
    }

    public void setConnectString(String string) {
        this.m_properties.setConnectString(string);
    }

    public void setEncrypt(boolean bl) {
        this.m_properties.setEncrypt(bl);
    }

    public void setLanguage(String string) {
        this.m_properties.setLanguage(string);
    }

    public void setPassword(String string) {
        this.m_properties.setPassword(string);
    }

    protected void setSiebelServiceName(String string) {
        this.m_siebelServiceName = string;
    }

    public void setUserName(String string) {
        this.m_properties.setUserName(string);
    }

    private void trace(int n, String string) {
        SiebelTrace.getInstance().trace(null, n, "SiebelJDBAdapterBase", string);
    }
}

