/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.codegen;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.data.SiebelPropertySet;
import com.siebel.integration.codegen.AccessRights;
import com.siebel.integration.codegen.AccessVisibility;
import com.siebel.integration.codegen.ClassDeclaration;
import com.siebel.integration.codegen.CodeWriter;
import com.siebel.integration.codegen.Declaration;
import com.siebel.integration.codegen.EJBCodeFilter;
import com.siebel.integration.codegen.JCACodeFilter;
import com.siebel.integration.codegen.MethodDeclaration;
import com.siebel.integration.codegen.WrapperCodeFilter;
import com.siebel.integration.common.BSMethodArgs;
import com.siebel.integration.common.BSMethodObject;
import com.siebel.integration.common.BSObject;
import com.siebel.integration.common.WFStepObject;
import com.siebel.integration.util.SiebelTrace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;

public class BSCodeGenerator {
    public static final String BUSINESS_SERVICE_SUFFIX = "BusServAdapter";
    public static final String WRAPPER_SUFFIX = "Wrapper";
    public static final String LOCAL_SUFFIX = "SessionEJBLocal";
    public static final String REMOTE_SUFFIX = "SessionEJBRemote";
    public static final String COMMON_SUFFIX = "SessionEJB";
    public static final String IMPL_SUFFIX = "SessionEJBBean";
    public static final String LOCAL_TYPE = "local";
    public static final String REMOTE_TYPE = "remote";
    public static final String COMMON_TYPE = "common";
    public static final String IMPL_TYPE = "impl";
    public static final String STRING_TYPE = "String";
    public static final String ALIAS_TYPE = "Alias";
    public static final String VARCHAR_TYPE = "VARCHAR";
    public static final String HIERARCHY_TYPE = "Hierarchy";
    public static final String ONLY_ONE = "One";
    public static final String INPUT_PARAMETER_SUFFIX = "Input";
    public static final String OUTPUT_PARAMETER_SUFFIX = "Output";
    public static final String OUTPUT_RESULT_PARAMETER_SUFFIX = "OutputResult";
    public static final String INTEGRATION_OBJECT_TYPE = "Integration Object";
    public static final String INT_OBJ_TYPE = "INT_OBJ";
    public static final String XSD_HIERARCHY_TYPE = "XSD Hierarchy";
    public static final String XSD_HIER_TYPE = "XSD_HIER";
    public static final String PROPSET_CHILD_TYPE = "PROPSET_CHILD";
    public static final String INPUT_ONLY = "Input";
    public static final String INPUT_OUTPUT = "Input / Output";
    public static final String OUTPUT_ONLY = "Output";
    public static final String IN_ONLY = "IN";
    public static final String IN_OUT = "INOUT";
    public static final String OUT_ONLY = "OUT";
    public static final String BLANK = "";
    public static final String VOID_TYPE = "void";
    public static final String OUTPUT_CODE_LIST_PROPERTY = "OutputCodeGeneratedList";
    public static final String OUTPUT_CODE_PROPERTY = "OutputCodeGenerated";
    public static final String OUTPUT_NAME_PROPERTY = "ObjectName";
    public static final String CODE_PROPERTY = "Code";
    public static final String NAME_PROPERTY = "Name";
    public static final String FILE_NAME_PROPERTY = "FileName";
    public static final String REPOSITORY_PROPERTY = "RepositoryName";
    public static final String VERSION_PROPERTY = "Version";
    public static final String PACKAGE_PROPERTY = "Package";
    public static final String GENERATION_DATE_PROPERTY = "GenerationDate";
    public static final String CODE_GEN_SERV_NAME_PROPERTY = "CodeGenerator";
    public static final String PROGRAM_LANGUAGE_PROPERTY = "Language";
    public static final String GENERATE_CODE_BUSINESS_SERVICE_NAME = "Siebel BS Code Generator";
    public static final String BUSINESS_SERVICE = "BUSINESS_SERVICE";
    public static final String INTEGRATION_OBJECT_SUFFIX = "IO";
    public static final String WORKFLOW_PROCESS_MANAGER = "Workflow Process Manager";
    public static final String PROCESS_NAME = "ProcessName";
    public static final String HANDLER_XML = "SOAPHandler";
    private BSObject m_bsObject;
    private String m_CodeGenerationPath;
    private Boolean m_bWorkflowCodeGeneration;
    private String m_WorkflowProcessName;
    private boolean m_bBackwardCompatibilityMode;
    private Properties m_operationNames = new Properties();
    private String m_busSvcNamespace;
    private String m_intObjName;
    private String m_webserviceName;
    private String m_xsdFileName;
    private String m_soapBindingStyle;
    private String m_soapBinding;

    public BSCodeGenerator() {
        this.m_CodeGenerationPath = BLANK;
        this.m_bsObject = null;
        this.m_bWorkflowCodeGeneration = false;
        this.m_WorkflowProcessName = null;
        this.m_operationNames = null;
        this.m_busSvcNamespace = null;
        this.m_intObjName = null;
        this.m_bBackwardCompatibilityMode = false;
        this.m_soapBindingStyle = "DOCUMENT";
        this.m_soapBinding = "1.1";
        this.m_webserviceName = this.m_bsObject.getBsName();
        this.m_xsdFileName = BLANK;
        SiebelTrace.getInstance().trace(null, 3, "BSCodeGenerator:BSCodeGenerator", "Created Siebel business service code generator object.");
    }

    public BSCodeGenerator(BSObject bSObject, String string, String string2) {
        this.m_bsObject = bSObject;
        this.m_CodeGenerationPath = string;
        this.m_bWorkflowCodeGeneration = false;
        this.m_WorkflowProcessName = null;
        this.m_operationNames = null;
        this.m_busSvcNamespace = null;
        this.m_intObjName = null;
        this.m_bBackwardCompatibilityMode = false;
        this.m_soapBindingStyle = "DOCUMENT";
        this.m_soapBinding = "1.1";
        this.m_webserviceName = string2;
        this.m_xsdFileName = BLANK;
        SiebelTrace.getInstance().trace(null, 3, "BSCodeGenerator:BSCodeGenerator", "Created Siebel business service code generator object.");
    }

    public BSCodeGenerator(BSObject bSObject, String string, boolean bl, Properties properties, String string2, String string3, String string4) {
        this.m_bsObject = bSObject;
        this.m_CodeGenerationPath = string;
        this.m_bWorkflowCodeGeneration = false;
        this.m_WorkflowProcessName = null;
        this.m_bBackwardCompatibilityMode = bl;
        this.m_operationNames = properties;
        this.m_busSvcNamespace = string2;
        this.m_intObjName = string3;
        this.m_webserviceName = string4;
        this.m_xsdFileName = BLANK;
        this.m_soapBindingStyle = "DOCUMENT";
        this.m_soapBinding = "1.1";
        SiebelTrace.getInstance().trace(null, 3, "BSCodeGenerator:BSCodeGenerator", "Created Siebel business service code generator object.");
    }

    private String EncodeString(String string) {
        String string2 = string;
        string2 = string2.replace("\\", "\\\\");
        string2 = string2.replace("\"", "\\\"");
        return "\"" + string2 + "\"";
    }

    public void setSoapBindingStyle(String string) {
        this.m_soapBindingStyle = string;
    }

    public void setSoapBinding(String string) {
        this.m_soapBinding = string;
    }

    public boolean generateCode() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ClassDeclaration classDeclaration = null;
        ClassDeclaration classDeclaration2 = null;
        ClassDeclaration classDeclaration3 = null;
        ClassDeclaration classDeclaration4 = null;
        ClassDeclaration classDeclaration5 = null;
        ClassDeclaration classDeclaration6 = null;
        ClassDeclaration classDeclaration7 = null;
        ArrayList<ClassDeclaration> arrayList = null;
        Properties properties = null;
        SiebelPropertySet siebelPropertySet = null;
        Calendar calendar = Calendar.getInstance();
        String string = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
        this.trace(3, "BSCodeGenerator:generateCode", "Started Siebel business service code generation.");
        if (this.m_bsObject == null) {
            this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716822));
            return false;
        }
        if (this.m_bsObject.getBsName().equals(WORKFLOW_PROCESS_MANAGER)) {
            this.m_bWorkflowCodeGeneration = true;
        }
        this.trace(3, "BSCodeGenerator:generateCode", "Creating class declaration objects for business service, wrapper and EJB beans.");
        classDeclaration = new ClassDeclaration(this.m_bsObject.getBsName() + BUSINESS_SERVICE_SUFFIX, this.m_bsObject.getBsName(), AccessRights.PUBLIC_ACCESS);
        classDeclaration2 = new ClassDeclaration(this.m_bsObject.getBsName() + BUSINESS_SERVICE_SUFFIX, this.m_bsObject.getBsName(), AccessRights.PUBLIC_ACCESS, true);
        classDeclaration3 = new ClassDeclaration(this.m_webserviceName + WRAPPER_SUFFIX, WRAPPER_SUFFIX);
        classDeclaration4 = new ClassDeclaration(this.m_webserviceName + LOCAL_SUFFIX, this.m_webserviceName, AccessRights.PUBLIC_ACCESS, true);
        classDeclaration5 = new ClassDeclaration(this.m_webserviceName + REMOTE_SUFFIX, this.m_webserviceName, AccessRights.PUBLIC_ACCESS, true);
        classDeclaration6 = new ClassDeclaration(this.m_webserviceName + COMMON_SUFFIX, this.m_webserviceName, AccessRights.PUBLIC_ACCESS, true);
        classDeclaration7 = new ClassDeclaration(this.m_webserviceName + IMPL_SUFFIX, this.m_webserviceName, AccessRights.PUBLIC_ACCESS, true);
        if (arrayList == null) {
            arrayList = new ArrayList<ClassDeclaration>();
        }
        if (classDeclaration3 != null) {
            classDeclaration3.SetAdapterClassName(this.m_bsObject.getBsName() + BUSINESS_SERVICE_SUFFIX);
            classDeclaration3.SetClassType(WRAPPER_SUFFIX);
            classDeclaration3.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration3);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding wrapper class declaration object to class array list.");
            }
        }
        if (classDeclaration4 != null) {
            classDeclaration4.SetClassType(LOCAL_TYPE);
            classDeclaration4.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration4);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding local interface class declaration object for EJB to class array list.");
            }
        }
        if (classDeclaration5 != null) {
            classDeclaration5.SetClassType(REMOTE_TYPE);
            classDeclaration5.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration5);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding remote interface class declaration object for EJB to class array list.");
            }
        }
        if (classDeclaration6 != null) {
            classDeclaration6.SetClassType(COMMON_TYPE);
            classDeclaration6.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration6);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding common interface class declaration object for EJB to class array list.");
            }
        }
        if (classDeclaration7 != null) {
            classDeclaration7.SetAdapterClassName(this.m_bsObject.getBsName());
            classDeclaration7.SetClassType(IMPL_TYPE);
            classDeclaration7.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration7);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding implementation interface class declaration object for EJB to class array list.");
            }
        }
        if (classDeclaration != null) {
            classDeclaration.SetAdapterClass(true);
            classDeclaration.SetClassType(BUSINESS_SERVICE_SUFFIX);
            classDeclaration.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding business service class declaration object for EJB to class array list.");
            }
        }
        if (classDeclaration2 != null) {
            classDeclaration2.SetAdapterClass(true);
            classDeclaration2.SetClassType(BUSINESS_SERVICE_SUFFIX);
            classDeclaration2.SetComment(this.m_bsObject.getBsName());
            if (arrayList != null) {
                arrayList.add(classDeclaration2);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding business service class declaration object for EJB to class array list.");
            }
        }
        this.trace(3, "BSCodeGenerator:generateCode", "Reading business service user properties.");
        properties = this.m_bsObject.getBsUserProps();
        if (properties != null) {
            object5 = properties.keys();
            while (object5.hasMoreElements()) {
                String string2 = object5.nextElement().toString();
                object4 = properties.getProperty(string2);
                object3 = new Declaration(STRING_TYPE, string2, string2, ONLY_ONE, AccessRights.PUBLIC_ACCESS, AccessVisibility.READ_ONLY);
                if (object3 == null || classDeclaration == null || classDeclaration2 == null) continue;
                ((Declaration)object3).SetValue(this.EncodeString((String)object4));
                this.trace(5, "BSCodeGenerator:generateCode", "Adding declaration object for user property \"" + string2 + "\" with value \"" + (String)object4 + "\" to bussiness class declaration field array.");
                classDeclaration.AddField((Declaration)object3);
                classDeclaration2.AddField((Declaration)object3);
            }
        } else {
            this.trace(3, "BSCodeGenerator:generateCode", "No business service user properties found.");
        }
        this.trace(3, "BSCodeGenerator:generateCode", "Reading business service methods.");
        if (this.m_bsObject.getBsMethods() != null) {
            object5 = this.m_bsObject.getBsMethods();
            for (int i = 0; i < ((Vector)object5).size(); ++i) {
                object4 = this.getBSMethod((BSMethodObject)((Vector)object5).get(i), arrayList);
                if (this.m_bBackwardCompatibilityMode) {
                    if (this.m_operationNames != null) {
                        ((MethodDeclaration)object4).setOperationName(this.m_operationNames.getProperty(((BSMethodObject)((Vector)object5).get(i)).getMethodName()));
                    }
                    if (this.m_busSvcNamespace != null) {
                        ((MethodDeclaration)object4).setTargetNamespace(this.m_busSvcNamespace);
                    }
                }
                if (object4 != null && classDeclaration != null && classDeclaration2 != null) {
                    if (this.m_bWorkflowCodeGeneration.booleanValue() && this.m_WorkflowProcessName != null && this.m_WorkflowProcessName != BLANK) {
                        classDeclaration.SetClassName(this.m_WorkflowProcessName + BUSINESS_SERVICE_SUFFIX);
                        classDeclaration2.SetClassName(this.m_WorkflowProcessName + BUSINESS_SERVICE_SUFFIX);
                        classDeclaration3.SetAdapterClassName(this.m_WorkflowProcessName + BUSINESS_SERVICE_SUFFIX);
                        classDeclaration7.SetAdapterClassName(this.m_WorkflowProcessName);
                    }
                    classDeclaration.AddMethod((MethodDeclaration)object4);
                    classDeclaration2.AddMethod((MethodDeclaration)object4);
                    this.trace(5, "BSCodeGenerator:generateCode", "Adding method declaration object for \"" + ((BSMethodObject)((Vector)object5).get(i)).getMethodName() + "\" method to business service class declaration method array.");
                }
                object3 = new MethodDeclaration((MethodDeclaration)object4);
                object2 = new MethodDeclaration((MethodDeclaration)object4);
                object = new MethodDeclaration((MethodDeclaration)object4);
                if (object3 != null && classDeclaration3 != null) {
                    classDeclaration3.AddMethod((MethodDeclaration)object3);
                    this.trace(5, "BSCodeGenerator:generateCode", "Adding method declaration object for \"" + ((BSMethodObject)((Vector)object5).get(i)).getMethodName() + "\" method to wrapper class declaration method array.");
                }
                if (object2 != null && classDeclaration6 != null) {
                    classDeclaration6.AddMethod((MethodDeclaration)object2);
                    this.trace(5, "BSCodeGenerator:generateCode", "Adding method declaration object for \"" + ((BSMethodObject)((Vector)object5).get(i)).getMethodName() + "\" method to common interface class declaration method array.");
                }
                if (object == null || classDeclaration7 == null) continue;
                classDeclaration7.AddMethod((MethodDeclaration)object);
                this.trace(5, "BSCodeGenerator:generateCode", "Adding method declaration object for \"" + ((BSMethodObject)((Vector)object5).get(i)).getMethodName() + "\" method to implementation interface class declaration method array.");
            }
        } else {
            this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716823));
            return false;
        }
        if (arrayList == null) {
            this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716810));
            return false;
        }
        siebelPropertySet = new SiebelPropertySet(OUTPUT_CODE_LIST_PROPERTY);
        if (siebelPropertySet != null && arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ClassDeclaration classDeclaration8 = arrayList.get(i);
                object4 = null;
                object4 = this.m_webserviceName;
                object3 = classDeclaration8.GetClassType();
                if (((String)object3).equalsIgnoreCase(WRAPPER_SUFFIX)) {
                    object2 = null;
                    object = null;
                    object = this.m_bBackwardCompatibilityMode ? new WrapperCodeFilter(classDeclaration8, this.m_busSvcNamespace) : new WrapperCodeFilter(classDeclaration8);
                    if (object == null) {
                        this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716824));
                        return false;
                    }
                    ((WrapperCodeFilter)object).setSoapVersion(this.m_soapBinding);
                    this.trace(3, "BSCodeGenerator:generateCode", "Generating wrapper code.");
                    object2 = new SiebelPropertySet(OUTPUT_CODE_PROPERTY);
                    if (object2 == null || object == null) continue;
                    ((SiebelPropertySet)object2).setProperty(OUTPUT_NAME_PROPERTY, this.m_bsObject.getBsName());
                    ((SiebelPropertySet)object2).setProperty(CODE_PROPERTY, ((WrapperCodeFilter)object).GenerateCode(WRAPPER_SUFFIX, (String)object4, (String)object4, this.m_soapBindingStyle));
                    ((SiebelPropertySet)object2).setProperty(NAME_PROPERTY, classDeclaration8.GetClassName());
                    ((SiebelPropertySet)object2).setProperty(FILE_NAME_PROPERTY, classDeclaration8.GetClassName() + ".java");
                    ((SiebelPropertySet)object2).setProperty(PACKAGE_PROPERTY, classDeclaration8.GetNamespace());
                    ((SiebelPropertySet)object2).setProperty(GENERATION_DATE_PROPERTY, string);
                    ((SiebelPropertySet)object2).setProperty(CODE_GEN_SERV_NAME_PROPERTY, GENERATE_CODE_BUSINESS_SERVICE_NAME);
                    ((SiebelPropertySet)object2).setProperty(PROGRAM_LANGUAGE_PROPERTY, "JCA");
                    ((SiebelPropertySet)object2).setProperty(HANDLER_XML, ((WrapperCodeFilter)object).generateHandler(this.m_bBackwardCompatibilityMode));
                    siebelPropertySet.addChild((SiebelPropertySet)object2);
                    continue;
                }
                if (classDeclaration8.GetClassType().equalsIgnoreCase(LOCAL_TYPE) || classDeclaration8.GetClassType().equalsIgnoreCase(REMOTE_TYPE) || classDeclaration8.GetClassType().equalsIgnoreCase(COMMON_TYPE) || classDeclaration8.GetClassType().equalsIgnoreCase(IMPL_TYPE) || classDeclaration8.GetClassType().equalsIgnoreCase(OUTPUT_RESULT_PARAMETER_SUFFIX)) {
                    object2 = null;
                    object = new EJBCodeFilter(classDeclaration8);
                    if (object == null) {
                        this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716825));
                        return false;
                    }
                    this.trace(3, "BSCodeGenerator:generateCode", "Generating EJB code.");
                    object2 = new SiebelPropertySet(OUTPUT_CODE_PROPERTY);
                    if (object2 == null || object == null) continue;
                    ((SiebelPropertySet)object2).setProperty(OUTPUT_NAME_PROPERTY, this.m_bsObject.getBsName());
                    ((SiebelPropertySet)object2).setProperty(CODE_PROPERTY, ((EJBCodeFilter)object).GenerateCode(classDeclaration8.GetClassType(), (String)object4, (String)object4));
                    ((SiebelPropertySet)object2).setProperty(NAME_PROPERTY, classDeclaration8.GetClassName());
                    ((SiebelPropertySet)object2).setProperty(FILE_NAME_PROPERTY, classDeclaration8.GetClassName() + ".java");
                    ((SiebelPropertySet)object2).setProperty(PACKAGE_PROPERTY, classDeclaration8.GetNamespace());
                    ((SiebelPropertySet)object2).setProperty(GENERATION_DATE_PROPERTY, string);
                    ((SiebelPropertySet)object2).setProperty(CODE_GEN_SERV_NAME_PROPERTY, GENERATE_CODE_BUSINESS_SERVICE_NAME);
                    ((SiebelPropertySet)object2).setProperty(PROGRAM_LANGUAGE_PROPERTY, "JCA");
                    siebelPropertySet.addChild((SiebelPropertySet)object2);
                    continue;
                }
                object2 = null;
                object = new JCACodeFilter(classDeclaration8, this.m_bBackwardCompatibilityMode, "BS", this.m_busSvcNamespace, this.m_intObjName);
                if (object == null) {
                    this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716809));
                    return false;
                }
                this.trace(3, "BSCodeGenerator:generateCode", "Generating business Service code.");
                object2 = new SiebelPropertySet(OUTPUT_CODE_PROPERTY);
                if (object2 == null || object == null) continue;
                ((SiebelPropertySet)object2).setProperty(OUTPUT_NAME_PROPERTY, this.m_bsObject.getBsName());
                ((SiebelPropertySet)object2).setProperty(CODE_PROPERTY, ((JCACodeFilter)object).GenerateCode(BUSINESS_SERVICE, (String)object4, (String)object4));
                ((SiebelPropertySet)object2).setProperty(NAME_PROPERTY, classDeclaration8.GetClassName());
                ((SiebelPropertySet)object2).setProperty(FILE_NAME_PROPERTY, classDeclaration8.GetClassName() + ".java");
                ((SiebelPropertySet)object2).setProperty(PACKAGE_PROPERTY, classDeclaration8.GetNamespace());
                ((SiebelPropertySet)object2).setProperty(GENERATION_DATE_PROPERTY, string);
                ((SiebelPropertySet)object2).setProperty(CODE_GEN_SERV_NAME_PROPERTY, GENERATE_CODE_BUSINESS_SERVICE_NAME);
                ((SiebelPropertySet)object2).setProperty(PROGRAM_LANGUAGE_PROPERTY, "JCA");
                siebelPropertySet.addChild((SiebelPropertySet)object2);
            }
        }
        if (siebelPropertySet != null) {
            CodeWriter codeWriter = new CodeWriter(this.m_CodeGenerationPath);
            if (codeWriter == null) {
                this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716807));
                return false;
            }
            if (!codeWriter.WriteCode(siebelPropertySet)) {
                this.trace(1, "BSCodeGenerator:generateCode", CSSMsgMgr.get(8716808));
                return false;
            }
        }
        return true;
    }

    private MethodDeclaration getBSMethod(BSMethodObject bSMethodObject, ArrayList<ClassDeclaration> arrayList) {
        int n;
        Object object;
        Object object2;
        Cloneable cloneable;
        boolean bl = false;
        boolean bl2 = false;
        this.trace(3, "BSCodeGenerator:getBSMethod", "Processing method - " + bSMethodObject.getMethodName());
        MethodDeclaration methodDeclaration = new MethodDeclaration(bSMethodObject.getMethodName(), bSMethodObject.getMethodName(), AccessRights.PUBLIC_ACCESS);
        ClassDeclaration classDeclaration = new ClassDeclaration(bSMethodObject.getMethodName() + "Input", bSMethodObject.getMethodName() + "Input", AccessRights.PUBLIC_ACCESS);
        ClassDeclaration classDeclaration2 = new ClassDeclaration(bSMethodObject.getMethodName() + "Input", bSMethodObject.getMethodName() + "Input", AccessRights.PUBLIC_ACCESS, true);
        ClassDeclaration classDeclaration3 = new ClassDeclaration(bSMethodObject.getMethodName() + "Output", bSMethodObject.getMethodName() + "Output", AccessRights.PUBLIC_ACCESS);
        ClassDeclaration classDeclaration4 = new ClassDeclaration(bSMethodObject.getMethodName() + "Output", bSMethodObject.getMethodName() + "Output", AccessRights.PUBLIC_ACCESS, true);
        ClassDeclaration classDeclaration5 = new ClassDeclaration(bSMethodObject.getMethodName() + OUTPUT_RESULT_PARAMETER_SUFFIX, bSMethodObject.getMethodName() + OUTPUT_RESULT_PARAMETER_SUFFIX, AccessRights.PUBLIC_ACCESS, true);
        Declaration declaration = new Declaration(STRING_TYPE, "SessionToken", "SessionToken", ONLY_ONE, AccessRights.PUBLIC_ACCESS);
        if (classDeclaration5 != null && declaration != null) {
            classDeclaration5.SetComment(this.m_bsObject.getBsName() + " output result parameter ");
            classDeclaration5.SetClassType(OUTPUT_RESULT_PARAMETER_SUFFIX);
            classDeclaration5.AddField(declaration);
            arrayList.add(classDeclaration5);
        }
        if (methodDeclaration != null) {
            methodDeclaration.SetComment(bSMethodObject.getMethodName());
        }
        this.trace(3, "BSCodeGenerator:getBSMethod", "Processing input and output arguments for method - " + bSMethodObject.getMethodName());
        if (bSMethodObject.getArgs() != null) {
            cloneable = bSMethodObject.getArgs();
            if (bSMethodObject.getMethodName().equals("QueryById") && !bSMethodObject.getXSDFilePath().equals(BLANK)) {
                this.m_xsdFileName = bSMethodObject.getXSDFilePath();
                BSMethodArgs bSMethodArgs = new BSMethodArgs("XsdUri", null, "Input", STRING_TYPE, null);
                object2 = new BSMethodArgs("OutputIntObjectName", null, "Input", STRING_TYPE, null);
                object = new BSMethodArgs("XSDContent", null, "Input", STRING_TYPE, null);
                ((Vector)cloneable).add(bSMethodArgs);
                ((Vector)cloneable).add(object2);
                ((Vector)cloneable).add(object);
            }
            for (n = 0; n < ((Vector)cloneable).size(); ++n) {
                object2 = ((Vector)cloneable).get(n);
                object = this.getBSMethodArgument((BSMethodArgs)object2, bSMethodObject.getMethodName());
                if (object == null) continue;
                if (((BSMethodArgs)object2).getArgType().equals("Input") || ((BSMethodArgs)object2).getArgType().equals(INPUT_OUTPUT) || ((BSMethodArgs)object2).getArgType().equals(IN_ONLY) || ((BSMethodArgs)object2).getArgType().equals(IN_OUT)) {
                    if (classDeclaration != null) {
                        classDeclaration.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                        classDeclaration.SetClassType(BLANK);
                        classDeclaration.AddField((Declaration)object);
                        bl = true;
                        this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + ((BSMethodArgs)object2).getArgName() + "\" to method input parameter class declaration field array.");
                    }
                    if (classDeclaration2 != null) {
                        classDeclaration2.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                        classDeclaration2.SetClassType(BLANK);
                        classDeclaration2.AddField((Declaration)object);
                        bl = true;
                        this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + ((BSMethodArgs)object2).getArgName() + "\" to method input parameter class declaration field array for EJB.");
                    }
                }
                if (!((BSMethodArgs)object2).getArgType().equals("Output") && !((BSMethodArgs)object2).getArgType().equals(INPUT_OUTPUT) && !((BSMethodArgs)object2).getArgType().equals(OUT_ONLY) && !((BSMethodArgs)object2).getArgType().equals(IN_OUT)) continue;
                if (classDeclaration3 != null) {
                    classDeclaration3.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                    classDeclaration3.SetClassType(BLANK);
                    classDeclaration3.AddField((Declaration)object);
                    bl2 = true;
                    this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + ((BSMethodArgs)object2).getArgName() + "\" to method output parameter class declaration field array.");
                }
                if (classDeclaration4 == null) continue;
                classDeclaration4.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                classDeclaration4.SetClassType(BLANK);
                classDeclaration4.AddField((Declaration)object);
                bl2 = true;
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + ((BSMethodArgs)object2).getArgName() + "\" to method output parameter class declaration field array for EJB.");
            }
        } else {
            this.trace(3, "BSCodeGenerator:getBSMethod", "No input and output arguments defined for method.");
        }
        if (this.m_bWorkflowCodeGeneration.booleanValue() && bSMethodObject.getWfStep() != null && bSMethodObject.getWfStep().size() > 0) {
            cloneable = bSMethodObject.getWfStep();
            for (n = 0; n < ((Vector)cloneable).size(); ++n) {
                BSMethodArgs bSMethodArgs;
                object2 = (WFStepObject)((Vector)cloneable).get(n);
                object = new Vector();
                if (((WFStepObject)object2).getMethodName().equalsIgnoreCase("QueryById") && !((WFStepObject)object2).getXsdFile().equals(BLANK)) {
                    BSMethodArgs bSMethodArgs2 = new BSMethodArgs("XsdUri:" + ((WFStepObject)object2).getServiceName(), null, "Input", STRING_TYPE, null);
                    bSMethodArgs = new BSMethodArgs("XSDContent:" + ((WFStepObject)object2).getServiceName(), null, "Input", STRING_TYPE, null);
                    ((Vector)object).add(bSMethodArgs2);
                    ((Vector)object).add(bSMethodArgs);
                }
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    bSMethodArgs = (BSMethodArgs)((Vector)object).get(i);
                    Declaration declaration2 = this.getBSMethodArgumentWFStepObject(bSMethodArgs, "QueryById", (WFStepObject)object2);
                    if (declaration2 == null) continue;
                    if (bSMethodArgs.getArgType().equals("Input") || bSMethodArgs.getArgType().equals(INPUT_OUTPUT) || bSMethodArgs.getArgType().equals(IN_ONLY) || bSMethodArgs.getArgType().equals(IN_OUT)) {
                        if (classDeclaration != null) {
                            classDeclaration.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                            classDeclaration.SetClassType(BLANK);
                            classDeclaration.AddField(declaration2);
                            bl = true;
                            this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + bSMethodArgs.getArgName() + "\" to method input parameter class declaration field array.");
                        }
                        if (classDeclaration2 != null) {
                            classDeclaration2.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                            classDeclaration2.SetClassType(BLANK);
                            classDeclaration2.AddField(declaration2);
                            bl = true;
                            this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + bSMethodArgs.getArgName() + "\" to method input parameter class declaration field array for EJB.");
                        }
                    }
                    if (!bSMethodArgs.getArgType().equals("Output") && !bSMethodArgs.getArgType().equals(INPUT_OUTPUT) && !bSMethodArgs.getArgType().equals(OUT_ONLY) && !bSMethodArgs.getArgType().equals(IN_OUT)) continue;
                    if (classDeclaration3 != null) {
                        classDeclaration3.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                        classDeclaration3.SetClassType(BLANK);
                        classDeclaration3.AddField(declaration2);
                        bl2 = true;
                        this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + bSMethodArgs.getArgName() + "\" to method output parameter class declaration field array.");
                    }
                    if (classDeclaration4 == null) continue;
                    classDeclaration4.SetComment(this.m_bsObject.getBsName() + " input parameter ");
                    classDeclaration4.SetClassType(BLANK);
                    classDeclaration4.AddField(declaration2);
                    bl2 = true;
                    this.trace(5, "BSCodeGenerator:getBSMethod", "Adding argument declaration object for \"" + bSMethodArgs.getArgName() + "\" to method output parameter class declaration field array for EJB.");
                }
            }
        }
        if (bl) {
            cloneable = new Declaration(bSMethodObject.getMethodName() + "Input", bSMethodObject.getMethodName() + "Input", BLANK, ONLY_ONE, AccessRights.PUBLIC_ACCESS);
            if (methodDeclaration != null && cloneable != null && arrayList != null) {
                methodDeclaration.AddArgument((Declaration)cloneable);
                arrayList.add(classDeclaration);
                arrayList.add(classDeclaration2);
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding input parameter class declaration type's declaration object to the \"" + bSMethodObject.getMethodName() + "\"  method declaration object's argument array.");
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding input parameter class declaration object to the class array list.");
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding input parameter class declaration object for EJB to the class array list.");
            }
        } else {
            cloneable = new Declaration(VOID_TYPE, VOID_TYPE, BLANK, ONLY_ONE, AccessRights.PUBLIC_ACCESS);
            if (methodDeclaration != null && cloneable != null) {
                methodDeclaration.AddArgument((Declaration)cloneable);
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding void type input argument declaration object to method declaration argument array.");
            }
        }
        if (bl2) {
            cloneable = new Declaration(methodDeclaration.GetMethodName() + "Output", methodDeclaration.GetMethodName() + "Output", BLANK, ONLY_ONE, AccessRights.PUBLIC_ACCESS);
            if (methodDeclaration != null && cloneable != null && arrayList != null) {
                methodDeclaration.SetReturnType((Declaration)cloneable);
                arrayList.add(classDeclaration3);
                arrayList.add(classDeclaration4);
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding output parameter class declaration type's declaration object to the \"" + bSMethodObject.getMethodName() + "\" method declaration object's argument array.");
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding output parameter class declaration object to the class array list.");
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding output parameter class declaration object for EJB to the class array list.");
            }
            Declaration declaration3 = new Declaration(methodDeclaration.GetMethodName() + "Output", methodDeclaration.GetMethodName() + "Output", BLANK, ONLY_ONE, AccessRights.PUBLIC_ACCESS);
            classDeclaration5.AddField(declaration3);
        } else {
            cloneable = new Declaration(VOID_TYPE, VOID_TYPE, BLANK, ONLY_ONE, AccessRights.PUBLIC_ACCESS);
            if (methodDeclaration != null && cloneable != null) {
                methodDeclaration.SetReturnType((Declaration)cloneable);
                this.trace(5, "BSCodeGenerator:getBSMethod", "Adding void type output argument declaration object to method declaration argument array.");
            }
        }
        return methodDeclaration;
    }

    private Declaration getBSMethodArgumentWFStepObject(BSMethodArgs bSMethodArgs, String string, WFStepObject wFStepObject) {
        Declaration declaration = null;
        if (string.equals("QueryById") && (bSMethodArgs.getArgName().indexOf("XsdUri") >= 0 || bSMethodArgs.getArgName().indexOf("XSDContent") >= 0)) {
            declaration = new Declaration(bSMethodArgs.getArgDataType(), bSMethodArgs.getArgName(), bSMethodArgs.getArgName(), ONLY_ONE, AccessRights.PRIVATE_ACCESS);
            if (declaration != null) {
                if (bSMethodArgs.getArgName().indexOf("XsdUri") >= 0) {
                    declaration.SetValue("\"" + this.getFileName(wFStepObject) + "\"");
                } else if (bSMethodArgs.getArgName().indexOf("XSDContent") >= 0) {
                    declaration.SetValue("\"" + this.getXSDFileAsString(wFStepObject) + "\"");
                }
            }
        } else {
            declaration = new Declaration(bSMethodArgs.getArgDataType(), bSMethodArgs.getArgName(), bSMethodArgs.getArgName(), ONLY_ONE, AccessRights.PUBLIC_ACCESS);
        }
        if (this.m_bBackwardCompatibilityMode) {
            if (bSMethodArgs.getXmlTag() != null) {
                declaration.setXmlTagName(bSMethodArgs.getXmlTag());
            }
            if (bSMethodArgs.getIntObjName() != null) {
                declaration.setSiebMsgArgName(bSMethodArgs.getIntObjName());
            }
        }
        if (declaration != null) {
            if (bSMethodArgs.getArgName().equals(PROCESS_NAME) && this.m_bWorkflowCodeGeneration.booleanValue()) {
                declaration.SetValue("\"" + bSMethodArgs.getDefaultString() + "\"");
                this.m_WorkflowProcessName = bSMethodArgs.getDefaultString();
                declaration.SetAccess(AccessRights.PRIVATE_ACCESS);
            }
            if (bSMethodArgs.getArgDataType().equals(INTEGRATION_OBJECT_TYPE) || bSMethodArgs.getArgDataType().equals(INT_OBJ_TYPE)) {
                declaration.SetComplexType(true);
                declaration.setImportPkgName(bSMethodArgs.getIntObjName());
                declaration.SetType(bSMethodArgs.getIntObjName() + INTEGRATION_OBJECT_SUFFIX);
                declaration.setBListOf(true);
                declaration.setBSiebMsgArg(true);
            } else if (bSMethodArgs.getArgDataType().equals(XSD_HIERARCHY_TYPE) || bSMethodArgs.getArgDataType().equals(XSD_HIER_TYPE)) {
                declaration.SetComplexType(true);
                declaration.setImportPkgName(bSMethodArgs.getIntObjName());
                if (this.m_bWorkflowCodeGeneration.booleanValue()) {
                    declaration.SetType(this.m_WorkflowProcessName + string + bSMethodArgs.getArgName());
                } else {
                    declaration.SetType(this.m_bsObject.getBsName() + string + bSMethodArgs.getArgName());
                }
            } else if ((bSMethodArgs.getArgDataType().equals(HIERARCHY_TYPE) || bSMethodArgs.getArgDataType().equals(PROPSET_CHILD_TYPE)) && bSMethodArgs.getIntObjName() != null) {
                declaration.SetComplexType(true);
                declaration.setImportPkgName(bSMethodArgs.getIntObjName());
                declaration.SetType(bSMethodArgs.getIntObjName() + INTEGRATION_OBJECT_SUFFIX);
                declaration.setBListOf(true);
                declaration.setBSiebMsgArg(true);
            } else if (bSMethodArgs.getArgDataType().equals(ALIAS_TYPE) || bSMethodArgs.getArgDataType().equals(VARCHAR_TYPE)) {
                declaration.SetType(STRING_TYPE);
            }
        }
        return declaration;
    }

    private Declaration getBSMethodArgument(BSMethodArgs bSMethodArgs, String string) {
        Declaration declaration = null;
        if (string.equals("QueryById") && (bSMethodArgs.getArgName().equals("XsdUri") || bSMethodArgs.getArgName().equals("OutputIntObjectName") || bSMethodArgs.getArgName().equals("XSDContent"))) {
            declaration = new Declaration(bSMethodArgs.getArgDataType(), bSMethodArgs.getArgName(), bSMethodArgs.getArgName(), ONLY_ONE, AccessRights.PRIVATE_ACCESS);
            if (declaration != null) {
                if (bSMethodArgs.getArgName().equals("XsdUri") || bSMethodArgs.getArgName().equals("OutputIntObjectName")) {
                    declaration.SetValue("\"" + this.getFileName() + "\"");
                } else if (bSMethodArgs.getArgName().equals("XSDContent")) {
                    declaration.SetValue("\"" + this.getXSDFileAsString() + "\"");
                }
            }
        } else {
            declaration = new Declaration(bSMethodArgs.getArgDataType(), bSMethodArgs.getArgName(), bSMethodArgs.getArgName(), ONLY_ONE, AccessRights.PUBLIC_ACCESS);
        }
        if (this.m_bBackwardCompatibilityMode) {
            if (bSMethodArgs.getXmlTag() != null) {
                declaration.setXmlTagName(bSMethodArgs.getXmlTag());
            }
            if (bSMethodArgs.getIntObjName() != null) {
                declaration.setSiebMsgArgName(bSMethodArgs.getIntObjName());
            }
        }
        if (declaration != null) {
            if (bSMethodArgs.getArgName().equals(PROCESS_NAME) && this.m_bWorkflowCodeGeneration.booleanValue()) {
                declaration.SetValue("\"" + bSMethodArgs.getDefaultString() + "\"");
                this.m_WorkflowProcessName = bSMethodArgs.getDefaultString();
                declaration.SetAccess(AccessRights.PRIVATE_ACCESS);
            }
            if (bSMethodArgs.getArgDataType().equals(INTEGRATION_OBJECT_TYPE) || bSMethodArgs.getArgDataType().equals(INT_OBJ_TYPE)) {
                declaration.SetComplexType(true);
                declaration.setImportPkgName(bSMethodArgs.getIntObjName());
                declaration.SetType(bSMethodArgs.getIntObjName() + INTEGRATION_OBJECT_SUFFIX);
                declaration.setBListOf(true);
                declaration.setBSiebMsgArg(true);
            } else if (bSMethodArgs.getArgDataType().equals(XSD_HIERARCHY_TYPE) || bSMethodArgs.getArgDataType().equals(XSD_HIER_TYPE)) {
                declaration.SetComplexType(true);
                declaration.setImportPkgName(bSMethodArgs.getIntObjName());
                if (this.m_bWorkflowCodeGeneration.booleanValue()) {
                    declaration.SetType(this.m_WorkflowProcessName + string + bSMethodArgs.getArgName());
                } else {
                    declaration.SetType(this.m_bsObject.getBsName() + string + bSMethodArgs.getArgName());
                }
            } else if ((bSMethodArgs.getArgDataType().equals(HIERARCHY_TYPE) || bSMethodArgs.getArgDataType().equals(PROPSET_CHILD_TYPE)) && bSMethodArgs.getIntObjName() != null) {
                declaration.SetComplexType(true);
                declaration.setImportPkgName(bSMethodArgs.getIntObjName());
                declaration.SetType(bSMethodArgs.getIntObjName() + INTEGRATION_OBJECT_SUFFIX);
                declaration.setBListOf(true);
                declaration.setBSiebMsgArg(true);
            } else if (bSMethodArgs.getArgDataType().equals(ALIAS_TYPE) || bSMethodArgs.getArgDataType().equals(VARCHAR_TYPE)) {
                declaration.SetType(STRING_TYPE);
            }
        }
        return declaration;
    }

    public boolean generateCode(BSObject bSObject, String string) {
        this.m_bsObject = bSObject;
        this.m_CodeGenerationPath = string;
        return this.generateCode();
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }

    private String getFileName() {
        int n = this.m_xsdFileName.lastIndexOf("/");
        String string = n == -1 ? this.m_xsdFileName : this.m_xsdFileName.substring(n + 1);
        return string;
    }

    private String getFileName(WFStepObject wFStepObject) {
        int n = wFStepObject.getXsdFile().lastIndexOf("/");
        String string = n == -1 ? wFStepObject.getXsdFile() : wFStepObject.getXsdFile().substring(n + 1);
        return string;
    }

    private String getXSDFileAsString() {
        String string = BLANK;
        try {
            String string2;
            URL uRL = new URL(this.m_xsdFileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string.replaceAll("\"", "\\\\\"");
        return string;
    }

    private String getXSDFileAsString(WFStepObject wFStepObject) {
        String string = BLANK;
        try {
            String string2;
            URL uRL = new URL(wFStepObject.getXsdFile());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string.replaceAll("\"", "\\\\\"");
        return string;
    }

    public static void main(String[] stringArray) {
        Vector<BSMethodArgs> vector = new Vector<BSMethodArgs>();
        BSMethodArgs bSMethodArgs = new BSMethodArgs(PROCESS_NAME, "42-INM-XEZ4", "Input", STRING_TYPE, BLANK);
        bSMethodArgs.setDefaultString("WorkflowCodeGen-Test4");
        vector.add(bSMethodArgs);
        BSMethodArgs bSMethodArgs2 = new BSMethodArgs("Error Code", "42-HD20G", "In/Out", STRING_TYPE, BLANK);
        vector.add(bSMethodArgs2);
        BSMethodArgs bSMethodArgs3 = new BSMethodArgs("Error Message", "42-HD20H", "In/Out", STRING_TYPE, BLANK);
        vector.add(bSMethodArgs3);
        BSMethodArgs bSMethodArgs4 = new BSMethodArgs("Object Id", "42-HD20I", "In/Out", STRING_TYPE, BLANK);
        vector.add(bSMethodArgs4);
        BSMethodArgs bSMethodArgs5 = new BSMethodArgs("Process Instance Id", "42-HD20K", "In/Out", STRING_TYPE, BLANK);
        vector.add(bSMethodArgs5);
        BSMethodArgs bSMethodArgs6 = new BSMethodArgs("Siebel Operation Object Id", "42-HD20L", "In/Out", STRING_TYPE, BLANK);
        vector.add(bSMethodArgs6);
        BSMethodArgs bSMethodArgs7 = new BSMethodArgs("PageSize", "42-HD20J", "In", "Number", BLANK);
        vector.add(bSMethodArgs7);
        BSMethodArgs bSMethodArgs8 = new BSMethodArgs("StartRowNum", "42-HD20O", "In", "Number", BLANK);
        vector.add(bSMethodArgs8);
        BSMethodArgs bSMethodArgs9 = new BSMethodArgs("ViewMode", "42-HD20P", "In", STRING_TYPE, BLANK);
        vector.add(bSMethodArgs9);
        BSMethodArgs bSMethodArgs10 = new BSMethodArgs(INTEGRATION_OBJECT_SUFFIX, "42-HD20M", "In", INTEGRATION_OBJECT_TYPE, BLANK);
        bSMethodArgs10.setIntObjName("AccountAttOrderAtt");
        bSMethodArgs10.setXmlTag("ListOfAccountattorderatt");
        vector.add(bSMethodArgs10);
        BSMethodArgs bSMethodArgs11 = new BSMethodArgs("IO2", "42-HD20N", "In/Out", INTEGRATION_OBJECT_TYPE, BLANK);
        bSMethodArgs11.setIntObjName("AccountAttOrderAttCopy");
        bSMethodArgs11.setXmlTag("ListOfAccountattorderattCopy");
        vector.add(bSMethodArgs11);
        Vector<BSMethodObject> vector2 = new Vector<BSMethodObject>();
        BSMethodObject bSMethodObject = new BSMethodObject("RunProcess", "42-INM-X7W", vector);
        vector2.add(bSMethodObject);
        BSObject bSObject = new BSObject(WORKFLOW_PROCESS_MANAGER, "42-INM-X5B1", vector2);
        Properties properties = new Properties();
        properties.setProperty("RunProcess", "runProcessY");
        BSCodeGenerator bSCodeGenerator = new BSCodeGenerator(bSObject, "D:/temp", true, properties, "http://siebel.com/CustomUI", "AccountAttOrderAttCopy", "WorkflowCodeGen-Test4");
        bSCodeGenerator.generateCode();
    }
}

