/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.codegen;

import com.siebel.integration.codegen.AccessRights;
import com.siebel.integration.codegen.ClassDeclaration;
import com.siebel.integration.codegen.CodeFilter;
import com.siebel.integration.codegen.Declaration;
import com.siebel.integration.codegen.MethodDeclaration;
import java.util.ArrayList;
import java.util.Calendar;

public class JCACodeFilter
extends CodeFilter {
    public static final String XML_SCHEMA = "XML_SCHEMA";
    public static final String BUSINESS_SERVICE = "BUSINESS_SERVICE";
    public static final int JAVA_SUPPORTED_STRING_CONSTANT_LENGTH = 65535;
    private boolean m_backwardCompatibilityMode = false;
    private String m_module = null;
    private String m_busSvcNamespace = "";
    private String m_intObjName = null;

    public JCACodeFilter() {
        this.m_backwardCompatibilityMode = false;
        this.m_module = null;
        this.m_busSvcNamespace = "";
        this.m_intObjName = null;
    }

    public JCACodeFilter(ClassDeclaration classDeclaration) {
        super(classDeclaration);
        this.m_backwardCompatibilityMode = false;
        this.m_module = null;
        this.m_busSvcNamespace = "";
        this.m_intObjName = null;
    }

    public JCACodeFilter(ClassDeclaration classDeclaration, boolean bl, String string, String string2, String string3) {
        super(classDeclaration);
        this.m_backwardCompatibilityMode = bl;
        this.m_module = string;
        this.m_busSvcNamespace = string2;
        this.m_intObjName = string3;
    }

    public String GenerateCode(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        Calendar calendar = Calendar.getInstance();
        String string6 = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
        ArrayList<String> arrayList = this.m_class_declaration.GetInterfaceArray();
        ArrayList<String> arrayList2 = this.m_class_declaration.GetInheritanceArray();
        if (string.equalsIgnoreCase(XML_SCHEMA)) {
            string5 = this.m_class_declaration.isForEJB() ? "com.siebel.ejb.local.p" : "com.siebel.local.p";
        } else if (string.equalsIgnoreCase(BUSINESS_SERVICE)) {
            string5 = this.m_class_declaration.isForEJB() ? "com.siebel.ejb.jca.p" : "com.siebel.service.jca.p";
        }
        if (this.m_class_declaration.IsAdapterClass()) {
            arrayList2.add("SiebelJCAAdapterBase");
        } else {
            arrayList.add("Serializable");
            arrayList.add("Cloneable");
            arrayList.add("SiebelHierarchy");
        }
        string4 = string4 + "package __PACKAGE____package__;\n\n\n/* \n * -- AUTOMATICALLY GENERATED FROM SIEBEL SAI Wizard -- \n * Copyright (C) Oracle Corporation 2010. All rights reserved. \n * \n * MODIFICATION OR EXTENSION OF THIS CODE SHALL VOID ANY APPLICABLE \n * WARRANTIES AND MAINTENANCE SUPPORT.\n * \n * Generated from Siebel SAI Code Generator \n * Generated Date  : __date__ \n */\n\n";
        string4 = string4 + "\n /* import classes we need. */  \nimport java.io.Serializable;  \nimport java.util.ArrayList; \nimport java.util.Enumeration; \n\nimport com.siebel.data.SiebelException; \nimport com.siebel.data.SiebelExceptionConstants; \nimport com.siebel.data.SiebelPropertySet; \n\nimport com.siebel.integration.util.SiebelHierarchy; \nimport com.siebel.integration.util.SiebelHierarchyImpl; \nimport com.siebel.integration.adapter.SiebelJCAAdapterBase; \nimport javax.xml.bind.annotation.*;  \nimport com.siebel.common.util.Base64;\nimport java.util.*;\nimport java.text.*;\nimport java.math.*;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport com.siebel.data.StreamingException;\nimport com.siebel.integration.sessmgr.streamhandler.StreamConstants;\nimport com.siebel.integration.util.SiebelTrace;\nimport com.siebel.integration.util.SiebelTraceLevel;\nimport java.io.FileNotFoundException;\nimport java.io.FileOutputStream;\nimport java.io.OutputStream;\nimport com.siebel.data.*; \nimport com.siebel.common.common.*; \nimport java.io.BufferedInputStream; \nimport java.io.BufferedOutputStream; \nimport java.io.File; \nimport java.io.FileInputStream; \nimport java.io.Serializable;\n";
        if (!this.m_class_declaration.isForEJB()) {
            string4 = string4 + "\n \nimport com.sun.xml.ws.developer.StreamingAttachment;\nimport javax.activation.DataHandler;\nimport com.sun.xml.ws.util.ByteArrayDataSource;\nimport javax.activation.DataSource;\nimport javax.activation.FileDataSource;\nimport com.siebel.common.util.FileManager; \n";
        }
        string4 = string4 + this.AddExtraReferences();
        string4 = string4 + "\n\n\n/** \n * __COMMENT__ \n * \n * Generated from Siebel SAI Code Generator \n **/ \n\n";
        this.m_class_declaration.SetNamespace(this.BeautifyClassName(string3) + "." + string5 + this.BeautifyNamespace(string2));
        this.m_class_declaration.SetClassName(this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        string4 = string4.replace("__PACKAGE__", string5);
        string4 = string4.replace("__package__", this.BeautifyNamespace(string2));
        string4 = string4.replace("__COMMENT__", this.m_class_declaration.GetClassName());
        string4 = string4.replace("__date__", string6);
        if (this.m_class_declaration.GetClassName().equals("Document") && !this.m_class_declaration.isForEJB()) {
            string4 = string4 + "\n@StreamingAttachment(parseEagerly=true, memoryThreshold=1048576L)";
            string4 = string4 + "\n@XmlAccessorType(XmlAccessType.PROPERTY)";
            string4 = string4 + "\n@XmlType(name = \"" + this.BeautifyClassName(this.m_class_declaration.GetClassName()) + "\" , namespace = \"" + string5 + this.BeautifyNamespace(string2) + "\" , propOrder = {\"fContentId\", \"fDocumentContent\",\"fTimedOut\",\"fEndOfData\",\"fAttachmentIsTextData\",\"fExtension\"})" + "\n";
        } else {
            string4 = string4 + "\n@XmlType(name = \"" + this.BeautifyClassName(this.m_class_declaration.GetClassName()) + "\" , namespace = \"" + string5 + this.BeautifyNamespace(string2) + "\")" + "\n";
        }
        string4 = string4 + this.AccessToString(this.m_class_declaration.GetAccess());
        string4 = string4 + "class " + this.BeautifyClassName(this.m_class_declaration.GetClassName());
        if (arrayList2.size() > 0) {
            string4 = string4 + " extends " + this.StringArrayToString(arrayList2);
        }
        if (arrayList.size() > 0) {
            string4 = string4 + " implements " + this.StringArrayToString(arrayList);
        }
        string4 = string4 + " {\n";
        string4 = string4 + "  /* class level properties */\n";
        string4 = string4 + "  public    static final String  SIEBEL_REPOSITORY  = \"";
        string4 = string4 + this.m_class_declaration.GetRepository() + "\";\n";
        string4 = string4 + "  public    static final String  SIEBEL_VERSION     = \"";
        string4 = string4 + this.m_class_declaration.GetVersion() + "\";\n\n";
        string4 = string4 + "  public    static final String  CLASS_PROPERTY     = \"";
        string4 = string4 + this.m_class_declaration.GetPropertyName() + "\";\n";
        string4 = string4 + "  public    static final boolean USING_LIST         = true;\n";
        string4 = string4 + "  public    static final boolean PS_TYPE_REQUIRED   = ";
        string4 = string.equalsIgnoreCase(XML_SCHEMA) && this.m_class_declaration.GetClassType().equals("IC") ? string4 + "true;\n" : string4 + "false;\n";
        string4 = string4 + this.AddProperties() + "\n";
        string4 = string4 + this.AddConstructors() + "\n";
        if (!this.m_class_declaration.IsAdapterClass()) {
            string4 = string4 + this.AddHashCode() + "\n";
            string4 = string4 + this.AddEqual() + "\n";
            string4 = string4 + this.AddClone() + "\n";
            if (this.m_backwardCompatibilityMode) {
                string4 = string4 + this.AddBckwardCompatibleToPSMethod() + "\n\n";
                string4 = string4 + this.AddBckwrdCompatibleFromPSMethod() + "\n\n";
            } else {
                string4 = string4 + this.AddToPropertySetMethod() + "\n\n";
                string4 = string4 + this.AddFromPropertySetMethod() + "\n\n";
            }
        }
        string4 = string4 + this.AddAccessMethods() + "\n";
        string4 = string4 + this.AddUserDefinedMethods() + "\n";
        if (this.m_class_declaration.GetClassName().equals("Document") && !this.m_class_declaration.isForEJB()) {
            string4 = string4 + this.AddsetDataValueMethod() + "\n";
        }
        string4 = string4 + this.AddFields();
        string4 = string4 + "}/* " + this.BeautifyClassName(this.m_class_declaration.GetClassName());
        string4 = string4 + " */\n\n\n\n\n\n\n";
        return string4;
    }

    protected String AddProperties() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        if (arrayList.size() > 0) {
            string = string + "\n  /* Field Level Properties */\n";
            for (int i = 0; i < arrayList.size(); ++i) {
                Declaration declaration = arrayList.get(i);
                String string2 = this.BeautifyVariableName(declaration.GetVariable() + "_PROPERTY");
                string2 = string2.replace(" ", "_");
                string2 = string2.toUpperCase();
                string = string + "  protected static final String  ";
                string = string + string2 + "  =  \"";
                string = string + declaration.GetProperty();
                string = string + "\";\n";
            }
        }
        return string;
    }

    protected String AddConstructors() {
        String string = this.m_class_declaration.IsAdapterClass() ? "  /* default constructor */ \n  public __TYPE__()  { \n    super(); \n    setSiebelServiceName(CLASS_PROPERTY);  \n  }/* public __TYPE__(...) */ \n\n \n  /* adapter constructor */ \n  public __TYPE__(String rbn) {\n    super(rbn);\n    setSiebelServiceName(CLASS_PROPERTY); \n  }/* public __TYPE__(...) */ \n\n \n  /* adapter constructor */ \n  public __TYPE__(String username, String password, String connect) {\n    super(username, password, connect);\n    setSiebelServiceName(CLASS_PROPERTY); \n  }/* public __TYPE__(...) */ \n\n \n  /* adapter constructor */ \n  public __TYPE__(String username, String password, String connect, String language) {\n    super(username, password, connect, language);\n    setSiebelServiceName(CLASS_PROPERTY); \n  }/* public __TYPE__(...) */ \n\n" : "  /* default constructor */ \n  public __TYPE__()  { \n    super(); \n  }/* public __TYPE__(...) */ \n\n\n  /* constructor from a Siebel Property Set */ \n  public __TYPE__(SiebelPropertySet ps) throws SiebelException { \n    super(); \n    fromPropertySet(ps);  \n  }/* public __TYPE__(...) */     \n\n";
        string = string.replace("__TYPE__", this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        return string;
    }

    protected String AddDestructors() {
        String string = "";
        return string;
    }

    protected String AddAccessMethods() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            string = string + "  /* access methods for ";
            string = string + this.BeautifyVariableName(declaration.GetVariable());
            string = string + " */\n";
            if (declaration.IsRepeated()) {
                if (declaration.IsReadable()) {
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "  __access__ ArrayList<__type__> getf__VARIABLE__() {    \n    if(__variable__ != null) {\n      return (ArrayList<__type__>)__variable__.clone();   \n    }else{\n      return null; \n    }/* if-else */\n  }/* __access__ ArrayList getf__VARIABLE__(...) */ \n\n");
                }
                if (declaration.IsWriteable()) {
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "  __access__ void setf__VARIABLE__(__type__ val) { \n    if(val != null) {\n      if(__variable__ == null) { \n        __variable__ = new ArrayList<__type__>(); \n      }/* if */  \n\n      __variable__.add(val); \n    }/* if */ \n  }/* __access__ void addf__VARIABLE__(...) */ \n\n  __access__ void clearf__VARIABLE__() { \n    if(__variable__ != null) { \n      __variable__.clear(); \n      __variable__ = null;\n    }/* if */ \n\n    __variable__ = new ArrayList<__type__>();\n  }/* __access__ void clearf__VARIABLE__(...) */ \n\n  __access__ void removef__VARIABLE__(int pos) { \n    if(__variable__ != null) { \n      __variable__.remove(pos); \n      __variable__ = null; \n    }/* if */ \n  }/* __access__ void removef__VARIABLE__(...) */ \n\n");
                }
            } else {
                if (!declaration.GetType().equalsIgnoreCase("byte[]") && declaration.GetAccess().equals((Object)AccessRights.PUBLIC_ACCESS)) {
                    String string2 = "";
                    String string3 = declaration.GetVariable();
                    if (this.m_backwardCompatibilityMode) {
                        if (this.m_module != null && this.m_module.equals("BS")) {
                            if (declaration.isBSiebMsgArg()) {
                                string2 = "http://www.siebel.com/xml/";
                                string2 = declaration.getSiebMsgArgName() != null ? string2 + declaration.getSiebMsgArgName().trim().replaceAll("\\s", "%20") : string2 + declaration.getSiebMsgArgName();
                                string3 = declaration.getXmlTagName();
                            } else {
                                string2 = this.m_busSvcNamespace != null ? this.m_busSvcNamespace.trim().replaceAll("\\s", "%20") : this.m_busSvcNamespace;
                            }
                        } else if (this.m_module != null && this.m_module.equals("IO")) {
                            string2 = "http://www.siebel.com/xml/";
                            string2 = this.m_intObjName != null ? string2 + this.m_intObjName.trim().replaceAll("\\s", "%20") : string2 + this.m_intObjName;
                        }
                    }
                    if (declaration.getXmlStyle().equals("Attribute")) {
                        string = string + "@XmlAttribute(namespace=\"\", name=\"" + this.BeautifyVariableNameWithoutToken(string3) + "\"";
                        if (declaration.GetCardinality().equals("One")) {
                            string = string + ", required=true";
                        }
                        string = string + ")\n";
                    } else {
                        string = this.m_backwardCompatibilityMode ? string + "@XmlElement(namespace=\"" + string2 + "\", name=\"" + this.BeautifyClassNameForMigration(string3) + "\"" : string + "@XmlElement(namespace=\"" + string2 + "\", name=\"" + this.BeautifyVariableNameWithoutToken(string3) + "\"";
                        if (declaration.GetCardinality().equals("One")) {
                            string = string + ", required=true";
                        }
                        string = string + ")\n";
                    }
                }
                if (declaration.IsReadable()) {
                    if (declaration.GetType().equalsIgnoreCase("byte[]")) {
                        string = string + "  @XmlTransient\n";
                    }
                    if (declaration.GetType().equalsIgnoreCase("DataHandler")) {
                        string = string + "@XmlMimeType(\"application/octet-stream\")\n";
                    }
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "  __access__ __type__ getf__VARIABLE__() { \n    return __variable__; \n  }/* __access__ __type__ getf__VARIABLE__(...) */ \n\n");
                }
                if (declaration.IsWriteable()) {
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "  __access__ void setf__VARIABLE__(__type__ val) { \n    __variable__ = val; \n  }/* __access__ void setf__VARIABLE__(...) */  \n\n");
                }
            }
            string = string + "\n";
        }
        return string;
    }

    protected String AddHashCode() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        string = string + "  public int hashCode() {\n";
        string = string + "    int HASH_PRIME = 51;\n";
        string = string + "    int hash       =  0;\n\n";
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            string = declaration.IsRepeated() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) {\n      for(int i = 0; i < __variable__.size(); ++i) { \n        __type__  tmp = (__type__)__variable__.get(i); \n\n        hash = HASH_PRIME * hash + tmp.hashCode(); \n      }/* for */ \n    }/* if */ \n\n") : string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) {\n      hash = HASH_PRIME * hash + __variable__.hashCode(); \n    }/* if */\n\n");
        }
        string = string + "    return hash;\n";
        string = string + "  }/* public int hashCode(...) */\n\n";
        return string;
    }

    protected String AddClone() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        string = string + "  public Object clone() {\n";
        string = string + "    try {    \n      ";
        string = string + this.BeautifyClassName(this.m_class_declaration.GetClassName());
        string = string + " result = (";
        string = string + this.BeautifyClassName(this.m_class_declaration.GetClassName());
        string = string + ") super.clone();\n\n";
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            if (declaration.IsRepeated()) {
                string = string + this.ADD_FIELD_CODE_BODY(declaration, "      if(__variable__ != null) {\n        result.__variable__ = (ArrayList<__type__>)__variable__.clone(); \n\n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__   elem  = (__type__)__variable__.get(i); \n\n          result.__variable__.add(i, elem); \n        }/* for */ \n      }/* if */ \n\n");
                continue;
            }
            if (this.BeautifyClassName(declaration.GetType()).equalsIgnoreCase("String") || this.BeautifyClassName(declaration.GetType()).equalsIgnoreCase("Integer") || this.BeautifyClassName(declaration.GetType()).equalsIgnoreCase("Boolean") || this.BeautifyClassName(declaration.GetType()).equalsIgnoreCase("BigDecimal") || this.BeautifyClassName(declaration.GetType()).equalsIgnoreCase("GregorianCalendar") || this.BeautifyClassName(declaration.GetType()).equalsIgnoreCase("DataHandler")) continue;
            string = string + this.ADD_FIELD_CODE_BODY(declaration, "      result.__variable__ = (__type__)__variable__.clone(); \n");
        }
        string = string + "      return result;\n";
        string = string + "    }catch(CloneNotSupportedException cnse) {\n";
        string = string + "       return null;\n    }/* try - catch */\n";
        string = string + "  }/* public Object clone(...) */\n\n";
        return string;
    }

    protected String AddEqual() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        string = string + "  public boolean equals(Object object) {\n";
        string = string + "    if(this == object) return true;\n";
        string = string + "    if(object == null) return false;\n";
        string = string + "    if(object.getClass() != getClass()) return false;\n";
        string = string + "    " + this.BeautifyClassName(this.m_class_declaration.GetClassName());
        string = string + " o = (" + this.BeautifyClassName(this.m_class_declaration.GetClassName());
        string = string + ")object;\n\n";
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            string = declaration.IsRepeated() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if((__variable__ != null) && (o.__variable__ != null)) { \n      if(__variable__.size() != o.__variable__.size()) return false; \n\n      for(int i = 0; i < __variable__.size(); ++i) { \n         if(! __variable__.get(i).equals(o.__variable__.get(i)))   \n           return false;  \n      }/* for */  \n    }else{\n      if(__variable__ != o.__variable__) return false;\n    }/* if */\n\n") : string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ == null) { \n       if(o.__variable__ != null) return false; \n    }else if(! __variable__.equals(o.__variable__)) return false; \n\n");
        }
        string = string + "    return true;\n";
        string = string + "  }/* public int equals(...) */\n\n";
        return string;
    }

    protected String AddExtraReferences() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            if (!declaration.IsComplexType()) continue;
            String string2 = "";
            String string3 = this.m_class_declaration.isForEJB() ? "com.siebel.ejb.local.p" : "com.siebel.local.p";
            string3 = declaration.getImportPkgName() != null && !declaration.getImportPkgName().equals("") ? string3 + this.BeautifyNamespace(declaration.getImportPkgName()) : string3 + this.BeautifyNamespace(declaration.GetType());
            string3 = string3 + ".";
            string3 = string3.toLowerCase();
            string2 = string2 + string3;
            string2 = string2 + this.BeautifyClassName(declaration.GetType());
            string = string + "\nimport ";
            string = string + string2;
            string = string + ";\n\n";
        }
        return string;
    }

    protected String AddBckwardCompatibleToPSMethod() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        String string2 = this.BeautifyClassName(this.m_class_declaration.GetClassName()) + "_PROPERTY";
        string2 = string2.toUpperCase();
        if (this.m_class_declaration.isBModifyToFromPS()) {
            string = string + "  public SiebelPropertySet toPropertySet() {\n";
            string = string + "      SiebelPropertySet ps = new SiebelPropertySet();\n\n";
            string = string + "      for(int j = 0; j < f" + this.m_class_declaration.GetClassName() + ".size() ; j ++){\n\n";
            string = string + "         SiebelPropertySet childPropSet = new SiebelPropertySet();\n\n";
            string = string + "         " + this.m_class_declaration.GetClassName() + " tmpIC = (" + this.m_class_declaration.GetClassName() + ")  f" + this.m_class_declaration.GetClassName() + ".get(j);\n";
            string = string + "         childPropSet.setType(CLASS_PROPERTY);\n";
            String string3 = this.m_class_declaration.GetClassType();
            if (arrayList.size() > 0) {
                string = string + "\n";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Declaration declaration = arrayList.get(i);
                    if (declaration.IsRepeated()) {
                        if (string3.equalsIgnoreCase("IO")) {
                            string = string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise  \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n\n          childPs.addChild(temp.toPropertySet());\n        }/* for */ \n\n        ps.addChild(childPs); \n\n");
                            string = string + this.ADD_FIELD_CODE_BODY(declaration, "  }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) { \n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__ temp = (__type__)  __variable__.get(i); \n\n          ps.addChild(temp.toPropertySet()); \n        }/* for */ \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                            continue;
                        }
                        if (!declaration.isBToBeAdded()) continue;
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise  \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n\n          childPs = temp.toPropertySet();\n        }/* for */ \n\n        childPs.setType(\"ListOf__property_name__\");\n        ps.addChild(childPs); \n\n");
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "  }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) { \n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__ temp = (__type__)  __variable__.get(i); \n\n          ps = temp.toPropertySet();\n        }/* for */ \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                        continue;
                    }
                    string = declaration.IsIntCompType() && declaration.IsSingle() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) {\n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        childPs.addChild(__variable__.toPropertySet());\n\n        ps.addChild(childPs); \n      }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) {\n        ps.addChild(__variable__.toPropertySet()); \n      }/* if */\n    }/* if USING_LIST */ \n\n") : (declaration.IsComplexType() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) {  \n      SiebelPropertySet childPs = null; \n\n      try { \n        childPs = new SiebelPropertySet(__variable__.toPropertySet()); \n      }catch(SiebelException se) {\n        throw new IllegalArgumentException(se.getMessage());\n      }/* try-catch */\n\n      childPs.setType(\"__var_name__\"); \n      ps.addChild(childPs); \n    }/* if */ \n\n") : (declaration.GetType().equalsIgnoreCase("Hierarchy") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.addChild(__variable__.toPropertySet()); \n\n") : (declaration.GetProperty().equalsIgnoreCase("<value>") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setValue(__variable__); \n\n") : string + this.ADD_FIELD_CODE_BODY(declaration, "    if(tmpIC.__variable__ != null)   \n      childPropSet.setProperty(\"__property_name__\", tmpIC.__variable__); \n\n"))));
                }
                string = string + "         ps.addChild(childPropSet);\n";
                string = string + "      }\n\n";
            }
            string = string + "    return ps;\n";
            string = string + "  }/* public SiebelPropertySet toPropertySet(...) */\n\n";
        } else {
            string2 = this.BeautifyClassName(this.m_class_declaration.GetClassName()) + "_PROPERTY";
            string2 = string2.toUpperCase();
            string = string + "  public SiebelPropertySet toPropertySet() {\n";
            string = string + "    SiebelPropertySet ps = new SiebelPropertySet();\n\n";
            string = string + "    ps.setType(CLASS_PROPERTY);\n";
            String string4 = this.m_class_declaration.GetClassType();
            if (arrayList.size() > 0) {
                string = string + "\n";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Declaration declaration = arrayList.get(i);
                    if (declaration.IsRepeated()) {
                        if (string4.equalsIgnoreCase("IO")) {
                            string = string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise  \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n\n          childPs.addChild(temp.toPropertySet());\n        }/* for */ \n\n        ps.addChild(childPs); \n\n");
                            string = string + this.ADD_FIELD_CODE_BODY(declaration, "  }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) { \n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__ temp = (__type__)  __variable__.get(i); \n\n          ps.addChild(temp.toPropertySet()); \n        }/* for */ \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                            continue;
                        }
                        if (!declaration.isBToBeAdded()) continue;
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise  \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n\n          childPs = temp.toPropertySet();\n        }/* for */ \n\n        childPs.setType(\"ListOf__property_name__\");\n        ps.addChild(childPs); \n\n");
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "  }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) { \n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__ temp = (__type__)  __variable__.get(i); \n\n          ps = temp.toPropertySet();\n        }/* for */ \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                        continue;
                    }
                    string = declaration.IsIntCompType() && declaration.IsSingle() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) {\n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        childPs.addChild(__variable__.toPropertySet());\n\n        ps.addChild(childPs); \n      }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) {\n        ps.addChild(__variable__.toPropertySet()); \n      }/* if */\n    }/* if USING_LIST */ \n\n") : (declaration.IsComplexType() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) {  \n      SiebelPropertySet childPs = null; \n\n      try { \n        childPs = new SiebelPropertySet(__variable__.toPropertySet()); \n      }catch(SiebelException se) {\n        throw new IllegalArgumentException(se.getMessage());\n      }/* try-catch */\n\n      childPs.setType(\"__var_name__\"); \n      ps.addChild(childPs); \n    }/* if */ \n\n") : (declaration.GetType().equalsIgnoreCase("Hierarchy") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.addChild(__variable__.toPropertySet()); \n\n") : (declaration.GetProperty().equalsIgnoreCase("<value>") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setValue(__variable__); \n\n") : string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setProperty(\"__property_name__\", __variable__); \n\n"))));
                }
            }
            string = string + "    return ps;\n";
            string = string + "  }/* public SiebelPropertySet toPropertySet(...) */\n\n";
        }
        return string;
    }

    protected String AddToPropertySetMethod() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        String string2 = this.BeautifyClassName(this.m_class_declaration.GetClassName()) + "_PROPERTY";
        string2 = string2.toUpperCase();
        string = string + "  public SiebelPropertySet toPropertySet() {\n";
        string = string + "    SiebelPropertySet ps = new SiebelPropertySet();\n\n";
        string = string + "    ps.setType(CLASS_PROPERTY);\n";
        String string3 = this.m_class_declaration.GetClassType();
        if (arrayList.size() > 0) {
            string = string + "\n";
            for (int i = 0; i < arrayList.size(); ++i) {
                Declaration declaration = arrayList.get(i);
                if (declaration.IsRepeated()) {
                    if (declaration.isDoc_Content()) {
                        string = this.m_class_declaration.isForEJB() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if document variable is null then the Siebel Adapter will ignore it. otherwise it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n        childPs.setType(\"Attachments\");\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n          childPs.addChild(temp.toPropertySet());\n        }/* for */ \n        ps.addChild(childPs); \n      }/* if */\n    }/* if USING_LIST */ \n\n") : string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if document variable is null then the Siebel Adapter will ignore it. otherwise it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n        childPs.setType(\"Attachments\");\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n          try \n          {\n             InputStream is= temp.getfDocumentContent().getInputStream(); \n             if (is.available() > SiebelJCAAdapterBase.ATTACHMENT_MEMORY_MIN_THRESHOLD && is.available() < SiebelJCAAdapterBase.ATTACHMENT_MEMORY_MAX_THRESHOLD) \n             {\n                 ps.setStreamed();\n                 ps.setProperty(StreamConstants.IS_STREAMED_ATTACHMENT, \"true\");\n             }\n             else if(is.available() > SiebelJCAAdapterBase.ATTACHMENT_MEMORY_MAX_THRESHOLD) \n             {\n                 Error error = new Error(\"Threshold Exceeded Max Threshold value: \" + SiebelJCAAdapterBase.ATTACHMENT_MEMORY_MAX_THRESHOLD); \n                 throw error; \n             } \n          }\n          catch (IOException ioe)\n          {\n             SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \"SiebelPropertySet::toPropertySet\", \"IO Exception occured while converting Document Type to Siebel Property Set\" + ioe.getStackTrace());\n             //IDS_JCA_STREAM_ATTACHMENT_CONVERSION_ERR : Error encountered converting input attachments to SiebelPropertySet\n             //StreamingException ioste = new StreamingException (new CSSException (CSSConsts.IDS_JCA_STREAM_DECODE_ERR));\n             //throw ioste;\n          }\n          childPs.addChild(temp.toPropertySet());\n        }/* for */ \n        ps.addChild(childPs); \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                        string = string + "    ps.setProperty(\"__property_name__\", \"__variable__\");\n\n";
                        string = string.replace("__property_name__", "HasAttachment");
                        string = string.replace("__variable__", "true");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("IO")) {
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise  \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n\n          childPs.addChild(temp.toPropertySet());\n        }/* for */ \n\n        ps.addChild(childPs); \n\n");
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "  }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) { \n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__ temp = (__type__)  __variable__.get(i); \n\n          ps.addChild(temp.toPropertySet()); \n        }/* for */ \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                        continue;
                    }
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise  \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) { \n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        for(int i = 0; i < __variable__.size(); ++i) { \n          __type__ temp = (__type__)  __variable__.get(i);  \n\n          childPs.addChild(temp.toPropertySet());\n        }/* for */ \n\n        ps.addChild(childPs); \n\n");
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "  }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) { \n        for(int i = 0; i < __variable__.size(); ++i) {   \n          __type__ temp = (__type__)  __variable__.get(i); \n\n          ps.addChild(temp.toPropertySet()); \n        }/* for */ \n      }/* if */\n    }/* if USING_LIST */ \n\n");
                    continue;
                }
                string = declaration.IsIntCompType() && declaration.IsSingle() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(USING_LIST) { \n      /* \n       * if __variable__ is null then \n       *      the Siebel Adapter will ignore it.\n       * otherwise \n       *      it will attempt to sync it.\n       */\n      if(__variable__ != null) {\n        SiebelPropertySet childPs = new SiebelPropertySet(); \n\n        childPs.setType(\"ListOf__property_name__\");\n\n        childPs.addChild(__variable__.toPropertySet());\n\n        ps.addChild(childPs); \n      }/* if */\n    }else{       /* not using list */ \n      if(__variable__ != null) {\n        ps.addChild(__variable__.toPropertySet()); \n      }/* if */\n    }/* if USING_LIST */ \n\n") : (declaration.IsComplexType() ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) {  \n      SiebelPropertySet childPs = null; \n\n      try { \n        childPs = new SiebelPropertySet(__variable__.toPropertySet()); \n      }catch(SiebelException se) {\n        throw new IllegalArgumentException(se.getMessage());\n      }/* try-catch */\n\n      childPs.setType(\"__var_name__\"); \n      ps.addChild(childPs); \n    }/* if */ \n\n") : (declaration.GetType().equalsIgnoreCase("Hierarchy") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.addChild(__variable__.toPropertySet()); \n\n") : (declaration.GetProperty().equalsIgnoreCase("<value>") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setValue(__variable__); \n\n") : (declaration.GetType().equalsIgnoreCase("byte[]") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   {\n        short err = 0; /*No need to handle tht error since this a validation check.*/\n        if((fAttachmentIsTextData != null && fAttachmentIsTextData.equalsIgnoreCase(\"true\")) || \n           (!Base64.isBase64(new String(__variable__), err)))\n            ps.setByteValue(__variable__); \n        else \n            ps.setByteValue(Base64.decode(new String(__variable__))); \n    }\n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_INTEGER") || declaration.GetType().equalsIgnoreCase("DTYPE_NUMBER") || declaration.GetType().equalsIgnoreCase("DTYPE_CURRENCY") || declaration.GetType().equalsIgnoreCase("NUMBER") || declaration.GetType().equalsIgnoreCase("integer") || declaration.GetType().equalsIgnoreCase("decimal") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setProperty(\"__property_name__\", __variable__.toString()); \n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_BOOL") || declaration.GetType().equalsIgnoreCase("boolean") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setProperty(\"__property_name__\", (__variable__?\"Y\":\"N\")); \n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_DATE") || declaration.GetType().equalsIgnoreCase("DATE") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) { \n       DateFormat __variable__Format = new SimpleDateFormat(\"MM/dd/yyyy\");   \n       ps.setProperty(\"__property_name__\", __variable__Format.format(__variable__.getTime())); \n        } \n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_DATETIME") || declaration.GetType().equalsIgnoreCase("DTYPE_UTCDATETIME") || declaration.GetType().equalsIgnoreCase("dateTime") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) {  \n      DateFormat __variable__Format = new SimpleDateFormat(\"MM/dd/yyyy HH:mm:ss\");   \n      ps.setProperty(\"__property_name__\", __variable__Format.format(__variable__.getTime())); \n       } \n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_TIME") || declaration.GetType().equalsIgnoreCase("time") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null) { \n       DateFormat __variable__Format = new SimpleDateFormat(\"HH:mm:ss\");   \n       ps.setProperty(\"__property_name__\", __variable__Format.format(__variable__.getTime())); \n        } \n\n") : (declaration.GetType().equalsIgnoreCase("DataHandler") ? string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      setDataValue(ps, __variable__); \n\n") : string + this.ADD_FIELD_CODE_BODY(declaration, "    if(__variable__ != null)   \n      ps.setProperty(\"__property_name__\", __variable__); \n\n")))))))))));
            }
        }
        string = string + "    return ps;\n";
        string = string + "  }/* public SiebelPropertySet toPropertySet(...) */\n\n";
        return string;
    }

    protected String AddBckwrdCompatibleFromPSMethod() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        boolean bl = false;
        String string2 = "      SiebelException se = new SiebelException(__MODULE__, 100);  \n      se.setDetailMessage(\"Input PropertySet is not of type [\" + \n                            CLASS_PROPERTY + \"]\");   \n      throw se; \n";
        string2 = string2.replace("__MODULE__", "1000");
        if (this.m_class_declaration.isBModifyToFromPS()) {
            string = string + "  public void fromPropertySet(SiebelPropertySet propSet) throws SiebelException {\n      for(int k=0 ; k < propSet.getChildCount() ; k++)\n      {\n          SiebelPropertySet ps = propSet.getChild(k);\n          " + this.m_class_declaration.GetClassName() + " temp = new " + this.m_class_declaration.GetClassName() + "();\n" + "          if((! PS_TYPE_REQUIRED) || (ps.getType().equals(CLASS_PROPERTY))) { \n\n";
            String string3 = this.m_class_declaration.GetClassType();
            for (int i = 0; i < arrayList.size(); ++i) {
                Declaration declaration = arrayList.get(i);
                if (declaration.IsRepeated() || declaration.IsIntCompType() && declaration.IsSingle()) {
                    if (declaration.isBToBeAdded()) {
                        string = string + "            " + this.BeautifyVariableName(declaration.GetVariable()) + " = null;\n";
                    }
                    bl = true;
                    continue;
                }
                if (declaration.IsComplexType()) {
                    string = string + "      for(int i = 0; i < ps.getChildCount(); i++) {\n";
                    string = string + "        if(ps.getChild(i).getType().equals(\"" + declaration.GetProperty() + "\")) {\n";
                    string = string + "          " + this.BeautifyVariableName(declaration.GetVariable());
                    string = string + " = new ";
                    string = string + this.BeautifyClassName(declaration.GetType());
                    string = string + "(ps.getChild(i));\n";
                    string = string + "        }/* if */\n";
                    string = string + "      }/* for */\n";
                    continue;
                }
                if (declaration.GetType().equalsIgnoreCase("Hierarchy")) {
                    string = string + "      for(int i = 0; i < ps.getChildCount(); i++) {\n";
                    string = string + "        if(ps.getChild(i).getType().equals(\"" + declaration.GetProperty() + "\")) {\n";
                    string = string + "          " + this.BeautifyVariableName(declaration.GetVariable());
                    string = string + " = new SiebelHierarchyImpl(ps.getChild(i));\n";
                    string = string + "        }/* if */\n";
                    string = string + "      }/* for */\n";
                    continue;
                }
                if (declaration.GetProperty().equalsIgnoreCase("<value>")) {
                    string = string + "            temp." + this.BeautifyVariableName(declaration.GetVariable()) + " = ps.getValue();\n";
                    continue;
                }
                if (!declaration.isBToBeAdded()) continue;
                string = string + "            temp." + this.BeautifyVariableName(declaration.GetVariable()) + " = ps.getProperty(\"" + declaration.GetProperty() + "\");\n";
            }
            string = string + "\n";
            if (bl) {
                String string4 = "";
                boolean bl2 = false;
                string4 = string4 + "      for(int i = 0; i < ps.getChildCount(); ++i) {\n";
                string4 = string4 + "        SiebelPropertySet  childPs = ps.getChild(i);\n\n";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Declaration declaration = arrayList.get(i);
                    if (declaration.IsRepeated() && declaration.isBToBeAdded()) {
                        bl2 = true;
                        string4 = string4 + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n              __type__ tmp = new __type__(childPs); \n\n              setf__VARIABLE__(tmp);\n          }/* if */  \n        }else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n              __type__ tmp = new __type__(childPs);    \n\n              setf__VARIABLE__(tmp);\n          }/* if */ \n        }/* if */  \n\n");
                        continue;
                    }
                    if (!declaration.IsIntCompType() || !declaration.IsSingle()) continue;
                    bl2 = true;
                    string4 = string4 + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n            for(int j = 0; j < childPs.getChildCount(); ++j){   \n              if (__variable__ != null) { \n                SiebelException se = new SiebelException(1000, 101); \n                se.setDetailMessage(\"Cardinality constraint violated for [__property_name__]\");   \n                throw se; \n              } \n              __variable__ = new __type__(childPs.getChild(j)); \n            }/* for */ \n          }/* if */  \n        }");
                    string4 = string4 + this.ADD_FIELD_CODE_BODY(declaration, "else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n            if (__variable__ != null) { \n              SiebelException se = new SiebelException(1000, 101); \n              se.setDetailMessage(\"Cardinality constraint violated for [__property_name__]\");   \n              throw se; \n            } \n            __variable__ = new __type__(childPs); \n          }/* if */ \n        }/* if */  \n\n");
                }
                string4 = string4 + "      }/* for */\n";
                if (bl2) {
                    string = string + string4;
                }
                string = string + "            setf" + this.m_class_declaration.GetClassName() + "(temp);\n\n";
            }
            string = string + "    } \n";
            string = string + "    else {\n";
            string = string + string2;
            string = string + "    }/* if */\n";
            string = string + "     }\n\n";
            string = string + "}/* public void fromPropertySet(...) */\n\n";
        } else {
            Declaration declaration;
            int n;
            string2 = "      SiebelException se = new SiebelException(__MODULE__, 100);  \n      se.setDetailMessage(\"Input PropertySet is not of type [\" + \n                            CLASS_PROPERTY + \"]\");   \n      throw se; \n";
            string2 = string2.replace("__MODULE__", "1000");
            string = string + "  public void fromPropertySet(SiebelPropertySet ps) throws SiebelException {\n";
            string = string + "    if((! PS_TYPE_REQUIRED) || (ps.getType().equals(CLASS_PROPERTY))) {\n";
            String string5 = this.m_class_declaration.GetClassType();
            for (n = 0; n < arrayList.size(); ++n) {
                declaration = arrayList.get(n);
                if (declaration.IsRepeated() || declaration.IsIntCompType() && declaration.IsSingle()) {
                    if (declaration.isBToBeAdded()) {
                        string = string + "      " + this.BeautifyVariableName(declaration.GetVariable()) + " = null;\n";
                    }
                    bl = true;
                    continue;
                }
                if (declaration.IsComplexType()) {
                    string = string + "      for(int i = 0; i < ps.getChildCount(); i++) {\n";
                    string = string + "        if(ps.getChild(i).getType().equals(\"" + declaration.GetProperty() + "\")) {\n";
                    string = string + "          " + this.BeautifyVariableName(declaration.GetVariable());
                    string = string + " = new ";
                    string = string + this.BeautifyClassName(declaration.GetType());
                    string = string + "(ps.getChild(i));\n";
                    string = string + "        }/* if */\n";
                    string = string + "      }/* for */\n";
                    continue;
                }
                if (declaration.GetType().equalsIgnoreCase("Hierarchy")) {
                    string = string + "      for(int i = 0; i < ps.getChildCount(); i++) {\n";
                    string = string + "        if(ps.getChild(i).getType().equals(\"" + declaration.GetProperty() + "\")) {\n";
                    string = string + "          " + this.BeautifyVariableName(declaration.GetVariable());
                    string = string + " = new SiebelHierarchyImpl(ps.getChild(i));\n";
                    string = string + "        }/* if */\n";
                    string = string + "      }/* for */\n";
                    continue;
                }
                if (declaration.GetProperty().equalsIgnoreCase("<value>")) {
                    string = string + "            " + this.BeautifyVariableName(declaration.GetVariable()) + " = ps.getValue();\n";
                    continue;
                }
                if (!declaration.isBToBeAdded()) continue;
                string = string + "            " + this.BeautifyVariableName(declaration.GetVariable()) + " = ps.getProperty(\"" + declaration.GetProperty() + "\");\n";
            }
            string = string + "\n";
            if (bl) {
                string = string + "      for(int i = 0; i < ps.getChildCount(); ++i) {\n";
                string = string + "        SiebelPropertySet  childPs = ps.getChild(i);\n\n";
                for (n = 0; n < arrayList.size(); ++n) {
                    declaration = arrayList.get(n);
                    if (declaration.IsRepeated()) {
                        if (declaration.isBToBeAdded() && declaration.isBSiebMsgArg()) {
                            string = string + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n            for(int j = 0; j < childPs.getChildCount(); ++j){   \n              __type__ tmp = new __type__(childPs.getChild(j)); \n\n              setf__VARIABLE__(tmp);\n            }/* for */ \n          }/* if */  \n        }else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n              __type__ tmp = new __type__(childPs);    \n\n              setf__VARIABLE__(tmp);\n          }/* if */ \n        }/* if */  \n\n");
                            continue;
                        }
                        if (!declaration.isBToBeAdded() || declaration.isBSiebMsgArg()) continue;
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n              __type__ tmp = new __type__(childPs); \n\n              setf__VARIABLE__(tmp);\n          }/* if */  \n        }else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n              __type__ tmp = new __type__(childPs);    \n\n              setf__VARIABLE__(tmp);\n          }/* if */ \n        }/* if */  \n\n");
                        continue;
                    }
                    if (!declaration.IsIntCompType() || !declaration.IsSingle()) continue;
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n            for(int j = 0; j < childPs.getChildCount(); ++j){   \n              if (__variable__ != null) { \n                SiebelException se = new SiebelException(1000, 101); \n                se.setDetailMessage(\"Cardinality constraint violated for [__property_name__]\");   \n                throw se; \n              } \n              __variable__ = new __type__(childPs.getChild(j)); \n            }/* for */ \n          }/* if */  \n        }");
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n            if (__variable__ != null) { \n              SiebelException se = new SiebelException(1000, 101); \n              se.setDetailMessage(\"Cardinality constraint violated for [__property_name__]\");   \n              throw se; \n            } \n            __variable__ = new __type__(childPs); \n          }/* if */ \n        }/* if */  \n\n");
                }
                string = string + "      }/* for */\n";
            }
            string = string + "    } \n";
            string = string + "    else {\n";
            string = string + string2;
            string = string + "    }/* if */\n  }/* public void fromPropertySet(...) */\n\n";
        }
        return string;
    }

    protected String AddFromPropertySetMethod() {
        Declaration declaration;
        int n;
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        boolean bl = false;
        String string2 = "      SiebelException se = new SiebelException(__MODULE__, 100);  \n      se.setDetailMessage(\"Input PropertySet is not of type [\" + \n                            CLASS_PROPERTY + \"]\");   \n      throw se; \n";
        string2 = string2.replace("__MODULE__", "1000");
        string = string + "  public void fromPropertySet(SiebelPropertySet ps) throws SiebelException {\n";
        string = string + "    if((! PS_TYPE_REQUIRED) || (ps.getType().equals(CLASS_PROPERTY))) {\n";
        String string3 = this.m_class_declaration.GetClassType();
        for (n = 0; n < arrayList.size(); ++n) {
            declaration = arrayList.get(n);
            if (declaration.IsRepeated() || declaration.IsIntCompType() && declaration.IsSingle()) {
                string = string + "      " + this.BeautifyVariableName(declaration.GetVariable()) + " = null;\n";
                bl = true;
                continue;
            }
            if (declaration.IsComplexType()) {
                string = string + "      for(int i = 0; i < ps.getChildCount(); i++) {\n";
                string = string + "        if(ps.getChild(i).getType().equals(\"" + declaration.GetProperty() + "\")) {\n";
                string = string + "          " + this.BeautifyVariableName(declaration.GetVariable());
                string = string + " = new ";
                string = string + this.BeautifyClassName(declaration.GetType());
                string = string + "(ps.getChild(i));\n";
                string = string + "        }/* if */\n";
                string = string + "      }/* for */\n";
                continue;
            }
            if (declaration.GetType().equalsIgnoreCase("Hierarchy")) {
                string = string + "      for(int i = 0; i < ps.getChildCount(); i++) {\n";
                string = string + "        if(ps.getChild(i).getType().equals(\"" + declaration.GetProperty() + "\")) {\n";
                string = string + "          " + this.BeautifyVariableName(declaration.GetVariable());
                string = string + " = new SiebelHierarchyImpl(ps.getChild(i));\n";
                string = string + "        }/* if */\n";
                string = string + "      }/* for */\n";
                continue;
            }
            string = declaration.GetProperty().equalsIgnoreCase("<value>") ? string + "      " + this.BeautifyVariableName(declaration.GetVariable()) + " = ps.getValue();\n" : (declaration.GetType().equalsIgnoreCase("byte[]") ? string + this.ADD_FIELD_CODE_BODY(declaration, "      __variable__ = ps.getByteValue();\n      if(__variable__ == null) { \n           if(ps.getFileReference() != null) {\n                try {\n                     File fs = new File(ps.getFileReference());\n                     BufferedInputStream is = new BufferedInputStream(new FileInputStream(fs));\n                     long length = fs.length();\n                     if (length > Integer.MAX_VALUE) {\n                          SiebelTrace.getInstance().trace (null, SiebelTraceLevel.LOG_ERROR, \n                            \"Document::fromPropertySet\", \n                            CSSMsgMgr.get(CSSConsts.IDS_REST_STREAM_FILE_LENGTH_ERR, fs.getName())); \n                          throw new IOException(CSSMsgMgr.get(CSSConsts.IDS_REST_STREAM_FILE_LENGTH_ERR, \n                                    fs.getName()));\n                     }\n                     byte[] bytes = new byte[(int)length];\n                     int offset = 0;\n                     int numRead = 0;\n                     while((numRead = is.read(bytes)) > 0) {\n                          offset += numRead;\n                     }\n\n                     if ( offset < bytes.length ) { \n                          SiebelTrace.getInstance().trace (null, SiebelTraceLevel.LOG_ERROR, \n                            \"Document::fromPropertySet\", \n                            CSSMsgMgr.get(CSSConsts.IDS_REST_STREAM_FILE_READ_ERR, fs.getName())); \n                          throw new IOException(CSSMsgMgr.get(CSSConsts.IDS_REST_STREAM_FILE_READ_ERR, \n                                    fs.getName()));\n                     } \n                     is.close(); \n                     __variable__ = bytes; \n                }\n                catch( IOException ioe) {\n                     SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \n                       \"Document::fromPropertySet\", \n                       CSSMsgMgr.get(CSSConsts.IDS_JCA_STREAM_DECODE_ERR)); \n\n                     SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \n                       \"IO Exception : \", ioe.getMessage());\n                }\n           }\n           else if ( ps.getValue() != null ) {\n                __variable__ = ps.getValue().getBytes();\n           }\n      }") : (declaration.GetType().equalsIgnoreCase("DTYPE_INTEGER") || declaration.GetType().equalsIgnoreCase("integer") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n      if( (ps.getProperty(\"__property_name__\") != null ) && (! ps.getProperty(\"__property_name__\").equals(\"\")) )\n          __variable__ = Integer.parseInt(ps.getProperty(\"__property_name__\"));\n      else \n          __variable__  = null;\n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_NUMBER") || declaration.GetType().equalsIgnoreCase("DTYPE_CURRENCY") || declaration.GetType().equalsIgnoreCase("NUMBER") || declaration.GetType().equalsIgnoreCase("decimal") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n      if( (ps.getProperty(\"__property_name__\") != null ) && (! ps.getProperty(\"__property_name__\").equals(\"\")) )\n          __variable__ = new BigDecimal(ps.getProperty(\"__property_name__\"));\n      else \n          __variable__  = null;\n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_BOOL") || declaration.GetType().equalsIgnoreCase("boolean") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n      if( (ps.getProperty(\"__property_name__\") != null ) && (ps.getProperty(\"__property_name__\").equals(\"Y\")) )\n         __variable__ = true;\n      else\n         __variable__  = false;\n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_DATE") || declaration.GetType().equalsIgnoreCase("DATE") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n\n        try \n        {\n           DateFormat  __variable__Format = new SimpleDateFormat(\"MM/dd/yyyy\");\n           if( (ps.getProperty(\"__property_name__\") != null ) && (! ps.getProperty(\"__property_name__\").equals(\"\")) )\n           {\n               __variable__ = new GregorianCalendar();\n               __variable__.setTime(__variable__Format.parse(ps.getProperty(\"__property_name__\")));\n           }\n        }\n        catch(Exception e)\n        {\n            SiebelException ex = new SiebelException();\n            ex.setDetailMessage(e.getMessage());\n            throw ex;\n        }\n\n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_DATETIME") || declaration.GetType().equalsIgnoreCase("DTYPE_UTCDATETIME") || declaration.GetType().equalsIgnoreCase("dateTime") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n\n        try \n        {\n           DateFormat  __variable__Format = new SimpleDateFormat(\"MM/dd/yyyy HH:mm:ss\");\n           if( (ps.getProperty(\"__property_name__\") != null ) && (! ps.getProperty(\"__property_name__\").equals(\"\")) )\n           {\n               __variable__ = new GregorianCalendar();\n               __variable__.setTime(__variable__Format.parse(ps.getProperty(\"__property_name__\")));\n           }\n        }\n        catch(Exception e)\n        {\n            SiebelException ex = new SiebelException();\n            ex.setDetailMessage(e.getMessage());\n            throw ex;\n        }\n\n\n") : (declaration.GetType().equalsIgnoreCase("DTYPE_TIME") || declaration.GetType().equalsIgnoreCase("time") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n\n        try \n        {\n           DateFormat  __variable__Format = new SimpleDateFormat(\"HH:mm:ss\");\n           if( (ps.getProperty(\"__property_name__\") != null ) && (! ps.getProperty(\"__property_name__\").equals(\"\")) )\n           {\n               __variable__ = new GregorianCalendar();\n               __variable__.setTime(__variable__Format.parse(ps.getProperty(\"__property_name__\")));\n           }\n        }\n        catch(Exception e)\n        {\n            SiebelException ex = new SiebelException();\n            ex.setDetailMessage(e.getMessage());\n            throw ex;\n        }\n\n\n") : (declaration.GetType().equalsIgnoreCase("DataHandler") ? string + this.ADD_FIELD_CODE_BODY(declaration, "\n      if (ps.isFileReference())\n      {\n          String fName = ps.getFileReference();\n          DataSource fileSource = new FileDataSource(fName);\n          fDocumentContent = new DataHandler(fileSource);\n      }\n      else\n      {\n          byte[] byteValue   = ps.getByteValue();\n          String contentType = \"application/octet-stream\";\n          DataSource byteArraySource = new ByteArrayDataSource(byteValue, contentType);\n          fDocumentContent = new DataHandler(byteArraySource);\n      }\n") : string + "      " + this.BeautifyVariableName(declaration.GetVariable()) + " = ps.getProperty(\"" + declaration.GetProperty() + "\");\n"))))))));
        }
        string = string + "\n";
        if (bl) {
            string = string + "      for(int i = 0; i < ps.getChildCount(); ++i) {\n";
            string = string + "        SiebelPropertySet  childPs = ps.getChild(i);\n\n";
            for (n = 0; n < arrayList.size(); ++n) {
                declaration = arrayList.get(n);
                if (declaration.IsRepeated()) {
                    if (declaration.isDoc_Content()) {
                        string = string + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"Attachments\")) { \n            for(int j = 0; j < childPs.getChildCount(); ++j){   \n              __type__ tmp = new __type__(childPs.getChild(j)); \n              setfDocument(tmp);\n            }/* for */ \n          }/* if */  \n        }");
                        continue;
                    }
                    string = string + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n            for(int j = 0; j < childPs.getChildCount(); ++j){   \n              __type__ tmp = new __type__(childPs.getChild(j)); \n\n              setf__VARIABLE__(tmp);\n            }/* for */ \n          }/* if */  \n        }else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n              __type__ tmp = new __type__(childPs);    \n\n              setf__VARIABLE__(tmp);\n          }/* if */ \n        }/* if */  \n\n");
                    continue;
                }
                if (!declaration.IsIntCompType() || !declaration.IsSingle()) continue;
                string = string + this.ADD_FIELD_CODE_BODY(declaration, "        if(USING_LIST) {  \n          if(childPs.getType().equals(\"ListOf__property_name__\")) { \n            for(int j = 0; j < childPs.getChildCount(); ++j){   \n              if (__variable__ != null) { \n                SiebelException se = new SiebelException(1000, 101); \n                se.setDetailMessage(\"Cardinality constraint violated for [__property_name__]\");   \n                throw se; \n              } \n              __variable__ = new __type__(childPs.getChild(j)); \n            }/* for */ \n          }/* if */  \n        }");
                string = string + this.ADD_FIELD_CODE_BODY(declaration, "else{   /* not using list */ \n          if(childPs.getType().equals(\"__property_name__\")) { \n            if (__variable__ != null) { \n              SiebelException se = new SiebelException(1000, 101); \n              se.setDetailMessage(\"Cardinality constraint violated for [__property_name__]\");   \n              throw se; \n            } \n            __variable__ = new __type__(childPs); \n          }/* if */ \n        }/* if */  \n\n");
            }
            string = string + "      }/* for */\n";
        }
        string = string + "    } \n";
        string = string + "    else {\n";
        string = string + string2;
        string = string + "    }/* if */\n  }/* public void fromPropertySet(...) */\n\n";
        return string;
    }

    protected String AddUserDefinedMethods() {
        String string = "";
        ArrayList<MethodDeclaration> arrayList = this.m_class_declaration.GetMethodArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodDeclaration methodDeclaration = arrayList.get(i);
            ArrayList<Declaration> arrayList2 = methodDeclaration.GetArgumentArray();
            String string2 = "void";
            if (arrayList2.size() > 0) {
                Declaration declaration = arrayList2.get(0);
                string2 = declaration.GetVariable();
            }
            string = methodDeclaration.GetReturnType().GetType().equalsIgnoreCase("void") ? string + this.ADD_METHOD_CODE_BODY(methodDeclaration, string2, "  /* __comment__ */ \n  __access__ __METHOD__ {  \n    __FAKE_INPUT_PARAM__ \n    invoke(\"__property_name__\", input.toPropertySet()); \n  }/* __access__ void __method__(...) */ \n\n") : string + this.ADD_METHOD_CODE_BODY(methodDeclaration, string2, "  /* __comment__ */  \n  __access__ __METHOD__ {     \n    __FAKE_INPUT_PARAM__ \n    return (new __type__(invoke(\"__property_name__\", input.toPropertySet()))); \n  }/* __access__ __type__ __method__(...) */   \n\n");
        }
        return string;
    }

    protected String AddsetDataValueMethod() {
        String string = "";
        string = string + "  private static void setDataValue(SiebelPropertySet ps, DataHandler dh) {\n";
        string = string + "    InputStream inStream = null;\n";
        string = string + "    File attFile = null;\n";
        string = string + "    BufferedOutputStream bufOutStream = null;\n";
        string = string + "    boolean bFNFErr = false;\n";
        string = string + "    boolean bIOErr = false;\n";
        string = string + "    Throwable aThrowable;\n\n";
        string = string + "    if (dh == null)\n";
        string = string + "      return;   //Do nothing\n\n";
        string = string + "    try {\n";
        string = string + "      inStream = dh.getInputStream();\n";
        string = string + "      if (ps.isStreamed()) {\n";
        string = string + "        String attFileRef = ps.getProperty(\"ContentId\");\n";
        string = string + "        FileManager fileMgr = new FileManager();\n";
        string = string + "        try {\n";
        string = string + "          attFile = fileMgr.createTempFile(attFileRef, \".tmp\");\n";
        string = string + "          bufOutStream = new BufferedOutputStream(new FileOutputStream(attFile));\n";
        string = string + "          dh.writeTo(bufOutStream);\n";
        string = string + "          bufOutStream.flush();\n";
        string = string + "          bufOutStream.close();\n";
        string = string + "        }\n";
        string = string + "        catch (FileNotFoundException fnfe) {\n";
        string = string + "          bFNFErr = true;\n";
        string = string + "          aThrowable = fnfe.fillInStackTrace();\n";
        string = string + "          SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \"CodeFilterConstants::setDataValue\",\n";
        string = string + "            CSSMsgMgr.get(CSSConsts.IDS_JCA_STREAM_FILE_NOT_FOUND_ERR) + ps.getStackTrace(aThrowable));\n";
        string = string + "          StreamingException fnfste = new StreamingException(new CSSException(CSSConsts.IDS_JCA_STREAM_FILE_NOT_FOUND_ERR));\n";
        string = string + "          //throw fnfste;\n";
        string = string + "        }\n";
        string = string + "        ps.setFileReference(attFile.getAbsolutePath());\n";
        string = string + "      }\n";
        string = string + "      else {\n";
        string = string + "        // not streamed\n";
        string = string + "        byte[] buf = new byte[inStream.available()];\n";
        string = string + "        inStream.read(buf, 0, buf.length);\n";
        string = string + "        ps.setByteValue(buf);\n";
        string = string + "      }\n";
        string = string + "    }\n";
        string = string + "    catch (IOException e) { \n";
        string = string + "      bIOErr = true;\n";
        string = string + "      aThrowable = e.fillInStackTrace();\n";
        string = string + "      SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \"CodeFilterConstants::setDataValue\", \"IO Exception occured while Streaming data in DataHandler to Attachment File Reference \" + attFile.getAbsolutePath()\n";
        string = string + "        + ps.getStackTrace(aThrowable));\n";
        string = string + "      StreamingException ioste = new StreamingException (new CSSException (CSSConsts.IDS_JCA_STREAM_ATTACHMENT_CONVERSION_ERR));\n";
        string = string + "      //throw ioste;\n";
        string = string + "    }\n";
        string = string + "    finally  {\n";
        string = string + "      if ((bFNFErr || bIOErr) && attFile != null) {\n";
        string = string + "        try {\n";
        string = string + "          attFile.delete();\n";
        string = string + "        }\n";
        string = string + "        catch (SecurityException se) {\n";
        string = string + "          SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \"CodeFilterConstants::setDataValue\", CSSMsgMgr.get(CSSConsts.IDS_JCA_STREAM_FILE_DELETE_ERR));\n";
        string = string + "          StreamingException stre = new StreamingException (new CSSException (CSSConsts.IDS_JCA_STREAM_FILE_DELETE_ERR));\n";
        string = string + "          // throw stre;\n";
        string = string + "        }\n";
        string = string + "      }\n";
        string = string + "    }\n";
        string = string + "  }\n\n";
        return string;
    }

    protected String GetUserDefinedMethodDeclaration(MethodDeclaration methodDeclaration) {
        String string = "";
        ArrayList<Declaration> arrayList = methodDeclaration.GetArgumentArray();
        string = string + this.BeautifyClassName(methodDeclaration.GetReturnType().GetType());
        string = string + " ";
        string = string + this.BeautifyMethodName(methodDeclaration.GetMethodName());
        string = string + "( ";
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            if (i > 0) {
                string = string + ", ";
            }
            if (declaration.GetVariable().equalsIgnoreCase("void")) continue;
            string = string + this.BeautifyClassName(declaration.GetVariable());
            string = string + "  input";
        }
        string = string + " ) throws SiebelException ";
        return string;
    }

    protected String AddFields() {
        String string = "";
        ArrayList<Declaration> arrayList = this.m_class_declaration.GetFieldArray();
        if (arrayList.size() > 0) {
            string = string + "  /* member variables */\n";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2;
                Declaration declaration = arrayList.get(i);
                if (declaration.IsRepeated()) {
                    if (declaration.GetAccess().equals((Object)AccessRights.PUBLIC_ACCESS)) {
                        string2 = declaration.GetVariable();
                        String string3 = "";
                        if (declaration.IsIntCompType() && string2.length() - 2 == string2.lastIndexOf("IC")) {
                            string2 = string2.substring(0, string2.length() - 2);
                        }
                        if (this.m_backwardCompatibilityMode) {
                            if (declaration.isBListOf()) {
                                string2 = "ListOf" + string2;
                            }
                            if (this.m_module != null && this.m_module.equals("BS")) {
                                if (declaration.isBSiebMsgArg()) {
                                    string3 = "http://www.siebel.com/xml/";
                                    string3 = declaration.getSiebMsgArgName() != null ? string3 + declaration.getSiebMsgArgName().trim().replaceAll("\\s", "%20") : string3 + declaration.getSiebMsgArgName();
                                    string2 = declaration.getXmlTagName();
                                } else {
                                    string3 = this.m_busSvcNamespace != null ? this.m_busSvcNamespace.trim().replaceAll("\\s", "%20") : this.m_busSvcNamespace;
                                }
                            } else if (this.m_module != null && this.m_module.equals("IO")) {
                                string3 = "http://www.siebel.com/xml/";
                                string3 = this.m_intObjName != null ? string3 + this.m_intObjName.trim().replaceAll("\\s", "%20") : string3 + this.m_intObjName;
                            }
                        }
                        string = this.m_backwardCompatibilityMode ? string + "  @XmlElement(nillable = true , namespace = \"" + string3 + "\" , name = \"" + this.BeautifyClassNameForMigration(string2) + "\")\n" : string + "  @XmlElement(nillable = true , namespace = \"" + string3 + "\" , name = \"" + this.BeautifyVariableNameWithoutToken(string2) + "\")\n";
                    }
                    string = string + "  protected ArrayList <" + declaration.GetType() + ">  " + this.BeautifyVariableName(declaration.GetVariable()) + " = null;\n";
                    continue;
                }
                if (declaration.GetValue() != null && !declaration.GetValue().equals("")) {
                    if (declaration.GetType().equalsIgnoreCase("byte[]")) {
                        string = string + "  @XmlMimeType(\"application/octet-stream\")\n";
                    }
                    if (declaration.GetValue().length() > 65535) {
                        string2 = declaration.GetValue();
                        int n = 0;
                        int n2 = 65535;
                        int n3 = 0;
                        int n4 = declaration.GetValue().length() / 65535;
                        while (n < string2.length()) {
                            if (string2.charAt(n2 - 1) == '\\') {
                                --n2;
                            }
                            String string4 = string2.substring(n, n2);
                            string = string + "  protected " + this.BeautifyClassName(declaration.GetType()) + " " + this.BeautifyVariableName(declaration.GetVariable()) + n3;
                            string = n3 == 0 ? string + " = " + string4 + "\";\n" : (n4 > 0 ? string + " = \"" + string4 + "\";\n" : string + " = \"" + string4 + ";\n");
                            --n4;
                            ++n3;
                            n = n2;
                            int n5 = string2.length() - n2;
                            if (n5 < 65535) {
                                n2 += n5;
                                continue;
                            }
                            n2 += 65535;
                        }
                        string = string + "  protected " + this.BeautifyClassName(declaration.GetType()) + "  " + this.BeautifyVariableName(declaration.GetVariable()) + " = ";
                        for (int j = 0; j < n3; ++j) {
                            if (j > 0) {
                                string = string + " + ";
                            }
                            string = string + this.BeautifyVariableName(declaration.GetVariable()) + j;
                        }
                        string = string + ";\n";
                        continue;
                    }
                    string = string + "  protected " + this.BeautifyClassName(declaration.GetType()) + "  " + this.BeautifyVariableName(declaration.GetVariable()) + " = " + declaration.GetValue() + ";\n";
                    continue;
                }
                if (declaration.GetType().equalsIgnoreCase("byte[]")) {
                    if (declaration.GetAccess().equals((Object)AccessRights.PUBLIC_ACCESS)) {
                        string = string + "@XmlElement(namespace=\"\", name=\"" + this.BeautifyVariableNameWithoutToken(declaration.GetVariable()) + "\")\n";
                    }
                    string = string + "  @XmlMimeType(\"application/octet-stream\")\n";
                }
                string = string + "  protected " + this.BeautifyClassName(declaration.GetType()) + "  " + this.BeautifyVariableName(declaration.GetVariable()) + " = null;\n";
            }
        }
        return string;
    }

    @Override
    protected String BeautifyClassName(String string) {
        String string2 = super.BeautifyClassName(string);
        if (!this.m_backwardCompatibilityMode) {
            if (string2.equalsIgnoreCase("Hierarchy")) {
                string2 = "SiebelHierarchy";
            } else if (string2.equalsIgnoreCase("Void")) {
                string2 = "void";
            } else if (string2.equalsIgnoreCase("DATE")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("NUMBER")) {
                string2 = "BigDecimal";
            } else if (string2.equalsIgnoreCase("STRING")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_ATTACHMENT")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_CURRENCY")) {
                string2 = "BigDecimal";
            } else if (string2.equalsIgnoreCase("DTYPE_DATETIME")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("DTYPE_DATE")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("DTYPE_UTCDATETIME")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("DTYPE_NOTE")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_PHONE")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_TEXT")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_ID")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_INTEGER")) {
                string2 = "Integer";
            } else if (string2.equalsIgnoreCase("DTYPE_NUMBER")) {
                string2 = "BigDecimal";
            } else if (string2.equalsIgnoreCase("DTYPE_BOOL")) {
                string2 = "Boolean";
            } else if (string2.equalsIgnoreCase("DTYPE_TIME")) {
                string2 = "GregorianCalendar";
            } else if (string2.startsWith("DATATYPE_")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("dateTime")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("date")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("time")) {
                string2 = "GregorianCalendar";
            } else if (string2.equalsIgnoreCase("boolean")) {
                string2 = "Boolean";
            } else if (string2.equalsIgnoreCase("integer")) {
                string2 = "Integer";
            } else if (string2.equalsIgnoreCase("decimal")) {
                string2 = "BigDecimal";
            }
        } else if (this.m_backwardCompatibilityMode) {
            if (string2.equalsIgnoreCase("Hierarchy")) {
                string2 = "SiebelHierarchy";
            } else if (string2.equalsIgnoreCase("Void")) {
                string2 = "void";
            } else if (string2.equalsIgnoreCase("DATE")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("NUMBER")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("STRING")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_ATTACHMENT")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_CURRENCY")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_DATETIME")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_DATE")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_UTCDATETIME")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_NOTE")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_PHONE")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_TEXT")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_ID")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_INTEGER")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_NUMBER")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_BOOL")) {
                string2 = "String";
            } else if (string2.equalsIgnoreCase("DTYPE_TIME")) {
                string2 = "String";
            } else if (string2.startsWith("DATATYPE_")) {
                string2 = "String";
            }
        }
        return string2;
    }

    protected String ADD_FIELD_CODE_BODY(Declaration declaration, String string) {
        String string2 = string;
        string2 = string2.replace("__var_name__", declaration.GetVariable());
        string2 = string2.replace("__type__", this.BeautifyClassName(declaration.GetType()));
        string2 = string2.replace("__variable__", this.BeautifyVariableName(declaration.GetVariable()));
        string2 = string2.replace("__VARIABLE__", this.BeautifyClassName(declaration.GetVariable()));
        string2 = string2.replace("__TYPE__", this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        string2 = string2.replace("__property_name__", declaration.GetProperty());
        string2 = string2.replace("__access__", this.AccessToString(declaration.GetAccess()));
        return string2;
    }

    protected String ADD_METHOD_CODE_BODY(MethodDeclaration methodDeclaration, String string, String string2) {
        String string3 = string2;
        string3 = string.equalsIgnoreCase("void") ? string3.replace("__FAKE_INPUT_PARAM__", "SiebelHierarchy    input              = new SiebelHierarchyImpl();") : string3.replace("__FAKE_INPUT_PARAM__", "");
        string3 = string3.replace("__type__", this.BeautifyClassName(methodDeclaration.GetReturnType().GetType()));
        string3 = string3.replace("__METHOD__", this.GetUserDefinedMethodDeclaration(methodDeclaration));
        string3 = string3.replace("__method__", this.BeautifyMethodName(methodDeclaration.GetMethodName()));
        string3 = string3.replace("__comment__", methodDeclaration.GetComment());
        string3 = string3.replace("__output__", this.BeautifyMethodName(methodDeclaration.GetReturnType().GetType()));
        string3 = string3.replace("__property_name__", methodDeclaration.GetProperty());
        string3 = string3.replace("__access__", this.AccessToString(methodDeclaration.GetAccess()));
        return string3;
    }
}

