/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.codegen;

import com.siebel.integration.codegen.ClassDeclaration;
import com.siebel.integration.codegen.CodeFilter;
import com.siebel.integration.codegen.Declaration;
import com.siebel.integration.codegen.MethodDeclaration;
import java.util.ArrayList;
import java.util.Calendar;

public class WrapperCodeFilter
extends CodeFilter {
    private String m_targetNamespace;
    private String m_soapVersion = "1.1";

    public WrapperCodeFilter(ClassDeclaration classDeclaration) {
        super(classDeclaration);
        this.m_targetNamespace = "http://siebel.com/";
    }

    public WrapperCodeFilter() {
        this.m_targetNamespace = "http://siebel.com/";
    }

    public WrapperCodeFilter(ClassDeclaration classDeclaration, String string) {
        super(classDeclaration);
        this.m_targetNamespace = string;
    }

    public String GenerateCode(String string, String string2, String string3, String string4) {
        String string5 = "";
        Calendar calendar = Calendar.getInstance();
        String string6 = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
        if (string.equalsIgnoreCase("Wrapper")) {
            string5 = "com.siebel.service.jca.p";
        }
        String string7 = "package __PACKAGE____package__;\n\n\n/* \n * -- AUTOMATICALLY GENERATED FROM SIEBEL SAI Wizard -- \n * Copyright (C) Oracle Corporation 2010. All rights reserved. \n * \n * MODIFICATION OR EXTENSION OF THIS CODE SHALL VOID ANY APPLICABLE \n * WARRANTIES AND MAINTENANCE SUPPORT.\n * \n * Generated from Siebel SAI Code Generator \n * Generated Date  : __date__ \n */\n\n";
        String string8 = "\n /* import classes we need. */ \nimport javax.jws.WebMethod;  \nimport javax.jws.WebParam; \nimport javax.jws.WebService; \nimport javax.xml.ws.*; \n \nimport javax.jws.soap.SOAPBinding; \nimport javax.naming.NamingException; \nimport com.siebel.data.SiebelException; \nimport com.siebel.integration.jca.cci.SiebelConnectionFactory; \nimport com.siebel.integration.jca.cci.notx.SiebelNoTxConnectionFactory; \nimport com.siebel.integration.jca.spi.notx.SiebelNoTxManagedConnectionFactory; \nimport com.siebel.integration.adapter.JCACommon; \nimport com.siebel.integration.util.SiebelTrace; \nimport com.siebel.integration.util.SiebelTraceLevel;\nimport com.sun.xml.ws.api.message.Header; \nimport com.sun.xml.ws.api.message.HeaderList; \nimport com.sun.xml.ws.developer.JAXWSProperties; \nimport javax.jws.HandlerChain; \nimport javax.annotation.Resource; \nimport javax.xml.ws.soap.MTOM; \nimport javax.jws.WebResult;\nimport javax.xml.ws.handler.MessageContext; ";
        string7 = string7 + string8;
        if (this.m_class_declaration.GetAttachmentStatus()) {
            string7 = string7 + "\nimport javax.xml.ws.soap.MTOM;";
        }
        string7 = string7 + "\n\n\n/** \n * __COMMENT__ \n * \n * Generated from Siebel SAI Code Generator \n **/ \n\n";
        this.m_class_declaration.SetNamespace(this.BeautifyClassName(string3) + "." + string5 + this.BeautifyNamespace(string2));
        this.m_class_declaration.SetClassName(this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        string7 = string7.replace("__PACKAGE__", string5);
        string7 = string7.replace("__package__", this.BeautifyNamespace(string2));
        string7 = string7.replace("__COMMENT__", this.m_class_declaration.GetComment());
        string7 = string7.replace("__date__", string6);
        string7 = string7 + this.AddWebServiceAnnotations();
        int n = this.m_class_declaration.GetClassName().indexOf("Wrapper");
        String string9 = this.m_class_declaration.GetClassName().substring(0, n);
        if (string9.length() > 0) {
            string7 = string7.replace("__SERVICE__", string9);
        }
        string7 = string7.replace("__STYLE__", string4.toUpperCase());
        string7 = string7 + this.SetSoapVersion();
        string7 = string7 + "@HandlerChain(file = \"handlers.xml\") \n@MTOM\n";
        string7 = string7 + this.AddClassDefinition();
        string7 = string7 + "}";
        return string7;
    }

    protected String SetSoapVersion() {
        String string = "";
        if (this.m_soapVersion.equalsIgnoreCase("1.2")) {
            string = "@BindingType(javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)\n";
        }
        return string;
    }

    public String generateHandler(boolean bl) {
        String string = "<handler-chains xmlns=\"http://java.sun.com/xml/ns/javaee\">\n   <handler-chain>\n      <service-name-pattern xmlns:ns1=\"TARGETNS\">ns1:BSNAMEService</service-name-pattern>\n      <handler>\n         <handler-name>WLS</handler-name>\n         <handler-class>com.siebel.integration.adapter.SessionTokenHandler</handler-class>\n         <soap-role>COMPATIBILITYMODE</soap-role>\n      </handler>\n   </handler-chain>\n</handler-chains>\n";
        int n = this.m_class_declaration.GetClassName().indexOf("Wrapper");
        String string2 = this.m_class_declaration.GetClassName().substring(0, n);
        string = string.replaceAll("TARGETNS", this.m_targetNamespace);
        string = string.replaceAll("BSNAME", string2);
        string = bl ? string.replaceAll("COMPATIBILITYMODE", "SiebelEAI") : string.replaceAll("COMPATIBILITYMODE", "SiebelFusionEAI");
        return string;
    }

    protected String AddConstructor() {
        String string = " \n    /* default constructor */ \n    public __TYPE__() \n    { \n    }/* public __TYPE__(...) */ \n\n\n";
        string = string.replace("__TYPE__", this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        string = string.replace("__AdptName__", this.BeautifyClassName(this.m_class_declaration.GetAdapterClassName()));
        string = string.replace("__AdptInst__", "m_adptInst");
        return string;
    }

    protected String addInitialize() {
        String string = "\n    \n    /* This method will create appropriate instance of SiebelNoTxConnectionFactory depending upon whether it is Managed environemnt\n     * setup or Non-Managed environment setup. If it is Managed environment then the connection factory instance is obtained by\n     * looking up the JNDI Object deployed on the WebLogic Server. If it is a Non-Managed environment, then it will create\n     * a new instance of SiebelNoTxConnectionFactory\n     * */\n    private void initialize(__AdptName__ __AdptInst__) {\n        boolean bManaged = false;\n        SiebelConnectionFactory m_cf = null;\n        String jndi = __AdptInst__.getResourceReferenceName();\n        \n\n        if (jndi != null)   \n              bManaged = true; \n    \n        if(bManaged)  \n        { \n            try   \n            {   \n                __AdptInst__.lookUp(\"java:comp/env/\"+jndi);  \n            }   \n            catch(NamingException ne) \n            {\n                SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, null, \"Exception : \"+ ne.getMessage()); \n            }\n        }  \n        else   \n        {  \n            __AdptInst__.setUserProperties(\"siebel.properties\"); \n            __AdptInst__.setSiebelServiceName(__AdptName__.CLASS_PROPERTY); \n            m_cf = new SiebelNoTxConnectionFactory(new SiebelNoTxManagedConnectionFactory()); \n            __AdptInst__.setConnectionFactory(m_cf); \n        }   \n    } /* End of initialize() */\n    \n";
        string = string.replace("__TYPE__", this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        string = string.replace("__AdptName__", this.BeautifyClassName(this.m_class_declaration.GetAdapterClassName()));
        string = string.replace("__AdptInst__", "m_adptInst");
        return string;
    }

    protected String AddWebServiceAnnotations() {
        String string = "@WebService(name=\"__SERVICE__PortType\", serviceName=\"__SERVICE__Service\", targetNamespace=\"__TARGET__NS__\", portName = \"__SERVICE__PortTypePort\")  \n@SOAPBinding(style=SOAPBinding.Style.__STYLE__,  use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED) \n";
        if (this.m_class_declaration.GetAttachmentStatus()) {
            string = string + "@MTOM";
        }
        string = string.replace("__TARGET__NS__", this.m_targetNamespace);
        return string;
    }

    protected String AddClassDefinition() {
        String string = "\n";
        string = string + "\npublic class __TYPE__ { \n     @Resource \n     WebServiceContext context;\n     private static ThreadLocal<WebServiceContext> tlContext =   new ThreadLocal<WebServiceContext>() ;\n \n";
        string = string.replace("__AdptName__", this.BeautifyClassName(this.m_class_declaration.GetAdapterClassName()));
        string = string.replace("__TYPE__", this.BeautifyClassName(this.m_class_declaration.GetClassName()));
        string = string + this.AddConstructor();
        string = string + this.addInitialize();
        string = string + this.AddMethodDefinition();
        return string;
    }

    protected String AddMethodDefinition() {
        String string = "";
        ArrayList<MethodDeclaration> arrayList = this.m_class_declaration.GetMethodArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodDeclaration methodDeclaration = arrayList.get(i);
            string = methodDeclaration.GetReturnType().GetType().equalsIgnoreCase("void") ? string + this.ADD_METHOD_CODE_BODY("\n\n    /* __comment__ */\n\n    @WebMethod(operationName = \"__OPERATION__NAME__INPUT__\")\n    @WebResult(name = \"__OPERATION__NAME__OUTPUT__\", targetNamespace = \"__TARGET__NS__\")\n    __access__ __RETURN__ __METHOD__(@WebParam(name = \"__OPERATION__NAME__INPUT__\" , targetNamespace = \"__TARGET__NS__\")\n        __INPUT__NAME__  input )  throws SiebelException \n    {\n        __AdptName__ __AdptInst__ = new __AdptName__ ();\n        JCACommon jcaCommon = new JCACommon();\n        WebServiceContext wsContext = null;\n        initialize(__AdptInst__);\n        {\n            tlContext.set(context);\n            wsContext = tlContext.get();\n            jcaCommon.readSoapHeader(__AdptInst__ , jcaCommon , wsContext);\n        }\n        try  \n        { \n            __AdptInst__.__method__(input);\n\n         \n       } \n       catch(SiebelException se) \n        { \n           SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \"__method__\", \"Exception : \"+ se.getDetailedMessage()); \n           throw se; \n        }\n       finally \n        {\n          wsContext = tlContext.get();\n          jcaCommon.SetSessionContext(__AdptInst__ , wsContext); \n       }\n   }\n    \n    \n", methodDeclaration) : string + this.ADD_METHOD_CODE_BODY("\n\n    /* __comment__ */\n\n    @WebMethod(operationName = \"__OPERATION__NAME__INPUT__\")\n    @WebResult(name = \"__OPERATION__NAME__OUTPUT__\", targetNamespace = \"__TARGET__NS__\")\n    __access__ __RETURN__ __METHOD__(@WebParam(name = \"__OPERATION__NAME__INPUT__\" , targetNamespace = \"__TARGET__NS__\")\n        __INPUT__NAME__  input )  throws SiebelException \n    {\n        __AdptName__ __AdptInst__ = new __AdptName__ ();\n        JCACommon jcaCommon = new JCACommon();\n        WebServiceContext wsContext = null;\n        initialize(__AdptInst__);\n        {\n            tlContext.set(context);\n            wsContext = tlContext.get();\n            jcaCommon.readSoapHeader(__AdptInst__ , jcaCommon , wsContext);\n        }\n        __output__ output = new __output__ (); \n        try  \n        { \n            output = __AdptInst__.__method__(input);\n\n       } \n       catch(SiebelException se) \n        { \n           SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_ERROR, \"__method__\", \"Exception : \"+ se.getDetailedMessage()); \n           throw se; \n        }\n        finally \n        {\n            wsContext = tlContext.get();\n            jcaCommon.SetSessionContext(__AdptInst__ , wsContext); \n        }\n        \n        return output; \n   }\n    \n    \n", methodDeclaration);
        }
        return string;
    }

    protected String ADD_METHOD_CODE_BODY(String string, MethodDeclaration methodDeclaration) {
        String string2 = string;
        string2 = string2.replace("__FAKE_INPUT_PARAM__", "");
        string2 = methodDeclaration.getOperationName().equals("") ? string2.replace("__OPERATION__NAME__INPUT__", methodDeclaration.GetMethodName() + "Input") : string2.replace("__OPERATION__NAME__INPUT__", methodDeclaration.getOperationName() + "_Input");
        string2 = methodDeclaration.getOperationName().equals("") ? string2.replace("__OPERATION__NAME__OUTPUT__", methodDeclaration.GetMethodName() + "Output") : string2.replace("__OPERATION__NAME__OUTPUT__", methodDeclaration.getOperationName() + "_Output");
        string2 = string2.replace("__TARGET__NS__", methodDeclaration.getTargetNamespace());
        string2 = string2.replace("__RETURN__", this.BeautifyClassName(methodDeclaration.GetReturnType().GetType()));
        string2 = string2.replace("__type__", this.BeautifyClassName(methodDeclaration.GetReturnType().GetType()));
        string2 = string2.replace("__METHOD__", methodDeclaration.GetMethodName());
        string2 = string2.replace("__INPUT__NAME__", methodDeclaration.GetMethodName() + "Input");
        string2 = string2.replace("__method__", this.BeautifyMethodName(methodDeclaration.GetMethodName()));
        string2 = string2.replace("__comment__", methodDeclaration.GetComment());
        string2 = string2.replace("__output__", methodDeclaration.GetReturnType().GetType());
        string2 = string2.replace("__property_name__", methodDeclaration.GetProperty());
        string2 = string2.replace("__access__", this.AccessToString(methodDeclaration.GetAccess()));
        string2 = string2.replace("__AdptInst__", "m_adptInst");
        string2 = string2.replace("__AdptName__", this.BeautifyClassName(this.m_class_declaration.GetAdapterClassName()));
        return string2;
    }

    protected String GetMethodDeclaration(MethodDeclaration methodDeclaration) {
        ArrayList<Declaration> arrayList = methodDeclaration.GetArgumentArray();
        String string = "";
        string = string + this.BeautifyClassName(methodDeclaration.GetReturnType().GetType());
        string = string + " ";
        String string2 = this.BeautifyClassName(methodDeclaration.GetMethodName());
        string = string + string2;
        string = string + "( ";
        for (int i = 0; i < arrayList.size(); ++i) {
            Declaration declaration = arrayList.get(i);
            if (i > 0) {
                string = string + ", ";
            }
            if (declaration.GetVariable().equalsIgnoreCase("void")) continue;
            string = string + "@WebParam(name =\"" + string2 + "_Input\")";
            string = string + this.BeautifyClassName(declaration.GetVariable());
            string = string + "  input";
        }
        string = string + " )  throws SiebelException";
        return string;
    }

    protected String AddIOImports() {
        String string = "\n";
        String string2 = "";
        String string3 = "com.siebel.local.p";
        string3.toLowerCase();
        string2 = string2 + string3;
        string2 = string2 + "*";
        string = string + "\nimport ";
        string = string + string2;
        string = string + ";\n\n";
        return string;
    }

    public void setTargetNamespace(String string) {
        this.m_targetNamespace = string;
    }

    public String getTargetNamespace() {
        return this.m_targetNamespace;
    }

    public void setSoapVersion(String string) {
        this.m_soapVersion = string;
    }
}

