/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.codegen;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.data.SiebelPropertySet;
import com.siebel.integration.codegen.AccessRights;
import com.siebel.integration.codegen.ClassDeclaration;
import com.siebel.integration.codegen.CodeWriter;
import com.siebel.integration.codegen.Declaration;
import com.siebel.integration.codegen.JCACodeFilter;
import com.siebel.integration.util.SiebelTrace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSDCodeGenerator {
    private String m_xsdFileName;
    private String m_BSName;
    private String m_BSMethodName;
    private String m_parameterName;
    private DocumentBuilder m_builder;
    private String m_baseIOName;
    private String m_stdNameSpacePrefix;
    private Properties m_attributeMap;
    private String m_CodeGenerationPath;
    private boolean m_hasAttachment = false;
    public static final String SIEBEL_MESSAGE = "SiebelMessage";
    public static final String INTEGRATION_OBJECT_SUFFIX = "IO";
    public static final String INTEGRATION_COMPONENT_SUFFIX = "IC";
    public static final String STRING_TYPE = "String";
    public static final String BLANK = "";
    public static final String STDNAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String OUTPUT_CODE_LIST_PROPERTY = "OutputCodeGeneratedList";
    public static final String OUTPUT_CODE_PROPERTY = "OutputCodeGenerated";
    public static final String XML_SCHEMA = "XML_SCHEMA";
    public static final String GENERATE_CODE_BUSINESS_SERVICE_NAME = "Siebel XSD Code Generator";
    public static final String OUTPUT_NAME_PROPERTY = "ObjectName";
    public static final String CODE_PROPERTY = "Code";
    public static final String NAME_PROPERTY = "Name";
    public static final String FILE_NAME_PROPERTY = "FileName";
    public static final String REPOSITORY_PROPERTY = "RepositoryName";
    public static final String VERSION_PROPERTY = "Version";
    public static final String PACKAGE_PROPERTY = "Package";
    public static final String GENERATION_DATE_PROPERTY = "GenerationDate";
    public static final String CODE_GEN_SERV_NAME_PROPERTY = "CodeGenerator";
    public static final String PROGRAM_LANGUAGE_PROPERTY = "Language";
    public static final String BASE_INTEGRATION_OBJECT = "baseIntegrationObject";
    public static final String MAJOR_VERSION = "majorVersion";
    public static final String MINOR_VERSION = "minorVersion";
    public static final String DRIVER_PARAMETER = "javax.xml.parsers.DocumentBuilderFactory";
    public static final String XERCES_DOCUMENT_BUILDER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    public static final String INTEGRATION_OBJECT_NAME = "IntObjectName";

    public Document parseXsd() {
        Document document = null;
        try {
            if (this.m_builder != null) {
                document = this.m_builder.parse(this.m_xsdFileName);
            }
            return document;
        }
        catch (IOException iOException) {
            this.trace(1, "XSDCodeGenerator:parseXSD", CSSMsgMgr.get(8716815, this.m_xsdFileName));
            this.trace(1, "XSDCodeGenerator:parseXSD", iOException.getMessage());
        }
        catch (SAXException sAXException) {
            this.trace(1, "XSDCodeGenerator:parseXSD", CSSMsgMgr.get(8716815, this.m_xsdFileName));
            this.trace(1, "XSDCodeGenerator:parseXSD", sAXException.getMessage());
        }
        return null;
    }

    public Element getRootElement(Document document) {
        return document.getDocumentElement();
    }

    public boolean generateCode() {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Object object5;
        SiebelPropertySet siebelPropertySet = null;
        ArrayList<Object> arrayList = null;
        ClassDeclaration classDeclaration = null;
        ClassDeclaration classDeclaration2 = null;
        ClassDeclaration classDeclaration3 = null;
        ClassDeclaration classDeclaration4 = null;
        this.m_attributeMap = new Properties();
        Calendar calendar = Calendar.getInstance();
        String string = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
        this.trace(3, "XSDCodeGenerator:generateCode", "Entered XSD Code Generation");
        if (this.m_xsdFileName == null || this.m_xsdFileName.equals(BLANK)) {
            this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716814));
            return false;
        }
        this.trace(3, "XSDCodeGenerator:generateCode", "Validating XSD File - " + this.m_xsdFileName);
        try {
            object5 = SchemaFactory.newInstance(STDNAMESPACE);
            object4 = ((SchemaFactory)object5).newSchema(new URL(this.m_xsdFileName));
        }
        catch (Exception exception) {
            this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716813, this.m_xsdFileName));
            this.trace(1, "XSDCodeGenerator:generateCode", exception.getMessage());
            return false;
        }
        this.trace(3, "XSDCodeGenerator:generateCode", "Parsing XSD File - " + this.m_xsdFileName);
        object5 = this.parseXsd();
        if (object5 == null) {
            return false;
        }
        object4 = this.getRootElement((Document)object5);
        if (object4 == null) {
            this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716812));
            return false;
        }
        this.trace(3, "XSDCodeGenerator:generateCode", "Processing Root Element " + object4.getTagName() + " to get all attributes");
        NamedNodeMap namedNodeMap = object4.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            n = -1;
            object3 = namedNodeMap.item(i).getNodeName();
            object2 = namedNodeMap.item(i).getNodeValue();
            n = ((String)object3).indexOf(MINOR_VERSION);
            if (n != -1) {
                if (this.m_attributeMap != null) {
                    this.m_attributeMap.setProperty(MINOR_VERSION, (String)object2);
                }
                this.trace(5, "XSDCodeGenerator:generateCode", "Found Attribute \"" + (String)object3 + "\" with value \"" + (String)object2 + "\"");
                continue;
            }
            n = ((String)object3).indexOf(MAJOR_VERSION);
            if (n != -1) {
                if (this.m_attributeMap != null) {
                    this.m_attributeMap.setProperty(MAJOR_VERSION, (String)object2);
                }
                this.trace(5, "XSDCodeGenerator:generateCode", "Found Attribute \"" + (String)object3 + "\" with value \"" + (String)object2 + "\"");
                continue;
            }
            n = ((String)object3).indexOf(BASE_INTEGRATION_OBJECT);
            if (n != -1) {
                this.m_baseIOName = object2;
            }
            if (((String)object3).toLowerCase().startsWith("xmlns:") && ((String)object2).equalsIgnoreCase(STDNAMESPACE)) {
                this.m_stdNameSpacePrefix = ((String)object3).substring(6);
            }
            if (this.m_attributeMap != null) {
                this.m_attributeMap.setProperty((String)object3, (String)object2);
            }
            this.trace(5, "XSDCodeGenerator:generateCode", "Found Attribute \"" + (String)object3 + "\" with value \"" + (String)object2 + "\"");
        }
        this.trace(3, "XSDCodeGenerator:generateCode", "Get all complexType nodes");
        NodeList nodeList = object4.getElementsByTagName(this.m_stdNameSpacePrefix + ":complexType");
        if (nodeList == null || nodeList.getLength() <= 0) {
            this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716811));
            return false;
        }
        this.trace(5, "XSDCodeGenerator:generateCode", "Number of complexType Elements found are: " + nodeList.getLength());
        this.trace(3, "XSDCodeGenerator:generateCode", "Processing Each complex Node and creating Class Declaration Object");
        for (n = 0; n < nodeList.getLength(); ++n) {
            int n2;
            object3 = (Element)nodeList.item(n);
            object2 = object3.getAttribute("name");
            if (object2 == null || ((String)object2).equals(BLANK)) {
                Element element = (Element)object3.getParentNode();
                object2 = element.getAttribute("name");
            }
            if ((n2 = ((String)(object2 = ((String)object2).toLowerCase())).indexOf("listof")) != -1 || (n2 = ((String)object2).indexOf("array")) != -1 || (n2 = ((String)object2).lastIndexOf("key")) != -1 || (n2 = ((String)object2).lastIndexOf("userproperty")) != -1) {
                this.trace(3, "XSDCodeGenerator:generateCode", "Ignoring complexType Element: " + (String)object2);
                continue;
            }
            if (((String)object2).equalsIgnoreCase(SIEBEL_MESSAGE)) {
                this.trace(3, "XSDCodeGenerator:generateCode", "Processing SiebelMessage Complex Type");
                classDeclaration = this.CreateSiebelMessageClass((Element)object3, (Element)object4, false);
                classDeclaration2 = this.CreateSiebelMessageClass((Element)object3, (Element)object4, true);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                if (classDeclaration != null && arrayList != null) {
                    this.trace(5, "XSDCodeGenerator:generateCode", "Adding SiebelMessage ClassDeclaration Object to classes ArrayList");
                    arrayList.add(classDeclaration);
                }
                if (classDeclaration2 == null || arrayList == null) continue;
                this.trace(5, "XSDCodeGenerator:generateCode", "Adding SiebelMessage ClassDeclaration Object for EJB to classes ArrayList");
                arrayList.add(classDeclaration2);
                continue;
            }
            this.trace(3, "XSDCodeGenerator:generateCode", "Processing " + (String)object2 + " ComplexType");
            classDeclaration3 = this.CreateICClass((Element)object3, (Element)object4, false);
            classDeclaration4 = this.CreateICClass((Element)object3, (Element)object4, true);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (classDeclaration3 != null && arrayList != null) {
                this.trace(5, "XSDCodeGenerator:generateCode", "Adding " + (String)object2 + " ClassDeclaration Object to classes ArrayList");
                arrayList.add(classDeclaration3);
            }
            if (classDeclaration4 == null || arrayList == null) continue;
            this.trace(5, "XSDCodeGenerator:generateCode", "Adding " + (String)object2 + " ClassDeclaration Object for EJB to classes ArrayList");
            arrayList.add(classDeclaration4);
        }
        if (this.m_hasAttachment) {
            Declaration declaration;
            Declaration declaration2;
            Declaration declaration3;
            Declaration declaration4;
            Declaration declaration5;
            this.trace(3, "XSDCodeGenerator:generateCode", "Input XSD has one or more attachment components");
            ArrayList<Declaration> arrayList2 = classDeclaration.GetFieldArray();
            object3 = new Declaration("Document", "Document", "Document", "Zero or More", AccessRights.PUBLIC_ACCESS);
            if (object3 != null) {
                ((Declaration)object3).setDoc_Content(true);
                ((Declaration)object3).SetIntCompType(true);
            }
            this.trace(5, "XSDCodeGenerator:generateCode", "Adding document Declaration Object to fields ArrayList of SiebelMessage class");
            arrayList2.add((Declaration)object3);
            arrayList2 = classDeclaration2.GetFieldArray();
            object2 = new Declaration("Document", "Document", "Document", "Zero or More", AccessRights.PUBLIC_ACCESS);
            if (object2 != null) {
                ((Declaration)object2).setDoc_Content(true);
                ((Declaration)object2).SetIntCompType(true);
            }
            this.trace(5, "XSDCodeGenerator:generateCode", "Adding document Declaration Object to fields ArrayList of SiebelMessageEJB class");
            arrayList2.add((Declaration)object2);
            ClassDeclaration classDeclaration5 = new ClassDeclaration("Document", "Document", AccessRights.PUBLIC_ACCESS);
            arrayList2 = new ArrayList();
            if (classDeclaration5 != null) {
                object = new Declaration("string", "TimedOut", "TimedOut", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration5 = new Declaration("string", "EndOfData", "EndOfData", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration4 = new Declaration("string", "AttachmentIsTextData", "AttachmentIsTextData", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration3 = new Declaration("string", "ContentId", "ContentId", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration2 = new Declaration("string", "Extension", "Extension", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration = new Declaration("DataHandler", "DocumentContent", "DocumentContent", "Zero or One", AccessRights.PUBLIC_ACCESS);
                arrayList2.add((Declaration)object);
                arrayList2.add(declaration5);
                arrayList2.add(declaration4);
                arrayList2.add(declaration3);
                arrayList2.add(declaration2);
                arrayList2.add(declaration);
                classDeclaration5.SetFields(arrayList2);
                classDeclaration5.SetClassType(INTEGRATION_COMPONENT_SUFFIX);
            }
            this.trace(5, "XSDCodeGenerator:generateCode", "Adding document ClassDeclaration Object to classes ArrayList");
            arrayList.add(classDeclaration5);
            object = new ClassDeclaration("Document", "Document", AccessRights.PUBLIC_ACCESS, true);
            arrayList2 = new ArrayList();
            if (object != null) {
                declaration5 = new Declaration("string", "TimedOut", "TimedOut", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration4 = new Declaration("string", "EndOfData", "EndOfData", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration3 = new Declaration("string", "AttachmentIsTextData", "AttachmentIsTextData", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration2 = new Declaration("string", "ContentId", "ContentId", "Zero or One", AccessRights.PUBLIC_ACCESS);
                declaration = new Declaration("string", "Extension", "Extension", "Zero or One", AccessRights.PUBLIC_ACCESS);
                Declaration declaration6 = new Declaration("byte[]", "DocumentContent", "DocumentContent", "Zero or One", AccessRights.PUBLIC_ACCESS);
                arrayList2.add(declaration5);
                arrayList2.add(declaration4);
                arrayList2.add(declaration3);
                arrayList2.add(declaration2);
                arrayList2.add(declaration);
                arrayList2.add(declaration6);
                ((ClassDeclaration)object).SetFields(arrayList2);
                ((ClassDeclaration)object).SetClassType(INTEGRATION_COMPONENT_SUFFIX);
            }
            this.trace(5, "XSDCodeGenerator:generateCode", "Adding document ClassDeclaration Object to classes ArrayList");
            arrayList.add(object);
        }
        if (arrayList == null) {
            this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716810));
            return false;
        }
        siebelPropertySet = new SiebelPropertySet(OUTPUT_CODE_LIST_PROPERTY);
        if (siebelPropertySet != null && arrayList != null) {
            this.trace(3, "XSDCodeGenerator:generateCode", "Generating code");
            for (int i = 0; i < arrayList.size(); ++i) {
                object3 = (ClassDeclaration)arrayList.get(i);
                object2 = this.m_BSName;
                SiebelPropertySet siebelPropertySet2 = null;
                object = new JCACodeFilter((ClassDeclaration)object3);
                if (object == null) {
                    this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716809));
                    return false;
                }
                siebelPropertySet2 = new SiebelPropertySet(OUTPUT_CODE_PROPERTY);
                if (siebelPropertySet2 == null || object == null) continue;
                this.trace(5, "XSDCodeGenerator:generateCode", "Generating code for " + ((ClassDeclaration)object3).GetClassName());
                siebelPropertySet2.setProperty(OUTPUT_NAME_PROPERTY, this.m_xsdFileName);
                siebelPropertySet2.setProperty(CODE_PROPERTY, ((JCACodeFilter)object).GenerateCode(XML_SCHEMA, this.m_BSName + this.m_BSMethodName + this.m_parameterName, (String)object2));
                siebelPropertySet2.setProperty(NAME_PROPERTY, ((ClassDeclaration)object3).GetClassName());
                siebelPropertySet2.setProperty(FILE_NAME_PROPERTY, ((ClassDeclaration)object3).GetClassName() + ".java");
                siebelPropertySet2.setProperty(PACKAGE_PROPERTY, ((ClassDeclaration)object3).GetNamespace());
                siebelPropertySet2.setProperty(GENERATION_DATE_PROPERTY, string);
                siebelPropertySet2.setProperty(CODE_GEN_SERV_NAME_PROPERTY, GENERATE_CODE_BUSINESS_SERVICE_NAME);
                siebelPropertySet2.setProperty(PROGRAM_LANGUAGE_PROPERTY, "JCA");
                siebelPropertySet.addChild(siebelPropertySet2);
            }
        }
        if (siebelPropertySet != null) {
            CodeWriter codeWriter = new CodeWriter(this.m_CodeGenerationPath);
            if (codeWriter == null) {
                this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716807));
                return false;
            }
            if (!codeWriter.WriteCode(siebelPropertySet)) {
                this.trace(1, "XSDCodeGenerator:generateCode", CSSMsgMgr.get(8716808));
                return false;
            }
        }
        return true;
    }

    private ClassDeclaration CreateICClass(Element element, Element element2, boolean bl) {
        ClassDeclaration classDeclaration = null;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        classDeclaration = bl ? new ClassDeclaration(element.getAttribute("name"), element.getAttribute("name"), AccessRights.PUBLIC_ACCESS, true) : new ClassDeclaration(element.getAttribute("name"), element.getAttribute("name"), AccessRights.PUBLIC_ACCESS);
        if (classDeclaration != null) {
            this.addAttributes(arrayList, element, false);
            this.addElements(arrayList, element, element2, false);
            classDeclaration.SetFields(arrayList);
            classDeclaration.SetClassType(INTEGRATION_COMPONENT_SUFFIX);
        }
        return classDeclaration;
    }

    public boolean generateCode(String string, String string2, String string3, String string4, String string5) {
        this.m_xsdFileName = string;
        this.m_BSName = string2;
        this.m_parameterName = string4;
        this.m_BSMethodName = string3;
        this.m_CodeGenerationPath = string5;
        return this.generateCode();
    }

    private ClassDeclaration CreateSiebelMessageClass(Element element, Element element2, boolean bl) {
        ClassDeclaration classDeclaration = null;
        Declaration declaration = null;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        classDeclaration = bl ? new ClassDeclaration(this.m_BSName + this.m_BSMethodName + this.m_parameterName, SIEBEL_MESSAGE, AccessRights.PUBLIC_ACCESS, true) : new ClassDeclaration(this.m_BSName + this.m_BSMethodName + this.m_parameterName, SIEBEL_MESSAGE, AccessRights.PUBLIC_ACCESS);
        if (classDeclaration != null) {
            String string;
            classDeclaration.SetParent(SIEBEL_MESSAGE + this.m_baseIOName + INTEGRATION_OBJECT_SUFFIX);
            classDeclaration.SetClassType(INTEGRATION_OBJECT_SUFFIX);
            this.addAttributes(arrayList, element, true);
            declaration = new Declaration(STRING_TYPE, "XsdUri", "XsdUri", BLANK, AccessRights.PRIVATE_ACCESS);
            if (declaration != null) {
                declaration.SetValue("\"" + this.getFileName() + "\"");
                arrayList.add(declaration);
            }
            if ((declaration = new Declaration(STRING_TYPE, MINOR_VERSION, MINOR_VERSION, BLANK, AccessRights.PRIVATE_ACCESS)) != null) {
                string = this.m_attributeMap.getProperty(MINOR_VERSION);
                if (string != null && !string.equals(BLANK)) {
                    declaration.SetValue("\"" + string + "\"");
                }
                arrayList.add(declaration);
            }
            if ((declaration = new Declaration(STRING_TYPE, MAJOR_VERSION, MAJOR_VERSION, BLANK, AccessRights.PRIVATE_ACCESS)) != null) {
                string = this.m_attributeMap.getProperty(MAJOR_VERSION);
                if (string != null && !string.equals(BLANK)) {
                    declaration.SetValue("\"" + string + "\"");
                }
                arrayList.add(declaration);
            }
            if ((declaration = new Declaration(STRING_TYPE, BASE_INTEGRATION_OBJECT, BASE_INTEGRATION_OBJECT, BLANK, AccessRights.PRIVATE_ACCESS)) != null) {
                if (this.m_baseIOName != null && !this.m_baseIOName.equals(BLANK)) {
                    declaration.SetValue("\"" + this.m_baseIOName + "\"");
                }
                arrayList.add(declaration);
            }
            if ((declaration = new Declaration(STRING_TYPE, INTEGRATION_OBJECT_NAME, INTEGRATION_OBJECT_NAME, BLANK, AccessRights.PRIVATE_ACCESS)) != null) {
                declaration.SetValue("\"" + this.getFileName() + "\"");
                arrayList.add(declaration);
            }
            if ((declaration = new Declaration(STRING_TYPE, "XSDContent", "XSDContent", BLANK, AccessRights.PRIVATE_ACCESS)) != null) {
                declaration.SetValue("\"" + this.getXSDFileAsString() + "\"");
                arrayList.add(declaration);
            }
            this.addElements(arrayList, element, element2, true);
            classDeclaration.SetFields(arrayList);
        }
        return classDeclaration;
    }

    private boolean addAttributes(ArrayList<Declaration> arrayList, Element element, boolean bl) {
        Declaration declaration = null;
        String[] stringArray = new String[2];
        this.trace(3, "XSDCodeGenerator:addAttributes", "Processing Attributes");
        NodeList nodeList = element.getElementsByTagName(this.m_stdNameSpacePrefix + ":attribute");
        if (nodeList == null || nodeList.getLength() <= 0) {
            this.trace(2, "XSDCodeGenerator:addAttributes", "No Attributes found");
            return true;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            stringArray = element2.getAttribute("type").split(":", 2);
            String string = stringArray.length == 1 ? stringArray[0] : stringArray[1];
            declaration = bl ? new Declaration(this.beautifyName(string), element2.getAttribute("name"), element2.getAttribute("name"), BLANK, AccessRights.PRIVATE_ACCESS) : new Declaration(this.beautifyName(string), element2.getAttribute("name"), element2.getAttribute("name"), BLANK, AccessRights.PUBLIC_ACCESS);
            if (declaration == null || arrayList == null) continue;
            this.trace(5, "XSDCodeGenerator:addAttributes", "Adding Declaration object for " + element2.getAttribute("name") + " to ClassDeclaration fieldArray.");
            arrayList.add(declaration);
        }
        return true;
    }

    private boolean addElements(ArrayList<Declaration> arrayList, Element element, Element element2, boolean bl) {
        Declaration declaration = null;
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[2];
        this.trace(3, "XSDCodeGenerator:addElements", "Processing Elements");
        NodeList nodeList = element.getElementsByTagName(this.m_stdNameSpacePrefix + ":sequence");
        if (nodeList == null || nodeList.getLength() <= 0) {
            this.trace(2, "XSDCodeGenerator:addElements", "No Elements found");
            return true;
        }
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i).getFirstChild();
            while (node != null) {
                Object object;
                Integer n;
                if (node.getNodeType() == 3) {
                    node = node.getNextSibling();
                }
                if (node == null) continue block0;
                stringArray = this.getElementAttributes((Element)node);
                if (stringArray[0] == null) {
                    node = node.getNextSibling();
                    continue;
                }
                stringArray2 = stringArray[1].split(":", 2);
                String string = stringArray2.length == 1 ? stringArray2[0] : stringArray2[1];
                if (string.equals("base64Binary")) {
                    string = "string";
                    this.m_hasAttachment = true;
                }
                if ((n = Integer.valueOf(string.lastIndexOf("Key"))) != -1 || (n = Integer.valueOf(string.lastIndexOf("UserProperty"))) != -1) {
                    node = node.getNextSibling();
                    continue;
                }
                if (string.toLowerCase().startsWith("listof") || string.toLowerCase().startsWith("array")) {
                    object = element2.getElementsByTagName(this.m_stdNameSpacePrefix + ":complexType");
                    for (int j = 0; j < object.getLength(); ++j) {
                        Element element3 = (Element)object.item(j);
                        if (!element3.getAttribute("name").equalsIgnoreCase(string)) continue;
                        this.addElements(arrayList, element3, element2, bl);
                        break;
                    }
                } else {
                    object = this.beautifyName(string);
                    if (bl) {
                        declaration = new Declaration((String)object, stringArray[0], this.getFileName(), stringArray[2], AccessRights.PUBLIC_ACCESS);
                        if (declaration != null) {
                            declaration.SetParentICName(string);
                        }
                    } else {
                        declaration = new Declaration((String)object, stringArray[0], stringArray[0], stringArray[2], AccessRights.PUBLIC_ACCESS);
                    }
                    if ((n = Integer.valueOf(stringArray[2].indexOf("More"))) != -1 || !this.isInListedDatatypes((String)object)) {
                        declaration.SetIntCompType(true);
                    }
                    if (declaration != null && arrayList != null) {
                        this.trace(5, "XSDCodeGenerator:addElements", "Adding Declaration object for " + stringArray[0] + " to ClassDeclaration fieldArray.");
                        arrayList.add(declaration);
                    }
                }
                node = node.getNextSibling();
            }
        }
        return true;
    }

    private boolean isInListedDatatypes(String string) {
        return string.equalsIgnoreCase("dateTime") || string.equalsIgnoreCase("date") || string.equalsIgnoreCase("time") || string.equalsIgnoreCase("boolean") || string.equalsIgnoreCase("integer") || string.equalsIgnoreCase("decimal") || string.equalsIgnoreCase("string");
    }

    public String beautifyName(String string) {
        String string2 = " -()[]{}+=!@#$%^&*\\\\/?<>,;:\\\"\\'`~|";
        char c = '_';
        String string3 = string;
        if (string3.equals("byte[]")) {
            return string3;
        }
        for (int i = 0; i < string2.length(); ++i) {
            string3 = string3.replace(string2.charAt(i), c);
        }
        return string3;
    }

    private String[] getElementAttributes(Element element) {
        String[] stringArray = new String[3];
        String string = BLANK;
        String string2 = BLANK;
        if (element.getTagName().equalsIgnoreCase(this.m_stdNameSpacePrefix + ":element")) {
            stringArray[0] = element.getAttribute("name");
            stringArray[1] = element.getAttribute("type");
            string = element.getAttribute("minOccurs");
            string2 = element.getAttribute("maxOccurs");
            Integer n = 1;
            Integer n2 = 1;
            String string3 = string == null || string.equals(BLANK) ? "One" : ((n = Integer.valueOf(Integer.valueOf(string))) > 0 ? "One" : "Zero");
            String string4 = string2 == null || string2.equals(BLANK) ? "One" : (string2.equalsIgnoreCase("unbounded") ? "More" : ((n2 = Integer.valueOf(Integer.valueOf(string2))) <= 1 ? "One" : "More"));
            stringArray[2] = string3 == "One" && string4 == "One" ? "One" : string3 + " or " + string4;
            return stringArray;
        }
        return null;
    }

    private String getFileName() {
        int n = this.m_xsdFileName.lastIndexOf("/");
        String string = n == -1 ? this.m_xsdFileName : this.m_xsdFileName.substring(n + 1);
        return string;
    }

    private String getXSDFileAsString() {
        String string = BLANK;
        try {
            String string2;
            URL uRL = new URL(this.m_xsdFileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string.replaceAll("\"", "\\\\\"");
        return string;
    }

    public XSDCodeGenerator() {
        this.m_xsdFileName = BLANK;
        this.m_BSName = BLANK;
        this.m_parameterName = BLANK;
        this.m_BSMethodName = BLANK;
        this.m_CodeGenerationPath = BLANK;
        this.m_baseIOName = BLANK;
        this.m_stdNameSpacePrefix = BLANK;
        this.m_attributeMap = null;
        this.m_hasAttachment = false;
        SiebelTrace.getInstance().trace(null, 3, "XSDCodeGenerator:XSDCodeGenerator", "Created XSD Code Generator object");
        try {
            SiebelTrace.getInstance().trace(null, 4, "XSDCodeGenerator:XSDCodeGenerator", "Setting DRIVER_PARAMTER to \"XERCES_DOCUMENT_BUILDER_FACTORY\"");
            System.setProperty(DRIVER_PARAMETER, XERCES_DOCUMENT_BUILDER_FACTORY);
            this.m_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SiebelTrace.getInstance().trace(null, 5, "XSDCodeGenerator:XSDCodeGenerator", "Document builder instance created - " + this.m_builder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SiebelTrace.getInstance().trace(null, 1, "XSDCodeGenerator:XSDCodeGenerator", CSSMsgMgr.get(8716805));
            SiebelTrace.getInstance().trace(null, 1, "XSDCodeGenerator:XSDCodeGenerator", parserConfigurationException.getMessage());
        }
    }

    public XSDCodeGenerator(String string, String string2, String string3, String string4, String string5) {
        this.m_xsdFileName = string;
        this.m_BSName = string2;
        this.m_parameterName = string4;
        this.m_BSMethodName = string3;
        this.m_CodeGenerationPath = string5;
        this.m_baseIOName = BLANK;
        this.m_stdNameSpacePrefix = BLANK;
        this.m_attributeMap = null;
        this.m_hasAttachment = false;
        SiebelTrace.getInstance().trace(null, 3, "XSDCodeGenerator:XSDCodeGenerator", "Created XSD Code Generator object");
        try {
            SiebelTrace.getInstance().trace(null, 4, "XSDCodeGenerator:XSDCodeGenerator", "Setting DRIVER_PARAMTER to \"XERCES_DOCUMENT_BUILDER_FACTORY\"");
            System.setProperty(DRIVER_PARAMETER, XERCES_DOCUMENT_BUILDER_FACTORY);
            this.m_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SiebelTrace.getInstance().trace(null, 5, "XSDCodeGenerator:XSDCodeGenerator", "Document builder instance created - " + this.m_builder);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SiebelTrace.getInstance().trace(null, 1, "XSDCodeGenerator:XSDCodeGenerator", CSSMsgMgr.get(8716805));
            SiebelTrace.getInstance().trace(null, 1, "XSDCodeGenerator:XSDCodeGenerator", parserConfigurationException.getMessage());
        }
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }

    public static void main(String[] stringArray) {
        XSDCodeGenerator xSDCodeGenerator = new XSDCodeGenerator("file:///C:/EAI/bin/ListOfAccount1WithUserKey.xsd", "AccountWS", "QueryPage", SIEBEL_MESSAGE, "D:/temp");
        xSDCodeGenerator.generateCode();
    }
}

