/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.codegen.outbound.dispatchergen;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.codegen.common.CodegenConstants;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.ws.WebEndpoint;

public class OutboundDispatcherGen {
    private File fileDispatch = null;
    private File filePath = null;
    private PrintWriter printWriter = null;
    private FileOutputStream fosWrapStream = null;
    private ArrayList<String> dispatcherInterface = new ArrayList();
    private ArrayList<String> dispatcherLocalInterface = new ArrayList();
    private ArrayList<String> dispatcherRemoteInterface = new ArrayList();
    private ArrayList<String> dispatcherBean = new ArrayList();
    private String strClassDir = null;
    private String strResultClassDir = null;
    private ArrayList<String> webendPoint = new ArrayList();
    private static final String JAVA_EXT = ".java";

    public ArrayList<String> getwebendPoint() {
        return this.webendPoint;
    }

    public OutboundDispatcherGen(String string) {
        this.strClassDir = string;
        this.initDispatcherInterface();
        this.initDispatcherBean();
    }

    public static void main(String[] stringArray) {
        SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Execute Outbound Dispatcher Generator using CLASSPATH:" + System.getProperty("java.class.path"));
        String string = stringArray[0];
        String string2 = stringArray[1];
        OutboundDispatcherGen outboundDispatcherGen = new OutboundDispatcherGen(string);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Outbound Dispatcher Generate in " + string2 + " location");
        outboundDispatcherGen.run(string2);
        for (String string3 : outboundDispatcherGen.getwebendPoint()) {
            SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Outbound Dispatcher added for  " + string3 + " WebEndPoint");
        }
        outboundDispatcherGen.generateDispatcher();
    }

    public int run(String string) {
        this.strResultClassDir = string;
        if (this.proxyfileslist(new File(this.strClassDir), "") == 1) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", CSSMsgMgr.get(8717488));
            return 1;
        }
        return 0;
    }

    private Matcher getPeriodMch(String string) {
        String string2 = string;
        Pattern pattern = Pattern.compile("[.]");
        Matcher matcher = pattern.matcher(string2);
        return matcher;
    }

    private void writeCopyRights() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        this.printWriter.println("/* ");
        this.printWriter.println(" * -- AUTOMATICALLY GENERATED FROM UI WRAPPER GENERATOR -- ");
        this.printWriter.println(" * Copyright (C) Oracle Corporation 2010. All rights reserved. ");
        this.printWriter.println(" * ");
        this.printWriter.println("");
        this.printWriter.println(" * MODIFICATION OR EXTENSION OF THIS CODE SHALL VOID ANY APPLICABLE ");
        this.printWriter.println(" * WARRANTIES AND MAINTENANCE SUPPORT.");
        this.printWriter.println(" * ");
        this.printWriter.println(" * Generated from Siebel SAI Code Generator ");
        this.printWriter.println(" * Generated Date    : " + simpleDateFormat.format(new GregorianCalendar().getTime()));
        this.printWriter.println("");
        this.printWriter.println("  */");
        this.printWriter.println("");
    }

    private int proxyfileslist(File file, String string) {
        String string2 = "";
        String string3 = "";
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isFile()) {
                    Class<?> clazz;
                    if (!file2.getName().endsWith(".class") || file2.getName().equals("package-info.class") || file2.getName().equals("ObjectFactory.class")) continue;
                    string3 = file2.getName().substring(0, file2.getName().toString().length() - 6);
                    try {
                        clazz = Class.forName(string + string3);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.out.println("ClassNotFoundException:");
                        classNotFoundException.printStackTrace();
                        return 1;
                    }
                    Matcher matcher = this.getPeriodMch(string + string3);
                    if (clazz.getSuperclass() == null || !clazz.getSuperclass().getName().equals("javax.xml.ws.Service") || this.getWEP(clazz) != 1) continue;
                    SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", CSSMsgMgr.get(8717488));
                    return 1;
                }
                if (!file2.isDirectory()) continue;
                string2 = string;
                String string4 = string = string != "" ? string + file2.getName() + "." : file2.getName() + ".";
                if (this.proxyfileslist(file2, string) == 1) {
                    SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", CSSMsgMgr.get(8717488));
                    return 1;
                }
                string = string2;
            }
        } else {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDispatcherGenerator", CSSMsgMgr.get(8717489));
            return 1;
        }
        return 0;
    }

    private int getWEP(Class clazz) {
        Method[] methodArray;
        Class<?>[] classArray = null;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            Annotation[] annotationArray = method.getAnnotations();
            classArray = method.getParameterTypes();
            for (int i = 0; i < annotationArray.length; ++i) {
                if (!annotationArray[i].annotationType().getName().endsWith("javax.xml.ws.WebEndpoint") || classArray.length != 0 || !method.getName().startsWith("get")) continue;
                this.webendPoint.add(((WebEndpoint)annotationArray[i]).name());
            }
        }
        return 0;
    }

    public void generateDispatcher() {
        this.generateDispatcher("DispatcherSession", this.dispatcherInterface, true);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Generated Outbound Dispatcher Common Interface:OutboundDispatcherGenerator");
        this.generateDispatcher("DispatcherSessionLocal", this.dispatcherLocalInterface, true);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Generated Outbound Dispatcher Local Interface:DispatcherSessionLocal");
        this.generateDispatcher("DispatcherSessionRemote", this.dispatcherRemoteInterface, true);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Generated Outbound Dispatcher Remote Interface:OutboundDispatcherGenerator");
        this.generateDispatcher("DispatcherSessionBean", this.dispatcherBean, false);
        this.writeLogFunctions();
        this.writeExceptionStackTrace();
        this.writeInvokeMethod();
        this.printWriter.close();
        SiebelTrace.getInstance().trace(null, 3, "OutboundDispatcherGenerator", " Generated Outbound Dispatcher Implementaion Bean class:OutboundDispatcherGenerator");
    }

    private void generateDispatcher(String string, ArrayList<String> arrayList, boolean bl) {
        String string2 = null;
        Matcher matcher = this.getPeriodMch("com.siebel.eai.outbound.dispatcher");
        String string3 = this.strResultClassDir + Matcher.quoteReplacement(CodegenConstants.SYSTEM_SEP + matcher.replaceAll(Matcher.quoteReplacement(CodegenConstants.SYSTEM_SEP)));
        try {
            this.filePath = new File(string3);
            this.filePath.mkdirs();
            this.fileDispatch = new File(string3 + CodegenConstants.SYSTEM_SEP + string + JAVA_EXT);
            this.fosWrapStream = new FileOutputStream(this.fileDispatch);
            this.printWriter = new PrintWriter(this.fosWrapStream);
            this.writeCopyRights();
            if (string.equalsIgnoreCase("DispatcherSessionBean")) {
                this.writeImportStatements();
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                string2 = arrayList.get(i);
                if (string2.equals("")) {
                    this.printWriter.println("");
                    continue;
                }
                string2 = string2.replaceAll("_DISPATCHER_INTERFACE_NAME_", "DispatcherSession");
                string2 = string2.replaceAll("_DISPATCHER_PACKAGE_NAME_", "com.siebel.eai.outbound.dispatcher");
                string2 = string2.replaceAll("_DISPATCHER_INTERFACE_LOCAL_NAME_", "DispatcherSessionLocal");
                string2 = string2.replaceAll("_DISPATCHER_INTERFACE_REMOTE_NAME_", "DispatcherSessionRemote");
                string2 = string2.replaceAll("_DISPATCHER_BEAN_NAME_", "DispatcherSessionBean");
                this.printWriter.println(string2);
            }
            if (bl) {
                this.printWriter.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeLogFunctions() {
        this.printWriter.println("private void setLogLevel(int logLevel) { ");
        this.printWriter.println("     try { ");
        this.printWriter.println("        SiebelTrace.getInstance().setLogLevel(logLevel);");
        this.printWriter.println("     } catch (Exception e) { ");
        this.printWriter.println("         SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_INFO, ");
        this.printWriter.println("                                         \"Siebel outbound Dispatcher Bean invoke()\", ");
        this.printWriter.println("                                         \" Invalid log level specified. Exception \" + ");
        this.printWriter.println("                                         e.getMessage()); ");
        this.printWriter.println("     } ");
        this.printWriter.println(" } ");
        this.printWriter.println("");
        this.printWriter.println("");
        this.printWriter.println("private void setLogLevel(String logLevel) { ");
        this.printWriter.println("    try { ");
        this.printWriter.println("        SiebelTrace.getInstance().setLogLevel(logLevel); ");
        this.printWriter.println("    } catch (Exception e) { ");
        this.printWriter.println("        SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_INFO, ");
        this.printWriter.println("                                        \"Siebel outbound Dispatcher Bean invoke()\", ");
        this.printWriter.println("                                        \" Invalid log level specified. Exception \" + ");
        this.printWriter.println("                                        e.getMessage()); ");
        this.printWriter.println("        SiebelTrace.getInstance().setLogLevel(SiebelTraceLevel.LOG_ERROR); ");
        this.printWriter.println("        throw new IllegalArgumentException(\"logLevel\"); ");
        this.printWriter.println("    } ");
        this.printWriter.println("} ");
        this.printWriter.println("");
        this.printWriter.println("");
        this.printWriter.println("private void setLogFile(String fileName) { ");
        this.printWriter.println("    SiebelTrace.getInstance().setLogfile(fileName); ");
        this.printWriter.println("    SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_DETAIL, ");
        this.printWriter.println("                                    \"Siebel outbound Dispatcher Bean invoke()\", ");
        this.printWriter.println("                                    \" Set log file using ejb \" + fileName); ");
        this.printWriter.println("} ");
        this.printWriter.println("");
    }

    private void writeExceptionStackTrace() {
        this.printWriter.println("private String getStackTrace(Throwable aThrowable) { ");
        this.printWriter.println("    final Writer result = new StringWriter(); ");
        this.printWriter.println("    final PrintWriter printWriter = new PrintWriter(result); ");
        this.printWriter.println("    aThrowable.printStackTrace(printWriter); ");
        this.printWriter.println("    return result.toString(); ");
        this.printWriter.println("} ");
        this.printWriter.println("");
    }

    private void writeInvokeMethod() {
        this.printWriter.println("public SiebelPropertySet invoke(String sendpoint, String smethod, ");
        this.printWriter.println("                                SiebelPropertySet spset) { ");
        this.printWriter.println("    SiebelPropertySet retobj = new SiebelPropertySet(); ");
        this.printWriter.println("    int iLogLevel = 0; ");
        this.printWriter.println("    Throwable aThrowable = null; ");
        this.printWriter.println("    String strPackageEndpoint = ");
        this.printWriter.println("        \"com.siebel.eai.outbound.wrapper.\" + \"_\" + sendpoint; ");
        this.printWriter.println("    String jndiName = ");
        this.printWriter.println("        objAccountWSBusServAdapter.getResourceReferenceName(); ");
        this.printWriter.println("   // If Resource adapter deployed already use the same log file ");
        this.printWriter.println("    if (jndiName != null) { ");
        this.printWriter.println("        SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_INFO, ");
        this.printWriter.println("                                        \"DispatcherSessionBean\", ");
        this.printWriter.println("                                        \" Log file is using from Resource Adapter. Log level:\" + ");
        this.printWriter.println("                                        SiebelTrace.getInstance().getLogLevel()); ");
        this.printWriter.println("    } else { // If Resource adapter not deployed already, use the EJB deployment dec parameters ");
        this.printWriter.println("        setLogFile(strLogFile); ");
        this.printWriter.println("        try { ");
        this.printWriter.println("            // Try to get Integer format. ");
        this.printWriter.println("            iLogLevel = Integer.parseInt(strLogLevel); ");
        this.printWriter.println("            setLogLevel(iLogLevel); ");
        this.printWriter.println("        } catch (NumberFormatException e) { ");
        this.printWriter.println("            SiebelTrace.getInstance().trace(null, ");
        this.printWriter.println("                                            SiebelTraceLevel.LOG_DETAIL, ");
        this.printWriter.println("                                            \"DispatcherSessionBean\", ");
        this.printWriter.println("                                            \" Got exception for parse log level integer. Treat as String. \"); ");
        this.printWriter.println("            //String format ");
        this.printWriter.println("            setLogLevel(strLogLevel); ");
        this.printWriter.println("        } ");
        this.printWriter.println("        SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_INFO, ");
        this.printWriter.println("                                        \"DispatcherSessionBean\", ");
        this.printWriter.println("                                        \" Log file is using from ejb. Log File:\" + ");
        this.printWriter.println("                                        strLogFile + \" Log level:\" + ");
        this.printWriter.println("                                        strLogLevel); ");
        this.printWriter.println("    } ");
        this.printWriter.println("    retobj.setType(\"ERROR\"); ");
        this.printWriter.println("    retobj.setValue(\"WebEndPointNotFound\"); ");
        this.printWriter.println("   try{ ");
        for (String string : this.webendPoint) {
            this.printWriter.println("");
            this.printWriter.println("       if(sendpoint.equals(\"" + string + "\")){");
            this.printWriter.println("       _" + string + " obj = new _" + string + "();");
            this.printWriter.println("               return obj.invoke(smethod, spset);");
            this.printWriter.println("          }");
            this.printWriter.println("");
        }
        this.printWriter.println("       }catch(Exception e){ ");
        this.printWriter.println("        SiebelTrace.getInstance().trace(null, SiebelTraceLevel.LOG_INFO, ");
        this.printWriter.println("                                        \"DispatcherSessionBean\", ");
        this.printWriter.println("                                        \" Exception occured. \" + ");
        this.printWriter.println("                                        getStackTrace(e));");
        this.printWriter.println("\t\t}");
        this.printWriter.println("   return (SiebelPropertySet)retobj; ");
        this.printWriter.println("} ");
        this.printWriter.println("} ");
    }

    private void writeImportStatements() {
        this.printWriter.println("package com.siebel.eai.outbound.dispatcher;");
        this.printWriter.println("");
        this.printWriter.println("import java.lang.reflect.Method;");
        this.printWriter.println("");
        this.printWriter.println("import javax.ejb.Local; ");
        this.printWriter.println("import javax.ejb.Remote; ");
        this.printWriter.println("import javax.ejb.Stateless; ");
        this.printWriter.println("");
        this.printWriter.println("import java.lang.reflect.InvocationTargetException; ");
        this.printWriter.println("");
        this.printWriter.println("import javax.annotation.Resource; ");
        this.printWriter.println("");
        this.printWriter.println("import java.io.PrintWriter; ");
        this.printWriter.println("import java.io.StringWriter; ");
        this.printWriter.println("import java.io.Writer; ");
        this.printWriter.println("");
        this.printWriter.println("import com.siebel.data.SiebelPropertySet; ");
        this.printWriter.println("import com.siebel.integration.util.SiebelTrace; ");
        this.printWriter.println("import com.siebel.integration.util.SiebelTraceLevel; ");
        this.printWriter.println("import com.siebel.integration.adapter.SiebelJCAAdapterBase;");
        this.printWriter.println("");
        this.printWriter.println("");
        for (String string : this.webendPoint) {
            this.printWriter.println("import com.siebel.eai.outbound.wrapper._" + string + ";");
        }
        this.printWriter.println("");
        this.printWriter.println("");
    }

    private void initDispatcherInterface() {
        this.dispatcherInterface.add("package _DISPATCHER_PACKAGE_NAME_;");
        this.dispatcherInterface.add("");
        this.dispatcherInterface.add("import com.siebel.data.SiebelPropertySet; ");
        this.dispatcherInterface.add("");
        this.dispatcherInterface.add("public interface _DISPATCHER_INTERFACE_NAME_ {");
        this.dispatcherInterface.add("   public SiebelPropertySet invoke(String sendpoint, String smethod, SiebelPropertySet spset);");
        this.dispatcherInterface.add("}");
        this.dispatcherLocalInterface.add("package _DISPATCHER_PACKAGE_NAME_; ");
        this.dispatcherLocalInterface.add("");
        this.dispatcherLocalInterface.add("import javax.ejb.Local; ");
        this.dispatcherLocalInterface.add("");
        this.dispatcherLocalInterface.add("@Local  ");
        this.dispatcherLocalInterface.add("public interface _DISPATCHER_INTERFACE_LOCAL_NAME_ extends _DISPATCHER_INTERFACE_NAME_{  ");
        this.dispatcherLocalInterface.add("}  ");
        this.dispatcherRemoteInterface.add("package _DISPATCHER_PACKAGE_NAME_; ");
        this.dispatcherRemoteInterface.add("");
        this.dispatcherRemoteInterface.add("import javax.ejb.Remote; ");
        this.dispatcherRemoteInterface.add("");
        this.dispatcherRemoteInterface.add("@Remote ");
        this.dispatcherRemoteInterface.add("  public interface _DISPATCHER_INTERFACE_REMOTE_NAME_ extends _DISPATCHER_INTERFACE_NAME_{ ");
        this.dispatcherRemoteInterface.add("} ");
    }

    private void initDispatcherBean() {
        this.dispatcherBean.add("@Stateless(mappedName = \"_DISPATCHER_BEAN_NAME_\") ");
        this.dispatcherBean.add("@Remote(_DISPATCHER_INTERFACE_REMOTE_NAME_.class) ");
        this.dispatcherBean.add("@Local(_DISPATCHER_INTERFACE_LOCAL_NAME_.class) ");
        this.dispatcherBean.add("public class _DISPATCHER_BEAN_NAME_ implements _DISPATCHER_INTERFACE_REMOTE_NAME_, ");
        this.dispatcherBean.add("                                              _DISPATCHER_INTERFACE_LOCAL_NAME_ { ");
        this.dispatcherBean.add("");
        this.dispatcherBean.add("    private static SiebelJCAAdapterBase objAccountWSBusServAdapter = ");
        this.dispatcherBean.add("        new SiebelJCAAdapterBase(); ");
        this.dispatcherBean.add("    @Resource(name = \"Logfile\") ");
        this.dispatcherBean.add("    String strLogFile = null; ");
        this.dispatcherBean.add("    @Resource(name = \"LogLevel\") ");
        this.dispatcherBean.add("    String strLogLevel = null; ");
        this.dispatcherBean.add("");
        this.dispatcherBean.add("    public _DISPATCHER_BEAN_NAME_() { ");
        this.dispatcherBean.add("        super(); ");
        this.dispatcherBean.add("    } ");
    }
}

