/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.common;

import com.siebel.integration.common.XSDCompField;
import com.siebel.integration.common.XSDCompKey;
import com.siebel.integration.common.XSDComponent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class XSDObject
implements Serializable {
    private String m_baseXOName = null;
    private String m_xmlTag = null;
    private String m_majorVersion = null;
    private String m_minorVersion = null;
    private String m_rowId = null;
    private Properties m_xoUserProps = null;
    private Vector<XSDComponent> m_xsdComponents = null;
    private String m_tab = "";
    private String m_propTab = "\t";

    public XSDObject() {
    }

    public XSDObject(String string, String string2, String string3, String string4, Properties properties, Vector<XSDComponent> vector) {
        this.m_baseXOName = string;
        this.m_xmlTag = string2;
        this.m_majorVersion = string3;
        this.m_minorVersion = string4;
        this.m_xoUserProps = properties;
        this.m_xsdComponents = vector;
    }

    public void addXSDComponent(XSDComponent xSDComponent) {
        if (this.m_xsdComponents == null) {
            this.m_xsdComponents = new Vector();
        }
        this.m_xsdComponents.add(xSDComponent);
    }

    public void setBaseXOName(String string) {
        this.m_baseXOName = string;
    }

    public String getBaseXOName() {
        return this.m_baseXOName;
    }

    public void setXmlTag(String string) {
        this.m_xmlTag = string;
    }

    public String getXmlTag() {
        return this.m_xmlTag;
    }

    public void setMajorVersion(String string) {
        this.m_majorVersion = string;
    }

    public String getMajorVersion() {
        return this.m_majorVersion;
    }

    public void setMinorVersion(String string) {
        this.m_minorVersion = string;
    }

    public String getMinorVersion() {
        return this.m_minorVersion;
    }

    public void setXoUserProps(Properties properties) {
        this.m_xoUserProps = properties;
    }

    public Properties getXoUserProps() {
        return this.m_xoUserProps;
    }

    public void setXsdComponents(Vector<XSDComponent> vector) {
        this.m_xsdComponents = vector;
    }

    public Vector<XSDComponent> getXsdComponents() {
        return this.m_xsdComponents;
    }

    public String toString() {
        String string = "";
        string = string + "BaseXOName : " + this.getBaseXOName() + "\n";
        string = string + "XmlTag : " + this.getXmlTag() + "\n";
        string = string + "MajorVersion : " + this.getMajorVersion() + "\n";
        string = string + "MinorVersion : " + this.getMinorVersion() + "\n";
        if (this.getXoUserProps() != null) {
            string = string + this.getUserProperties(this.getXoUserProps());
        }
        string = string + this.getXSDComponent(this.getXsdComponents());
        return string;
    }

    private String getXSDComponent(Vector<XSDComponent> vector) {
        String string = "";
        this.m_tab = this.m_tab + "\t";
        this.m_propTab = this.m_propTab + "\t";
        for (int i = 0; i < vector.size(); ++i) {
            XSDComponent xSDComponent = vector.get(i);
            string = string + this.m_tab + "XcName : " + xSDComponent.getXcName() + "\n";
            string = string + this.m_tab + "ParentXCName : " + xSDComponent.getParentXCName() + "\n";
            string = string + this.m_tab + "XmlTag : " + xSDComponent.getXmlTag() + "\n";
            if (xSDComponent.getXcUserProps() != null) {
                string = string + this.getUserProperties(xSDComponent.getXcUserProps());
            }
            if (xSDComponent.getXcFields() != null) {
                string = string + this.getFields(xSDComponent.getXcFields());
            }
            if (xSDComponent.getXcKeys() != null) {
                string = string + this.getKeys(xSDComponent.getXcKeys());
            }
            if (xSDComponent.getChildrenXsdComponents() == null) continue;
            string = string + this.getXSDComponent(xSDComponent.getChildrenXsdComponents());
        }
        return string;
    }

    private String getUserProperties(Properties properties) {
        String string = "";
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            string = string + this.m_propTab + string2 + " -> " + properties.getProperty(string2) + "\n";
        }
        return string;
    }

    private String getFields(Vector<XSDCompField> vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            XSDCompField xSDCompField = vector.get(i);
            string = string + this.m_tab + "\t" + "FieldName : " + xSDCompField.getFieldName() + "\n";
            string = string + this.m_tab + "\t" + "DataType : " + xSDCompField.getDataType() + "\n";
            string = string + this.m_tab + "\t" + "XmlStyle : " + xSDCompField.getXmlStyle() + "\n";
            string = string + this.m_tab + "\t" + "XmlTag : " + xSDCompField.getXmlTag() + "\n";
            if (xSDCompField.getFieldUserProps() == null) continue;
            this.m_propTab = this.m_propTab + "\t";
            string = string + this.getUserProperties(xSDCompField.getFieldUserProps());
        }
        return string;
    }

    private String getKeys(Vector<XSDCompKey> vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            XSDCompKey xSDCompKey = vector.get(i);
            string = string + this.m_tab + "\t" + "KeyName : " + xSDCompKey.getKeyName() + "\n";
            string = string + this.m_tab + "\t" + "KeyType : " + xSDCompKey.getKeyType() + "\n";
            string = string + this.m_tab + "\t" + "KeySequence : " + xSDCompKey.getKeySequence() + "\n";
            if (xSDCompKey.getKeyFields() == null) continue;
            string = string + this.getFields(xSDCompKey.getKeyFields());
        }
        return string;
    }

    public void setRowId(String string) {
        this.m_rowId = string;
    }

    public String getRowId() {
        return this.m_rowId;
    }

    public Properties addXoUserProps(Properties properties) {
        String string;
        if (this.m_xoUserProps == null) {
            this.m_xoUserProps = properties;
            return this.m_xoUserProps;
        }
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = this.m_xoUserProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties2.setProperty(string, this.m_xoUserProps.getProperty(string));
        }
        enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties2.setProperty(string, properties.getProperty(string));
        }
        this.m_xoUserProps = properties2;
        return this.m_xoUserProps;
    }
}

