/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.common;

import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.SiebelDeployment;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class DeployUtil
extends SiebelDeployment {
    private static String deployLogFilePath = null;

    public static void setDeployLogFilePath(String string) {
        deployLogFilePath = string;
    }

    public static String getDeployLogFilePath() {
        return deployLogFilePath;
    }

    public static String javaxXMLBindjar() {
        return DeployUtil.weblogicModulePathJar("javax.xml.bind", "2.1.1");
    }

    public static String javaxXMLWSjar() {
        return DeployUtil.weblogicModulePathJar("javax.xml.ws", "2.1.1");
    }

    public static String javaxJWSjar() {
        return DeployUtil.weblogicModulePathJar("javax.jws", "2.0");
    }

    public static String wlfullClientjar(String string, String string2) {
        return DeployUtil.BuildWlClient(string, string2);
    }

    public static String webservicejar(String string) {
        return DeployUtil.weblogicServerPathJar(string, "webservices");
    }

    private static String weblogicServerPathJar(String string, String string2) {
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Weblogic server jar path: " + string);
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Jar name: " + string2);
        String string3 = null;
        String string4 = null;
        String string5 = string + "server/lib";
        File file = new File(string5);
        if (!file.exists()) {
            SiebelTrace.getInstance().trace(null, 1, "DeployUtil", string5 + "Oracle WebLogic server path does not exist.");
            return string3;
        }
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            SiebelTrace.getInstance().trace(null, 1, "DeployUtil", string5 + " directory contains no jar files.");
            return string3;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = stringArray[i];
            if (!string4.contains(string2)) continue;
            string3 = string + "server/lib" + "/" + string4;
        }
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Full jar path: " + string3);
        return string3;
    }

    public static String BuildWlClient(String string, String string2) {
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Creating wlfullclient.jar from ANT task.");
        String string3 = System.getProperty("java.version");
        String string4 = null;
        String string5 = null;
        if (string3.contains("1.6")) {
            string5 = "inbound_java6_wlfullclient";
            string4 = string + "server/lib" + "/" + "wlfullclient.jar";
            SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Using JDK1.6. Target name is: " + string5 + ". wlfullclient path: " + string4);
        } else if (string3.contains("1.6")) {
            string5 = "inbound_java5_wlfullclient";
            string4 = string + "server/lib" + "/" + "wlfullclient5.jar";
            SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Using JDK1.5. Target name is: " + string5 + ". wlfullclient path: " + string4);
        } else {
            string5 = null;
            string4 = null;
            SiebelTrace.getInstance().trace(null, 1, "DeployUtil", "WebLogic JarBuilder Tool can support JDK 1.5 or JDK 1.6 only. Check with Weblogic documentation for build wlfullclient.jar file with less then JDK 1.5 compiler.");
        }
        if (string5 != null && !DeployUtil.verifywlfullclient(string4)) {
            SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Executing ANT target: " + string5);
            File file = new File(string2 + DeploymentConstants.SYSTEM_SEP + "build.xml");
            Project project = new Project();
            project.setUserProperty("ant.file", file.getAbsolutePath());
            project.setUserProperty("WEBLOGIC.ROOT", string);
            project.init();
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)projectHelper);
            projectHelper.parse(project, (Object)file);
            project.executeTarget(string5);
            SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Executed ANT target: " + string5);
        }
        return string4;
    }

    public static String glassfishRTjar() {
        return DeployUtil.weblogicModulePathJar("glassfish.jaxws.rt", "1.0.0.0_2-1-4");
    }

    private static String weblogicModulePathJar(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = "../modules";
        URL uRL = URLFactory.newDirURL((URL)URLFactory.newDirURL((String)Ide.getOracleHomeDirectory()), (String)string5);
        String string6 = uRL.getPath();
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Jar path for " + string + " version " + string2 + ": " + string6);
        int n = string6.lastIndexOf("/");
        if (n < 0) {
            SiebelTrace.getInstance().trace(null, 1, "DeployUtil", "Invalid weblogic server path.");
            return string3;
        }
        string6 = string6.substring(0, n);
        File file = new File(string6);
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Creating new file object for: " + string6);
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            string3 = null;
            SiebelTrace.getInstance().trace(null, 1, "DeployUtil", string6 + " directory contains no jar files.");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = stringArray[i];
                if (!string4.contains(string)) continue;
                string3 = string6 + "/" + string4;
                SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Full path for " + string + ": " + string3);
            }
        }
        return string3;
    }

    private static boolean verifywlfullclient(String string) {
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "Verifying wlfullclient: " + string);
        boolean bl = new File(string).exists();
        if (bl) {
            SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "File " + string + " exists.");
            return true;
        }
        SiebelTrace.getInstance().trace(null, 3, "DeployUtil", "File " + string + " does not exist.");
        return false;
    }
}

