/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.common;

import com.siebel.integration.deploy.common.DeployUtil;
import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.LogOutputStream;
import com.siebel.integration.deploy.common.StdOutErrorLevel;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;

public abstract class SiebelDeployment {
    protected String siebelSourceRoot = null;
    protected String siebelRoot = null;
    protected String weblogicRoot = null;
    protected String depModel = "DDOnly";
    private LogManager logManager = LogManager.getLogManager();
    private Handler fileHandler = null;
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private Logger logger = null;
    private LogOutputStream los = null;

    public SiebelDeployment() {
        this.logManager.reset();
        try {
            this.fileHandler = new FileHandler(DeployUtil.getDeployLogFilePath(), true);
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelDeployment", "FileHandler is not able to get proper log file path for log console messages.");
            iOException.printStackTrace();
        }
        this.fileHandler.setFormatter(new SimpleFormatter());
        Logger.getLogger("").addHandler(this.fileHandler);
        this.stdout = System.out;
        this.stderr = System.err;
        this.logger = Logger.getLogger("stdout");
        this.los = new LogOutputStream(this.logger, StdOutErrorLevel.STDOUT);
        System.setOut(new PrintStream(this.los, true));
        this.logger = Logger.getLogger("stderr");
        this.los = new LogOutputStream(this.logger, StdOutErrorLevel.STDERR);
        System.setErr(new PrintStream(this.los, true));
    }

    public void init(String string, String string2, String string3) {
        this.siebelSourceRoot = string;
        this.siebelRoot = string2;
        this.weblogicRoot = string3;
        SiebelTrace.getInstance().trace(null, 3, "SiebelDeployment", "Initializing Weblogic root: " + string3 + "; Siebel deployment source path: " + string + "; Siebel Jar path: " + string2);
    }

    public boolean executeANTTasks(ArrayList<String> arrayList, Hashtable<String, String> hashtable) {
        Project project = null;
        SiebelTrace.getInstance().trace(null, 3, "SiebelDeployment", "Executing ANT tasks. ");
        String string = this.siebelRoot + DeploymentConstants.SYSTEM_SEP + "build.xml";
        SiebelTrace.getInstance().trace(null, 3, "SiebelDeployment", "build.xml path: " + string);
        try {
            String string2;
            project = new Project();
            File file = new File(string);
            project.setUserProperty("ant.file", file.getAbsolutePath());
            DefaultLogger defaultLogger = new DefaultLogger();
            defaultLogger.setErrorPrintStream(System.err);
            defaultLogger.setOutputPrintStream(System.out);
            defaultLogger.setMessageOutputLevel(2);
            project.addBuildListener((BuildListener)defaultLogger);
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement();
                String string3 = hashtable.get(string2);
                project.setUserProperty(string2, string3);
            }
            project.setUserProperty("WEBLOGIC.ROOT", this.weblogicRoot);
            project.fireBuildStarted();
            project.init();
            string2 = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)string2);
            string2.parse(project, (Object)file);
            for (String string4 : arrayList) {
                project.executeTarget(string4);
                SiebelTrace.getInstance().trace(null, 3, "SiebelDeployment", "ANT executed target: " + string4);
            }
            project.fireBuildFinished(null);
        }
        catch (BuildException buildException) {
            project.fireBuildFinished(null);
            SiebelTrace.getInstance().trace(null, 1, "SiebelDeployment", "Exception occurred: " + buildException.toString());
            buildException.printStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "SiebelDeployment", "Exception occurred while executing ANT task.");
            return false;
        }
        return true;
    }

    private Hashtable<String, String> initParams(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SIEBEL.DEPLOY.NAME", string);
        hashtable.put("SIEBEL.DEPLOY.PATH", string2);
        hashtable.put("WEBLOGIC.USER.NAME", string3);
        hashtable.put("WEBLOGIC.PASSWORD", string4);
        hashtable.put("WEBLOGIC.PROVIDER.URL", string5);
        hashtable.put("WEBLOGIC.SERVER.NAME", string6);
        if (bl) {
            hashtable.put("SIEBEL.DEPLOY.VERSION", string7);
        }
        return hashtable;
    }

    public boolean start(String string, String string2, String string3, String string4, String string5, String string6) {
        SiebelTrace.getInstance().trace(null, 3, "SiebelDeployment", "Start  " + string + " application.");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("start");
        boolean bl = this.executeANTTasks(arrayList, this.initParams(string, string2, string3, string4, string5, string6, "", false));
        SiebelTrace.getInstance().trace(null, 3, "SiebelDeployment", "Started  " + string + " successfully.");
        return bl;
    }

    public boolean undeploy(String string, String string2, String string3, String string4) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("undeploy");
        hashtable.put("SIEBEL.DEPLOY.NAME", string);
        hashtable.put("WEBLOGIC.USER.NAME", string2);
        hashtable.put("WEBLOGIC.PASSWORD", string3);
        hashtable.put("WEBLOGIC.PROVIDER.URL", string4);
        boolean bl = this.executeANTTasks(arrayList, hashtable);
        return bl;
    }

    public void setDeploymentModel(String string) {
        this.depModel = string;
    }

    public boolean deployToWLS(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) {
        WebLogicDeploymentManager webLogicDeploymentManager;
        String string8 = "SiebelDeployment";
        SiebelTrace.getInstance().trace(null, 3, string8, "Deploying application to weblogic server.");
        if (string == null || string.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid application name.");
            return false;
        }
        if (string2 == null || string2.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid application path.");
            return false;
        }
        if (!new File(string2).exists()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid application path.");
            return false;
        }
        if (string3 == null || string3.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid weblogic user name.");
            return false;
        }
        if (string4 == null || string4.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid weblogic password.");
            return false;
        }
        if (string5 == null || string5.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid weblogic URL.");
            return false;
        }
        if (string6 == null || string6.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, string8, "Error occurred while deploying to Oracle WebLogic server. Invalid server specified.");
            return false;
        }
        String string9 = string5.substring(0, string5.indexOf(":"));
        String string10 = string5.substring(string5.lastIndexOf("/") + 1, string5.lastIndexOf(":"));
        String string11 = string5.substring(string5.lastIndexOf(":") + 1);
        ProgressObject progressObject = null;
        ModuleType moduleType = ModuleType.WAR;
        String string12 = null;
        boolean bl = false;
        try {
            webLogicDeploymentManager = SessionHelper.getRemoteDeploymentManager((String)string9, (String)string10, (String)string11, (String)string3, (String)string4);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, string8, string + " deployment failed due to " + exception.getMessage());
            return false;
        }
        try {
            DeploymentOptions deploymentOptions = new DeploymentOptions();
            deploymentOptions.setRemote(true);
            deploymentOptions.setStageMode("nostage");
            Target[] targetArray = webLogicDeploymentManager.getTargets();
            Target[] targetArray2 = new Target[1];
            for (int i = 0; i < targetArray.length; ++i) {
                if (!targetArray[i].getName().equalsIgnoreCase(string6)) continue;
                targetArray2[0] = targetArray[i];
                break;
            }
            if (targetArray2[0] == null) {
                SiebelTrace.getInstance().trace(null, 1, string8, "Could not find target Oracle Weblogic server " + string6 + " - " + string10 + ":" + string11);
                SiebelTrace.getInstance().trace(null, 1, string8, string + " deployment failed.");
                return false;
            }
            deploymentOptions.setVersionIdentifier(string7);
            deploymentOptions.setName(string);
            switch (n) {
                case 1: {
                    moduleType = ModuleType.RAR;
                    string12 = null;
                    string8 = "ResourceAdapterDeployment";
                    deploymentOptions.setSecurityModel(this.depModel);
                    break;
                }
                case 2: {
                    moduleType = ModuleType.WAR;
                    string12 = null;
                    string8 = "InboundWebServiceDeployment";
                    deploymentOptions.setSecurityModel(this.depModel);
                    break;
                }
                case 3: {
                    moduleType = ModuleType.EJB;
                    string12 = string + ".jar";
                    string8 = "InboundEJBDeployment";
                    deploymentOptions.setSecurityModel(this.depModel);
                    break;
                }
                case 4: {
                    moduleType = ModuleType.EAR;
                    string12 = string + ".jar";
                    string8 = "OutboundDeployment";
                    break;
                }
                case 5: {
                    moduleType = ModuleType.WAR;
                    string12 = null;
                    string8 = "RESTDeployment";
                    deploymentOptions.setSecurityModel(this.depModel);
                    break;
                }
                case 6: {
                    moduleType = ModuleType.EJB;
                    string12 = string + ".jar";
                    string8 = "XsdEJBDeployment";
                    break;
                }
                case 7: {
                    moduleType = ModuleType.EJB;
                    string12 = null;
                    string8 = "MDBDeployment";
                    break;
                }
                default: {
                    SiebelTrace.getInstance().trace(null, 1, string8, string + " deployment could not be started. Unsupported deployment mode.");
                }
            }
            TargetModuleID[] targetModuleIDArray = webLogicDeploymentManager.getAvailableModules(moduleType, targetArray2);
            if (targetModuleIDArray != null && (targetModuleIDArray = webLogicDeploymentManager.filter(targetModuleIDArray, string7 != null ? string + "#" + string7 : string, string12, string7)) != null && targetModuleIDArray.length > 0) {
                bl = true;
                progressObject = webLogicDeploymentManager.redeploy(targetModuleIDArray, new File(string2), (File)null, deploymentOptions);
                SiebelTrace.getInstance().trace(null, 3, string8, "Redeployment of " + string + " done.");
            }
            if (!bl) {
                progressObject = webLogicDeploymentManager.distribute(targetArray2, new File(string2), null, deploymentOptions);
                Thread.sleep(15000L);
                SiebelTrace.getInstance().trace(null, 3, string8, "Distribution of " + string + " done. Starting " + string);
                targetModuleIDArray = webLogicDeploymentManager.getAvailableModules(moduleType, targetArray2);
                if (targetModuleIDArray != null) {
                    targetModuleIDArray = webLogicDeploymentManager.filter(targetModuleIDArray, string7 != null ? string + "#" + string7 : string, string12, string7);
                    progressObject = webLogicDeploymentManager.start(targetModuleIDArray, deploymentOptions);
                    SiebelTrace.getInstance().trace(null, 3, string8, "Successfully started " + string);
                } else {
                    SiebelTrace.getInstance().trace(null, 1, string8, string + " deployed could not be started.");
                    webLogicDeploymentManager.release();
                    return false;
                }
            }
            Thread.sleep(15000L);
            DeploymentStatus deploymentStatus = progressObject.getDeploymentStatus();
            SiebelTrace.getInstance().trace(null, 3, string8, "Deployment of " + string + " " + deploymentStatus.getState());
            webLogicDeploymentManager.release();
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, string8, string + " deployment failed due to " + exception.getMessage());
            webLogicDeploymentManager.release();
            return false;
        }
        return true;
    }
}

