/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.inbound;

import com.siebel.integration.deploy.common.DeployUtil;
import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.DeploymentParameters;
import com.siebel.integration.deploy.common.SiebelDeployment;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class EJBDeployment
extends SiebelDeployment {
    private static final String EJBJAR_XML_PATH = DeploymentConstants.SYSTEM_SEP + "src" + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "ejb-jar.xml";
    private static final String WEBLOGIC_EJBJAR_XML_PATH = DeploymentConstants.SYSTEM_SEP + "src" + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "weblogic-ejb-jar.xml";
    private static final String APPLICATION_XML_PATH = DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "application.xml";
    private static final String WEBLOGIC_APPLICATION_XML_PATH = DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + " weblogic-application.xml";
    private String res_ref_name = null;
    private String jndi_name = null;
    private String ejb_jndi_name = null;
    private String trans_timeout = null;
    private String m_siebLang = null;
    private String m_initPoolSize = null;
    private String m_maxPoolSize = null;
    private Hashtable<String, String> hashtable = new Hashtable();
    private String securityModel = "DDOnly";

    public void init(String string, String string2, String string3, String string4) {
        super.init(string, string2, string3);
        this.m_siebLang = string4;
    }

    public boolean builddeployEJB(DeploymentParameters deploymentParameters) {
        if (deploymentParameters == null) {
            SiebelTrace.getInstance().trace(null, 1, "InboundEJBDeployment", "Deployment parameters specified for EJB is null.");
            return false;
        }
        String string = deploymentParameters.getBsName();
        String string2 = deploymentParameters.getVersion();
        String string3 = deploymentParameters.getGenerateCodePath();
        String string4 = deploymentParameters.getWlsUser();
        String string5 = deploymentParameters.getWlsPwd();
        String string6 = deploymentParameters.getWlsURL();
        String string7 = deploymentParameters.getWLSServer();
        if (string == null || string.equals("") || string3 == null || string3.equals("") || string2 == null || string2.equals("") || string4 == null || string4.equals("") || string5 == null || string5.equals("") || string6 == null || string6.equals("") || string7 == null || string7.equals("")) {
            SiebelTrace.getInstance().trace(null, 1, "InboundEJBDeployment", "Input arguments validation failed for Inbound EJB Deployment. Some or all the parameters specified are empty. Entered values are:  \n; Business service name: " + string + "; Business service version: " + string2 + "; Source code path: " + string3 + "; Weblogic User name: " + string4 + "; Weblogic URL: " + string6 + "; Weblogic Server: " + string7 + "\n");
            return false;
        }
        String string8 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + "EJB" + DeploymentConstants.SYSTEM_SEP + string + "EJB.ear";
        SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", "Starting build and deployment of inbound EJB: " + string + " in " + string7 + " using " + string6);
        if (!this.compileBusinessService(string, string2, string3)) {
            return false;
        }
        if (!this.createEJBDeploymentDescriptors(string, string2, this.res_ref_name, this.jndi_name)) {
            return false;
        }
        if (!this.createDeploymentDescriptors(string, string2)) {
            return false;
        }
        if (!this.BuildEJB(string, string2, string3)) {
            return false;
        }
        super.setDeploymentModel(this.securityModel);
        if (!super.deployToWLS(string + "EJB", string8, string4, string5, string6, string7, string2, 3)) {
            return false;
        }
        SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", "Completed build and deployment of inbound EJB: " + string8);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDeploymentDescriptors(String string, String string2) {
        boolean bl = true;
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Creating Enterprise Application(EAR) deployment descriptors for outbound webservice: " + string);
        String string3 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + "EJB" + DeploymentConstants.SYSTEM_SEP + APPLICATION_XML_PATH;
        String string4 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + "EJB" + DeploymentConstants.SYSTEM_SEP + WEBLOGIC_APPLICATION_XML_PATH;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            File file = new File(string3);
            if (file.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string3 + " exist. Delete!");
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            String string5 = "<?xml version = '1.0' encoding = 'UTF-8'?> \n    <application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee  http://java.sun.com/xml/ns/javaee/application_5.xsd\" version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\"> \n    <display-name>siebel-dispatcher-bean-name</display-name> \n    <module> \n          <ejb>siebel-dispatcher-bean-name.jar</ejb> \n     </module> \n </application> \n";
            string5 = string5.replaceAll("siebel-dispatcher-bean-name", string + "EJB");
            fileOutputStream.write(string5.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string3 + " deployment descriptor successfully created.");
            File file2 = new File(string4);
            if (file2.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string4 + " exist. Delete!");
                file2.delete();
            }
            fileOutputStream2 = new FileOutputStream(file2);
            String string6 = "<?xml version = '1.0' encoding = 'UTF-8'?> \n<weblogic-application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-application http://www.bea.com/ns/weblogic/weblogic-application/1.0/weblogic-application.xsd\" xmlns=\"http://www.bea.com/ns/weblogic/weblogic-application\"/> \n";
            fileOutputStream2.write(string6.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string4 + " deployment descriptor successfully created.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeploymentUtil", "Exception occurred while creating Enterprise Application(EAR) deployment descriptors. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        finally {
            try {
                fileOutputStream.close();
                fileOutputStream2.close();
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 1, "OutboundDeploymentUtil", "Exception occurred while closing Enterprise Application(EAR) deployment descriptors. Details: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEJBDeploymentDescriptors(String string, String string2, String string3, String string4) {
        boolean bl = true;
        String string5 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + EJBJAR_XML_PATH;
        String string6 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + WEBLOGIC_EJBJAR_XML_PATH;
        String string7 = null;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            File file = new File(string5);
            if (file.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", string5 + " exist. Deleting.");
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            string7 = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \nxsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/j2ee/ejb-jar_3_0.xsd\" \n   version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\"> \n<enterprise-beans> \n     <session> \n         <ejb-name>Siebel-Business-Service-NameEJB</ejb-name> \n         <ejb-class>com.siebel.ejb.jca.pSiebel-Business-Service-Lower.Siebel-Business-Service-NameSessionEJBBean</ejb-class> \n         <session-type>Stateless</session-type> \n         <resource-ref> \n             <res-ref-name>resource-reference-name</res-ref-name> \n             <res-type>com.siebel.integration.jca.cci.notx.SiebelNoTxConnectionFactory</res-type> \n             <res-auth>Container</res-auth> \n             <res-sharing-scope>Shareable</res-sharing-scope> \n         </resource-ref> \n     </session> \n</enterprise-beans> \n</ejb-jar>".replaceAll("resource-reference-name", string3);
            string7 = string7.replaceAll("Siebel-Business-Service-Name", string);
            string7 = string7.replaceAll("Siebel-Business-Service-Lower", string.toLowerCase());
            fileOutputStream.write(string7.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", string5 + " deployment descriptor successfully created.");
            File file2 = new File(string6);
            if (file2.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", string6 + " exist. Deleting.");
                file2.delete();
            }
            fileOutputStream2 = new FileOutputStream(file2);
            string7 = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<weblogic-ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \nxsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-ejb-jar.xsd\" \nxmlns=\"http://www.bea.com/ns/weblogic/weblogic-ejb-jar\"> \n   <weblogic-enterprise-bean>\n   <ejb-name>Siebel-Business-Service-NameEJB</ejb-name>\n   <stateless-session-descriptor>\n       <pool>\n           <max-beans-in-free-pool>bean-max-size</max-beans-in-free-pool>\n           <initial-beans-in-free-pool>bean-initial-size</initial-beans-in-free-pool> \n       </pool> \n       <business-interface-jndi-name-map> \n           <business-remote>com.siebel.ejb.jca.pSiebel-Business-Service-Lower.Siebel-Business-Service-NameSessionEJBRemote</business-remote> \n           <jndi-name>EJB-JNDI-Name</jndi-name> \n       </business-interface-jndi-name-map> \n   </stateless-session-descriptor> \n   <resource-description> \n      <res-ref-name>resource-reference-name</res-ref-name> \n      <jndi-name>JNDI-Name</jndi-name> \n   </resource-description> \n   <transaction-descriptor> \n       <trans-timeout-seconds>Siebel-Trans-Timeout</trans-timeout-seconds> \n   </transaction-descriptor> \n   </weblogic-enterprise-bean> \n</weblogic-ejb-jar> ".replaceAll("resource-reference-name", string3);
            string7 = string7.replaceAll("EJB-JNDI-Name", this.ejb_jndi_name);
            string7 = string7.replaceAll("JNDI-Name", string4);
            string7 = string7.replaceAll("Siebel-Business-Service-Name", string);
            string7 = string7.replaceAll("Siebel-Business-Service-Lower", string.toLowerCase());
            string7 = string7.replaceAll("Siebel-Trans-Timeout", this.trans_timeout);
            string7 = string7.replaceAll("bean-initial-size", this.m_initPoolSize);
            string7 = string7.replaceAll("bean-max-size", this.m_maxPoolSize);
            fileOutputStream2.write(string7.getBytes());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeploymentUtil", "Exception occurred while creating Inbound EJB deployment descriptors. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        finally {
            try {
                fileOutputStream.close();
                fileOutputStream2.close();
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 1, "OutboundDeploymentUtil", "Exception occurred while closing Inbound EJB deployment descriptors. Details: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private boolean compileBusinessService(String string, String string2, String string3) {
        this.initBasicParameters(string, string3);
        this.initAdvancedParameters();
        this.hashtable.put("SIEBEL.INBOUND.VERSION", string2);
        SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", "Executing ANT target inbound_pre_build");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("inbound_pre_build");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    private boolean BuildEJB(String string, String string2, String string3) {
        this.initBasicParameters(string, string3);
        this.initAdvancedParameters();
        this.hashtable.put("SIEBEL.INBOUND.VERSION", string2);
        this.hashtable.put("SIEBEL.LANG", this.m_siebLang);
        SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", "Executing ANT target inbound_build_ejbmain");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("inbound_build_ejbmain");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    private void initBasicParameters(String string, String string2) {
        String string3 = string2 + DeploymentConstants.SYSTEM_SEP + string;
        this.hashtable.put("SIEBEL.SOURCE.ROOT", this.siebelSourceRoot);
        this.hashtable.put("SIEBEL_ROOT", this.siebelRoot);
        this.hashtable.put("SIEBEL.BUSINESS.SERVICE.NAME", string);
        this.hashtable.put("SIEBEL.GENERATECODE.ROOT", string3);
        this.hashtable.put("SIEBEL.BS.NAME.LOWER.CASE", string.toLowerCase());
        SiebelTrace.getInstance().trace(null, 3, "InboundEJBDeployment", "Initializing parameters for executing ANT task [Siebel deployment source path: " + this.siebelSourceRoot + "; Siebel Jar path: " + this.siebelRoot + "; Webservice name: " + string + "; Siebel Deployment path: " + string3 + "]");
    }

    private void initAdvancedParameters() {
        this.hashtable.put("WEBLOGIC.FULLCLIENT.JAR", DeployUtil.BuildWlClient(this.weblogicRoot, this.siebelRoot));
        this.hashtable.put("WEBLOGIC.GLASSFISHRT.JAR", DeployUtil.glassfishRTjar());
    }

    public void setsiebelRoot(String string) {
        this.siebelRoot = string;
    }

    public String getsiebelRoot() {
        return this.siebelRoot;
    }

    public void setsiebelSourceRoot(String string) {
        this.siebelSourceRoot = string;
    }

    public String getsiebelSourceRoot() {
        return this.siebelSourceRoot;
    }

    public void setweblogicFullClient(String string) {
        this.weblogicRoot = string;
    }

    public String getweblogicFullClient() {
        return this.weblogicRoot;
    }

    public void setRes_ref_name(String string) {
        this.res_ref_name = string;
    }

    public String getRes_ref_name() {
        return this.res_ref_name;
    }

    public void setJndi_name(String string) {
        this.jndi_name = string;
    }

    public String getJndi_name() {
        return this.jndi_name;
    }

    public void setejb_jndi_name(String string) {
        this.ejb_jndi_name = string;
    }

    public String getejb_jndi_name() {
        return this.ejb_jndi_name;
    }

    public void settrans_timeout(String string) {
        this.trans_timeout = string;
    }

    public String gettrans_timeout() {
        return this.trans_timeout;
    }

    public void setInitPoolSize(String string) {
        this.m_initPoolSize = string;
    }

    public String getInitPoolSize() {
        return this.m_initPoolSize;
    }

    public void setMaxPoolSize(String string) {
        this.m_maxPoolSize = string;
    }

    public String getMaxPoolSize() {
        return this.m_maxPoolSize;
    }

    public void setSecurityModel(String string) {
        this.securityModel = string;
    }

    public String getSecurityModel() {
        return this.securityModel;
    }
}

