/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.inbound;

import com.siebel.integration.deploy.common.DeployUtil;
import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.SiebelDeployment;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class WSDeployment
extends SiebelDeployment {
    private static final String WEB_XML_PATH = DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + "WS" + DeploymentConstants.SYSTEM_SEP + "WEB-INF" + DeploymentConstants.SYSTEM_SEP + "web.xml";
    private static final String WEBLOGIC_XML_PATH = DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + "WS" + DeploymentConstants.SYSTEM_SEP + "WEB-INF" + DeploymentConstants.SYSTEM_SEP + "weblogic.xml";
    private String res_ref_name = null;
    private String jndi_name = null;
    private boolean m_bBackwardCompatibility = false;
    private Hashtable<String, String> hashtable = new Hashtable();
    private String securityModel = "DDOnly";

    @Override
    public void init(String string, String string2, String string3) {
        super.init(string, string2, string3);
    }

    public boolean builddeploywebservice(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string == null || string.equals("") || string3 == null || string3.equals("") || string2 == null || string2.equals("") || string4 == null || string4.equals("") || string5 == null || string5.equals("") || string6 == null || string6.equals("") || string7 == null || string7.equals("")) {
            SiebelTrace.getInstance().trace(null, 1, "InboundWebServiceDeployment", "Input arguments validation failed for Inbound Webservice Deployment. Some or all the parameters specified are empty. Entered values are:  \n; Business service name: " + string + "; Business service version: " + string2 + "; Source code path: " + string3 + "; Weblogic user name: " + string4 + "; Weblogic URL: " + string6 + "; Weblogic server: " + string7 + "\n");
            return false;
        }
        String string8 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + "WS" + DeploymentConstants.SYSTEM_SEP + string + "WebSvc.war";
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Started build and deployment of inbound webservice: " + string + " to " + string7 + " using " + string6);
        if (!this.compileBusinessService(string, string2, string3)) {
            return false;
        }
        if (!this.createDeploymentDescriptors(string, string2, this.res_ref_name, this.jndi_name)) {
            return false;
        }
        if (!this.BuildWebService(string, string2, string3)) {
            return false;
        }
        super.setDeploymentModel(this.securityModel);
        if (!super.deployToWLS(string + "WebSvc", string8, string4, string5, string6, string7, string2, 2)) {
            return false;
        }
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Completed build and deployment of inbound webservice: " + string8);
        return true;
    }

    private void initBasicParameters(String string, String string2) {
        String string3 = string2 + DeploymentConstants.SYSTEM_SEP + string;
        this.hashtable.put("SIEBEL.SOURCE.ROOT", this.siebelSourceRoot);
        this.hashtable.put("SIEBEL_ROOT", this.siebelRoot);
        this.hashtable.put("SIEBEL.BUSINESS.SERVICE.NAME", string);
        this.hashtable.put("SIEBEL.GENERATECODE.ROOT", string3);
        this.hashtable.put("SIEBEL.BS.NAME.LOWER.CASE", string.toLowerCase());
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Initializing parameters to execute ANT task [ Siebel deployment source path: " + this.siebelSourceRoot + "; Siebel jar path: " + this.siebelRoot + "; Webservice name: " + string + "; Siebel deployment path: " + string3 + "]");
    }

    private void initAdvancedParameters() {
        this.hashtable.put("WEBLOGIC.FULLCLIENT.JAR", DeployUtil.BuildWlClient(this.weblogicRoot, this.siebelRoot));
        this.hashtable.put("WEBLOGIC.GLASSFISHRT.JAR", DeployUtil.glassfishRTjar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDeploymentDescriptors(String string, String string2, String string3, String string4) {
        boolean bl = true;
        String string5 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + WEB_XML_PATH;
        String string6 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "inbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + WEBLOGIC_XML_PATH;
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Creating inbound webservice application deployment descriptors files for " + string);
        String string7 = null;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            File file = new File(string5);
            if (file.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", string5 + " exist. Deleting.");
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            string7 = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<web-app xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\" version=\"2.5\" xmlns=\"http://java.sun.com/xml/ns/javaee\">\n  <servlet>\n    <servlet-name>BSNAMEPortTypePort</servlet-name>\n    <servlet-class>com.siebel.service.jca.pbsname.BSNAMEWrapper</servlet-class>\n    <load-on-startup>1</load-on-startup>\n  </servlet>\n  <servlet-mapping>\n    <servlet-name>BSNAMEPortTypePort</servlet-name>\n    <url-pattern>/BSNAMEPortTypePort</url-pattern>\n  </servlet-mapping>\n   <session-config>\n    <session-timeout>35</session-timeout>\n  </session-config>\n  <mime-mapping>\n    <extension>html</extension>\n    <mime-type>text/html</mime-type>\n  </mime-mapping>\n  <mime-mapping>\n    <extension>txt</extension>\n    <mime-type>text/plain</mime-type>\n  </mime-mapping>\n  <resource-ref>\n    <res-ref-name>resource-reference-name</res-ref-name>\n    <res-type>com.siebel.integration.jca.cci.notx.SiebelNoTxConnectionFactory</res-type>\n    <res-auth>Container</res-auth>\n    <res-sharing-scope>Shareable</res-sharing-scope>\n  </resource-ref>\n</web-app>\n".replaceAll("resource-reference-name", string3);
            string7 = string7.replaceAll("BSNAME", string);
            string7 = string7.replaceAll("bsname", string.toLowerCase());
            fileOutputStream.write(string7.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", string5 + " deployment descriptor successfully created.");
            File file2 = new File(string6);
            if (file2.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", string6 + " exist. Deleting.");
                file2.delete();
            }
            fileOutputStream2 = new FileOutputStream(file2);
            string7 = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<weblogic-web-app xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-web-app.xsd\" xmlns=\"http://www.bea.com/ns/weblogic/weblogic-web-app\">\n <resource-description>\n     <res-ref-name>resource-reference-name</res-ref-name>\n     <jndi-name>JNDI-Name</jndi-name>\n</resource-description> \n<container-descriptor>\n  <prefer-web-inf-classes>\n    false\n  </prefer-web-inf-classes>\n</container-descriptor>\n</weblogic-web-app>\n".replaceAll("resource-reference-name", string3);
            string7 = string7.replaceAll("JNDI-Name", string4);
            fileOutputStream2.write(string7.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", string6 + " deployment descriptor successfully created.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeploymentUtil", "Exception occurred while creating Inbound webservice application deployment descriptors. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        finally {
            try {
                fileOutputStream.close();
                fileOutputStream2.close();
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 1, "OutboundDeploymentUtil", "Exception occurred while closing Inbound webservice application deployment descriptors. Details: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public boolean clean(String string, String string2, String string3, String string4, String string5, String string6) {
        super.undeploy(string + "WebSvc", string4, string5, string6);
        this.initBasicParameters(string, string3);
        this.hashtable.put("SIEBEL.INBOUND.VERSION", string2);
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Executing ANT target: clean_webservice");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("clean_webservice");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    private boolean compileBusinessService(String string, String string2, String string3) {
        this.initBasicParameters(string, string3);
        this.initAdvancedParameters();
        this.hashtable.put("SIEBEL.INBOUND.VERSION", string2);
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Executing ANT target: inbound_pre_build");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("inbound_pre_build");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    private boolean BuildWebService(String string, String string2, String string3) {
        this.initBasicParameters(string, string3);
        this.initAdvancedParameters();
        this.hashtable.put("SIEBEL.INBOUND.VERSION", string2);
        SiebelTrace.getInstance().trace(null, 3, "InboundWebServiceDeployment", "Executing ANT target: inbound_build_wsmain");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("inbound_build_wsmain");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    public void setsiebelRoot(String string) {
        this.siebelRoot = string;
    }

    public String getsiebelRoot() {
        return this.siebelRoot;
    }

    public void setsiebelSourceRoot(String string) {
        this.siebelSourceRoot = string;
    }

    public String getsiebelSourceRoot() {
        return this.siebelSourceRoot;
    }

    public void setweblogicFullClient(String string) {
        this.weblogicRoot = string;
    }

    public String getweblogicFullClient() {
        return this.weblogicRoot;
    }

    public void setRes_ref_name(String string) {
        this.res_ref_name = string;
    }

    public String getRes_ref_name() {
        return this.res_ref_name;
    }

    public void setJndi_name(String string) {
        this.jndi_name = string;
    }

    public String getJndi_name() {
        return this.jndi_name;
    }

    public void setBBackwardCompatibility(boolean bl) {
        this.m_bBackwardCompatibility = bl;
    }

    public boolean isBBackwardCompatibility() {
        return this.m_bBackwardCompatibility;
    }

    public void setSecurityModel(String string) {
        this.securityModel = string;
    }

    public String getSecurityModel() {
        return this.securityModel;
    }
}

