/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.mdb;

import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.SiebelDeployment;
import com.siebel.integration.deploy.mdb.MDBDescFileCreator;
import com.siebel.integration.deploy.mdb.MDBSavedParams;
import com.siebel.integration.util.SiebelTrace;
import java.util.ArrayList;
import java.util.Hashtable;

public class MDBDeployment
extends SiebelDeployment {
    private MDBSavedParams m_mdbParams = null;
    private String m_siebLang = null;
    Hashtable<String, String> hashtable = new Hashtable();

    public void InitXMLParameters(MDBSavedParams mDBSavedParams, String string) {
        this.m_mdbParams = mDBSavedParams;
        this.m_siebLang = string;
    }

    public boolean buildDeployMDB(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (string == null || string.equals("") || string2 == null || string2.equals("") || string3 == null || string3.equals("") || string4 == null || string4.equals("") || string5 == null || string5.equals("") || string6 == null || string6.equals("") || string7 == null || string7.equals("") || string8 == null || string8.trim().equals("")) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Input arguments validation failed for resource adapter deployment. Some or all the parameters specified are empty. Entered values are:  \nMDB name: " + string + " ; MDB path: " + string2 + " ; SiebelMDB jar file path: " + string3 + " ; Weblogic User name: " + string4 + " ; Weblogic URL: " + string6 + " ; Weblogic Server: " + string7 + "\n");
            return false;
        }
        this.trace(3, "MDBDeployment", "Starting build and deployment of Siebel resource adapter MDB.");
        this.init(string2, string3, string8);
        if (!this.buildMDB(string, string2, string3)) {
            return false;
        }
        if (!this.createDeploymentDescriptors(string, string2)) {
            return false;
        }
        if (!this.updateMDBAndClean(string, string2)) {
            return false;
        }
        String string9 = string2 + DeploymentConstants.SYSTEM_SEP + "mdb" + DeploymentConstants.SYSTEM_SEP + string + "/SiebelMDB.jar";
        if (!super.deployToWLS(string, string9, string4, string5, string6, string7, null, 7)) {
            return false;
        }
        this.trace(3, "ResourceAdapterDeployment", "Completed build and deployment of Siebel resource adapter MDB " + string);
        return true;
    }

    private boolean updateMDBAndClean(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mdb_update");
        arrayList.add("metainf_clean");
        this.hashtable.put("MDB.NAME", string);
        this.hashtable.put("SIEBEL.SOURCE.ROOT", string2);
        SiebelTrace.getInstance().trace(null, 3, "MDBDeployment", "Initializing parameters to execute ANT task [Siebel deployment path: " + string2 + "; Siebel MDB name: " + string + "]");
        if (!super.executeANTTasks(arrayList, this.hashtable)) {
            return false;
        }
        this.trace(3, "MDBDeployment", "Completed build for Siebel resource adapter MDB " + string + " from ANT task.");
        return true;
    }

    private boolean buildMDB(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mdb_build");
        this.hashtable.put("MDB.NAME", string);
        this.hashtable.put("SIEBEL.SOURCE.ROOT", string2);
        this.hashtable.put("SIEBEL_ROOT", string3);
        this.hashtable.put("SIEBEL.LANG", this.m_siebLang);
        SiebelTrace.getInstance().trace(null, 3, "MDBDeployment", "Initializing parameters to run ANT task [Siebel Jar path: " + string3 + " Siebel Deployment path: " + string2 + " Siebel MDB Name: " + string + "]");
        if (!super.executeANTTasks(arrayList, this.hashtable)) {
            return false;
        }
        this.trace(3, "MDBDeployment", "Completed build for Siebel resource adapter MDB " + string + " from ANT task.");
        return true;
    }

    public void undeployresourceAdapter(String string, String string2, String string3, String string4) {
        super.undeploy(string, string2, string3, string4);
    }

    private boolean createDeploymentDescriptors(String string, String string2) {
        String string3 = string2 + DeploymentConstants.SYSTEM_SEP + "mdb" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "ejb-jar.xml";
        String string4 = string2 + DeploymentConstants.SYSTEM_SEP + "mdb" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "weblogic-ejb-jar.xml";
        MDBDescFileCreator mDBDescFileCreator = new MDBDescFileCreator(this.m_mdbParams);
        return mDBDescFileCreator.CreateEJBJarXML(string3) && mDBDescFileCreator.CreateWLSEJBJarXML(string4);
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }
}

