/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.mdb;

import com.siebel.integration.deploy.mdb.MDBSavedParams;
import com.siebel.integration.util.SiebelTrace;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.validation.SchemaFactory;

public class MDBDescFileCreator {
    private MDBSavedParams mdbSavedParam = null;

    public MDBDescFileCreator() {
    }

    public MDBDescFileCreator(MDBSavedParams mDBSavedParams) {
        if (mDBSavedParams == null) {
            return;
        }
        this.mdbSavedParam = mDBSavedParams;
    }

    public boolean CreateEJBJarXML(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            this.trace(3, "MDBDeployment", "Creating ejb-jar.xml file.");
            string2 = string2 + this.AddXMLHeader();
            this.trace(3, "MDBDeployment", "Added header. Adding envelope.");
            this.WriteSchemaToFile(string, string2);
            this.trace(3, "MDBDeployment", "Created ejb-jar.xml file.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Exception occurred while creating Resource adapter deployment descriptor ra.xml file. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public boolean createApplicationXML(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            this.trace(3, "MDBDeployment", "Creating ejb-jar.xml file");
            string2 = string2 + "<?xml version = '1.0' encoding = 'UTF-8'?>\n<application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee  http://java.sun.com/xml/ns/javaee/application_5.xsd\" version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\">\n\t<module>\n\t  <ejb>SiebelMDB.jar</ejb>\n\t</module>\n</application>\n";
            this.WriteSchemaToFile(string, string2);
            this.trace(3, "MDBDeployment", "Created ejb-jar.xml file.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Exception occurred while creating Resource adapter deployment descriptor ra.xml file. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public boolean createWebLogicApplicationXML(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            this.trace(3, "MDBDeployment", "Creating ejb-jar.xml file");
            string2 = string2 + "<?xml version = '1.0' encoding = 'UTF-8'?>\n<weblogic-application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-application http://www.bea.com/ns/weblogic/weblogic-application/1.0/weblogic-application.xsd\" xmlns=\"http://www.bea.com/ns/weblogic/weblogic-application\"/>";
            this.trace(3, "MDBDeployment", "Completed creating xml. Now writing to the file");
            this.WriteSchemaToFile(string, string2);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Exception occurred while creating Resource adapter deployment descriptor ra.xml file. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String AddXMLHeader() {
        String string = "";
        string = string + "<?xml version = '1.0' encoding = 'windows-1252'?>\r\n";
        string = string + "<ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n";
        string = string + "         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd\"\r\n";
        string = string + "         version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\">\r\n";
        string = string + "  <enterprise-beans>\r\n";
        string = string + " <message-driven>\r\n";
        string = string + this.AddEJBParamTag();
        string = string + "   <ejb-class>com.siebel.integration.jca.cci.SiebelJCAMessageDrivenBean</ejb-class>\r\n";
        string = string + "   <transaction-type>Container</transaction-type>\r\n";
        string = string + "   </message-driven>\r\n";
        string = string + "</enterprise-beans>\r\n";
        string = string + "</ejb-jar>\r\n";
        return string;
    }

    private String AddEJBParamTag() {
        String string = "";
        string = string + "   <display-name>" + this.mdbSavedParam.getMDBName() + "</display-name>" + "\r\n";
        string = string + "   <ejb-name>" + this.mdbSavedParam.getEJBname() + "</ejb-name>" + "\r\n";
        return string;
    }

    public boolean CreateWLSEJBJarXML(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            this.trace(3, "MDBDeployment", "Creating weblogic-ejb-jar.xml file.");
            string2 = string2 + this.AddXWLSMLHeader();
            this.trace(3, "MDBDeployment", "Added header. Adding envelope.");
            this.trace(3, "MDBDeployment", "Successfully created weblogic-ejb-jar.xml.");
            this.WriteSchemaToFile(string, string2);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Exception occurred while creating Resource adapter deployment descriptor ra.xml file. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String AddXWLSMLHeader() {
        String string = "";
        string = string + "<?xml version = '1.0' encoding = 'windows-1252'?>\r\n";
        string = string + "<weblogic-ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n";
        string = string + "                  xsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-ejb-jar http://www.bea.com/ns/weblogic/weblogic-ejb-jar/1.0/weblogic-ejb-jar.xsd\"\r\n";
        string = string + "                  xmlns=\"http://www.bea.com/ns/weblogic/weblogic-ejb-jar\">\r\n";
        string = string + " <weblogic-enterprise-bean>\r\n";
        string = string + "  <ejb-name>" + this.mdbSavedParam.getEJBname() + "</ejb-name>" + "\r\n";
        string = string + "  <message-driven-descriptor>\r\n";
        string = string + "   <pool>\r\n";
        string = string + this.AddWLSEJBParamTag();
        string = string + "   </pool>\r\n";
        string = string + "   <resource-adapter-jndi-name>" + this.mdbSavedParam.getRAJNDIName() + "</resource-adapter-jndi-name>" + "\r\n";
        string = string + "  </message-driven-descriptor>\r\n";
        string = string + " </weblogic-enterprise-bean>\r\n";
        string = string + "</weblogic-ejb-jar>\r\n";
        return string;
    }

    private String AddWLSEJBParamTag() {
        String string = "";
        string = string + "    <max-beans-in-free-pool>" + this.mdbSavedParam.getMaxFreePoolSize() + "</max-beans-in-free-pool>" + "\r\n";
        string = string + "    <initial-beans-in-free-pool>" + this.mdbSavedParam.getInitFreePoolSize() + "</initial-beans-in-free-pool>" + "\r\n";
        return string;
    }

    private void WriteSchemaToFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes("UTF-8"));
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        catch (FileNotFoundException fileNotFoundException) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Write Schema to file failed. Exception: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Write Schema to file failed. Exception: " + iOException.getMessage());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "MDBDeployment", "Write Schema to file failed. Exception: " + exception.getMessage());
        }
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }
}

