/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.outbound;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.deploy.common.DeployUtil;
import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.SiebelDeployment;
import com.siebel.integration.util.SiebelTrace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.wsdl.WSDLException;
import oracle.bali.xml.share.TransactionToken;
import oracle.j2ee.ws.common.tools.api.WSFileSystem;
import oracle.jdeveloper.webservices.tools.FileSystem;
import oracle.jdeveloper.webservices.tools.WebServiceTools;
import oracle.jdevimpl.webservices.tools.wsa.Assembler;
import oracle.jdevimpl.webservices.tools.wsa.JDevWSFileSystem;

public class EARDeployment
extends SiebelDeployment {
    private static final String APPLICATION_XML_PATH = DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "application.xml";
    private static final String WEBLOGIC_APPLICATION_XML_PATH = DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + " weblogic-application.xml";
    private static final String OUTBOUND_EJB_JAR_XML = DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "ejb-jar.xml";
    private static final String OUTBOUD_WEBLOGIC_EJB_JAR_XML = DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "weblogic-ejb-jar.xml";
    private String strLogLevel = null;
    private String strLogFile = null;
    private String m_siebLang = null;
    private String strOutboundJNDIName = null;
    private String strOutboundTransTime = null;
    private String m_extWSDLName = null;
    Hashtable<String, String> hashtable = new Hashtable();
    private String securityModel = "DDOnly";

    public void init(String string, String string2, String string3, String string4) {
        super.init(string, string2, string3);
        this.m_siebLang = string4;
    }

    private void initBasicParameters(String string, String string2, String string3) {
        this.hashtable.put("SIEBEL.SOURCE.ROOT", this.siebelSourceRoot);
        this.hashtable.put("SIEBEL_ROOT", this.siebelRoot);
        this.hashtable.put("WEBSERVICE.NAME", string);
        this.hashtable.put("EAR.VERSION", string2);
        this.hashtable.put("PROXY.WSDL.FILE", string3);
        this.hashtable.put("SIEBEL.LANG", this.m_siebLang);
        this.hashtable.put("SIEBEL.OUTBOUND_LOG_FILE", this.strLogFile);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", " Initializing parameters to execute ANT task [ Siebel deployment source path: " + this.siebelSourceRoot + "; Siebel jar path: " + this.siebelRoot + "; Webservice name: " + string + "; Enterprise application version: " + string2 + "; Webservice path: " + string3 + " ]");
    }

    private void initAdvancedParameters() {
        String string = DeployUtil.glassfishRTjar();
        String string2 = DeployUtil.javaxJWSjar();
        String string3 = DeployUtil.javaxXMLWSjar();
        String string4 = DeployUtil.javaxXMLBindjar();
        this.hashtable.put("WEBLOGIC.GLASSFISHRT.JAR", string);
        this.hashtable.put("JWS.JAR.FILE", string2);
        this.hashtable.put("XML.WS.JAR.FILE", string3);
        this.hashtable.put("XML.BIND.JAR.FILE", string4);
        this.hashtable.put("WEBLOGIC.FULLCLIENT.JAR", DeployUtil.BuildWlClient(this.weblogicRoot, this.siebelRoot));
        this.hashtable.put("WEBSERVICE.JAR.FILE", DeployUtil.webservicejar(this.weblogicRoot));
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Initializing parameters to execute ANT task [ Siebel deployment source path: " + this.siebelSourceRoot + "; Siebel jar path: " + this.siebelRoot + "; Glassfish RT path: " + string + "; JWS path: " + string2 + "; XML WS path: " + string3 + "; XML bind path: " + string4);
    }

    public boolean builddeployOutboundEAR(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("") || string3 == null || string3.trim().equals("") || string4 == null || string4.trim().equals("") || string5 == null || string5.trim().equals("") || string6 == null || string6.trim().equals("") || string7 == null || string7.trim().equals("")) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", "Input arguments validation failed for Outbound Deployment. Some or all the parameters specified are empty. Entered values are:  \n; Webservice name: " + string + "; EAR version: " + string2 + "; Webservice WSDL file path: " + string3 + "; Weblogic user name: " + string4 + "; Weblogic URL: " + string6 + "; Weblogic server: " + string7);
            return false;
        }
        String string8 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + string + ".ear";
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Starting build and deployment of outbound webservice: " + string + "; EAR version: " + string2 + " in " + string7 + " using " + string6);
        if (!this.webservicePreBuild(string, string2, string3)) {
            return false;
        }
        if (!this.webserviceWSDLget(string, string2, string3)) {
            return false;
        }
        if (!this.webserviceClientGen(this.siebelSourceRoot, string, string2)) {
            return false;
        }
        if (!this.createBuildProxy(string, string2, string3)) {
            return false;
        }
        if (!this.createDeploymentDescriptors(string, string2)) {
            return false;
        }
        if (!this.createEJBDeploymentDescriptors(string, string2)) {
            return false;
        }
        if (!this.buildEAR(string, string2, string3)) {
            return false;
        }
        super.setDeploymentModel(this.securityModel);
        if (!super.deployToWLS(string, string8, string4, string5, string6, string7, string2, 4)) {
            return false;
        }
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Completed build and deployment of outbound webservice: " + string);
        return true;
    }

    private boolean webservicePreBuild(String string, String string2, String string3) {
        this.initBasicParameters(string, string2, string3);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Executing ANT target outbound_pre_build");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("outbound_pre_build");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    private boolean createBuildProxy(String string, String string2, String string3) {
        this.initBasicParameters(string, string2, string3);
        this.initAdvancedParameters();
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Executing ANT target outbound_build_proxy");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("outbound_build_proxy");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    private boolean webserviceWSDLget(String string, String string2, String string3) {
        String string4 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "wsdl";
        if (!new File(string4).exists()) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", CSSMsgMgr.get(8716817) + ": " + string4);
            return false;
        }
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "WSDL specified: " + string3);
        if (string3.startsWith("http://") || string3.startsWith("https://") || string3.startsWith("HTTP://") || string3.startsWith("HTTPS://")) {
            return this.DownloadWSDLFromURL(string4, string3);
        }
        if (!new File(string3).exists()) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", CSSMsgMgr.get(8716819) + ": " + string3);
            return false;
        }
        return this.DownloadWSDLFromURL(string4, "file:///" + string3);
    }

    private boolean DownloadWSDLFromURL(String string, String string2) {
        SiebelTrace.getInstance().trace(null, 3, "Deployment", "Downloading wsdl from URL: " + string2);
        if (string == null || string.trim().equals("")) {
            return false;
        }
        if (string2 == null || string2.trim().equals("")) {
            return false;
        }
        URL uRL = null;
        WebServiceTools webServiceTools = new WebServiceTools();
        FileSystem fileSystem = new FileSystem(null, (TransactionToken)null);
        File file = new File(string);
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            SiebelTrace.getInstance().trace(null, 1, "Deployment", "Exception occurred while downloading WSDL. Detailed exception: " + malformedURLException.getMessage());
            return false;
        }
        Assembler.getAssembler().setFileSystem((WSFileSystem)new JDevWSFileSystem());
        File[] fileArray = null;
        try {
            fileArray = webServiceTools.fetchWsdlExt(uRL, null, file, null, fileSystem);
            this.m_extWSDLName = fileArray[0].toString();
        }
        catch (WSDLException wSDLException) {
            SiebelTrace.getInstance().trace(null, 1, "Deployment", "Exception occurred while downloading WSDL. Detailed exception: " + wSDLException.getMessage());
            return false;
        }
        return true;
    }

    private boolean webserviceClientGen(String string, String string2, String string3) {
        if (this.m_extWSDLName == null || this.m_extWSDLName.trim().equals("")) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", CSSMsgMgr.get(8716888) + ": " + this.m_extWSDLName);
            return false;
        }
        File file = new File(this.m_extWSDLName);
        if (!file.exists()) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", CSSMsgMgr.get(8716819) + ": " + this.m_extWSDLName);
            return false;
        }
        String string4 = file.getName();
        if (string4 == null || string4.trim().isEmpty()) {
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", "Proxy WSDL file name is empty.");
            throw new IllegalArgumentException("Proxy WSDL file name is empty.");
        }
        this.initBasicParameters(string2, string3, this.m_extWSDLName);
        this.initAdvancedParameters();
        this.hashtable.put("PROXY.WSDL.FILE.NAME", string4);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", " Executing ANT target outbound_build_proxy_classes");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("outbound_build_proxy_classes");
        if (super.executeANTTasks(arrayList, this.hashtable)) {
            String string5 = string + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + string3 + DeploymentConstants.SYSTEM_SEP + "classes" + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "jax-ws-catalog.xml";
            String string6 = "<?xml version='1.0' encoding='UTF-8'?>\n<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"system\">\n<system systemId=\"META-INF/wsdls/WSDLFileName\" uri=\"./wsdls/WSDLFileName\"/>\n</catalog>".replaceAll("WSDLFileName", string4);
            try {
                File file2 = new File(string5);
                if (file2.exists()) {
                    file2.delete();
                }
                file2.createNewFile();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string5, true));
                bufferedWriter.write(string6);
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", CSSMsgMgr.get(8718314) + iOException.getMessage());
                throw new IllegalArgumentException(CSSMsgMgr.get(8718314));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", CSSMsgMgr.get(8718314) + illegalArgumentException.getMessage());
                throw new IllegalArgumentException(CSSMsgMgr.get(8718314));
            }
            return true;
        }
        return false;
    }

    private boolean buildEAR(String string, String string2, String string3) {
        this.initBasicParameters(string, string2, string3);
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Executing ANT target outbound_build_ejb,outbound_build_ear");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("outbound_build_ejb");
        arrayList.add("outbound_build_ear");
        return super.executeANTTasks(arrayList, this.hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDeploymentDescriptors(String string, String string2) {
        boolean bl = true;
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Creating Enterprise Application(EAR) deployment descriptors for outbound webservice " + string);
        String string3 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + APPLICATION_XML_PATH;
        String string4 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "deploy" + DeploymentConstants.SYSTEM_SEP + WEBLOGIC_APPLICATION_XML_PATH;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            File file = new File(string3);
            if (file.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string3 + " exist. Deleting.");
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            String string5 = "<?xml version = '1.0' encoding = 'UTF-8'?> \n    <application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee  http://java.sun.com/xml/ns/javaee/application_5.xsd\" version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\"> \n    <display-name>siebel-dispatcher-bean-name</display-name> \n    <module> \n          <ejb>siebel-dispatcher-bean-name.jar</ejb> \n     </module> \n </application> \n";
            string5 = string5.replaceAll("siebel-dispatcher-bean-name", string);
            fileOutputStream.write(string5.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string3 + " deployment descriptor successfully created.");
            File file2 = new File(string4);
            if (file2.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string4 + " exist. Deleting.");
                file2.delete();
            }
            fileOutputStream2 = new FileOutputStream(file2);
            String string6 = "<?xml version = '1.0' encoding = 'UTF-8'?> \n<weblogic-application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-application http://www.bea.com/ns/weblogic/weblogic-application/1.0/weblogic-application.xsd\" xmlns=\"http://www.bea.com/ns/weblogic/weblogic-application\"/> \n";
            string6 = string6.replaceAll("EJB-JNDI-Name", this.strOutboundJNDIName);
            fileOutputStream2.write(string6.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string4 + " deployment descriptor successfully created.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", "Exception occurred while creating Enterprise Application(EAR) deployment descriptors. Details: " + exception.getMessage());
            bl = false;
        }
        finally {
            try {
                fileOutputStream.close();
                fileOutputStream2.close();
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 1, "OutboundDeployment", "Exception occurred while closing Enterprise Application(EAR) deployment descriptors. Details: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createEJBDeploymentDescriptors(String string, String string2) {
        boolean bl = true;
        SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Creating EJB deployment descriptors for outbound webservice " + string);
        String string3 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "source" + DeploymentConstants.SYSTEM_SEP + OUTBOUND_EJB_JAR_XML;
        String string4 = this.siebelSourceRoot + DeploymentConstants.SYSTEM_SEP + "outbound" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + string2 + DeploymentConstants.SYSTEM_SEP + "source" + DeploymentConstants.SYSTEM_SEP + OUTBOUD_WEBLOGIC_EJB_JAR_XML;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            File file = new File(string3);
            if (file.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string3 + " exist. Deleting.");
                file.delete();
            }
            fileOutputStream = new FileOutputStream(file);
            String string5 = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/j2ee/ejb-jar_3_0.xsd\"\n         version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\">\n     <enterprise-beans>\n    <session>\n      <ejb-name>siebel-dispatcher-bean-name</ejb-name>\n       <ejb-class>com.siebel.eai.outbound.dispatcher.DispatcherSessionBean</ejb-class>\n      <session-type>Stateless</session-type>\n\t  <!-- Supported log levels: \"FATAL\", \"ERROR\", \"WARN\", \"INFO\", \"DETAIL\", \"DEBUG\"-->\n\t   <env-entry>\n         <env-entry-name>LogLevel</env-entry-name>\n         <env-entry-type>java.lang.String</env-entry-type>\n         <env-entry-value>StrLogLevel</env-entry-value>\n      </env-entry>\n      </session>\n    </enterprise-beans>\n    </ejb-jar>".replaceAll("StrLogLevel", this.strLogLevel);
            string5 = string5.replaceAll("siebel-dispatcher-bean-name", string);
            fileOutputStream.write(string5.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string3 + " deployment descriptor successfully created.");
            File file2 = new File(string4);
            if (file2.exists()) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string4 + " exist. Deleting.");
                file2.delete();
            }
            fileOutputStream2 = new FileOutputStream(file2);
            String string6 = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<weblogic-ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n                  xsi:schemaLocation=\"http://www.bea.com/ns/weblogic/weblogic-ejb-jar http://www.bea.com/ns/weblogic/weblogic-ejb-jar/1.0/weblogic-ejb-jar.xsd\"\n                  xmlns=\"http://www.bea.com/ns/weblogic/weblogic-ejb-jar\">\n  <weblogic-enterprise-bean>\n    <ejb-name>siebel-dispatcher-bean-name</ejb-name>\n    <stateless-session-descriptor>\n      <pool>\n        <max-beans-in-free-pool>20</max-beans-in-free-pool>\n        <initial-beans-in-free-pool>6</initial-beans-in-free-pool>\n      </pool>\n      <business-interface-jndi-name-map>\n        <business-remote>com.siebel.eai.outbound.dispatcher.DispatcherSessionRemote</business-remote>\n        <jndi-name>EJB-JNDI-Name</jndi-name>\n      </business-interface-jndi-name-map>\n    </stateless-session-descriptor>\n\t <transaction-descriptor>\n        <trans-timeout-seconds>Siebel-Trans-Timeout</trans-timeout-seconds>\n     </transaction-descriptor> \n  </weblogic-enterprise-bean>\n</weblogic-ejb-jar>\n".replaceAll("Siebel-Trans-Timeout", this.strOutboundTransTime);
            string6 = string6.replaceAll("EJB-JNDI-Name", this.strOutboundJNDIName);
            string6 = string6.replaceAll("siebel-dispatcher-bean-name", string);
            fileOutputStream2.write(string6.getBytes());
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", string4 + " deployment descriptor successfully created.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Exception occurred while creating Outbound EJB deployment descriptors. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        finally {
            try {
                fileOutputStream.close();
                fileOutputStream2.close();
            }
            catch (Exception exception) {
                SiebelTrace.getInstance().trace(null, 3, "OutboundDeployment", "Exception occurred while closing Outbound EJB deployment descriptors. Details: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public void setstrOutboundJNDIName(String string) {
        this.strOutboundJNDIName = string;
    }

    public String getstrOutboundJNDIName() {
        return this.strOutboundJNDIName;
    }

    public void setstrOutboundTransTime(String string) {
        this.strOutboundTransTime = string;
    }

    public String getstrOutboundTransTime() {
        return this.strOutboundTransTime;
    }

    public String getstrLogLevel() {
        return this.strLogLevel;
    }

    public void setstrLogLevel(String string) {
        this.strLogLevel = string;
    }

    public void setstrLogFile(String string) {
        this.strLogFile = string;
    }

    public String getstrLogFile() {
        return this.strLogFile;
    }

    public void setSecurityModel(String string) {
        this.securityModel = string;
    }

    public String getSecurityModel() {
        return this.securityModel;
    }
}

