/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.resourceadapter;

import com.siebel.integration.deploy.common.DeploymentConstants;
import com.siebel.integration.deploy.common.SiebelDeployment;
import com.siebel.integration.deploy.resourceadapter.RAXmlSavedParams;
import com.siebel.integration.deploy.resourceadapter.WebLogicRASavedParams;
import com.siebel.integration.deploy.resourceadapter.XMLFileCreator;
import com.siebel.integration.util.SiebelTrace;
import java.util.ArrayList;
import java.util.Hashtable;

public class RADeployment
extends SiebelDeployment {
    Hashtable<String, String> hashtable = new Hashtable();
    private RAXmlSavedParams m_raXml = null;
    private WebLogicRASavedParams m_wlsRAXml = null;
    private String securityModel = null;

    public void setSecurityModel(String string) {
        this.securityModel = string;
    }

    public String getSecurityModel() {
        return this.securityModel;
    }

    public void InitXMLParameters(RAXmlSavedParams rAXmlSavedParams, WebLogicRASavedParams webLogicRASavedParams) {
        this.m_raXml = rAXmlSavedParams;
        this.m_wlsRAXml = webLogicRASavedParams;
    }

    public boolean builddeployResourceAdapter(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string == null || string.equals("") || string2 == null || string2.equals("") || string3 == null || string3.equals("") || string4 == null || string4.equals("") || string5 == null || string5.equals("") || string6 == null || string6.equals("") || string7 == null || string7.equals("")) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Input arguments validation failed for resource adapter deployment. Some or all the parameters specified are empty. Entered values are:  \n Resource Adapter name: " + string + "; Resource Adapter path: " + string2 + "; Siebel jar file path: " + string3 + "; Weblogic User name: " + string4 + "; Weblogic URL: " + string6 + "; Weblogic Server: " + string7 + "\n");
            return false;
        }
        this.trace(3, "ResourceAdapterDeployment", "Starting build and deployment of Siebel resource adapter.");
        if (!this.buildResourceAdapter(string, string2, string3)) {
            return false;
        }
        if (!this.createDeploymentDescriptors(string, string2)) {
            return false;
        }
        String string8 = string2 + DeploymentConstants.SYSTEM_SEP + "resourceadapter" + DeploymentConstants.SYSTEM_SEP + string;
        super.setDeploymentModel(this.securityModel);
        if (!this.deployToWLS(string, string8, string4, string5, string6, string7, null, 1)) {
            return false;
        }
        this.trace(3, "ResourceAdapterDeployment", "Completed build and deployment of Siebel resource adapter " + string);
        return true;
    }

    private void initParams(String string, String string2, String string3, String string4, String string5, String string6) {
        this.hashtable.put("SIEBEL.DEPLOY.NAME", string);
        this.hashtable.put("SIEBEL.DEPLOY.PATH", string2);
        this.hashtable.put("WEBLOGIC.USER.NAME", string3);
        this.hashtable.put("WEBLOGIC.PASSWORD", string4);
        this.hashtable.put("WEBLOGIC.PROVIDER.URL", string5);
        this.hashtable.put("WEBLOGIC.SERVER.NAME", string6);
    }

    public void undeployresourceAdapter(String string, String string2, String string3, String string4) {
        super.undeploy(string, string2, string3, string4);
    }

    private boolean buildResourceAdapter(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("adapter_build");
        this.hashtable.put("RESOURCE.ADAPTER.NAME", string);
        this.hashtable.put("SIEBEL.SOURCE.ROOT", string2);
        this.hashtable.put("SIEBEL_ROOT", string3);
        this.hashtable.put("SIEBEL.LANG", this.m_raXml.getSiebelLang());
        SiebelTrace.getInstance().trace(null, 3, "ResourceAdapterDeployment", "Initializing parameters to execute ANT task [Siebel Jar path: " + string3 + "; Siebel deployment path: " + string2 + "; Siebel resource adapter name: " + string + "]");
        if (!super.executeANTTasks(arrayList, this.hashtable)) {
            return false;
        }
        this.trace(3, "ResourceAdapterDeployment", "Completed build for Siebel resource adapter " + string + " from ANT task.");
        return true;
    }

    private boolean createDeploymentDescriptors(String string, String string2) {
        String string3 = string2 + DeploymentConstants.SYSTEM_SEP + "resourceadapter" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "ra.xml";
        String string4 = string2 + DeploymentConstants.SYSTEM_SEP + "resourceadapter" + DeploymentConstants.SYSTEM_SEP + string + DeploymentConstants.SYSTEM_SEP + "META-INF" + DeploymentConstants.SYSTEM_SEP + "weblogic-ra.xml";
        XMLFileCreator xMLFileCreator = new XMLFileCreator(this.m_raXml, this.m_wlsRAXml);
        return xMLFileCreator.CreateRAXml(string3) && xMLFileCreator.CreateWLSRaXml(string4);
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }
}

