/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.deploy.resourceadapter;

import com.siebel.common.common.CSSException;
import com.siebel.common.crypt.SiebelCipher;
import com.siebel.integration.deploy.resourceadapter.RAXmlSavedParams;
import com.siebel.integration.deploy.resourceadapter.WebLogicRASavedParams;
import com.siebel.integration.util.SiebelTrace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class XMLFileCreator {
    private RAXmlSavedParams savedParam = null;
    private WebLogicRASavedParams wlsRAParams = null;
    private String connUrl = null;

    public XMLFileCreator() {
    }

    public XMLFileCreator(RAXmlSavedParams rAXmlSavedParams, WebLogicRASavedParams webLogicRASavedParams) {
        if (rAXmlSavedParams == null || webLogicRASavedParams == null) {
            return;
        }
        this.savedParam = rAXmlSavedParams;
        this.wlsRAParams = webLogicRASavedParams;
    }

    public boolean CreateRAXml(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            this.trace(3, "ResourceAdapterDeployment", "Creating ra.xml file.");
            string2 = string2 + this.AddXMLHeader();
            this.trace(3, "ResourceAdapterDeployment", "Added header. Adding envelope.");
            string2 = string2 + this.AddRAParamTag();
            string2 = string2 + "</connector>";
            this.WriteSchemaToFile(string, string2);
            this.trace(3, "ResourceAdapterDeployment", "Successfully created ra.xml file.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Exception occurred while creating Resource adapter deployment descriptor ra.xml file. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String AddXMLHeader() {
        String string = "";
        string = string + "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n";
        string = string + "<connector xmlns=\"http://java.sun.com/xml/ns/j2ee\"";
        string = string + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        string = string + " xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee   http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd\"";
        string = string + " version=\"1.5\">\r\n";
        string = string + " <display-name>SiebelJCAAdapter</display-name>\r\n";
        string = string + " <vendor-name>Oracle</vendor-name>\r\n";
        string = string + " <eis-type>Siebel CRM</eis-type>\r\n";
        string = string + " <resourceadapter-version>1.0</resourceadapter-version>\r\n";
        return string;
    }

    private String AddRAParamTag() throws CSSException {
        String string = "";
        string = string + " <resourceadapter>\r\n";
        string = string + "<resourceadapter-class>com.siebel.integration.adapter.SiebelJCAAdapterBase</resourceadapter-class>\r\n";
        if (this.savedParam.isMdbEnabled()) {
            string = string + this.AddMDBProp();
        }
        string = string + "  <outbound-resourceadapter>\r\n";
        string = string + "   <connection-definition>\r\n";
        string = string + "    <managedconnectionfactory-class>com.siebel.integration.jca.spi.notx.SiebelNoTxManagedConnectionFactory</managedconnectionfactory-class>\r\n";
        string = string + this.AddConnURLConfigProp();
        string = string + this.AddSessionTokenMaxAgeProp();
        string = string + this.AddSessionTokenTimeoutProp();
        string = string + this.AddSessionTimeoutProp();
        string = string + this.AddConnectionsPerEAIProcessProp();
        string = string + this.AddB2BModeProp();
        string = string + this.AddB2BUserProp();
        string = string + this.AddB2BPasswordProp();
        string = string + this.AddUserNameProp();
        string = string + this.AddPasswordProp();
        string = string + this.AddSiebelLanguageProp();
        string = string + this.AddResRefNameProp();
        string = string + this.AddCacheDurationProp();
        string = string + this.AddLogFileProp();
        string = string + this.AddLogLevelProp();
        string = string + this.AddMaxAnonUsersProp();
        if (this.savedParam.getSSLParams() != null) {
            string = string + this.AddSSLParams();
        }
        if (this.savedParam.getVirtualHost() != null && !this.savedParam.getVirtualHost().equals("")) {
            string = string + this.AddVirtualHost();
        }
        string = string + "    <connectionfactory-interface>javax.resource.cci.ConnectionFactory</connectionfactory-interface>\r\n";
        string = string + "    <connectionfactory-impl-class>com.siebel.integration.jca.cci.notx.SiebelNoTxConnectionFactory</connectionfactory-impl-class>\r\n";
        string = string + "    <connection-interface>javax.resource.cci.Connection</connection-interface>\r\n";
        string = string + "    <connection-impl-class>com.siebel.integration.jca.cci.notx.SiebelNoTxConnection</connection-impl-class>\r\n";
        string = string + "   </connection-definition>\r\n";
        string = string + "   <transaction-support>NoTransaction</transaction-support>\r\n";
        string = string + this.AddSecurityProp();
        string = string + "   <reauthentication-support>false</reauthentication-support>\r\n";
        string = string + "  </outbound-resourceadapter>\r\n";
        if (this.savedParam.isMdbEnabled()) {
            string = string + "        <inbound-resourceadapter>";
            string = string + "            <messageadapter>";
            string = string + "                <messagelistener>";
            string = string + "                    <messagelistener-type>javax.resource.cci.MessageListener</messagelistener-type>";
            string = string + "                    <activationspec>";
            string = string + "                        <activationspec-class>com.siebel.integration.jca.spi.SiebelActivationSpec</activationspec-class>";
            string = string + "                    </activationspec>";
            string = string + "                </messagelistener>";
            string = string + "            </messageadapter>";
            string = string + "        </inbound-resourceadapter>";
        }
        string = string + " </resourceadapter>\r\n";
        return string;
    }

    private String AddConnURLConfigProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>ConnectionURL</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        this.connUrl = this.savedParam.getVirtualHost() == null || this.savedParam.getVirtualHost().trim().equals("") ? "siebel." + this.savedParam.getProtocol() + "://" + this.savedParam.getMachineName() + ":" + this.savedParam.getPort() + "/" + this.savedParam.getEnterpriseName() + "/" + this.savedParam.getEaiAlias() : "siebel." + this.savedParam.getProtocol() + "://" + this.savedParam.getMachineName() + "/" + this.savedParam.getEnterpriseName() + "/" + this.savedParam.getEaiAlias();
        string = string + "     <config-property-value>" + this.connUrl + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddSessionTokenMaxAgeProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>SessionTokenMaxAge</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getSessioTokenMaxAge() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddMDBProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>QueueConnectionFactory</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getQueueConnFactory() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>ReceiveQueue</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getReceiveQ() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>SendQueue</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getSendQ() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>JCAReceiverLog</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getReceiverLog() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>JCASenderLog</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getSenderLog() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddSessionTokenTimeoutProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>SessionTokenTimeout</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getSessionTokenTimeout() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddSessionTimeoutProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>SessionTimeout</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getSessionTimeOut() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddConnectionsPerEAIProcessProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>ConnectionsPerEAIOM</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getConnPerEAIProcess() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddB2BModeProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>B2BMode</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getB2bMode() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddB2BUserProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>B2BUser</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getB2bUser() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddB2BPasswordProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>B2BPassword</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value> </config-property-value>\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddUserNameProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>UserName</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getUsername() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddPasswordProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>Password</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value> </config-property-value>\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddSiebelLanguageProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>SiebelLanguage</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getSiebelLang() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddResRefNameProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>ResRefName</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getResName() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddCacheDurationProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>CacheDuration</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getCacheDuration() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddLogFileProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>LogFile</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getLogFile() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddLogLevelProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>LogLevel</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getLogLevel() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddMaxAnonUsersProp() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>MaxAnonUsers</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getMaxAnnonUser() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddSSLParams() throws CSSException {
        String string = "";
        try {
            SiebelCipher siebelCipher = null;
            siebelCipher = this.savedParam.getB2bMode().equalsIgnoreCase("true") ? new SiebelCipher(this.savedParam.getB2bUser()) : new SiebelCipher(this.savedParam.getUsername());
            string = string + "    <config-property>\r\n";
            string = string + "     <config-property-name>KeystoreName</config-property-name>\r\n";
            string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
            string = string + "     <config-property-value>" + this.savedParam.getSSLParams().getKeyName() + "</config-property-value>" + "\r\n";
            string = string + "    </config-property>\r\n";
            string = string + "    <config-property>\r\n";
            string = string + "     <config-property-name>KeystorePassword</config-property-name>\r\n";
            string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
            string = string + "     <config-property-value>" + siebelCipher.encrypt(this.savedParam.getSSLParams().getKeyPassword()) + "</config-property-value>" + "\r\n";
            string = string + "    </config-property>\r\n";
            string = string + "    <config-property>\r\n";
            string = string + "     <config-property-name>KeystoreAlias</config-property-name>\r\n";
            string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
            string = string + "     <config-property-value>" + this.savedParam.getSSLParams().getKeyAlias() + "</config-property-value>" + "\r\n";
            string = string + "    </config-property>\r\n";
            string = string + "    <config-property>\r\n";
            string = string + "     <config-property-name>TruststoreName</config-property-name>\r\n";
            string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
            string = string + "     <config-property-value>" + this.savedParam.getSSLParams().getTrustName() + "</config-property-value>" + "\r\n";
            string = string + "    </config-property>\r\n";
            string = string + "    <config-property>\r\n";
            string = string + "     <config-property-name>TruststorePassword</config-property-name>\r\n";
            string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
            string = string + "     <config-property-value>" + siebelCipher.encrypt(this.savedParam.getSSLParams().getTrustPassword()) + "</config-property-value>" + "\r\n";
            string = string + "    </config-property>\r\n";
        }
        catch (CSSException cSSException) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Encryption of truststore and keystore passwords failed while creating resource adapter deployment descriptor ra.xml file. Details: " + cSSException.getMessage());
            throw cSSException;
        }
        return string;
    }

    private String AddVirtualHost() {
        String string = "";
        string = string + "    <config-property>\r\n";
        string = string + "     <config-property-name>VirtualHosts</config-property-name>\r\n";
        string = string + "     <config-property-type>java.lang.String</config-property-type>\r\n";
        string = string + "     <config-property-value>" + this.savedParam.getVirtualHost() + "</config-property-value>" + "\r\n";
        string = string + "    </config-property>\r\n";
        return string;
    }

    private String AddSecurityProp() {
        String string = "";
        string = string + "   <authentication-mechanism>\r\n";
        string = string + "   <authentication-mechanism-type>BasicPassword</authentication-mechanism-type>\r\n";
        string = string + "   <credential-interface>javax.resource.spi.security.PasswordCredential</credential-interface>\r\n";
        string = string + "   </authentication-mechanism>\r\n";
        return string;
    }

    public boolean CreateWLSRaXml(String string) {
        boolean bl = true;
        String string2 = "";
        try {
            this.trace(3, "ResourceAdapterDeployment", "Creating weblogic-ra.xml file.");
            string2 = string2 + this.AddWLSXmlHeader();
            this.trace(3, "ResourceAdapterDeployment", "Added header. Adding envelope.");
            string2 = string2 + this.AddWlsRAParamTag();
            string2 = string2 + " </weblogic-connector>";
            this.WriteSchemaToFile(string, string2);
            this.trace(3, "ResourceAdapterDeployment", "Successfully created weblogic-ra.xml.");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Exception occurred while creating Resource adapter deployment desc weblogic-ra.xml file. Details: " + exception.getMessage());
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private String AddWLSXmlHeader() {
        String string = "";
        string = string + "<?xml version=\"1.0\" ?>\r\n";
        string = string + " <weblogic-connector xmlns=\"http://www.bea.com/ns/weblogic/90\">\r\n";
        string = string + " <jndi-name>" + this.wlsRAParams.getRAJNDIName() + "</jndi-name>" + "\r\n";
        string = string + "<enable-global-access-to-classes>true</enable-global-access-to-classes>\r\n";
        return string;
    }

    private String AddWlsRAParamTag() {
        String string = "";
        string = string + "    <outbound-resource-adapter> \r\n";
        string = string + "       <connection-definition-group>\r\n";
        string = string + "          <connection-factory-interface>javax.resource.cci.ConnectionFactory</connection-factory-interface>\r\n";
        string = string + "             <connection-instance>\r\n";
        string = string + this.AddJNDIProp();
        string = string + "                <connection-properties>\r\n";
        string = string + "                   <pool-params>\r\n";
        string = string + this.AddInitCapacityProp();
        string = string + this.AddMaxCapacityProp();
        string = string + "                      <capacity-increment>1</capacity-increment>\r\n";
        string = string + "                      <shrinking-enabled>true</shrinking-enabled>\r\n";
        string = string + "                      <shrink-frequency-seconds>60</shrink-frequency-seconds>\r\n";
        string = string + "\t\t\t<highest-num-waiters>2</highest-num-waiters>\r\n";
        string = string + "                   </pool-params>\r\n";
        string = string + "                   <properties> \r\n";
        string = string + "                      <property>\r\n";
        string = string + "                         <name>ConnectionURL</name>\r\n";
        string = string + "                          <value>" + this.connUrl + "</value>" + "\r\n";
        string = string + "                      </property> \r\n";
        string = string + "                   </properties>\r\n";
        string = string + "                </connection-properties> \r\n";
        string = string + "             </connection-instance> \r\n";
        string = string + "       </connection-definition-group>\r\n";
        string = string + "    </outbound-resource-adapter>\r\n";
        return string;
    }

    private String AddJNDIProp() {
        String string = "";
        string = string + "                <jndi-name>" + this.wlsRAParams.getJndiName() + "</jndi-name>" + "\r\n";
        return string;
    }

    private String AddInitCapacityProp() {
        String string = "";
        string = string + "                      <initial-capacity>0</initial-capacity>\r\n";
        return string;
    }

    private String AddMaxCapacityProp() {
        String string = "";
        string = string + "                      <max-capacity>10</max-capacity>\r\n";
        return string;
    }

    private void WriteSchemaToFile(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(string2.getBytes("UTF-8"));
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        catch (FileNotFoundException fileNotFoundException) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Write Schema to file failed. Exception: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Write Schema to file failed. Exception: " + iOException.getMessage());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Write Schema to file failed. Exception: " + exception.getMessage());
        }
    }

    private void validateSchema(String string) {
        File file = new File(string);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(file);
            this.trace(3, "ResourceAdapterDeployment", "Completed Validation. XML Built Successfully");
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "ResourceAdapterDeployment", "Schema validation failed. Deleting the file." + exception.getMessage());
            file.delete();
        }
    }

    public void trace(int n, String string, String string2) {
        SiebelTrace.getInstance().trace(null, n, string, string2);
    }
}

