/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.cci;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSPropertySetEx;
import com.siebel.integration.jca.cci.SiebelConnectionMetaData;
import com.siebel.integration.jca.client.SiebelInteraction;
import com.siebel.integration.jca.client.SiebelInteractionSpec;
import com.siebel.integration.jca.client.SiebelPropertySetRecord;
import com.siebel.integration.jca.eis.SiebelCon;
import com.siebel.integration.jca.eis.SiebelConException;
import com.siebel.integration.jca.spi.SiebelManagedConnection;
import com.siebel.integration.util.SiebelTrace;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.Record;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.CommException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnection;

public abstract class SiebelConnection
implements Connection {
    protected static final String MODULE_NAME = "SiebelConnection";
    public static final int SIEBCON_UNINITED = 0;
    public static final int SIEBCON_INITED = 1;
    public static final int SIEBCON_READY = 2;
    public static final int SIEBCON_BUSY = 3;
    public static final int SIEBCON_SHUTTING_DOWN = 4;
    public static final int SIEBCON_TERMINATED = 5;
    public static final int SIEBCON_ERROR = -1;
    protected SiebelManagedConnection m_managedConnection = null;
    protected String m_sessionId = null;
    protected String m_username = null;
    protected String m_password = null;
    protected String m_connectStr = null;
    protected String m_language = null;
    protected int m_connectionState = 0;
    private transient PrintWriter m_logWriter = null;
    private boolean m_appErrorFlag = false;
    private long m_lastAccessTime = 0L;
    private static final String SessionTokenError = "SBL-EAI-04608";

    public SiebelConnection(SiebelManagedConnection siebelManagedConnection) throws ResourceException {
        this.m_managedConnection = siebelManagedConnection;
        this.initialize();
        this.stateTransition(2);
    }

    public SiebelConnection(String string, String string2, String string3, String string4) throws ResourceException {
        this.m_username = string;
        this.m_password = string2;
        this.m_connectStr = string3;
        this.m_language = string4;
        this.initialize();
        this.stateTransition(2);
    }

    public Interaction createInteraction() throws ResourceException {
        return new SiebelInteraction(this);
    }

    public Interaction createInteraction(SiebelConnection siebelConnection) throws ResourceException {
        return new SiebelInteraction(siebelConnection);
    }

    public void close() throws ResourceException {
        SiebelTrace.getInstance().pushStack("connection.close");
        this.trace(3, "Closing the connection", true);
        if (!(this.isConnectionState(5) || this.isConnectionState(-1) && !this.isAppErrorFlag())) {
            this.stateTransition(4);
            this.disconnect();
            if (!(this.isConnectionState(5) || this.isConnectionState(-1) && !this.isAppErrorFlag())) {
                this.stateTransition(5);
            }
        }
        SiebelTrace.getInstance().popStack();
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        this.trace(3, "Executing " + interactionSpec);
        if (!(record instanceof SiebelPropertySetRecord)) {
            this.trace(1, "Error: Record is not a SiebelPropertySetRecord");
            throw new ClassCastException(CSSMsgMgr.get(8716401));
        }
        if (!(record2 instanceof SiebelPropertySetRecord)) {
            this.trace(1, "Error: Record is not a SiebelPropertySetRecord");
            throw new ClassCastException(CSSMsgMgr.get(8716401));
        }
        this.execute(interactionSpec, record);
        return true;
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        Serializable serializable;
        this.trace(3, "Executing " + interactionSpec);
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            serializable = (SiebelInteractionSpec)interactionSpec;
            string = serializable.getServiceName();
            string2 = serializable.getFunctionName();
            bl = serializable.getCloseOnAppErr();
        }
        catch (ClassCastException classCastException) {
            this.trace(1, "Error: could not cast ispec into a SiebelInteractionSpec");
            throw new ClassCastException(CSSMsgMgr.get(8716397));
        }
        catch (Exception exception) {
            this.trace(1, "Error: invalid ispec (type SiebelInteractionSpec)");
            throw new ResourceException(CSSMsgMgr.get(8716397));
        }
        serializable = null;
        SiebelPropertySetRecord siebelPropertySetRecord = null;
        try {
            serializable = (SiebelPropertySetRecord)record;
            siebelPropertySetRecord = new SiebelPropertySetRecord();
        }
        catch (ClassCastException classCastException) {
            this.trace(1, "Error: could not cast input record into a SiebelPropertySetRecord");
            throw new ClassCastException(CSSMsgMgr.get(8716401));
        }
        catch (Exception exception) {
            this.trace(1, "Error: could not cast input record into a SiebelPropertySetRecord");
            throw new ResourceException(CSSMsgMgr.get(8716401));
        }
        SiebelPropertySetRecord siebelPropertySetRecord2 = null;
        try {
            siebelPropertySetRecord2 = siebelPropertySetRecord = this.execute(string, string2, (SiebelPropertySetRecord)serializable, bl);
        }
        catch (ResourceException resourceException) {
            this.trace(1, "Resource Exception was thrown from the execute method.");
            throw resourceException;
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(CSSMsgMgr.get(8716404));
            this.trace(1, "Error in converting Siebel's output from the propertyset when invoking the Siebel business service method (" + string + "::" + string2 + ") -- " + exception.getMessage());
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        return siebelPropertySetRecord2;
    }

    public SiebelPropertySetRecord execute(String string, String string2, SiebelPropertySetRecord siebelPropertySetRecord) throws ResourceException {
        return this.execute(string, string2, siebelPropertySetRecord, false);
    }

    public SiebelPropertySetRecord execute(String string, String string2, SiebelPropertySetRecord siebelPropertySetRecord, boolean bl) throws ResourceException {
        this.trace(3, "execute(" + string + "::" + string2 + ") on " + this);
        if (this.m_sessionId == null) {
            this.stateTransition(-1);
            this.trace(1, "execute(" + string + "::" + string2 + ") called with a invalid session.");
            throw new IllegalStateException(CSSMsgMgr.get(8716403));
        }
        this.stateTransition(3);
        SiebelPropertySetRecord siebelPropertySetRecord2 = null;
        try {
            this.m_lastAccessTime = System.currentTimeMillis();
            CSSPropertySetEx cSSPropertySetEx = SiebelCon.invoke(this.m_sessionId, string, string2, siebelPropertySetRecord.toCSSPropertySetEx());
            siebelPropertySetRecord2 = cSSPropertySetEx != null ? new SiebelPropertySetRecord(cSSPropertySetEx) : new SiebelPropertySetRecord();
            this.trace(3, string + "." + string2 + " SUCCEEDED on " + this.toString());
        }
        catch (SiebelConException siebelConException) {
            ResourceException resourceException = new ResourceException(siebelConException.getMessage());
            this.trace(1, string + "." + string2 + " FAILED on " + this.toString() + " with message " + siebelConException.getMessage());
            if (siebelConException.isAppErrorFlag()) {
                if (bl && siebelConException.getMessage().indexOf(SessionTokenError) < 0) {
                    this.setAppErrorFlag(true);
                    this.stateTransition(-1);
                } else {
                    this.stateTransition(2);
                }
            } else {
                this.stateTransition(-1);
            }
            resourceException.setLinkedException((Exception)siebelConException);
            throw resourceException;
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(CSSMsgMgr.get(8716404));
            this.trace(1, string + "." + string2 + " FAILED on " + this.toString() + " with message " + exception.getMessage());
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        this.stateTransition(2);
        return siebelPropertySetRecord2;
    }

    public boolean getAutoCommit() {
        return true;
    }

    public int getConnectionState() {
        return this.m_connectionState;
    }

    public String getConnectString() {
        return this.m_connectStr;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public int getLogLevel() {
        return SiebelTrace.getInstance().getLogLevel();
    }

    public abstract LocalTransaction getLocalTransaction() throws ResourceException;

    public ConnectionMetaData getMetaData() throws ResourceException {
        return new SiebelConnectionMetaData(this);
    }

    public abstract ResultSetInfo getResultSetInfo() throws ResourceException;

    public String getSessionId() {
        return this.m_sessionId;
    }

    public String getUserName() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public boolean isConnectionState(int n) {
        return this.m_connectionState == n;
    }

    public abstract void setAutoCommit(boolean var1) throws ResourceException;

    public void setManagedConnection(ManagedConnection managedConnection) throws ResourceException {
        this.m_managedConnection = (SiebelManagedConnection)managedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() throws ResourceException {
        SiebelTrace.getInstance().pushStack("disconnect");
        try {
            if (this.m_sessionId != null) {
                this.trace(3, "Closing the actual Siebel connection for " + this);
                SiebelCon.close(this.m_sessionId);
            }
        }
        catch (Exception exception) {
            this.trace(1, "Error when attempting to disconnect session (" + this.m_sessionId + ").");
            this.stateTransition(-1);
        }
        finally {
            if (this.m_managedConnection != null) {
                this.stateTransition(5);
                this.m_managedConnection.cleanup();
            }
            this.m_managedConnection = null;
            this.m_sessionId = null;
            this.m_password = null;
            this.m_username = null;
            this.m_connectStr = null;
        }
        SiebelTrace.getInstance().popStack();
    }

    public void setLogLevel(int n) {
        try {
            SiebelTrace.getInstance().setLogLevel(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.trace(1, "Invalid log level specified : " + n);
        }
    }

    public void setLogLevel(String string) {
        try {
            SiebelTrace.getInstance().setLogLevel(string);
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().setLogLevel(1);
            throw new IllegalArgumentException("logLevel");
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.m_logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.m_logWriter;
    }

    public String toString() {
        return "Connection (" + this.m_sessionId + ", " + this.m_username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() throws ResourceException {
        try {
            this.trace(3, "Opening a new connection to Siebel ...", true);
            this.m_sessionId = SiebelCon.open(this.m_username, this.m_password, this.m_connectStr, this.m_language);
            this.stateTransition(1);
            this.trace(3, "Opened a new connection to Siebel (Siebel session : " + this.m_sessionId + ")");
        }
        catch (SiebelConException siebelConException) {
            try {
                this.stateTransition(-1);
            }
            catch (ResourceException resourceException) {}
            finally {
                String string = CSSMsgMgr.get(8716413) + System.getProperty("line.separator") + "Caused by: " + siebelConException.getMessage();
                this.trace(0, "Error in initialize(): " + string);
                throw new CommException(string);
            }
        }
        catch (Exception exception) {
            String string = CSSMsgMgr.get(8716413) + " - " + exception;
            this.trace(0, "Error in initialize(): " + string);
            try {
                this.stateTransition(-1);
            }
            catch (ResourceException resourceException) {}
        }
    }

    protected void stateTransition(int n) throws ResourceException {
        if (this.getConnectionState() == n) {
            this.trace(1, "Already in state " + this.getConnectionState());
            return;
        }
        if (!this.isAppErrorFlag() && this.getConnectionState() == -1) {
            this.trace(1, "Cannot leave the ERROR state, -1");
            return;
        }
        this.trace(5, "StateTransition: " + this.getConnectionState() + " --> " + n);
        switch (n) {
            case 0: {
                this.trace(1, "Cannot make the state transition (" + this.getConnectionState() + " --> " + n + ").");
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
            case 1: {
                if (this.m_connectionState == 0) break;
                this.trace(1, "Cannot make the state transition (" + this.getConnectionState() + " --> " + n + ").");
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
            case 2: {
                if (this.m_connectionState == 1 || this.m_connectionState == 3) break;
                this.trace(1, "Cannot make the state transition (" + this.getConnectionState() + " --> " + n + ").");
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
            case 3: {
                if (this.m_connectionState == 2) break;
                this.trace(1, "Cannot make the state transition (" + this.getConnectionState() + " --> " + n + ").");
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
            case 4: {
                if (this.m_connectionState == 2 || this.m_connectionState == -1) break;
                this.trace(1, "Cannot make the state transition (" + this.getConnectionState() + " --> " + n + ").");
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
            case 5: {
                if (this.m_connectionState == 4 || this.m_connectionState == -1 || this.m_connectionState == 5) break;
                this.trace(1, "Cannot make the state transition (" + this.getConnectionState() + " --> " + n + ").");
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
            case -1: {
                break;
            }
            default: {
                this.trace(1, "Trying to transition to an invalid state (" + this.getConnectionState() + " --> " + n + ") " + this);
                this.stateTransition(-1);
                throw new IllegalStateException(CSSMsgMgr.get(8716396));
            }
        }
        this.m_connectionState = n;
        if (n == -1 && this.m_managedConnection != null) {
            this.m_managedConnection.sendEvent(5, null, this);
        }
    }

    private void trace(int n, String string) {
        this.trace(n, string, false);
    }

    private void trace(int n, String string, boolean bl) {
        SiebelTrace.getInstance().trace(this.m_logWriter, n, "SiebelConnection(" + this.hashCode() + ")", string, bl);
    }

    public boolean isAppErrorFlag() {
        return this.m_appErrorFlag;
    }

    public void setAppErrorFlag(boolean bl) {
        this.m_appErrorFlag = bl;
    }

    public long getLastAccessTime() {
        return this.m_lastAccessTime;
    }
}

