/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.cci;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.jca.client.SiebelConnectionSpec;
import com.siebel.integration.jca.spi.SiebelConnectionRequestInfo;
import com.siebel.integration.util.SiebelTrace;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public abstract class SiebelConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    protected Reference m_reference = null;
    protected ConnectionManager m_connectionManager = null;
    protected ManagedConnectionFactory m_managedConnectionFactory = null;
    protected int m_timeout = 0;
    private transient PrintWriter m_logWriter = null;
    private static final String MODULE_NAME = "SiebelConnectionFactory";

    public SiebelConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        if (managedConnectionFactory == null) {
            this.trace(1, "Error: ManagedConnectionFactory can not be null.");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716398));
        }
        this.m_managedConnectionFactory = managedConnectionFactory;
        this.m_connectionManager = this.getConnectionManager();
        this.trace(5, "new (MCF=" + managedConnectionFactory.toString() + ")");
    }

    public SiebelConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        if (managedConnectionFactory != null) {
            this.m_managedConnectionFactory = managedConnectionFactory;
            if (connectionManager != null) {
                this.m_connectionManager = connectionManager;
                this.trace(5, "new (MCF=" + managedConnectionFactory.toString() + ", CM=" + connectionManager.toString() + ")");
            } else {
                this.m_connectionManager = this.getConnectionManager();
                this.trace(5, "new (MCF=" + managedConnectionFactory.toString() + ", null)");
            }
        } else {
            this.trace(1, "ManagedConnectionFactory cannot be null.");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716398));
        }
    }

    public Connection getConnection() throws ResourceException {
        this.trace(5, "getConnection() (no ConnectionSpec argument)");
        Connection connection = (Connection)this.m_connectionManager.allocateConnection(this.m_managedConnectionFactory, null);
        this.trace(5, "Got connection " + connection);
        return connection;
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        if (connectionSpec == null || !(connectionSpec instanceof SiebelConnectionSpec)) {
            this.trace(1, "ConnectionSpec must be of type SiebelConnectionSpec and non-null: " + connectionSpec);
            throw new IllegalArgumentException(CSSMsgMgr.get(8716395));
        }
        SiebelConnectionSpec siebelConnectionSpec = (SiebelConnectionSpec)connectionSpec;
        this.trace(5, "getConnection(ConnectionSpec=" + siebelConnectionSpec + ")");
        SiebelConnectionRequestInfo siebelConnectionRequestInfo = new SiebelConnectionRequestInfo(siebelConnectionSpec.getSessionId(), siebelConnectionSpec.getUserName(), siebelConnectionSpec.getPassword(), siebelConnectionSpec.getConnectString(), siebelConnectionSpec.getLanguage());
        Connection connection = (Connection)this.m_connectionManager.allocateConnection(this.m_managedConnectionFactory, (ConnectionRequestInfo)siebelConnectionRequestInfo);
        this.trace(5, "Got connection " + connection);
        return connection;
    }

    public abstract ConnectionManager getConnectionManager();

    public abstract ResourceAdapterMetaData getMetaData() throws ResourceException;

    public RecordFactory getRecordFactory() throws ResourceException {
        return null;
    }

    public Reference getReference() {
        this.trace(5, "Getting a reference to the connection factory");
        return this.m_reference;
    }

    public int getLogLevel() {
        return SiebelTrace.getInstance().getLogLevel();
    }

    public void setLogLevel(int n) {
        SiebelTrace.getInstance().setLogLevel(n);
    }

    public void setLogLevel(String string) {
        SiebelTrace.getInstance().setLogLevel(string);
    }

    public void setReference(Reference reference) {
        this.trace(5, "Setting a reference to the connection factory");
        this.m_reference = reference;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.m_logWriter = printWriter;
    }

    public int getTimeout() throws ResourceException {
        return this.m_timeout;
    }

    public void setTimeout(int n) throws ResourceException {
        this.m_timeout = n;
    }

    private void trace(int n, String string) {
        SiebelTrace.getInstance().trace(this.m_logWriter, n, "SiebelConnectionFactory(" + this.hashCode() + ")", string);
    }
}

