/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.client;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.jca.cci.SiebelConnection;
import com.siebel.integration.jca.cci.SiebelConnectionMetaData;
import com.siebel.integration.jca.spi.SiebelManagedConnection;
import com.siebel.integration.util.SiebelTrace;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.IllegalStateException;

public class SiebelConnectionHandle
implements Connection {
    private boolean m_valid = true;
    private static final String MODULE_NAME = "SiebelConnectionHandle";
    private SiebelManagedConnection m_managedConnection = null;

    public SiebelConnectionHandle(SiebelManagedConnection siebelManagedConnection) throws ResourceException {
        this.m_managedConnection = siebelManagedConnection;
        this.m_valid = true;
        this.trace(5, "Creating SiebelConnectionHandle for " + siebelManagedConnection);
    }

    public SiebelConnectionHandle(boolean bl) {
        this.m_valid = bl;
    }

    public void associateConnection(SiebelManagedConnection siebelManagedConnection) throws ResourceException {
        if (siebelManagedConnection == null) {
            throw new IllegalStateException(CSSMsgMgr.get(8716393));
        }
        this.checkManagedConnectionValid();
        this.m_managedConnection.removeSiebelConnectionHandle(this);
        this.m_managedConnection = siebelManagedConnection;
        this.m_managedConnection.addSiebelConnectionHandle(this);
    }

    public void close() throws ResourceException {
        this.m_managedConnection.closeHandle(this);
    }

    public void invalidate() {
        this.m_valid = false;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public Interaction createInteraction() throws ResourceException {
        this.trace(5, "Creating a new Interaction.");
        try {
            return this.getRealConnection().createInteraction();
        }
        catch (ResourceException resourceException) {
            this.trace(1, "ResourceException in createInteraction(): " + resourceException.getMessage());
            throw resourceException;
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(CSSMsgMgr.get(8716393));
            this.trace(1, "Exception in createInteraction(): " + exception.getMessage());
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
    }

    public boolean getAutoCommit() throws IllegalStateException {
        return this.getRealConnection().getAutoCommit();
    }

    public String getConnectString() throws IllegalStateException {
        return this.getRealConnection().getConnectString();
    }

    public String getLanguage() throws IllegalStateException {
        return this.getRealConnection().getLanguage();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.getRealConnection().getLocalTransaction();
    }

    public ConnectionMetaData getMetaData() throws IllegalStateException {
        return new SiebelConnectionMetaData(this.getRealConnection());
    }

    protected SiebelConnection getRealConnection() throws IllegalStateException {
        this.checkManagedConnectionValid();
        return this.m_managedConnection.getSiebelConnection();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        return this.getRealConnection().getResultSetInfo();
    }

    public String getSessionId() throws IllegalStateException {
        return this.getRealConnection().getSessionId();
    }

    public String getUserName() throws IllegalStateException {
        return this.getRealConnection().getUserName();
    }

    public String getPassword() throws IllegalStateException {
        return this.getRealConnection().getPassword();
    }

    protected void checkManagedConnectionValid() throws IllegalStateException {
        if (!this.m_valid) {
            throw new IllegalStateException(CSSMsgMgr.get(8716393));
        }
    }

    public void setAutoCommit(boolean bl) throws ResourceException {
        try {
            this.getRealConnection().setAutoCommit(bl);
        }
        catch (ResourceException resourceException) {
            throw resourceException;
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(CSSMsgMgr.get(8716393));
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
    }

    public String toString() {
        return "SiebelConnectionHandle(" + this.hashCode() + ")";
    }

    private void trace(int n, String string) {
        try {
            SiebelTrace.getInstance().trace(this.m_managedConnection.getLogWriter(), n, "SiebelConnectionHandle(" + this.hashCode() + "(", string);
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public void setManagedConnection(SiebelManagedConnection siebelManagedConnection) {
        this.m_managedConnection = siebelManagedConnection;
    }

    public SiebelManagedConnection getManagedConnection() {
        return this.m_managedConnection;
    }

    public long getLastAccessedTime() throws ResourceException {
        this.trace(5, "Getting last access time of the connection - " + this.toString());
        try {
            return this.getRealConnection().getLastAccessTime();
        }
        catch (ResourceException resourceException) {
            this.trace(1, "ResourceException in getLastAccessedTime(): " + resourceException.getMessage());
            throw resourceException;
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(CSSMsgMgr.get(8716393));
            this.trace(1, "Exception in getLastAccessedTime(): " + exception.getMessage());
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
    }
}

