/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.eis;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSPropertySet;
import com.siebel.common.common.CSSPropertySetEx;
import com.siebel.common.common.CSSUtilities;
import com.siebel.common.common.CSSVersion;
import com.siebel.integration.jca.eis.SiebelConException;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.om.conmgr.ConMgrException;
import com.siebel.om.conmgr.ConnectionManager;
import com.siebel.om.conmgr.SSLConfig;
import com.siebel.om.conmgr.Transaction;
import com.siebel.om.om.CSSLocale;
import com.siebel.om.sisnapi.ArgList;
import com.siebel.om.sisnapi.ArgSpec;
import com.siebel.om.sisnapi.LogoffRequest;
import com.siebel.om.sisnapi.LogonRequest;
import com.siebel.om.sisnapi.OMRPCACK;
import com.siebel.om.sisnapi.OMRPCRequest;
import com.siebel.om.sisnapi.SessCloseReq;
import java.util.StringTokenizer;

public class SiebelCon {
    public static void close(String string) throws SiebelConException {
        if (string == null) {
            return;
        }
        SiebelCon.trace(5, "Closing a real connection to Siebel, SessionId=" + string);
        try {
            LogoffRequest logoffRequest = new LogoffRequest(true);
            Transaction transaction = new Transaction();
            transaction.setRequest(logoffRequest);
            ConnectionManager.send(string, transaction);
            SiebelCon.sessClose(string);
        }
        catch (ConMgrException conMgrException) {
            throw new SiebelConException(conMgrException);
        }
        catch (CSSException cSSException) {
            throw new SiebelConException(cSSException);
        }
    }

    public static void attach(String string) throws SiebelConException {
        if (string == null) {
            throw new IllegalArgumentException("sessionId");
        }
        try {
            ArgList argList = new ArgList();
            ArgList argList2 = SiebelCon.propertySetToArgList(CSSLocale.createLocaleProfile());
            argList.addArg("bAttach", new ArgSpec(true));
            argList.addArg("SISNSIOMVersion", new ArgSpec(203));
            argList.addArg("localeProfile", new ArgSpec(argList2));
            argList.addArg("bJavaClient", new ArgSpec(true));
            argList.addArg("bReturnCommonDefs", new ArgSpec(false));
            argList.addArg("bReturnProductConfig", new ArgSpec(false));
            argList.addArg("bReturnPreferences", new ArgSpec(false));
            argList.addArg("bReturnViewAccessMap", new ArgSpec(false));
            argList = SiebelCon.sendReceive(string, 501, argList, 0);
        }
        catch (CSSException cSSException) {
            throw new SiebelConException(cSSException);
        }
    }

    public static String detach(String string) throws SiebelConException {
        SiebelCon.sendReceive(string, 18, new ArgList());
        return string;
    }

    public static CSSPropertySetEx invoke(String string, String string2, String string3, CSSPropertySetEx cSSPropertySetEx) throws SiebelConException, CSSException {
        if (string == null) {
            throw new IllegalArgumentException("sessionId");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("serviceName");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("methodName");
        }
        CSSPropertySetEx cSSPropertySetEx2 = new CSSPropertySetEx();
        ArgList argList = new ArgList();
        argList.addArg("serviceName", new ArgSpec(string2));
        argList.addArg("methodName", new ArgSpec(string3));
        argList.addArg("inputArgs", new ArgSpec(cSSPropertySetEx.encodeAsString()));
        argList = SiebelCon.sendReceive(string, 507, argList);
        String string4 = argList.getArg("outputArgs").getString();
        if (!cSSPropertySetEx2.decodeFromString(string4)) {
            throw new SiebelConException(string4);
        }
        return cSSPropertySetEx2;
    }

    public static String open(String string, String string2, String string3, String string4) throws SiebelConException {
        SiebelCon.trace(5, "Opening a real connection to Siebel: User=" + string + " Connect=" + string3 + " Language=" + string4);
        if (string == null) {
            throw new IllegalArgumentException("username");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("connect");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("lang");
        }
        int n = SiebelCon.checkVersionCompatibility(string4);
        String string5 = null;
        boolean bl = false;
        try {
            if (SiebelCon.decodeURLForSSL(string3.trim())) {
                SSLConfig.decryptPasswords(string);
            }
            string5 = ConnectionManager.open(string3).toString();
            bl = true;
            SiebelCon.trace(5, "Session Id = " + string5);
            LogonRequest logonRequest = new LogonRequest(null, string, string2, 4, false, 1, n);
            Transaction transaction = new Transaction();
            transaction.setRequest(logonRequest);
            ConnectionManager.send(string5, transaction);
        }
        catch (ConMgrException conMgrException) {
            SiebelCon.trace(5, "SiebelCon: ConMgrException : " + conMgrException);
            if (bl) {
                SiebelCon.sessClose(string5);
            }
            throw new SiebelConException(conMgrException);
        }
        catch (CSSException cSSException) {
            SiebelCon.trace(5, "SiebelCon: CSSException : " + cSSException);
            throw new SiebelConException(cSSException.getErrorMessage());
        }
        return string5;
    }

    private static int checkVersionCompatibility(String string) throws SiebelConException {
        int n;
        try {
            String string2 = new CSSVersion(string).getVersionString();
            int n2 = 0;
            int n3 = 0;
            while (string2.charAt(n2++) != '[') {
            }
            while (string2.charAt(n3++) != ']') {
            }
            String string3 = string2.substring(n2, n3 - 1);
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            SiebelCon.trace(5, "SiebelCon: Exception : " + indexOutOfBoundsException);
            throw new SiebelConException("Possible version incompatibility");
        }
        catch (Exception exception) {
            SiebelCon.trace(5, "SiebelCon: Exception : " + exception);
            throw new SiebelConException("Version info not found.  Check that message bundles are properly deployed.");
        }
        return n;
    }

    private static void trace(int n, String string) {
        SiebelTrace.getInstance().trace(null, n, "SiebelCon", string);
    }

    private static void sessClose(String string) throws SiebelConException {
        if (string == null) {
            return;
        }
        try {
            SessCloseReq sessCloseReq = new SessCloseReq();
            Transaction transaction = new Transaction();
            transaction.setRequestFast(sessCloseReq);
            ConnectionManager.send(string, transaction);
        }
        catch (Exception exception) {
            SiebelCon.trace(1, "WARNING: sessClose failed-login also failed: " + exception);
        }
    }

    private static ArgList sendReceive(String string, int n, ArgList argList) throws SiebelConException {
        return SiebelCon.sendReceive(string, n, argList, 0);
    }

    private static ArgList sendReceive(String string, int n, ArgList argList, int n2) throws SiebelConException {
        SiebelCon.trace(5, Thread.currentThread().getName() + " SiebelCon.sendReceive(" + string + ", " + n + ", " + argList + ", " + n2);
        Transaction transaction = new Transaction();
        OMRPCACK oMRPCACK = null;
        try {
            OMRPCRequest oMRPCRequest = new OMRPCRequest(n, n2, 0, argList);
            transaction.setRequest(oMRPCRequest);
            oMRPCACK = (OMRPCACK)ConnectionManager.send(string, transaction);
            int n3 = oMRPCACK.getErrorCount();
            if (n3 > 0) {
                oMRPCACK.getArgList().getArg2("notifyList");
                CSSException cSSException = oMRPCACK.getError(0);
                for (int i = 1; i < n3; ++i) {
                    cSSException.addErrorMsg(oMRPCACK.getError(i));
                }
                throw new SiebelConException(cSSException, true);
            }
        }
        catch (ConMgrException conMgrException) {
            throw new SiebelConException(conMgrException);
        }
        catch (CSSException cSSException) {
            throw new SiebelConException(cSSException);
        }
        return oMRPCACK.getArgList();
    }

    private static ArgList propertySetToArgList(CSSPropertySet cSSPropertySet) throws CSSException {
        Object object;
        ArgList argList = new ArgList();
        argList.addArg("type", new ArgSpec(cSSPropertySet.getType()));
        ArgList argList2 = new ArgList();
        Object object2 = cSSPropertySet.enumPropertyKeys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            argList2.addArg((String)object, new ArgSpec(cSSPropertySet.getProperty((String)object)));
        }
        argList.addArg("propArray", new ArgSpec(argList2));
        object2 = new ArgList();
        object = cSSPropertySet.enumSubsets();
        while (object.hasMoreElements()) {
            CSSPropertySet cSSPropertySet2 = (CSSPropertySet)object.nextElement();
            ((ArgList)object2).addArg(cSSPropertySet2.getType(), new ArgSpec(SiebelCon.propertySetToArgList(cSSPropertySet2)));
        }
        argList.addArg("subsetArray", new ArgSpec((ArgList)object2));
        return argList;
    }

    private static boolean decodeURLForSSL(String string) throws CSSException {
        boolean bl = false;
        String string2 = "!";
        String string3 = "ssl";
        String string4 = "http";
        String string5 = "tcpip";
        int n = 5;
        int n2 = 5;
        int n3 = 1;
        String[] stringArray = new String[n2];
        String string6 = (string = string.trim()).toLowerCase();
        int n4 = string6.indexOf(string2);
        if (n4 != -1) {
            if (string6.charAt(n4 - 1) == '/') {
                --n4;
            }
            string6 = string6.substring(0, n4);
            string = string.substring(0, n4);
        }
        n4 = 0;
        if (string6.startsWith("siebel") && string6.indexOf("://") != -1) {
            int n5;
            int n6 = string6.indexOf("://");
            if (n6 == -1) {
                throw new CSSException(8716494, string);
            }
            String string7 = string6.substring(0, n6);
            for (n5 = 0; n5 < n2; ++n5) {
                stringArray[n5] = null;
            }
            n5 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ".");
            while (n5 < n && stringTokenizer.hasMoreTokens()) {
                stringArray[n5++] = stringTokenizer.nextToken();
            }
            if (CSSUtilities.isEmpty(stringArray[n3]) || CSSUtilities.compareNoCase(stringArray[n3], string5) == 0) {
                return false;
            }
            if (CSSUtilities.compareNoCase(stringArray[n3], string4) == 0) {
                return false;
            }
            if (CSSUtilities.compareNoCase(stringArray[n3], string3) == 0) {
                return true;
            }
            throw new CSSException(8716494, string);
        }
        return bl;
    }
}

