/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.spi;

import com.siebel.integration.util.SiebelTrace;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;

public class SiebelConnectionPool {
    public static final int DEFAULT_POOL_SIZE = 25;
    private static final String MODULE_NAME = "ConnectionPool";
    protected int m_maxConnectionsPooled = 25;
    protected HashSet m_pooledConnections = new HashSet();

    public SiebelConnectionPool() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SiebelConnectionPool.this.closeAllConnections();
            }
        });
    }

    protected synchronized void closeAllConnections() {
        HashSet hashSet = (HashSet)this.m_pooledConnections.clone();
        for (ManagedConnection managedConnection : hashSet) {
            this.closeConnection(managedConnection);
        }
    }

    public synchronized void addConnection(ManagedConnection managedConnection) {
        String string;
        if (this.m_pooledConnections.size() < this.m_maxConnectionsPooled) {
            boolean bl = this.m_pooledConnections.add(managedConnection);
            if (bl) {
                string = "Added the connection back to the pool.  Now ";
            } else {
                string = "Did not add the connection to the pool. ";
                this.closeConnection(managedConnection);
            }
        } else {
            string = "Did not add the connection to the pool. ";
            this.closeConnection(managedConnection);
        }
        try {
            SiebelTrace.getInstance().trace(managedConnection.getLogWriter(), 3, MODULE_NAME, string + this.m_pooledConnections.size() + " connections are in the pool.");
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public synchronized HashSet getConnections() {
        HashSet hashSet = (HashSet)this.m_pooledConnections.clone();
        return hashSet;
    }

    public int getMaxConnectionsPooled() {
        return this.m_maxConnectionsPooled;
    }

    public synchronized boolean removeConnection(ManagedConnection managedConnection) {
        boolean bl = this.m_pooledConnections.remove(managedConnection);
        String string = this.m_pooledConnections.size() + " connections are in the pool.";
        string = bl ? "Removed a connection from the pool.  Now " + string : "Tried and failed to remove connection from the pool.  " + string;
        try {
            SiebelTrace.getInstance().trace(managedConnection.getLogWriter(), 3, MODULE_NAME, string);
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        return bl;
    }

    public void setMaxConnectionsPooled(int n) {
        this.m_maxConnectionsPooled = n;
    }

    public void closeConnection(ManagedConnection managedConnection) {
        try {
            this.removeConnection(managedConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            try {
                SiebelTrace.getInstance().trace(managedConnection.getLogWriter(), 3, MODULE_NAME, "Closing the connection ...");
            }
            catch (Exception exception) {
                // empty catch block
            }
            managedConnection.destroy();
        }
        catch (ResourceException resourceException) {
            try {
                SiebelTrace.getInstance().trace(managedConnection.getLogWriter(), 1, MODULE_NAME, "Error while attempting to clean up a managed connection.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

