/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.spi;

import com.siebel.integration.jca.spi.SiebelConnectionPool;
import com.siebel.integration.util.SiebelTrace;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public abstract class SiebelConnectionPoolEventListener
implements ConnectionEventListener {
    protected static final String MODULE_NAME = "ConnectionPoolEventListener";
    protected boolean m_connectionError = false;
    protected SiebelConnectionPool m_connectionPool = null;
    protected ManagedConnection m_managedConnection = null;

    public SiebelConnectionPoolEventListener(SiebelConnectionPool siebelConnectionPool, ManagedConnection managedConnection) {
        this.m_connectionPool = siebelConnectionPool;
        this.m_managedConnection = managedConnection;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            SiebelTrace.getInstance().trace(this.m_managedConnection.getLogWriter(), 3, MODULE_NAME, "Received an event that the client closed the connection handle : " + this.m_managedConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_connectionError) {
            this.m_connectionPool.closeConnection(this.m_managedConnection);
        } else {
            this.m_connectionPool.addConnection(this.m_managedConnection);
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            SiebelTrace.getInstance().trace(this.m_managedConnection.getLogWriter(), 1, MODULE_NAME, "Received an event that an error occurred on the connection.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_connectionError = true;
    }

    public abstract void localTransactionCommitted(ConnectionEvent var1);

    public abstract void localTransactionStarted(ConnectionEvent var1);

    public abstract void localTransactionRolledback(ConnectionEvent var1);
}

