/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.spi;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.jca.cci.SiebelConnection;
import com.siebel.integration.jca.client.SiebelConnectionHandle;
import com.siebel.integration.jca.spi.SiebelConnectionRequestInfo;
import com.siebel.integration.jca.spi.SiebelManagedConnectionFactory;
import com.siebel.integration.jca.spi.SiebelManagedConnectionMetaData;
import com.siebel.integration.util.SiebelTrace;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public abstract class SiebelManagedConnection
implements ManagedConnection {
    private boolean inCleanup;
    protected static final String MODULE_NAME = "SiebelManagedConnection";
    protected SiebelConnection m_connection = null;
    private Vector m_listeners = null;
    protected Set m_connectionHandles = null;
    protected SiebelManagedConnectionFactory m_managedConnectionFactory = null;
    protected boolean m_destroyed = false;
    private transient PrintWriter m_logWriter = null;
    protected String m_userName = null;
    protected String m_language = null;
    protected String m_connectStr = null;
    protected String m_sessionId = null;
    protected int m_logLevel = 0;

    public SiebelManagedConnection(SiebelManagedConnectionFactory siebelManagedConnectionFactory, SiebelConnection siebelConnection, String string, String string2, String string3, String string4) throws ResourceException {
        this.m_managedConnectionFactory = siebelManagedConnectionFactory;
        this.m_sessionId = string;
        this.m_connectStr = string3;
        this.m_userName = string2;
        this.m_language = string4;
        this.m_connection = siebelConnection;
        this.m_listeners = new Vector();
        this.m_connectionHandles = new HashSet();
        this.setLogWriter(siebelManagedConnectionFactory.getLogWriter());
        siebelConnection.setManagedConnection(this);
        this.trace(3, "Constructor complete for " + this.hashCode() + " representing SiebelConnection " + siebelConnection.hashCode());
    }

    public void addSiebelConnectionHandle(SiebelConnectionHandle siebelConnectionHandle) {
        this.m_connectionHandles.add(siebelConnectionHandle);
        this.trace(5, "Added SiebelConnectionHandle " + siebelConnectionHandle.hashCode() + "; " + this.m_connectionHandles.size() + " handles now are held");
        if (this.m_connectionHandles.size() > 1) {
            this.trace(2, "MULTIPLE HANDLES NOW IN EXISTENCE FOR MANAGED CONNECTION " + this.toString());
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace(5, "Adding ConnectionEventListener (" + connectionEventListener + ") to " + this);
        this.m_listeners.addElement(connectionEventListener);
    }

    public void associateConnection(Object object) throws ResourceException {
        this.validateConnectionState();
        this.trace(5, "Associate a connection ... ");
        if (!(object instanceof SiebelConnectionHandle)) {
            this.trace(1, "Invalid connection handle type passed, should be of type SiebelConnectionHandle");
            throw new IllegalStateException(CSSMsgMgr.get(8716393));
        }
        ((SiebelConnectionHandle)object).associateConnection(this);
    }

    public void cleanup() throws ResourceException {
        SiebelTrace.getInstance().pushStack("SMC.cleanup");
        if (this.inCleanup) {
            this.trace(5, "Rejecting re-entrant call to cleanup()");
            SiebelTrace.getInstance().popStack();
            return;
        }
        this.inCleanup = true;
        this.trace(3, "Cleaning up " + this.m_connectionHandles.size() + " handles on " + this.toString());
        Object[] objectArray = this.m_connectionHandles.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                SiebelConnectionHandle siebelConnectionHandle = (SiebelConnectionHandle)objectArray[i];
                this.closeHandle(siebelConnectionHandle);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.inCleanup = false;
                SiebelTrace.getInstance().popStack();
                throw new ResourceException(exception.toString());
            }
        }
        this.m_connectionHandles.clear();
        this.inCleanup = false;
        SiebelTrace.getInstance().popStack();
    }

    public void closeHandle(SiebelConnectionHandle siebelConnectionHandle) {
        if (!siebelConnectionHandle.isValid()) {
            this.trace(3, "Ignored attempt made to close invalid SiebelConnectionHandle (no ManagedConnection)");
            return;
        }
        this.trace(5, "Closing SiebelConnectionHandle " + siebelConnectionHandle.hashCode());
        siebelConnectionHandle.invalidate();
        this.removeSiebelConnectionHandle(siebelConnectionHandle);
        this.sendEvent(1, null, siebelConnectionHandle);
    }

    public void destroy() throws ResourceException {
        SiebelTrace.getInstance().pushStack("SMC.destroy");
        this.trace(3, "Destroying " + this.toString());
        if (!this.m_destroyed) {
            try {
                this.cleanup();
            }
            catch (Exception exception) {
                this.trace(1, "Encountered exception in destroy():  " + exception.getMessage());
                throw new ResourceException(exception.getMessage());
            }
            finally {
                this.m_destroyed = true;
                if (this.m_connection != null) {
                    this.m_connection.close();
                    this.m_connection = null;
                }
            }
        }
        this.trace(5, "Finished destroy");
        SiebelTrace.getInstance().popStack();
    }

    public void finalize() {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        this.trace(3, "getConnection(CRI=" + connectionRequestInfo + "; Subject=" + subject + ")");
        if (this.m_connectionHandles.size() > 0) {
            this.trace(3, "Request made for SHARED CONNECTION HANDLE on " + this.toString() + "(" + this.m_connectionHandles.size() + " already present)");
        }
        String string = null;
        if (subject != null) {
            object = this.m_managedConnectionFactory.getMatchingCredentials(subject);
            string = object.getUserName();
        } else if (connectionRequestInfo instanceof SiebelConnectionRequestInfo) {
            string = ((SiebelConnectionRequestInfo)connectionRequestInfo).getUserName();
        }
        if (!this.m_userName.equals(string)) {
            this.trace(3, "User requesting connection is different from user connection originally created for.");
        }
        this.validateConnectionState();
        object = new SiebelConnectionHandle(this);
        this.addSiebelConnectionHandle((SiebelConnectionHandle)object);
        return object;
    }

    public String getConnectString() {
        return this.m_connectStr;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public int getLogLevel() {
        SiebelTrace siebelTrace = SiebelTrace.getInstance();
        return siebelTrace.getLogLevel();
    }

    public abstract LocalTransaction getLocalTransaction() throws ResourceException;

    public void localTransactionCommitted() {
    }

    public void localTransactionRolledback() {
    }

    public void localTransactionStarted() {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_logWriter;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() throws IllegalStateException {
        this.validateConnectionState();
        return this.m_managedConnectionFactory;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.validateConnectionState();
        return new SiebelManagedConnectionMetaData(this);
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public SiebelConnection getSiebelConnection() throws IllegalStateException {
        this.validateConnectionState();
        return this.m_connection;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public abstract XAResource getXAResource() throws ResourceException;

    public int hashCode() {
        String string = "" + this.m_sessionId + this.m_connectStr + this.m_userName + this.m_language;
        return string.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SiebelManagedConnection siebelManagedConnection = (SiebelManagedConnection)object;
        return !(this.m_sessionId == null ? siebelManagedConnection.m_sessionId != null : !this.m_sessionId.equals(siebelManagedConnection.m_sessionId));
    }

    public boolean isDestroyed() {
        return this.m_destroyed;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace(5, "Removing ConnectionEventListener (" + connectionEventListener + ")");
        this.m_listeners.removeElement(connectionEventListener);
    }

    public void removeSiebelConnectionHandle(SiebelConnectionHandle siebelConnectionHandle) {
        boolean bl = this.m_connectionHandles.remove(siebelConnectionHandle);
        if (bl) {
            this.trace(5, "Removed SiebelConnectionHandle " + siebelConnectionHandle.hashCode() + "; " + this.m_connectionHandles.size() + " handles remain");
        } else {
            this.trace(2, "Already removed SiebelConnectionHandle " + siebelConnectionHandle.hashCode() + "; still " + this.m_connectionHandles.size() + " handles");
        }
    }

    private void trace(int n, String string) {
        SiebelTrace.getInstance().trace(this.m_logWriter, n, "SiebelManagedConnection(" + this.hashCode() + ")", string);
    }

    public void sendEvent(int n, Exception exception) {
        ConnectionEvent connectionEvent = exception == null ? new ConnectionEvent((ManagedConnection)this, n) : new ConnectionEvent((ManagedConnection)this, n, exception);
        this.sendEvent(connectionEvent);
    }

    public void sendEvent(int n, Exception exception, Object object) {
        ConnectionEvent connectionEvent = exception != null ? new ConnectionEvent((ManagedConnection)this, n, exception) : new ConnectionEvent((ManagedConnection)this, n);
        if (object != null) {
            connectionEvent.setConnectionHandle(object);
        }
        this.sendEvent(connectionEvent);
    }

    public void sendEvent(ConnectionEvent connectionEvent) {
        Vector vector = (Vector)this.m_listeners.clone();
        int n = vector != null ? vector.size() : 0;
        for (int i = 0; i < n; ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)vector.elementAt(i);
            SiebelTrace.getInstance().pushStack("" + connectionEvent.hashCode());
            this.trace(5, "START notification:  ConnectionEvent id=" + connectionEvent.getId() + "; hashCode=" + connectionEvent.hashCode() + "; listener=" + connectionEventListener);
            try {
                switch (connectionEvent.getId()) {
                    case 1: {
                        connectionEventListener.connectionClosed(connectionEvent);
                        break;
                    }
                    case 2: {
                        connectionEventListener.localTransactionStarted(connectionEvent);
                        break;
                    }
                    case 3: {
                        connectionEventListener.localTransactionCommitted(connectionEvent);
                        break;
                    }
                    case 4: {
                        connectionEventListener.localTransactionRolledback(connectionEvent);
                        break;
                    }
                    case 5: {
                        connectionEventListener.connectionErrorOccurred(connectionEvent);
                        break;
                    }
                    default: {
                        String string = CSSMsgMgr.get(8716394);
                        this.trace(1, "Error: " + string);
                        throw new IllegalArgumentException(string);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.trace(1, "A RuntimeException (" + runtimeException.toString() + ") occurred while notifying listener " + connectionEventListener);
            }
            this.trace(5, "FINISH notification:  ConnectionEvent id=" + connectionEvent.getId() + "; hashCode=" + connectionEvent.hashCode() + "; listener=" + connectionEventListener);
            SiebelTrace.getInstance().popStack();
        }
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (printWriter != null) {
            this.trace(5, "logWriter set to " + printWriter + " on " + this.toString());
        }
        this.m_logWriter = printWriter;
        if (this.m_connection == null) {
            throw new IllegalStateException(CSSMsgMgr.get(8716398));
        }
        this.m_connection.setLogWriter(printWriter);
    }

    public String toString() {
        return "SiebelManagedConnection(" + this.hashCode() + ")";
    }

    private void validateConnectionState() throws IllegalStateException {
        if (this.m_destroyed) {
            this.trace(1, "Error: Siebel Managed Connection already closed.");
            throw new IllegalStateException(CSSMsgMgr.get(8716398));
        }
    }
}

