/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.spi;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.jca.spi.SiebelConnectionRequestInfo;
import com.siebel.integration.jca.spi.SiebelManagedConnection;
import com.siebel.integration.sessmgr.SiebelJCASessionManager;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.integration.util.SiebelUserProperties;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class SiebelManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
ValidatingManagedConnectionFactory {
    private transient PrintWriter m_logWriter = null;
    protected SiebelUserProperties m_properties = new SiebelUserProperties();
    protected String m_id = null;
    protected boolean m_b2bMode = false;
    protected String m_b2bUser = "";
    protected String m_b2bPassword = "";

    public SiebelManagedConnectionFactory() {
        try {
            String string = this.m_properties.getLanguage();
            if (string == null) {
                string = "enu";
            }
            CSSMsgMgr.loadMessages(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SiebelManagedConnectionFactory(String string, String string2, String string3) {
        this.setUserName(string);
        this.setPassword(string2);
        this.setConnectString(string3);
        try {
            CSSMsgMgr.loadMessages("enu");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SiebelManagedConnectionFactory(String string, String string2, String string3, String string4) {
        this.setUserName(string);
        this.setPassword(string2);
        this.setConnectString(string3);
        this.setLanguage(string4);
        try {
            if (string4 == null) {
                string4 = "enu";
            }
            CSSMsgMgr.loadMessages(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract Object createConnectionFactory() throws ResourceException;

    public abstract Object createConnectionFactory(ConnectionManager var1) throws ResourceException;

    public abstract ManagedConnection createManagedConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SiebelManagedConnectionFactory) {
            SiebelManagedConnectionFactory siebelManagedConnectionFactory = (SiebelManagedConnectionFactory)object;
            if (this.m_id.equals(siebelManagedConnectionFactory.m_id)) {
                return true;
            }
        }
        return false;
    }

    public String getConnectString() {
        return this.m_properties.getConnectString();
    }

    public boolean getEncrypted() {
        return this.m_properties.getEncrypted();
    }

    public String getLanguage() {
        return this.m_properties.getLanguage();
    }

    public int getLogLevel() {
        return this.m_properties.getLogLevel();
    }

    public String getPassword() {
        if (this.m_b2bMode) {
            return this.m_b2bPassword;
        }
        return this.m_properties.getPassword();
    }

    public String getUserName() {
        if (this.m_b2bMode) {
            return this.m_b2bUser;
        }
        return this.m_properties.getUserName();
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_logWriter;
    }

    public int hashCode() {
        if (this.m_id == null) {
            this.m_id = new UID().toString();
        }
        return this.m_id.hashCode();
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        String string;
        PasswordCredential passwordCredential;
        SiebelTrace.getInstance().pushStack("MCF.match");
        this.trace(3, "matchManagedConnections(" + set.size() + " connections; CRI=" + connectionRequestInfo + "; Subject=" + subject);
        SiebelConnectionRequestInfo siebelConnectionRequestInfo = null;
        if (connectionRequestInfo instanceof SiebelConnectionRequestInfo) {
            siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
        }
        String string2 = this.getUserName();
        if (siebelConnectionRequestInfo != null) {
            string2 = siebelConnectionRequestInfo.getUserName();
        }
        if (subject != null && (passwordCredential = this.getMatchingCredentials(subject)) != null) {
            string2 = passwordCredential.getUserName();
        }
        passwordCredential = null;
        if (siebelConnectionRequestInfo != null && (string = siebelConnectionRequestInfo.getSessionId()) != null) {
            passwordCredential = this.matchOnSessionId(set, string, string2);
        }
        if (passwordCredential == null) {
            string = this.getConnectString();
            String string3 = this.getLanguage();
            if (siebelConnectionRequestInfo != null) {
                string = siebelConnectionRequestInfo.getConnectString();
                string3 = siebelConnectionRequestInfo.getLanguage();
            }
            passwordCredential = this.matchOnConnCriteria(set, string2, string, string3);
        }
        SiebelTrace.getInstance().popStack();
        return passwordCredential;
    }

    private ManagedConnection matchOnConnCriteria(Set set, String string, String string2, String string3) throws ResourceException {
        for (Object e : set) {
            SiebelManagedConnectionFactory siebelManagedConnectionFactory;
            if (!(e instanceof SiebelManagedConnection)) continue;
            SiebelManagedConnection siebelManagedConnection = (SiebelManagedConnection)e;
            try {
                siebelManagedConnectionFactory = (SiebelManagedConnectionFactory)siebelManagedConnection.getManagedConnectionFactory();
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            if (!siebelManagedConnection.getConnectString().equals(string2) || !siebelManagedConnection.getLanguage().equals(string3) || !siebelManagedConnection.getUserName().equals(string) || !siebelManagedConnectionFactory.equals(this)) continue;
            this.trace(3, "Matched connection by attributes, with username=" + siebelManagedConnection.getUserName());
            return siebelManagedConnection;
        }
        this.trace(3, "No connection had matching connection parameters.");
        return null;
    }

    private ManagedConnection matchOnSessionId(Set set, String string, String string2) {
        for (Object e : set) {
            SiebelManagedConnectionFactory siebelManagedConnectionFactory;
            if (!(e instanceof SiebelManagedConnection)) continue;
            SiebelManagedConnection siebelManagedConnection = (SiebelManagedConnection)e;
            try {
                siebelManagedConnectionFactory = (SiebelManagedConnectionFactory)siebelManagedConnection.getManagedConnectionFactory();
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            if (!siebelManagedConnection.getSessionId().equals(string) || !siebelManagedConnection.getUserName().equals(string2) || !siebelManagedConnectionFactory.equals(this)) continue;
            this.trace(3, "Matched connection by sessionId.");
            return siebelManagedConnection;
        }
        this.trace(5, "No connection had a matching sessionId");
        return null;
    }

    public void setConnectString(String string) {
        this.m_properties.setConnectString(string);
    }

    public void setUserName(String string) {
        this.m_properties.setUserName(string);
        SiebelJCASessionManager.RA_USER = string;
    }

    public void setLogLevel(int n) {
        try {
            SiebelTrace.getInstance().setLogLevel(n);
            this.trace(5, "setLogLevel(" + n + ")");
        }
        catch (Exception exception) {
            this.trace(1, "Invalid log level specified : " + n);
        }
    }

    public void setLogLevel(String string) {
        try {
            this.trace(5, "setLogLevel(" + string + ")");
            SiebelTrace.getInstance().setLogLevel(string);
        }
        catch (Exception exception) {
            System.out.println("Invalid log level specified : " + string);
            SiebelTrace.getInstance().setLogLevel(1);
            throw new IllegalArgumentException("logLevel");
        }
    }

    public void setLanguage(String string) {
        this.m_properties.setLanguage(string);
    }

    public void setPassword(String string) {
        this.m_properties.setPassword(string);
        SiebelJCASessionManager.RA_PWD = string;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.m_logWriter = printWriter;
    }

    protected void trace(int n, String string) {
        try {
            SiebelTrace.getInstance().trace(this.getLogWriter(), n, this.getMODULE_NAME(), string);
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public abstract String getMODULE_NAME();

    protected PasswordCredential getMatchingCredentials(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<PasswordCredential> set = subject.getPrivateCredentials(PasswordCredential.class);
        for (PasswordCredential passwordCredential : set) {
            if (!this.equals(passwordCredential.getManagedConnectionFactory())) continue;
            return passwordCredential;
        }
        this.trace(3, "Subject has no PasswordCredential for this ManagedConnectionFactory");
        return null;
    }
}

