/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.spi.notx;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.jca.spi.SiebelConnectionManager;
import com.siebel.integration.jca.spi.SiebelConnectionRequestInfo;
import com.siebel.integration.jca.spi.notx.SiebelNoTxConnectionPoolEventListener;
import com.siebel.integration.util.SiebelTrace;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class SiebelNoTxConnectionManager
extends SiebelConnectionManager
implements ConnectionManager,
Serializable {
    public SiebelNoTxConnectionManager() {
    }

    public SiebelNoTxConnectionManager(String string) {
        super(string);
    }

    public SiebelNoTxConnectionManager(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public SiebelNoTxConnectionManager(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.trace(managedConnectionFactory.getLogWriter(), 5, "Allocating a connection for the MCF=" + managedConnectionFactory + " with CRI=" + connectionRequestInfo);
        SiebelConnectionRequestInfo siebelConnectionRequestInfo = this.createSCRI(connectionRequestInfo, managedConnectionFactory.getLogWriter());
        HashSet<PasswordCredential> hashSet = new HashSet<PasswordCredential>();
        PasswordCredential passwordCredential = new PasswordCredential(siebelConnectionRequestInfo.getUserName(), siebelConnectionRequestInfo.getPassword().toCharArray());
        hashSet.add(passwordCredential);
        Subject subject = new Subject(true, new HashSet(), new HashSet(), hashSet);
        ManagedConnection managedConnection = null;
        Object object = managedConnectionFactory;
        synchronized (object) {
            boolean bl;
            managedConnection = managedConnectionFactory.matchManagedConnections((Set)this.m_connectionPool.getConnections(), subject, (ConnectionRequestInfo)siebelConnectionRequestInfo);
            if (managedConnection != null && !(bl = this.m_connectionPool.removeConnection(managedConnection))) {
                managedConnection = null;
            }
        }
        if (managedConnection == null) {
            this.trace(managedConnectionFactory.getLogWriter(), 5, "No existing connections; creating a new one");
            managedConnection = managedConnectionFactory.createManagedConnection(null, (ConnectionRequestInfo)siebelConnectionRequestInfo);
            object = new SiebelNoTxConnectionPoolEventListener(this.m_connectionPool, managedConnection);
            managedConnection.addConnectionEventListener((ConnectionEventListener)object);
        } else {
            this.trace(managedConnectionFactory.getLogWriter(), 5, "Found an existing connection to reuse");
        }
        return managedConnection.getConnection(null, (ConnectionRequestInfo)siebelConnectionRequestInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SiebelConnectionRequestInfo createSCRI(ConnectionRequestInfo connectionRequestInfo, PrintWriter printWriter) throws IllegalArgumentException {
        SiebelConnectionRequestInfo siebelConnectionRequestInfo = null;
        if (connectionRequestInfo != null) {
            if (connectionRequestInfo instanceof SiebelConnectionRequestInfo) {
                siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
                if (siebelConnectionRequestInfo.getConnectString() != null && siebelConnectionRequestInfo.getUserName() != null) {
                    if (siebelConnectionRequestInfo.getPassword() != null) return siebelConnectionRequestInfo;
                }
                this.trace(printWriter, 1, "Insufficient connection parameters supplied: connectString=" + siebelConnectionRequestInfo.getConnectString() + "; username=" + siebelConnectionRequestInfo.getUserName() + "; password=" + siebelConnectionRequestInfo.getPassword());
                throw new IllegalArgumentException(CSSMsgMgr.get(8716395));
            }
            this.trace(printWriter, 1, "Invalid ConnectionRequestInfo passed to allocateConnection");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716402));
        }
        if (this.m_properties == null) {
            this.trace(printWriter, 1, "No connection parameters supplied (properties file not found)");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716400));
        }
        String string = this.m_properties.getUserName();
        String string2 = this.m_properties.getPassword();
        String string3 = this.m_properties.getConnectString();
        String string4 = this.m_properties.getLanguage();
        if (string == null || string2 == null || string3 == null) {
            this.trace(printWriter, 1, "Insufficient connection parameters supplied in properties file: connectString=" + string3 + "; username=" + string + "; password=" + string2);
            throw new IllegalArgumentException(CSSMsgMgr.get(8716400));
        }
        if (string4 != null) return new SiebelConnectionRequestInfo(null, string, string2, string3, string4);
        string4 = "enu";
        return new SiebelConnectionRequestInfo(null, string, string2, string3, string4);
    }

    private void trace(PrintWriter printWriter, int n, String string) {
        SiebelTrace.getInstance().trace(printWriter, n, "Connection Manager", string);
    }
}

