/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.spi.notx;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSPropertySetEx;
import com.siebel.integration.adapter.SiebelJCAAdapterBase;
import com.siebel.integration.jca.cci.SiebelConnection;
import com.siebel.integration.jca.cci.notx.SiebelNoTxConnection;
import com.siebel.integration.jca.cci.notx.SiebelNoTxConnectionFactory;
import com.siebel.integration.jca.eis.SiebelCon;
import com.siebel.integration.jca.spi.SiebelConnectionRequestInfo;
import com.siebel.integration.jca.spi.SiebelManagedConnectionFactory;
import com.siebel.integration.jca.spi.notx.SiebelNoTxManagedConnection;
import com.siebel.integration.sessmgr.SiebelJCASessionManager;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.om.conmgr.ConnectionManager;
import com.siebel.om.conmgr.SSLConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class SiebelNoTxManagedConnectionFactory
extends SiebelManagedConnectionFactory {
    protected static String MODULE_NAME = "SiebelNoTxManagedConnectionFactory";
    private static String BUSINESS_SERVICE = "EAI JCA Service";
    private static String METHOD_ECHO = "Echo";

    public SiebelNoTxManagedConnectionFactory() {
    }

    public SiebelNoTxManagedConnectionFactory(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public SiebelNoTxManagedConnectionFactory(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    @Override
    public Object createConnectionFactory() throws ResourceException {
        SiebelTrace.getInstance().pushStack("MCF.createCF");
        SiebelNoTxConnectionFactory siebelNoTxConnectionFactory = new SiebelNoTxConnectionFactory(this, null);
        SiebelTrace.getInstance().popStack();
        return siebelNoTxConnectionFactory;
    }

    @Override
    public Object createConnectionFactory(javax.resource.spi.ConnectionManager connectionManager) throws ResourceException {
        SiebelTrace.getInstance().pushStack("MCF.createCF");
        SiebelNoTxConnectionFactory siebelNoTxConnectionFactory = new SiebelNoTxConnectionFactory(this, connectionManager);
        SiebelTrace.getInstance().popStack();
        return siebelNoTxConnectionFactory;
    }

    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        SiebelTrace.getInstance().pushStack("MCF.createMC");
        PasswordCredential passwordCredential = this.getMatchingCredentials(subject);
        this.trace(5, "createManagedConnection(CRI=" + connectionRequestInfo + "; Subject=" + subject);
        if (passwordCredential != null) {
            this.trace(5, "createManagedConnection() using values from Subject");
        } else if (connectionRequestInfo != null) {
            this.trace(5, "createManagedConnection() using CRI (SiebelConnectionRequestInfo)");
            if (subject != null) {
                this.trace(2, "createManagedConnection() passed a Subject with no PasswordCredentials matching this MCF.");
            }
        } else {
            this.trace(5, "createManagedConnection() using defaults (ra.xml descriptor values)");
        }
        String string = this.getUserName();
        String string2 = this.getPassword();
        String string3 = this.getConnectString();
        String string4 = this.getLanguage();
        if (connectionRequestInfo != null) {
            try {
                object = (SiebelConnectionRequestInfo)connectionRequestInfo;
                string = ((SiebelConnectionRequestInfo)object).getUserName();
                string2 = ((SiebelConnectionRequestInfo)object).getPassword();
                string3 = ((SiebelConnectionRequestInfo)object).getConnectString();
                string4 = ((SiebelConnectionRequestInfo)object).getLanguage();
            }
            catch (ClassCastException classCastException) {
                this.trace(2, "createManagedConnection(): ConnectionRequestInfo is not of type SiebelConnectionRequestInfo");
            }
            if (string == null || string2 == null || string3 == null) {
                this.trace(1, "createManagedConnection(): Passed SiebelConnectionRequestInfo with null value: " + connectionRequestInfo.toString());
                SiebelTrace.getInstance().popStack();
                throw new SecurityException(CSSMsgMgr.get(8716395));
            }
        }
        if (passwordCredential != null) {
            string = passwordCredential.getUserName();
            string2 = new String(passwordCredential.getPassword());
        }
        object = null;
        try {
            object = new SiebelNoTxConnection(string, string2, string3, string4);
            ((SiebelConnection)object).setLogWriter(this.getLogWriter());
        }
        catch (ResourceException resourceException) {
            SiebelTrace.getInstance().popStack();
            throw resourceException;
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().popStack();
            String string5 = CSSMsgMgr.get(8716405);
            ResourceException resourceException = new ResourceException(string5);
            this.trace(1, "Error while attempting to create a managed connection " + string5);
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        SiebelNoTxManagedConnection siebelNoTxManagedConnection = new SiebelNoTxManagedConnection(this, (SiebelConnection)object, ((SiebelConnection)object).getSessionId(), string, string3, string4);
        SiebelTrace.getInstance().popStack();
        return siebelNoTxManagedConnection;
    }

    @Override
    public String getMODULE_NAME() {
        return MODULE_NAME;
    }

    public void setConnectionURL(String string) {
        this.setConnectString(string);
    }

    public void setSiebelLanguage(String string) {
        this.setLanguage(string);
    }

    public void setResRefName(String string) {
        SiebelJCAAdapterBase.m_resourceReferenceName = string;
    }

    public void setCacheDuration(String string) {
        SiebelJCAAdapterBase.m_cacheDuration = Long.parseLong(string) * 60000L;
    }

    public void setLogFile(String string) {
        SiebelTrace.getInstance().setLogfile(string);
    }

    public void setMaxAnonUsers(String string) {
        SiebelJCASessionManager.MAX_ANON_USERS = Integer.parseInt(string);
    }

    public void setSessionTokenMaxAge(String string) {
        SiebelJCASessionManager.setSessionTokenMaxAge(new Long(string) * 60L * 1000L);
    }

    public void setSessionTimeout(String string) {
        int n = new Integer(string);
        if (n < 1) {
            n = 45;
        }
        ConnectionManager.setSessionTimeout(n * 60);
    }

    public void setConnectionsPerEAIOM(String string) {
        int n = new Integer(string);
        if (n < 1) {
            n = 5;
        } else if (n > 100) {
            n = 100;
        }
        ConnectionManager.setPoolSize(n);
    }

    public void setB2BMode(String string) {
        this.m_b2bMode = new Boolean(string);
        SiebelJCASessionManager.setB2BMode(this.m_b2bMode);
    }

    public void setB2BUser(String string) {
        this.m_b2bUser = string;
    }

    public void setB2BPassword(String string) {
        this.m_b2bPassword = string;
    }

    public void setSessionTokenTimeout(String string) {
        SiebelJCASessionManager.setSessionTokenTimeout(new Long(string) * 60000L);
    }

    public void setKeystoreName(String string) {
        SSLConfig.setKeyStoreName(string);
    }

    public void setTruststoreName(String string) {
        SSLConfig.setTrustStorename(string);
    }

    public void setKeystoreAlias(String string) {
        SSLConfig.setKeyStoreAlias(string);
    }

    public void setKeystorePassword(String string) {
        SSLConfig.setKeyStorePassword(string);
    }

    public void setTruststorePassword(String string) {
        SSLConfig.setTrustStorePassword(string);
    }

    public void setVirtualHosts(String string) {
        ConnectionManager.InitVirtualServer(string);
    }

    public void setCloseOnAppError(String string) {
        SiebelJCASessionManager.setCloseOnAppError(Boolean.valueOf(string));
    }

    public void setUseOnlyLatestToken(String string) {
        SiebelJCASessionManager.setBUseOnlyLatestToken(Boolean.valueOf(string));
    }

    public void setPingThresholdTime(String string) {
        SiebelJCASessionManager.setThresholdTime(new Long(string) * 60000L);
    }

    public Set getInvalidConnections(Set set) throws ResourceException {
        CSSPropertySetEx cSSPropertySetEx = new CSSPropertySetEx();
        HashSet<SiebelNoTxManagedConnection> hashSet = new HashSet<SiebelNoTxManagedConnection>();
        Iterator iterator = set.iterator();
        SiebelNoTxManagedConnection siebelNoTxManagedConnection = null;
        while (iterator.hasNext()) {
            try {
                siebelNoTxManagedConnection = (SiebelNoTxManagedConnection)iterator.next();
                cSSPropertySetEx.setProperty("ConnectionID", siebelNoTxManagedConnection.getSessionId());
                SiebelCon.invoke(siebelNoTxManagedConnection.getSessionId(), BUSINESS_SERVICE, METHOD_ECHO, cSSPropertySetEx);
            }
            catch (Exception exception) {
                if (exception.getMessage().indexOf("SBL-SMI-00107") < 0) continue;
                hashSet.add(siebelNoTxManagedConnection);
                ResourceException resourceException = new ResourceException(exception.getMessage());
                throw resourceException;
            }
        }
        return hashSet;
    }
}

