/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.jca.util;

import com.siebel.common.common.CSSMsgMgr;
import com.siebel.integration.jca.spi.SiebelConnectionRequestInfo;
import com.siebel.integration.util.SiebelTrace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class CommonUtilities {
    public static void checkCredential(PasswordCredential passwordCredential, String string) throws SecurityException {
        if (passwordCredential == null) {
            if (string != null) {
                throw new SecurityException(CSSMsgMgr.get(8716399));
            }
        } else if (!passwordCredential.getUserName().equals(string)) {
            SiebelTrace.getInstance().trace(null, 2, "CommonUtilities", "Throwing SecurityException: Username different from that in PasswordCredential");
            throw new SecurityException(CSSMsgMgr.get(8716399));
        }
    }

    public static String getConnectString(ConnectionRequestInfo connectionRequestInfo) throws Exception {
        try {
            SiebelConnectionRequestInfo siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
            return siebelConnectionRequestInfo.getConnectString();
        }
        catch (Exception exception) {
            throw new Exception("Could not extract connection string from ConnectionRequestInfo");
        }
    }

    public static String getLanguage(ConnectionRequestInfo connectionRequestInfo) throws Exception {
        try {
            SiebelConnectionRequestInfo siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
            return siebelConnectionRequestInfo.getLanguage();
        }
        catch (Exception exception) {
            throw new Exception("Could not extract the language from ConnectionRequestInfo");
        }
    }

    public static PasswordCredential getPasswordCredential(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = null;
        if (subject == null) {
            SiebelConnectionRequestInfo siebelConnectionRequestInfo;
            if (connectionRequestInfo != null && (siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo).getUserName() != null && siebelConnectionRequestInfo.getPassword() != null) {
                passwordCredential = new PasswordCredential(siebelConnectionRequestInfo.getUserName(), siebelConnectionRequestInfo.getPassword().toCharArray());
                passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
            }
        } else {
            Set<PasswordCredential> set = subject.getPrivateCredentials(PasswordCredential.class);
            Iterator<PasswordCredential> iterator = set.iterator();
            while (iterator.hasNext()) {
                PasswordCredential passwordCredential2;
                passwordCredential = passwordCredential2 = iterator.next();
            }
        }
        if (passwordCredential == null) {
            // empty if block
        }
        return passwordCredential;
    }

    public static String getSessionId(ConnectionRequestInfo connectionRequestInfo) throws Exception {
        String string = null;
        try {
            SiebelConnectionRequestInfo siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
            string = siebelConnectionRequestInfo.getSessionId();
        }
        catch (Exception exception) {
            throw new Exception("Could not extract the session id from ConnectionRequestInfo");
        }
        return string;
    }

    public static Subject getSubject(SiebelConnectionRequestInfo siebelConnectionRequestInfo) {
        HashSet<PasswordCredential> hashSet = new HashSet<PasswordCredential>();
        PasswordCredential passwordCredential = new PasswordCredential(siebelConnectionRequestInfo.getUserName(), siebelConnectionRequestInfo.getPassword().toCharArray());
        hashSet.add(passwordCredential);
        Subject subject = new Subject(true, new HashSet(), new HashSet(), hashSet);
        return subject;
    }

    public static void setConnectString(ConnectionRequestInfo connectionRequestInfo, String string) throws Exception {
        try {
            SiebelConnectionRequestInfo siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
            siebelConnectionRequestInfo.setConnectString(string);
        }
        catch (Exception exception) {
            throw new Exception("Could not set the connect string in the ConnectionRequestInfo");
        }
    }

    public static void setSessionId(ConnectionRequestInfo connectionRequestInfo, String string) throws Exception {
        try {
            SiebelConnectionRequestInfo siebelConnectionRequestInfo = (SiebelConnectionRequestInfo)connectionRequestInfo;
            siebelConnectionRequestInfo.setSessionId(string);
        }
        catch (Exception exception) {
            throw new Exception("Could not set the session id in the ConnectionRequestInfo");
        }
    }
}

