/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.mq;

import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.siebel.integration.ProcessException;
import com.siebel.integration.ProcessRequest;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class SiebelMqBaseServer
implements ProcessRequest,
MessageListener {
    protected static final String DEFAULT_INPUT_QUEUE_NAME = "SiebelInputQueue";
    protected static final String DEFAULT_OUTPUT_QUEUE_NAME = "SiebelOutputQueue";
    protected static final String DEFAULT_MESSAGE_QUEUE_NAME = "SiebelQueueManager";
    protected static int PERSISTENCE = 1;
    protected static int PRIORITY = 5;
    protected static int TARGETCLIENT = 1;
    protected String m_inputQueueName = "SiebelInputQueue";
    protected String m_outputQueueName = "SiebelOutputQueue";
    protected String m_queueManagerName = "SiebelQueueManager";
    protected Queue m_inputQueue;
    protected Queue m_outputQueue;
    protected QueueSender m_queueSender;
    protected QueueReceiver m_queueReceiver;
    protected QueueSession m_queueSession;
    protected QueueConnection m_queueConnection;
    protected MQQueueConnectionFactory m_queueConnectionFactory;

    public SiebelMqBaseServer() throws JMSException {
        this.initConnection();
    }

    public SiebelMqBaseServer(String string, String string2) throws JMSException {
        if (string != null) {
            this.m_queueManagerName = string;
        }
        if (string2 != null) {
            this.m_inputQueueName = string2;
        }
        this.initConnection();
    }

    public SiebelMqBaseServer(String string, String string2, String string3) throws JMSException {
        if (string != null) {
            this.m_queueManagerName = string;
        }
        if (string2 != null) {
            this.m_inputQueueName = string2;
        }
        if (string3 != null) {
            this.m_outputQueueName = string3;
        }
        this.initConnection();
    }

    public void initConnection() throws JMSException {
        String string = "queue://" + this.m_queueManagerName + '/' + this.m_outputQueueName + "?persistence=" + PERSISTENCE + "&priority=" + PRIORITY + "&targetClient=" + TARGETCLIENT;
        this.m_queueConnectionFactory = new MQQueueConnectionFactory();
        this.m_queueConnectionFactory.setQueueManager(this.m_queueManagerName);
        this.m_queueConnection = this.m_queueConnectionFactory.createQueueConnection();
        this.m_queueConnection.start();
        this.m_queueSession = this.m_queueConnection.createQueueSession(false, 1);
        this.m_inputQueue = this.m_queueSession.createQueue(this.m_inputQueueName);
        this.m_outputQueue = this.m_queueSession.createQueue(string);
        this.m_queueReceiver = this.m_queueSession.createReceiver(this.m_inputQueue);
        this.m_queueSender = this.m_queueSession.createSender(this.m_outputQueue);
        this.m_queueReceiver.setMessageListener((MessageListener)this);
    }

    public void onMessage(Message message) {
        block7: {
            String string = null;
            try {
                if (message instanceof TextMessage) {
                    try {
                        string = this.processRequest(this.m_inputQueue, ((TextMessage)message).getText());
                        if (string != null) {
                            this.sendMessage(message.getJMSMessageID(), string);
                        }
                        break block7;
                    }
                    catch (ProcessException processException) {
                        System.out.println("Process Exception : " + processException.getMessage());
                    }
                    break block7;
                }
                System.out.println("Process Exception : Invalid message type.");
            }
            catch (JMSException jMSException) {
                System.out.println("JMSException :" + jMSException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("Exception    :" + exception.getMessage());
            }
        }
    }

    public void finalize() {
        try {
            this.m_queueReceiver.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_queueSender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_queueSession.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_queueConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-mgr")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-in")) {
                string2 = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-out")) continue;
            string3 = stringArray[++i];
        }
        try {
            SiebelMqBaseServer siebelMqBaseServer = new SiebelMqBaseServer(string, string2, string3);
        }
        catch (JMSException jMSException) {
            System.out.println(jMSException.getMessage());
        }
        while (true) {
            // Infinite loop
        }
    }

    public void sendMessage(String string, String string2) throws JMSException {
        TextMessage textMessage = this.m_queueSession.createTextMessage(string2);
        if (string != null) {
            textMessage.setJMSCorrelationID(string);
        }
        this.m_queueSender.send((Message)textMessage);
    }

    @Override
    public String processRequest(Object object, String string) throws ProcessException {
        String string2 = null;
        System.out.println("Just received : " + string);
        return string2;
    }
}

