/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.servlet;

import com.siebel.integration.ProcessException;
import com.siebel.integration.ProcessRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SiebelHttpBaseServlet
extends HttpServlet
implements ProcessRequest {
    public static final int PAGE_SCOPE = 1;
    public static final int REQUEST_SCOPE = 2;
    public static final int SESSION_SCOPE = 3;
    public static final int APPLICATION_SCOPE = 4;
    private static final String XML_DOCUMENT_PARAMETER = "servlet.base.xml.request";
    private static final String INVALID_NAME = "servlet.base.invalid.name";
    private static final String INVALID_VALUE = "servlet.base.invalid.value";
    private static final String INVALID_COOKIE = "servlet.base.invalid.cookie";
    private static final String INVALID_SCOPE = "servlet.base.invalid.scope";
    protected ResourceBundle fieldResourceBundle = null;
    protected String fieldResourceBundleName = null;

    public SiebelHttpBaseServlet() {
        try {
            this.fieldResourceBundleName = "BaseServlet";
            this.fieldResourceBundle = ResourceBundle.getBundle(this.fieldResourceBundleName);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Could not find the resource bundle (BaseServlet).");
        }
    }

    public SiebelHttpBaseServlet(String string) {
        try {
            this.fieldResourceBundleName = string;
            this.fieldResourceBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Could not find the resource bundle (" + string + ").");
        }
    }

    public void addCookie(HttpServletResponse httpServletResponse, String string, String string2) {
        Cookie cookie = new Cookie(string, string2);
        httpServletResponse.addCookie(cookie);
    }

    public void addCookie(HttpServletResponse httpServletResponse, String string, String string2, int n) {
        Cookie cookie = null;
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_VALUE));
        }
        cookie = new Cookie(string, string2);
        cookie.setMaxAge(n);
        httpServletResponse.addCookie(cookie);
    }

    public void addCookie(HttpServletResponse httpServletResponse, Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException(this.fieldResourceBundle.getString(INVALID_COOKIE));
        }
        httpServletResponse.addCookie(cookie);
    }

    protected Enumeration arrayToEnum(Object[] objectArray) {
        if (objectArray != null) {
            Vector<Object> vector = new Vector<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i]);
            }
            return vector.elements();
        }
        return null;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        BufferedReader bufferedReader = null;
        try {
            string2 = httpServletRequest.getContentType();
            bufferedReader = httpServletRequest.getReader();
            string = new String();
            while ((string4 = bufferedReader.readLine()) != null) {
                string = string + string4;
            }
            string3 = this.processRequest(httpServletRequest, string);
        }
        catch (ProcessException processException) {
            httpServletResponse.setStatus(processException.getStatus());
            this.log("Received an process exception : " + processException.getMessage());
        }
        if (string3 != null && string3.length() > 0) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println(string3);
        }
    }

    public void endSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        httpSession = httpServletRequest.getSession(true);
    }

    public Object findAttribute(HttpServletRequest httpServletRequest, String string) {
        Object object = null;
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        object = this.getAttribute(httpServletRequest, string, 2);
        if (object == null && (object = this.getAttribute(httpServletRequest, string, 3)) == null) {
            object = this.getAttribute(httpServletRequest, string, 4);
        }
        return object;
    }

    public String findParameter(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        string2 = this.getParameter(httpServletRequest, string, 2);
        if (string2 == null) {
            string2 = this.getParameter(httpServletRequest, string, 4);
        }
        return string2;
    }

    public void forward(HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        httpServletResponse.sendRedirect(string);
    }

    public Object getAttribute(HttpServletRequest httpServletRequest, String string) {
        return this.getAttribute(httpServletRequest, string, 2);
    }

    public Object getAttribute(HttpServletRequest httpServletRequest, String string, int n) {
        Object object = null;
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        switch (n) {
            case 2: {
                object = httpServletRequest.getAttribute(string);
                break;
            }
            case 3: {
                object = httpServletRequest.getSession(true).getValue(string);
                break;
            }
            case 4: {
                object = this.getServletContext().getAttribute(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
        }
        return object;
    }

    public Enumeration getAttributeNamesInScope(HttpServletRequest httpServletRequest, int n) {
        Enumeration enumeration = null;
        switch (n) {
            case 2: {
                enumeration = httpServletRequest.getParameterNames();
                break;
            }
            case 3: {
                enumeration = this.arrayToEnum(httpServletRequest.getSession(false).getValueNames());
                break;
            }
            case 4: {
                enumeration = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
        }
        return enumeration;
    }

    public Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        Cookie cookie = null;
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!cookieArray[i].getName().equals(string)) continue;
                cookie = cookieArray[i];
                break;
            }
        }
        return cookie;
    }

    public String getCookieValue(HttpServletRequest httpServletRequest, String string) {
        Cookie cookie = this.getCookie(httpServletRequest, string);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public String getExtraPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getPathInfo();
    }

    public String getParameter(HttpServletRequest httpServletRequest, String string) {
        return this.getParameter(httpServletRequest, string, 2);
    }

    public String getParameter(HttpServletRequest httpServletRequest, String string, int n) {
        String string2 = null;
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        switch (n) {
            case 2: {
                string2 = httpServletRequest.getParameter(string);
                break;
            }
            case 3: 
            case 4: {
                string2 = this.getServletConfig().getInitParameter(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
        }
        return string2;
    }

    public Enumeration getParameterNamesInScope(HttpServletRequest httpServletRequest, int n) {
        Enumeration enumeration = null;
        switch (n) {
            case 1: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
            case 2: {
                enumeration = httpServletRequest.getParameterNames();
                break;
            }
            case 3: 
            case 4: {
                enumeration = this.getServletConfig().getInitParameterNames();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
        }
        return enumeration;
    }

    public HttpSession getSession(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        return httpServletRequest.getSession(true);
    }

    public void removeAttribute(HttpServletRequest httpServletRequest, String string) {
        this.removeAttribute(httpServletRequest, string, 3);
    }

    public void removeAttribute(HttpServletRequest httpServletRequest, String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        switch (n) {
            case 3: {
                httpServletRequest.getSession(true).removeValue(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
        }
    }

    public void setAttribute(HttpServletRequest httpServletRequest, String string, Object object) {
        this.setAttribute(httpServletRequest, string, object, 2);
    }

    public void setAttribute(HttpServletRequest httpServletRequest, String string, Object object, int n) {
        if (string == null) {
            throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_NAME));
        }
        switch (n) {
            case 2: {
                break;
            }
            case 3: {
                httpServletRequest.getSession(true).putValue(string, object);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(this.fieldResourceBundle.getString(INVALID_SCOPE));
            }
        }
    }

    public void setResourceBundle(String string) {
        this.fieldResourceBundleName = string;
        this.fieldResourceBundle = ResourceBundle.getBundle(string);
    }

    public String startSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
        httpSession = httpServletRequest.getSession(true);
        return httpSession.getId();
    }

    @Override
    public String processRequest(Object object, String string) throws ProcessException {
        return string;
    }
}

