/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.sessmgr;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.common.CSSPropertySetEx;
import com.siebel.common.crypt.SessionTokenRSACrypt;
import com.siebel.common.crypt.SiebelCipher;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.StreamingException;
import com.siebel.integration.jca.cci.SiebelConnection;
import com.siebel.integration.jca.client.SiebelConnectionHandle;
import com.siebel.integration.jca.client.SiebelConnectionSpec;
import com.siebel.integration.jca.client.SiebelInteraction;
import com.siebel.integration.jca.client.SiebelInteractionSpec;
import com.siebel.integration.jca.client.SiebelPropertySetRecord;
import com.siebel.integration.jca.eis.SiebelCon;
import com.siebel.integration.jca.eis.SiebelConException;
import com.siebel.integration.jca.spi.SiebelManagedConnection;
import com.siebel.integration.sessmgr.UserConnectionMap;
import com.siebel.integration.sessmgr.streamhandler.StreamHandler;
import com.siebel.integration.sessmgr.streamhandler.StreamObject;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.integration.util.SiebelUserProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.InteractionSpec;

public class SiebelJCASessionManager {
    private String m_userName = null;
    private String m_password = null;
    private String m_sessionType = null;
    private String m_sessionToken = null;
    private String m_impersonate = null;
    private String m_newSessionToken = null;
    private String m_xsdUri = null;
    private ConnectionFactory m_connectionFactory = null;
    private SiebelUserProperties m_properties = null;
    private String m_siebelServiceName = null;
    private String m_methodName = null;
    private SiebelInteraction m_interaction = null;
    private boolean m_newToken = false;
    private boolean m_StatefulFromAnotherServer = false;
    private SiebelPropertySet m_spsSessTokenAttr = null;
    private SiebelPropertySet m_requestInput = null;
    private SessionTokenRSACrypt m_crypt = null;
    private boolean m_RESTRequest = false;
    private SiebelCipher m_siebCipher = null;
    private static final String TOKEN_ID = "TID";
    private static final String SESSION_ID = "SSI";
    private static final String USERNAME = "SUN";
    private static final String PASSWORD = "SPW";
    private static final String CREATE_TIME = "SCT";
    private static final String ACCESS_TIME = "SAT";
    private static final String NEW_TOKEN_FLAG = "NTF";
    private static final String TOKEN = "VSI";
    private static final String SESS_TYPE = "SST";
    private static final String IMPERSONATE = "Impersonate";
    private static final String IMPERSONATE_USER = "ImpersonateUser";
    private static final String IMPERSONATE_PASSWORD = "ImpersonatePasswd";
    private static final String SEED = "SeedString";
    private static final String OLD_SESSION_TOKEN = "oldSessionToken";
    private static final String NEW_SESSION_TOKEN = "newSessionToken";
    public static int MAX_ANON_USERS = 10;
    public static String RA_USER = null;
    public static String RA_PWD = null;
    private static boolean B2B_MODE = false;
    private static boolean B2B = false;
    private static long SESSION_TOKEN_MAX_AGE = 172800000L;
    private static long SESSION_TOKEN_TIMEOUT = 900000L;
    private static boolean CLOSE_ON_APP_ERROR = true;
    private static String JNDI_XSD_DIR = "XSDs.";
    private static String DOT_XSD = ".xsd";
    private static Vector<Connection> m_anonConnections = new Vector();
    protected static Hashtable<String, Connection> m_Connections = new Hashtable();
    private static boolean m_bUseOnlyLatestToken = true;
    private static String m_seed = "";
    protected static long m_thresholdTime = 900000L;
    private static UserConnectionMap m_userMap = new UserConnectionMap();
    private static SortedMap m_userAccessTimeMap = new TreeMap(new userAccessTimeCompartor());
    protected static Connection m_pingConnectionHandle = null;
    protected static Lock m_lock = new ReentrantLock();
    protected static Condition m_connObject = m_lock.newCondition();

    public SiebelJCASessionManager() {
    }

    public SiebelJCASessionManager(ConnectionFactory connectionFactory, SiebelUserProperties siebelUserProperties, String string) {
        this.m_connectionFactory = connectionFactory;
        this.m_properties = siebelUserProperties;
        this.m_siebelServiceName = string;
        B2B = this.getB2BMode();
        if (siebelUserProperties != null) {
            SESSION_TOKEN_MAX_AGE = this.getSessionTokenMaxAge(siebelUserProperties);
            SESSION_TOKEN_TIMEOUT = this.getSessionTokenTimeout(siebelUserProperties);
            if (siebelUserProperties.getMaxAnonUsers() != -1) {
                MAX_ANON_USERS = siebelUserProperties.getMaxAnonUsers();
            }
        }
    }

    public SiebelPropertySet handleRequest(String string, SiebelPropertySet siebelPropertySet) throws ResourceException, IllegalArgumentException, SiebelException, InterruptedException {
        SiebelPropertySet siebelPropertySet2 = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_newSessionToken = null;
        this.m_requestInput = siebelPropertySet;
        this.m_methodName = string;
        this.m_impersonate = !B2B ? "true" : "";
        if (this.m_connectionFactory == null) {
            throw new IllegalStateException("Connection Factory");
        }
        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Connection Factory is not null");
        Connection connection = null;
        connection = this.m_sessionToken != null ? this.processSTAndGetConnection() : this.getConnection();
        try {
            if (this.m_RESTRequest && this.m_xsdUri != null && !this.m_xsdUri.isEmpty()) {
                this.m_requestInput.setProperty("IsREST", "true");
                this.m_requestInput.setProperty("XsdUri", this.m_xsdUri);
            }
            Object object = new SiebelPropertySet(this.m_requestInput);
            object = this.removeXSDContent((SiebelPropertySet)object);
            if (!this.m_sessionType.equalsIgnoreCase("None")) {
                this.m_newSessionToken = this.generateSessionToken(connection);
            }
            if (m_bUseOnlyLatestToken && (this.m_sessionType.equalsIgnoreCase("Stateful") || this.m_sessionToken != null)) {
                ((SiebelPropertySet)object).setProperty(OLD_SESSION_TOKEN, this.m_sessionToken != null ? this.m_sessionToken : "");
                ((SiebelPropertySet)object).setProperty(NEW_SESSION_TOKEN, this.m_newSessionToken != null ? this.m_newSessionToken : "");
            }
            String string3 = "Input Request: ServiceName = " + this.m_siebelServiceName + ", MethodName = " + this.m_methodName;
            if (object != null) {
                string3 = ((SiebelPropertySet)object).getChildCount() > 0 ? string3 + ", Inupt Message = " + ((SiebelPropertySet)object).getChild(0).toString() : string3 + ", Inupt Message = " + ((SiebelPropertySet)object).toString();
            }
            SiebelTrace.getInstance().trace(null, 5, "SiebelJCASessionManager.handleRequest()", string3);
            siebelPropertySet2 = this.executeBusinessService(this.m_userName, this.m_password, string, (SiebelPropertySet)object, connection);
            SiebelPropertySet siebelPropertySet3 = this.doPostExecution(siebelPropertySet2, connection);
            if (siebelPropertySet3 != null) {
                siebelPropertySet2 = siebelPropertySet3;
            }
            if ((string2 = siebelPropertySet2.getProperty("ReLoginErrMsg")) != null) {
                this.close(this.m_interaction, connection);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", string2);
                throw illegalArgumentException;
            }
            string3 = "Response: ServiceName = " + this.m_siebelServiceName + ", MethodName = " + this.m_methodName + " completed successfully.";
            if (siebelPropertySet2 != null) {
                string3 = string3 + "  Output Message = " + siebelPropertySet2.toString();
            }
            SiebelTrace.getInstance().trace(null, 5, "SiebelJCASessionManager.handleRequest()", string3);
        }
        catch (ResourceException resourceException) {
            Object object;
            if (connection == null && this.m_StatefulFromAnotherServer) {
                object = resourceException.getLinkedException();
                if (object.getClass() == SiebelConException.class && (!((SiebelConException)object).isAppErrorFlag() || ((SiebelConException)object).isAppErrorFlag() && CLOSE_ON_APP_ERROR)) {
                    bl2 = true;
                }
            } else if (!((SiebelConnectionHandle)connection).isValid()) {
                bl2 = true;
            }
            if (resourceException.getMessage().indexOf("SBL-JCA-0031") >= 0 || resourceException.getMessage().indexOf("8716599") >= 0) {
                if (this.m_userName != null && this.m_password != null) {
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Invalid connection possibly due to Siebel Server shutdown/restart or network failure. Attempting Reconnect");
                    siebelPropertySet2 = this.handleRequest(string, siebelPropertySet);
                    bl3 = true;
                    object = siebelPropertySet2;
                    return object;
                }
                if (this.m_sessionType.equalsIgnoreCase("Stateful")) {
                    this.m_sessionToken = null;
                    this.m_spsSessTokenAttr = null;
                }
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", CSSMsgMgr.get(8718807));
                object = new ResourceException(new CSSException(8718807).toString());
                throw object;
            }
            if (resourceException.getMessage().indexOf("SBL-SMI-00107") >= 0) {
                if (this.m_userName != null && this.m_password != null) {
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Connection to Siebel task not available. Attempting Reconnect.");
                    siebelPropertySet2 = this.handleRequest(string, siebelPropertySet);
                    bl3 = true;
                    object = siebelPropertySet2;
                    return object;
                }
                if (this.m_sessionType.equalsIgnoreCase("Stateful")) {
                    this.m_sessionToken = null;
                    this.m_spsSessTokenAttr = null;
                }
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Connection to Siebel task not available.");
                throw resourceException;
            }
            if (resourceException.getMessage().indexOf("SBL-EAI-04608") >= 0) {
                bl = true;
            }
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", resourceException.getMessage() + resourceException.getErrorCode());
            throw resourceException;
        }
        catch (SiebelException siebelException) {
            if (siebelException.getMessage().indexOf("SBL-EAI-04608") >= 0) {
                bl = true;
            }
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", siebelException.getDetailedMessage());
            throw siebelException;
        }
        finally {
            String string4;
            if (siebelPropertySet2 != null && (string4 = siebelPropertySet2.getProperty("MinorVersionMisMatch")) != null) {
                SiebelTrace.getInstance().trace(null, 2, "SiebelJCASessionManager.handleRequest()", "Minor version of " + string4 + " XSDs do not match minor version of their corresponding Base Integration Objects");
            }
            if (string2 == null) {
                this.releaseConnection(connection, bl, bl2, bl3);
            }
        }
        return siebelPropertySet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(Connection connection, boolean bl, boolean bl2, boolean bl3) throws ResourceException {
        if (this.m_sessionType.equalsIgnoreCase("Stateful")) {
            if (bl) {
                if (!this.m_StatefulFromAnotherServer) {
                    m_Connections.put(this.getSessionTokenKey(), connection);
                }
                this.m_sessionToken = null;
                this.m_spsSessTokenAttr = null;
            } else if (bl2) {
                this.close(this.m_interaction, connection);
                if (!bl3) {
                    this.m_sessionToken = null;
                    this.m_spsSessTokenAttr = null;
                }
            } else {
                this.m_sessionToken = this.m_newSessionToken;
                this.m_spsSessTokenAttr = this.getAttributesFromSessionToken(this.m_sessionToken);
                if (!this.m_StatefulFromAnotherServer) {
                    m_Connections.put(this.getSessionTokenKey(), connection);
                }
            }
            this.m_newSessionToken = null;
        } else if (this.m_sessionType.equalsIgnoreCase("None") || this.m_sessionType.equalsIgnoreCase("Stateless")) {
            if (bl) {
                if (!this.m_StatefulFromAnotherServer) {
                    m_Connections.put(this.getSessionTokenKey(), connection);
                }
                this.m_sessionToken = null;
                this.m_spsSessTokenAttr = null;
            } else if (bl2 || this.m_sessionToken == null) {
                if (bl2) {
                    this.close(this.m_interaction, connection);
                    if (!bl3) {
                        this.m_sessionToken = null;
                    }
                    this.m_spsSessTokenAttr = null;
                } else {
                    if (this.m_userName != null && !this.m_userName.equalsIgnoreCase(RA_USER) && !this.m_RESTRequest) {
                        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Adding connection for user" + this.m_userName + "in user affintiy map");
                        Long l = ((SiebelConnectionHandle)connection).getLastAccessedTime();
                        UserConnectionMap userConnectionMap = m_userMap;
                        synchronized (userConnectionMap) {
                            m_userMap.put(this.m_userName, connection);
                            m_userAccessTimeMap.put(l, this.m_userName);
                        }
                    } else if (this.m_RESTRequest) {
                        this.close(null, connection);
                    } else {
                        this.close(this.m_interaction, connection);
                    }
                    if (this.m_sessionType.equalsIgnoreCase("Stateless") && !bl3) {
                        this.m_sessionToken = this.m_newSessionToken;
                        this.m_spsSessTokenAttr = this.getAttributesFromSessionToken(this.m_sessionToken);
                        this.m_newSessionToken = null;
                    }
                }
            } else {
                if (!this.m_StatefulFromAnotherServer) {
                    this.terminateConnection(connection);
                    this.close(this.m_interaction, connection);
                } else {
                    String string = this.m_spsSessTokenAttr.getProperty(SESSION_ID);
                    try {
                        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Closing Siebel session (" + string + ")");
                        SiebelCon.close(string);
                    }
                    catch (SiebelConException siebelConException) {
                        SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", "Error occured while attempting to close session (" + string + ")");
                    }
                }
                this.m_sessionToken = null;
                this.m_spsSessTokenAttr = null;
            }
        }
    }

    private SiebelPropertySet doPostExecution(SiebelPropertySet siebelPropertySet, Connection connection) throws IllegalArgumentException, ResourceException, StreamingException {
        String string = siebelPropertySet.getProperty("XSDNotAvailable");
        if (string != null) {
            String string2 = siebelPropertySet.getProperty("MinorVersionMisMatch");
            if (string2 != null) {
                SiebelTrace.getInstance().trace(null, 2, "SiebelJCASessionManager.handleRequest()", "Minor version of " + string2 + " XSDs do not match minor version of their corresponding Base Integration Objects");
            }
            return this.executeBusinessService(this.m_userName, this.m_password, this.m_methodName, this.m_requestInput, connection);
        }
        return null;
    }

    private String getXSDFileAsString(String string) {
        String string2 = "";
        try {
            String string3;
            URL uRL = new URL(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3 + "\n";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private Connection processSTAndGetConnection() throws ResourceException, InterruptedException {
        String string = this.m_sessionType;
        Connection connection = null;
        this.m_spsSessTokenAttr = this.getAttributesFromSessionToken(this.m_sessionToken);
        if (this.m_sessionType.equalsIgnoreCase("None")) {
            string = this.m_spsSessTokenAttr.getProperty(SESS_TYPE);
        }
        if (string.equalsIgnoreCase("Stateless")) {
            this.m_newToken = true;
            String string2 = this.m_spsSessTokenAttr.getProperty(USERNAME);
            String string3 = this.m_spsSessTokenAttr.getProperty(PASSWORD);
            if (this.m_userName == null) {
                this.m_userName = string2;
            }
            if (this.m_password == null) {
                this.m_password = string3;
            }
            this.m_sessionToken = null;
            this.m_spsSessTokenAttr = null;
            connection = this.getConnection();
        } else if (string.equalsIgnoreCase("Stateful")) {
            if (this.validateSessionToken(false)) {
                this.m_newToken = false;
                this.m_impersonate = "false";
                connection = m_Connections.get(this.getSessionTokenKey());
                if (connection != null) {
                    m_lock.lock();
                    try {
                        while (m_pingConnectionHandle != null && connection == m_pingConnectionHandle) {
                            m_connObject.await();
                        }
                        connection = m_Connections.remove(this.getSessionTokenKey());
                    }
                    catch (InterruptedException interruptedException) {
                        SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", "Request Thread interruped. ");
                        throw interruptedException;
                    }
                    finally {
                        m_lock.unlock();
                    }
                }
                if (connection == null) {
                    this.m_StatefulFromAnotherServer = true;
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Stateful Request from another server");
                }
            } else {
                this.m_newToken = true;
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Attempting transparent relogin");
                connection = this.getConnection();
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws ResourceException {
        Connection connection = null;
        boolean bl = true;
        if (this.m_sessionType.equalsIgnoreCase("Stateful")) {
            this.m_newToken = true;
            bl = false;
        } else if (this.m_sessionType.equalsIgnoreCase("Stateless")) {
            this.m_newToken = true;
        }
        if (this.m_userName != null && this.m_password != null) {
            connection = this.getConnectionHandle(bl);
            if (connection == null) {
                throw new ResourceException(CSSMsgMgr.get(8716799));
            }
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "created connection for default user");
        } else if (this.m_sessionType.equalsIgnoreCase("None")) {
            Vector<Connection> vector = m_anonConnections;
            synchronized (vector) {
                if (!B2B && m_anonConnections.size() >= MAX_ANON_USERS) {
                    SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", "Resource Adapter has reached Maximum Anonymous User Limit");
                    throw new ResourceException(CSSMsgMgr.get(8716794));
                }
                if (!B2B) {
                    if (this.m_properties != null) {
                        this.m_userName = this.m_properties.getUserName();
                        this.m_password = this.m_properties.getPassword();
                    } else {
                        this.m_userName = RA_USER;
                        this.m_password = RA_PWD;
                    }
                }
                if ((connection = this.getConnectionHandle(false)) == null) {
                    throw new ResourceException(CSSMsgMgr.get(8716799));
                }
                if (!B2B) {
                    m_anonConnections.add(connection);
                }
                if (!B2B && this.m_properties == null) {
                    this.m_userName = ((SiebelConnectionHandle)connection).getUserName();
                    this.m_password = ((SiebelConnectionHandle)connection).getPassword();
                    if (this.m_userName == null || this.m_password == null || this.m_userName.equals("") || this.m_password.equals("")) {
                        SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", "Invalid connection handle. Username and/or Password is empty");
                        throw new ResourceException(CSSMsgMgr.get(8716799));
                    }
                    SiebelTrace.getInstance().trace(null, 5, "SiebelJCASessionManager.handleRequest()", "Credentials retrieved for user " + this.m_userName);
                }
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Created Anonymous connection");
            }
        } else {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Invalid UserName / Password pair");
            throw new ResourceException(CSSMsgMgr.get(8716408));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnectionHandle(boolean bl) throws ResourceException {
        Connection connection;
        block15: {
            connection = null;
            if (bl) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getConnectionHandle()", "Lookup connection for " + this.m_userName + " in user affinity map.");
                UserConnectionMap userConnectionMap = m_userMap;
                synchronized (userConnectionMap) {
                    connection = m_userMap.remove(this.m_userName);
                    if (connection != null) {
                        m_userAccessTimeMap.remove(((SiebelConnectionHandle)connection).getLastAccessedTime());
                    }
                }
            }
            if (connection == null) {
                if (bl) {
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getConnectionHandle()", "Connection for " + this.m_userName + " not found in user affinity map.");
                }
                try {
                    if (this.m_properties != null && !this.m_properties.isEmpty()) {
                        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getConnectionHandle()", "getConnection(SiebelConnectionSpec) : " + this.m_properties.getUserName());
                        connection = this.m_connectionFactory.getConnection((ConnectionSpec)new SiebelConnectionSpec(null, this.m_properties.getUserName(), this.m_properties.getPassword(), this.m_properties.getConnectString(), this.m_properties.getLanguage()));
                    } else {
                        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getConnectionHandle()", " Get connection from connection pool. ");
                        connection = this.m_connectionFactory.getConnection();
                    }
                }
                catch (ResourceException resourceException) {
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getConnectionHandle()", "Connection pool exhausted. Releasing least recently used connection from user affinity map.");
                    UserConnectionMap userConnectionMap = m_userMap;
                    synchronized (userConnectionMap) {
                        if (!m_userAccessTimeMap.isEmpty() && !m_userMap.isEmpty()) {
                            Long l = (Long)m_userAccessTimeMap.firstKey();
                            String string = (String)m_userAccessTimeMap.remove(l);
                            connection = m_userMap.MatchAndRemove(string, l);
                        }
                    }
                    if (connection != null) break block15;
                    throw resourceException;
                }
            }
        }
        return connection;
    }

    private SiebelPropertySet executeSeedRequest(SiebelPropertySet siebelPropertySet, Connection connection) throws ResourceException {
        Object object;
        SiebelPropertySetRecord siebelPropertySetRecord = null;
        this.m_interaction = (SiebelInteraction)connection.createInteraction();
        boolean bl = false;
        bl = this.m_properties != null ? ((object = this.m_properties.getCloseOnAppErr()) != null ? ((String)object).compareToIgnoreCase("true") == 0 : false) : CLOSE_ON_APP_ERROR;
        object = new SiebelInteractionSpec("EAI JCA Service", "GetSeed", bl);
        SiebelPropertySetRecord siebelPropertySetRecord2 = new SiebelPropertySetRecord();
        siebelPropertySetRecord2.dup(siebelPropertySetRecord2, siebelPropertySet);
        siebelPropertySetRecord = (SiebelPropertySetRecord)this.m_interaction.execute((InteractionSpec)object, siebelPropertySetRecord2);
        return siebelPropertySetRecord;
    }

    private SiebelPropertySet executeBusinessService(String string, String string2, String string3, SiebelPropertySet siebelPropertySet, Connection connection) throws ResourceException, StreamingException {
        Object object;
        SiebelPropertySetRecord siebelPropertySetRecord = null;
        SiebelPropertySetRecord siebelPropertySetRecord2 = new SiebelPropertySetRecord();
        SiebelInteractionSpec siebelInteractionSpec = null;
        SiebelPropertySetRecord siebelPropertySetRecord3 = new SiebelPropertySetRecord();
        if (this.m_siebelServiceName == null || string3 == null) {
            throw new IllegalArgumentException(CSSMsgMgr.get(8716796));
        }
        siebelPropertySet.setProperty("ServiceName", this.m_siebelServiceName);
        siebelPropertySet.setProperty("MethodName", string3);
        if (this.isRESTRequest()) {
            this.m_impersonate = "false";
        }
        if (this.m_impersonate.equals("true")) {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.executeBusinessService()", "Impersonating user : " + string);
            siebelPropertySet.setProperty(IMPERSONATE, this.m_impersonate);
            siebelPropertySet.setProperty(IMPERSONATE_USER, string);
            siebelPropertySet.setProperty(IMPERSONATE_PASSWORD, string2);
        }
        boolean bl = false;
        bl = this.m_properties != null ? ((object = this.m_properties.getCloseOnAppErr()) != null ? ((String)object).compareToIgnoreCase("true") == 0 : false) : CLOSE_ON_APP_ERROR;
        try {
            SiebelPropertySet siebelPropertySet2;
            object = new StreamHandler();
            String string4 = null;
            String string5 = null;
            StreamObject streamObject = null;
            boolean bl2 = false;
            if (siebelPropertySet.getChildCount() > 0) {
                for (int i = 0; i < siebelPropertySet.getChildCount(); ++i) {
                    string4 = siebelPropertySet.getChild(i).getProperty("HasAttachment");
                    string5 = siebelPropertySet.getChild(i).getProperty("StreamedAttachment");
                    if (string4 == null || string5 == null || !string4.equals("true") || !string5.equals("true")) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.executeBusinessService()", "Streaming Request");
                streamObject = new StreamObject();
                siebelPropertySet2 = ((StreamHandler)object).sendRequest(siebelPropertySet, streamObject);
                siebelPropertySetRecord3.dup(siebelPropertySetRecord3, siebelPropertySet2);
            } else {
                siebelPropertySetRecord3.dup(siebelPropertySetRecord3, siebelPropertySet);
            }
            while (true) {
                String string6;
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.executeBusinessService()", "Sending Chunk");
                if (!this.m_StatefulFromAnotherServer) {
                    this.m_interaction = (SiebelInteraction)connection.createInteraction();
                    siebelInteractionSpec = new SiebelInteractionSpec("EAI JCA Service", "Dispatch", bl);
                    siebelPropertySetRecord = (SiebelPropertySetRecord)this.m_interaction.execute(siebelInteractionSpec, siebelPropertySetRecord3);
                } else {
                    siebelPropertySetRecord = this.executeStatefulRequest(siebelPropertySetRecord3, bl);
                }
                if (streamObject == null) {
                    streamObject = new StreamObject();
                }
                if ((string6 = (siebelPropertySet2 = ((StreamHandler)object).handleRequest(siebelPropertySetRecord, streamObject)).getProperty("RequestType")) == null || string6.isEmpty()) {
                    siebelPropertySetRecord2.dup(siebelPropertySetRecord2, siebelPropertySet2);
                    break;
                }
                siebelPropertySetRecord3.dup(siebelPropertySetRecord3, siebelPropertySet2);
            }
        }
        catch (StreamingException streamingException) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager::executeBusinessService", "Streaming Exception occured.");
            throw streamingException;
        }
        return siebelPropertySetRecord2;
    }

    private void terminateConnection(Connection connection) {
        if (connection != null) {
            SiebelConnectionHandle siebelConnectionHandle = (SiebelConnectionHandle)connection;
            SiebelManagedConnection siebelManagedConnection = siebelConnectionHandle.getManagedConnection();
            siebelManagedConnection.sendEvent(5, null, siebelConnectionHandle);
        }
    }

    protected void close(SiebelInteraction siebelInteraction, Connection connection) {
        try {
            if (siebelInteraction != null) {
                siebelInteraction.close();
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.close()", "Closed interaction");
            }
            if (connection != null) {
                if (m_anonConnections.contains(connection)) {
                    m_anonConnections.remove(connection);
                }
                connection.close();
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.close()", "Closed connectionHandle");
            }
        }
        catch (ResourceException resourceException) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.close()", "Exception while closing Interaction and ConnectionHandle: " + resourceException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections() {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            Connection connection = null;
            SiebelConnectionHandle siebelConnectionHandle = null;
            if (!m_anonConnections.isEmpty()) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.closeAllConnections()", "Closing anonymous connections");
                for (int i = 0; i < m_anonConnections.size(); ++i) {
                    connection = m_anonConnections.get(i);
                    m_anonConnections.remove(connection);
                    siebelConnectionHandle = (SiebelConnectionHandle)connection;
                    if (!siebelConnectionHandle.isValid()) continue;
                    object2 = siebelConnectionHandle.getManagedConnection().getSiebelConnection();
                    this.close(null, (Connection)object2);
                }
            }
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.closeAllConnections()", "Closing all connection present in user affinity map.");
            Object object3 = m_userMap;
            synchronized (object3) {
                if (!m_userMap.isEmpty() && !m_userAccessTimeMap.isEmpty()) {
                    object2 = m_userAccessTimeMap.keySet();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string = (String)m_userAccessTimeMap.get(object.next());
                        siebelConnectionHandle = (SiebelConnectionHandle)m_userMap.remove(string);
                        if (!siebelConnectionHandle.isValid()) continue;
                        SiebelConnection siebelConnection = siebelConnectionHandle.getManagedConnection().getSiebelConnection();
                        this.close(null, siebelConnection);
                    }
                }
            }
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.closeAllConnections()", "Closing ignored connections");
            m_lock.lock();
            bl = true;
            object3 = m_Connections.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                siebelConnectionHandle = (SiebelConnectionHandle)m_Connections.remove(object2);
                if (!siebelConnectionHandle.isValid()) continue;
                object = siebelConnectionHandle.getManagedConnection().getSiebelConnection();
                this.close(null, (Connection)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bl) {
                m_lock.unlock();
            }
        }
    }

    private String generateSessionToken(Connection connection) {
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        try {
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.generateSessionToken()", "Generating session token");
            if (this.m_newToken) {
                string5 = string6 = ((SiebelConnectionHandle)connection).getSessionId();
                string4 = System.currentTimeMillis() + "";
                string3 = "1";
                string7 = this.m_userName;
                string8 = this.m_password;
            } else {
                string5 = string6 = this.m_spsSessTokenAttr.getProperty(SESSION_ID);
                string4 = this.m_spsSessTokenAttr.getProperty(CREATE_TIME);
                string3 = "0";
                string7 = this.m_spsSessTokenAttr.getProperty(USERNAME);
                string8 = this.m_spsSessTokenAttr.getProperty(PASSWORD);
            }
            siebelPropertySet.setProperty(TOKEN_ID, string5);
            siebelPropertySet.setProperty(SESSION_ID, string6);
            siebelPropertySet.setProperty(USERNAME, string7 + "");
            siebelPropertySet.setProperty(PASSWORD, string8 + "");
            siebelPropertySet.setProperty(CREATE_TIME, string4);
            siebelPropertySet.setProperty(ACCESS_TIME, System.currentTimeMillis() + "");
            siebelPropertySet.setProperty(NEW_TOKEN_FLAG, string3);
            siebelPropertySet.setProperty(TOKEN, "");
            siebelPropertySet.setProperty(SESS_TYPE, this.m_sessionType);
            string = siebelPropertySet.encodeSessionTokenAsString();
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.generateSessionToken()", "Encoded as string");
            string2 = this.m_siebCipher.encrypt(string);
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.generateSessionToken()", "Generated session token successfully");
        }
        catch (CSSException cSSException) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.generateSessionToken()", "Exception while encrypting the session token: " + cSSException.toString());
        }
        catch (Exception exception) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.generateSessionToken()", "Exception while getting the session id to encrypt: " + exception.toString());
        }
        return string2;
    }

    private SiebelPropertySet getAttributesFromSessionToken(String string) {
        String string2 = "";
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getAttributesFromSessionToken()", "Getting attributes from session token");
        try {
            string2 = this.m_siebCipher.decrypt(string);
            siebelPropertySet.decodeSessionTokenFromString(string2);
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.getAttributesFromSessionToken()", "Retrieved attributes successfully");
        }
        catch (CSSException cSSException) {
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.getAttributesFromSessionToken()", "Exception while decrypting the session token: " + cSSException.toString());
        }
        return siebelPropertySet;
    }

    private String getSessionTokenKey() {
        if (this.m_spsSessTokenAttr != null) {
            return this.m_spsSessTokenAttr.getProperty(SESSION_ID) + this.m_spsSessTokenAttr.getProperty(USERNAME) + this.m_spsSessTokenAttr.getProperty(PASSWORD) + this.m_spsSessTokenAttr.getProperty(CREATE_TIME);
        }
        return null;
    }

    private boolean validateSessionToken(boolean bl) throws IllegalArgumentException, InterruptedException {
        long l = Long.parseLong(this.m_spsSessTokenAttr.getProperty(CREATE_TIME));
        long l2 = Long.parseLong(this.m_spsSessTokenAttr.getProperty(ACCESS_TIME));
        long l3 = System.currentTimeMillis();
        int n = 0;
        SiebelTrace.getInstance().trace(null, 4, "SiebelJCASessionManager.validateSessionToken()", " SESSION_TOKEN_MAX_AGE : " + SESSION_TOKEN_MAX_AGE + " SESSION_TOKEN_TIMEOUT : " + SESSION_TOKEN_TIMEOUT + " currTime-crtTime : " + (l3 - l) + " currTime-accTime : " + (l3 - l2));
        if (SESSION_TOKEN_MAX_AGE < 0L && SESSION_TOKEN_TIMEOUT < 0L) {
            n = (short)(n + 1);
        }
        if (SESSION_TOKEN_MAX_AGE < 0L && l3 - l2 < SESSION_TOKEN_TIMEOUT) {
            n = (short)(n + 1);
        }
        if (SESSION_TOKEN_TIMEOUT < 0L && l3 - l < SESSION_TOKEN_MAX_AGE) {
            n = (short)(n + 1);
        }
        if (l3 - l < SESSION_TOKEN_MAX_AGE && l3 - l2 < SESSION_TOKEN_TIMEOUT) {
            n = (short)(n + 1);
        }
        if (n > 0) {
            return true;
        }
        if (!bl) {
            this.clearSessionTokenCache(this.getSessionTokenKey());
            this.m_sessionToken = null;
            this.m_spsSessTokenAttr = null;
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.validateSessionToken()", "Session Token has expired");
            throw new IllegalArgumentException(CSSMsgMgr.get(8716800));
        }
        this.clearSessionTokenCache(this.getSessionTokenKey());
        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.validateSessionToken()", "Session Token has expired.");
        return false;
    }

    private void clearSessionTokenCache(String string) throws InterruptedException {
        Connection connection = m_Connections.get(string);
        if (connection != null) {
            m_lock.lock();
            try {
                while (m_pingConnectionHandle != null && connection == m_pingConnectionHandle) {
                    m_connObject.await();
                }
                connection = m_Connections.remove(this.getSessionTokenKey());
            }
            catch (InterruptedException interruptedException) {
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.clearSessionTokenCache()", "Request Thread interruped. ");
                throw interruptedException;
            }
            finally {
                m_lock.unlock();
            }
            this.terminateConnection(connection);
        } else {
            String string2 = this.m_spsSessTokenAttr.getProperty(SESSION_ID);
            try {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.clearSessionTokenCache()", "Closing Siebel session (" + string2 + ")");
                SiebelCon.close(string2);
            }
            catch (SiebelConException siebelConException) {
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.clearSessionTokenCache()", "Error occured while attempting to close session (" + string2 + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSessionManager() throws ResourceException, CSSException {
        Connection connection = null;
        try {
            String string = m_seed;
            synchronized (string) {
                if (m_seed.equals("")) {
                    connection = this.getConnectionHandle(false);
                    if (connection == null) {
                        throw new ResourceException(CSSMsgMgr.get(8716799));
                    }
                    m_seed = ((SiebelConnectionHandle)connection).getUserName() + ((SiebelConnectionHandle)connection).getPassword();
                    this.close(null, connection);
                }
            }
            this.m_siebCipher = new SiebelCipher(m_seed);
        }
        catch (ResourceException resourceException) {
            this.close(this.m_interaction, connection);
            if (resourceException.getMessage().indexOf("SBL-JCA-0031") >= 0 || resourceException.getMessage().indexOf("8716599") >= 0) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Invalid connection possibly due to Siebel Server shutdown/restart or network failure. Attempting Reconnect");
                this.initSessionManager();
                return;
            }
            if (resourceException.getMessage().indexOf("SBL-SMI-00107") >= 0) {
                SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.handleRequest()", "Connection to Siebel task not available. Attempting Reconnect.");
                this.initSessionManager();
                return;
            }
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.handleRequest()", resourceException.getMessage() + resourceException.getErrorCode());
            throw resourceException;
        }
    }

    private SiebelPropertySetRecord executeStatefulRequest(SiebelPropertySetRecord siebelPropertySetRecord, boolean bl) throws ResourceException {
        SiebelPropertySetRecord siebelPropertySetRecord2;
        String string = this.m_spsSessTokenAttr.getProperty(SESSION_ID);
        try {
            CSSPropertySetEx cSSPropertySetEx = SiebelCon.invoke(string, "EAI JCA Service", "Dispatch", siebelPropertySetRecord.toCSSPropertySetEx());
            siebelPropertySetRecord2 = cSSPropertySetEx != null ? new SiebelPropertySetRecord(cSSPropertySetEx) : new SiebelPropertySetRecord();
        }
        catch (SiebelConException siebelConException) {
            ResourceException resourceException = new ResourceException(siebelConException.getMessage());
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.executeStatefulRequest()", "EAI JCA Service.Dispatch  FAILED on with message " + siebelConException.getMessage());
            if (siebelConException.isAppErrorFlag() && CLOSE_ON_APP_ERROR && siebelConException.getMessage().indexOf("SBL-EAI-04608") < 0) {
                try {
                    SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.executeStatefulRequest()", "Closing Siebel connection due to application error as CloseOnAppError is set to true");
                    SiebelCon.close(string);
                }
                catch (SiebelConException siebelConException2) {
                    SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.executeStatefulRequest()", "Error occured while attempting to close session (" + string + ")");
                }
            }
            resourceException.setLinkedException((Exception)siebelConException);
            throw resourceException;
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException(CSSMsgMgr.get(8716404));
            SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.executeStatefulRequest()", "EAI JCA Service.Dispatch  FAILED on with message " + exception.getMessage());
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        return siebelPropertySetRecord2;
    }

    private SiebelPropertySet removeXSDContent(SiebelPropertySet siebelPropertySet) {
        for (int i = 0; i < siebelPropertySet.getChildCount(); ++i) {
            siebelPropertySet.getChild(i).removeProperty("XSDContent");
        }
        siebelPropertySet.removeProperty("XSDContent");
        String string = siebelPropertySet.getFirstProperty();
        while (!string.isEmpty()) {
            if (string.startsWith("XSDContent:")) {
                siebelPropertySet.removeProperty(string);
            }
            string = siebelPropertySet.getNextProperty();
        }
        return siebelPropertySet;
    }

    private String getCreationTime(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1, string.length());
        return string2;
    }

    private long getSessionTokenMaxAge(SiebelUserProperties siebelUserProperties) {
        String string = siebelUserProperties.getSessionTokenMaxAge();
        if (string != null) {
            return Long.parseLong(string) * 60000L;
        }
        return SESSION_TOKEN_MAX_AGE;
    }

    private long getSessionTokenTimeout(SiebelUserProperties siebelUserProperties) {
        String string = siebelUserProperties.getSessionTokenTimeout();
        if (string != null) {
            return Long.parseLong(string) * 60000L;
        }
        return SESSION_TOKEN_TIMEOUT;
    }

    public boolean getB2BMode() {
        if (this.m_properties != null) {
            return this.m_properties.isB2BMode();
        }
        return B2B_MODE;
    }

    public String getSessionUserName() {
        return this.m_userName;
    }

    public String getSessionPassword() {
        return this.m_password;
    }

    public String getSessionType() {
        return this.m_sessionType;
    }

    public String getSessionToken() {
        return this.m_sessionToken;
    }

    public static void setSessionTokenMaxAge(long l) {
        SESSION_TOKEN_MAX_AGE = l;
    }

    public static void setSessionTokenTimeout(long l) {
        SESSION_TOKEN_TIMEOUT = l;
    }

    public static void setCloseOnAppError(boolean bl) {
        CLOSE_ON_APP_ERROR = bl;
    }

    public static void setB2BMode(boolean bl) {
        B2B_MODE = bl;
    }

    public void setSessionUserName(String string) {
        this.m_userName = string;
    }

    public void setSessionPassword(String string) {
        this.m_password = string;
    }

    public void setSessionType(String string) {
        if (string == null || string.equalsIgnoreCase("None") || string.equals("")) {
            this.m_sessionType = "None";
        } else if (!(string.equalsIgnoreCase("None") || string.equalsIgnoreCase("Stateless") || string.equalsIgnoreCase("Stateful") || string.equalsIgnoreCase("ServerDetermined"))) {
            this.m_sessionType = "None";
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.setSessionType", "Invalid Session Type \"" + string + "\". Defaulting it to \"None\".");
        } else {
            this.m_sessionType = string;
        }
    }

    public void setSessionToken(String string) {
        this.m_sessionToken = string != null && string.trim().equals("") ? null : string;
    }

    public void setRESTRequest(boolean bl) {
        this.m_RESTRequest = bl;
    }

    public boolean isRESTRequest() {
        return this.m_RESTRequest;
    }

    public static void setBUseOnlyLatestToken(boolean bl) {
        m_bUseOnlyLatestToken = bl;
    }

    public static boolean isBUseOnlyLatestToken() {
        return m_bUseOnlyLatestToken;
    }

    public static void setThresholdTime(long l) {
        m_thresholdTime = l;
    }

    public static long getThresholdTime() {
        return m_thresholdTime;
    }

    public void setXsdUri(String string) {
        this.m_xsdUri = string;
    }

    public String getXsdUri() {
        return this.m_xsdUri;
    }

    private static class userAccessTimeCompartor
    implements Comparator<Long> {
        private userAccessTimeCompartor() {
        }

        @Override
        public int compare(Long l, Long l2) {
            return l.compareTo(l2);
        }
    }
}

