/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.sessmgr;

import com.siebel.integration.jca.client.SiebelConnectionHandle;
import com.siebel.integration.jca.client.SiebelInteraction;
import com.siebel.integration.jca.client.SiebelInteractionSpec;
import com.siebel.integration.jca.client.SiebelPropertySetRecord;
import com.siebel.integration.sessmgr.SiebelJCASessionManager;
import com.siebel.integration.util.SiebelTrace;
import com.siebel.integration.util.SiebelUserProperties;
import java.util.Enumeration;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.work.Work;
import weblogic.connector.extensions.LongRunning;

@LongRunning
public class SiebelJCASessionManagerWork
extends SiebelJCASessionManager
implements Work {
    private boolean m_doWork = false;

    public SiebelJCASessionManagerWork(ConnectionFactory connectionFactory, SiebelUserProperties siebelUserProperties, String string) {
        super(connectionFactory, siebelUserProperties, string);
    }

    public SiebelJCASessionManagerWork() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SiebelPropertySetRecord siebelPropertySetRecord = new SiebelPropertySetRecord();
        SiebelInteraction siebelInteraction = null;
        String string = null;
        block17: while (this.m_doWork) {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                SiebelTrace.getInstance().trace(null, 1, "SiebelJCASessionManager.run()", "Interrupt exception occured on sweep thread during sleep");
            }
            SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.run()", "Checking validity of stateful connection after interval");
            Enumeration enumeration = m_Connections.keys();
            while (this.m_doWork) {
                m_lock.lock();
                try {
                    if (!enumeration.hasMoreElements()) continue block17;
                    string = (String)enumeration.nextElement();
                    m_pingConnectionHandle = (SiebelConnectionHandle)m_Connections.get(string);
                }
                finally {
                    m_lock.unlock();
                    continue block17;
                }
                if (m_pingConnectionHandle == null) continue;
                try {
                    long l;
                    long l2 = System.currentTimeMillis();
                    if (l2 - (l = ((SiebelConnectionHandle)m_pingConnectionHandle).getLastAccessedTime()) <= m_thresholdTime) continue;
                    siebelInteraction = (SiebelInteraction)m_pingConnectionHandle.createInteraction();
                    SiebelInteractionSpec siebelInteractionSpec = new SiebelInteractionSpec("EAI JCA Service", "Echo", false);
                    SiebelPropertySetRecord siebelPropertySetRecord2 = (SiebelPropertySetRecord)siebelInteraction.execute(siebelInteractionSpec, siebelPropertySetRecord);
                }
                catch (ResourceException resourceException) {
                    if (!((SiebelConnectionHandle)m_pingConnectionHandle).isValid()) {
                        m_Connections.remove(string);
                    }
                    this.close(siebelInteraction, null);
                }
                finally {
                    m_lock.lock();
                    try {
                        m_pingConnectionHandle = null;
                        m_connObject.signalAll();
                    }
                    finally {
                        m_lock.unlock();
                    }
                }
            }
        }
    }

    public void release() {
        SiebelTrace.getInstance().trace(null, 3, "SiebelJCASessionManager.release ()", "Stopping sweep thread...");
        this.m_doWork = false;
    }

    public void setDoWork(boolean bl) {
        this.m_doWork = bl;
    }

    public boolean isDoWork() {
        return this.m_doWork;
    }
}

