/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.sessmgr.streamhandler;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.StreamingException;
import com.siebel.integration.sessmgr.streamhandler.RequestType;
import com.siebel.integration.sessmgr.streamhandler.StreamObject;
import com.siebel.integration.sessmgr.streamhandler.StreamState;
import com.siebel.integration.util.SiebelTrace;

public class StreamHandler {
    public SiebelPropertySet handleRequest(SiebelPropertySet siebelPropertySet, StreamObject streamObject) throws StreamingException {
        SiebelPropertySet siebelPropertySet2 = null;
        String string = "false";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Entering StreamHander handleRequest.");
        string = siebelPropertySet.getProperty("Streamed");
        string2 = siebelPropertySet.getProperty("RequestType");
        string3 = siebelPropertySet.getProperty("RequestStatus");
        string4 = siebelPropertySet.getProperty("SequenceNumber");
        string5 = siebelPropertySet.getValue();
        if (string2 == null || string4 == null) {
            SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Response from Siebel server is not streamed.");
            return siebelPropertySet;
        }
        int n = Integer.valueOf(string4);
        RequestType requestType = RequestType.getValue(string2);
        switch (requestType) {
            case REQ: {
                try {
                    StreamState streamState = StreamState.getValue(string3);
                    switch (streamState) {
                        case STRM_START: {
                            SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Request received is of type REQ with state STRM_START");
                            streamObject.init();
                            streamObject.setSeqNo(n);
                            streamObject.setState(StreamState.STRM_START);
                            streamObject.appendToFile(string5, false);
                            siebelPropertySet2 = this.CreateAck(streamObject);
                            return siebelPropertySet2;
                        }
                        case STRM_INPROG: {
                            SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Request received is of type REQ  with state STRM_PROG");
                            streamObject.setSeqNo(n);
                            streamObject.setState(StreamState.STRM_INPROG);
                            streamObject.appendToFile(string5, false);
                            siebelPropertySet2 = this.CreateAck(streamObject);
                            return siebelPropertySet2;
                        }
                    }
                    break;
                }
                catch (StreamingException streamingException) {
                    SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Error is processing the stream request. Sending NAK");
                    siebelPropertySet2 = this.CreateNAck(string4, streamingException.getMessage());
                    return siebelPropertySet2;
                }
            }
            case ACK: {
                try {
                    SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Received an ACK for the chunk sent Sending next chunk");
                    siebelPropertySet2 = this.createRequest(streamObject);
                    return siebelPropertySet2;
                }
                catch (StreamingException streamingException) {
                    SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Error is sending chunk Sending NAK");
                    siebelPropertySet2 = this.CreateNAck(string4, streamingException.getMessage());
                    return siebelPropertySet2;
                }
            }
            case NAK: {
                SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Received a NAK for the chunk sent cleaning up and exiting");
                streamObject.close();
                SiebelTrace.getInstance().trace(null, 1, "StreamObject::appendToFile", CSSMsgMgr.get(8718796));
                StreamingException streamingException = new StreamingException(new CSSException(8718796));
                throw streamingException;
            }
            case REQ_END: {
                SiebelTrace.getInstance().trace(null, 3, "StreamHandler::handleRequest", "Request received is of type REQ_END. Last chunk received. Decoding the request.");
                streamObject.setSeqNo(n);
                streamObject.setState(StreamState.STRM_END);
                streamObject.appendToFile(string5, true);
                siebelPropertySet2 = streamObject.decodeFromFile();
                return siebelPropertySet2;
            }
        }
        return siebelPropertySet2;
    }

    public SiebelPropertySet sendRequest(SiebelPropertySet siebelPropertySet, StreamObject streamObject) throws StreamingException {
        SiebelPropertySet siebelPropertySet2 = null;
        SiebelTrace.getInstance().trace(null, 3, "StreamHandler::createRequest", "Entering StreamHander sendRequest  to stream the request and send first chunk.");
        streamObject.init();
        streamObject.encodeToFile(siebelPropertySet);
        siebelPropertySet2 = this.createRequest(streamObject);
        return siebelPropertySet2;
    }

    private SiebelPropertySet createRequest(StreamObject streamObject) throws StreamingException {
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        String string = "";
        String string2 = "";
        String string3 = "";
        SiebelTrace.getInstance().trace(null, 3, "StreamHandler::createRequest", "Entering StreamHander createRequest  to send chunk.");
        string = streamObject.getChunk();
        siebelPropertySet.setValue(string);
        siebelPropertySet.setProperty("Streamed", "true");
        string2 = String.valueOf(streamObject.getState().ordinal());
        siebelPropertySet.setProperty("RequestStatus", string2);
        siebelPropertySet.setProperty("SequenceNumber", streamObject.getSeqNo().toString());
        string3 = streamObject.getState() == StreamState.STRM_END ? String.valueOf(RequestType.REQ_END.ordinal()) : String.valueOf(RequestType.REQ.ordinal());
        siebelPropertySet.setProperty("RequestType", string3);
        return siebelPropertySet;
    }

    private SiebelPropertySet CreateAck(StreamObject streamObject) {
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        String string = "";
        string = String.valueOf(streamObject.getSeqNo());
        String string2 = "";
        string2 = String.valueOf(RequestType.ACK.ordinal());
        siebelPropertySet.setProperty("RequestType", string2);
        siebelPropertySet.setProperty("SequenceNumber", string);
        return siebelPropertySet;
    }

    private SiebelPropertySet CreateNAck(String string, String string2) {
        SiebelPropertySet siebelPropertySet = null;
        String string3 = "";
        string3 = String.valueOf(RequestType.NAK.ordinal());
        siebelPropertySet.setProperty("RequestError", string2);
        siebelPropertySet.setProperty("RequestType", string3);
        siebelPropertySet.setProperty("SequenceNumber", string);
        return siebelPropertySet;
    }
}

