/*
 * Decompiled with CFR 0.152.
 */
package com.siebel.integration.sessmgr.streamhandler;

import com.siebel.common.common.CSSException;
import com.siebel.common.common.CSSMsgMgr;
import com.siebel.common.util.FileManager;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.StreamingException;
import com.siebel.integration.sessmgr.streamhandler.StreamState;
import com.siebel.integration.util.SiebelTrace;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class StreamObject {
    public static final Integer CHUNK_SIZE = 1617;
    private StreamState m_state;
    private Integer m_seqNo;
    private File m_file;
    private RandomAccessFile m_raf;
    private FileWriter m_fw;
    private BufferedWriter m_bw;

    public StreamObject() {
        this.m_state = StreamState.STRM_NO_STATE;
        this.m_seqNo = 0;
        this.m_file = null;
        this.m_raf = null;
        this.m_fw = null;
        this.m_bw = null;
    }

    public StreamObject(StreamState streamState, Integer n) {
        this.m_state = streamState;
        this.m_seqNo = n;
        this.m_file = null;
        this.m_raf = null;
        this.m_fw = null;
        this.m_bw = null;
    }

    public void init() throws StreamingException {
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::init", "Entering Stream Object Initialization.");
        Long l = Thread.currentThread().getId();
        String string = l.toString();
        SiebelTrace.getInstance().trace(null, 4, "StreamObject::init", "threadId:" + string);
        String string2 = System.getProperty("weblogic.home");
        SiebelTrace.getInstance().trace(null, 4, "StreamObject::init", "User Directory Location:" + string2);
        String string3 = string2 + System.getProperty("file.separator") + "_siebel_tmp" + System.getProperty("file.separator") + "Dir" + string;
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::init", "Creating Temporary Directory.");
        try {
            String string4 = "StreamTempFile" + string;
            FileManager fileManager = new FileManager();
            this.m_file = FileManager.createTempFile(string4, ".tmp");
            if (!this.m_file.exists()) {
                SiebelTrace.getInstance().trace(null, 1, "StreamObject::init", CSSMsgMgr.get(8718788, string3));
                StreamingException streamingException = new StreamingException(new CSSException(8718788, string3));
                throw streamingException;
            }
        }
        catch (SecurityException securityException) {
            SiebelTrace.getInstance().trace(null, 1, "StreamObject::init", CSSMsgMgr.get(8718790));
            SiebelTrace.getInstance().trace(null, 1, "Security Exception:", securityException.getMessage());
            StreamingException streamingException = new StreamingException(new CSSException(8718790));
            throw streamingException;
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "StreamObject::init", CSSMsgMgr.get(8718788, string3));
            SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
            StreamingException streamingException = new StreamingException(new CSSException(8718788, string3));
            throw streamingException;
        }
    }

    public void setSeqNo(Integer n) {
        this.m_seqNo = n;
    }

    public Integer getSeqNo() {
        return this.m_seqNo;
    }

    public void encodeToFile(SiebelPropertySet siebelPropertySet) throws StreamingException {
        Boolean bl = false;
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::encodeToFile", "Entering Stream Object encodingToFile.");
        try {
            if (!siebelPropertySet.encodeToFile(this.m_file)) {
                SiebelTrace.getInstance().trace(null, 1, "StreamObject::encodeToFile", CSSMsgMgr.get(8718799));
                StreamingException streamingException = new StreamingException(new CSSException(8718791));
                throw streamingException;
            }
        }
        catch (IOException iOException) {
            bl = true;
            SiebelTrace.getInstance().trace(null, 1, "StreamObject::encodeToFile", CSSMsgMgr.get(8718791));
            SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
            StreamingException streamingException = new StreamingException(new CSSException(8718791));
            throw streamingException;
        }
        finally {
            if (bl.booleanValue() && this.m_file != null) {
                this.m_file.delete();
            }
        }
    }

    public SiebelPropertySet decodeFromFile() throws StreamingException {
        SiebelPropertySet siebelPropertySet = new SiebelPropertySet();
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::decodeFromFile", "Entering Stream Object decodeFromFile.");
        try {
            if (!siebelPropertySet.decodeFromFile(this.m_file)) {
                SiebelTrace.getInstance().trace(null, 1, "StreamObject::decodingFromFile", CSSMsgMgr.get(8718800));
                StreamingException streamingException = new StreamingException(new CSSException(8718792));
                throw streamingException;
            }
            SiebelPropertySet siebelPropertySet2 = siebelPropertySet;
            return siebelPropertySet2;
        }
        catch (IOException iOException) {
            SiebelTrace.getInstance().trace(null, 1, "StreamObject::decodingFromFile", CSSMsgMgr.get(8718792));
            SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
            StreamingException streamingException = new StreamingException(new CSSException(8718792));
            throw streamingException;
        }
        finally {
            if (this.m_file != null) {
                this.m_file.delete();
            }
        }
    }

    public String getChunk() throws StreamingException {
        String string = null;
        Integer n = -1;
        Boolean bl = false;
        Boolean bl2 = false;
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::getChunk", "Entering Stream Object getChunk.");
        try {
            if (this.m_raf == null) {
                this.m_raf = new RandomAccessFile(this.m_file, "r");
            }
            Integer n2 = this.getSeqNo() + 1;
            SiebelTrace.getInstance().trace(null, 3, "StreamObject::getChunk", "Reading Chunk: " + n2.toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(CHUNK_SIZE);
            byte[] byArray = new byte[CHUNK_SIZE.intValue()];
            n = this.m_raf.read(byArray);
            if (n == -1) {
                bl = true;
                string = "";
                byteArrayOutputStream.close();
                this.m_raf.close();
                SiebelTrace.getInstance().trace(null, 3, "StreamObject::getChunk", "Last chunk read. ");
            } else {
                byteArrayOutputStream.write(byArray, 0, n);
                string = byteArrayOutputStream.toString();
                byteArrayOutputStream.close();
                if (n < CHUNK_SIZE) {
                    bl = true;
                    this.m_raf.close();
                    SiebelTrace.getInstance().trace(null, 3, "StreamObject::getChunk", "Last chunk read. ");
                }
            }
            StreamState streamState = this.getState();
            if (streamState == StreamState.STRM_NO_STATE) {
                this.setState(StreamState.STRM_START);
            } else if (!(bl.booleanValue() || streamState != StreamState.STRM_START && streamState != StreamState.STRM_INPROG)) {
                this.setState(StreamState.STRM_INPROG);
            } else if (bl.booleanValue() && (streamState == StreamState.STRM_START || streamState == StreamState.STRM_INPROG)) {
                this.setState(StreamState.STRM_END);
            }
            this.setSeqNo(n2);
            String string2 = string;
            return string2;
        }
        catch (IOException iOException) {
            bl2 = true;
            SiebelTrace.getInstance().trace(null, 1, "StreamObject::getChunk", CSSMsgMgr.get(8718793));
            SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
            StreamingException streamingException = new StreamingException(new CSSException(8718793));
            throw streamingException;
        }
        finally {
            if (bl.booleanValue() || bl2.booleanValue()) {
                try {
                    if (this.m_raf != null) {
                        this.m_raf.close();
                    }
                }
                catch (IOException iOException) {
                    SiebelTrace.getInstance().trace(null, 1, "StreamObject::getChunk", CSSMsgMgr.get(8718794));
                    SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
                    StreamingException streamingException = new StreamingException(new CSSException(8718794));
                    throw streamingException;
                }
                this.m_file.delete();
            }
        }
    }

    public void appendToFile(String string, Boolean bl) throws StreamingException {
        Boolean bl2 = false;
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::appendToFile", "Entering Stream Object appendToFile.");
        if (!string.isEmpty()) {
            try {
                if (this.m_fw == null && this.m_bw == null) {
                    this.m_fw = new FileWriter(this.m_file);
                    this.m_bw = new BufferedWriter(this.m_fw);
                    this.m_bw.append(string);
                } else {
                    this.m_bw.append(string);
                    this.m_bw.flush();
                }
            }
            catch (IOException iOException) {
                bl2 = true;
                SiebelTrace.getInstance().trace(null, 1, "StreamObject::appendToFile", CSSMsgMgr.get(8718795));
                SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
                StreamingException streamingException = new StreamingException(new CSSException(8718795));
                throw streamingException;
            }
            finally {
                if (bl.booleanValue() || bl2.booleanValue()) {
                    try {
                        if (this.m_bw != null) {
                            this.m_bw.close();
                        }
                        if (this.m_fw != null) {
                            this.m_fw.close();
                        }
                    }
                    catch (IOException iOException) {
                        SiebelTrace.getInstance().trace(null, 1, "StreamObject::appendToFile", CSSMsgMgr.get(8718794));
                        SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
                        StreamingException streamingException = new StreamingException(new CSSException(8718794));
                        throw streamingException;
                    }
                    if (bl2.booleanValue()) {
                        this.m_file.delete();
                    }
                }
            }
        }
    }

    public void close() throws StreamingException {
        SiebelTrace.getInstance().trace(null, 3, "StreamObject::close", "Entering Stream Object close.");
        try {
            if (this.m_bw != null) {
                this.m_bw.close();
            }
            if (this.m_fw != null) {
                this.m_fw.close();
            }
            if (this.m_raf != null) {
                this.m_raf.close();
            }
        }
        catch (IOException iOException) {
            this.m_file.delete();
            SiebelTrace.getInstance().trace(null, 1, "StreamObject::close", CSSMsgMgr.get(8718794));
            SiebelTrace.getInstance().trace(null, 1, "IO Exception:", iOException.getMessage());
            StreamingException streamingException = new StreamingException(new CSSException(8718794));
            throw streamingException;
        }
    }

    public void setState(StreamState streamState) {
        this.m_state = streamState;
    }

    public StreamState getState() {
        return this.m_state;
    }
}

